/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.data.file;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.translator.FileConnection;

public class FileConnectionImpl
extends BasicConnection
implements FileConnection {
    private File parentDirectory;
    private Map<String, String> fileMapping;
    private boolean allowParentPaths;
    private static final Pattern parentRef = Pattern.compile("(^\\.\\.(\\\\{2}|/)?.*)|((\\\\{2}|/)\\.\\.)");

    public FileConnectionImpl(String parentDirectory, Map<String, String> fileMapping, boolean allowParentPaths) {
        this.parentDirectory = new File(parentDirectory);
        if (fileMapping == null) {
            fileMapping = Collections.emptyMap();
        }
        this.fileMapping = fileMapping;
        this.allowParentPaths = allowParentPaths;
    }

    public File getFile(String path) throws ResourceException {
        if (path == null) {
            return this.parentDirectory;
        }
        String altPath = this.fileMapping.get(path);
        if (altPath != null) {
            path = altPath;
        }
        if (!this.allowParentPaths && parentRef.matcher(path).matches()) {
            throw new ResourceException("Parent path .. not allowed in file path " + path);
        }
        if (new File(path).isAbsolute()) {
            return new File(path);
        }
        return new File(this.parentDirectory, path);
    }

    public void close() throws ResourceException {
    }
}

