/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.views;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.boot.Metadata;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.spring.annotations.ExcelTable;
import org.teiid.spring.views.ViewBuilder;

public class ExcelTableView
extends ViewBuilder<ExcelTable> {
    private AtomicInteger columnIdx = new AtomicInteger();
    private StringBuilder columns = new StringBuilder();

    public ExcelTableView(Metadata metadata) {
        super(metadata);
    }

    @Override
    void onFinish(Table view, MetadataFactory mf, Class<?> entityClazz, ExcelTable annotation) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(this.columns.toString()).append("FROM ");
        sb.append(entityClazz.getSimpleName().toLowerCase()).append(".").append(annotation.sheetName());
        sb.append(" AS st");
        view.setSelectTransformation(sb.toString());
    }

    @Override
    void onColumnCreate(Table view, Column column, MetadataFactory mf, Field field, String parent, boolean last, ExcelTable annotation) {
        boolean headerExists = annotation.headerRow() != -1;
        String columnName = column.getName();
        if (!headerExists) {
            columnName = "column" + this.columnIdx.incrementAndGet();
        }
        this.columns.append("convert(st.").append(columnName).append(",").append(column.getRuntimeType()).append(")");
        this.columns.append(" AS ").append(column.getName());
        if (!last) {
            this.columns.append(", ");
        } else {
            this.columns.append(" ");
        }
    }
}

