/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.teiid.spring.autoconfigure.DelegatingPlatformTransactionManager;

@Configuration
@EnableTransactionManagement
public class MultiDataSourceTransactionManagement
implements TransactionManagementConfigurer {
    @Autowired(required=false)
    private TransactionManager transactionManager;
    @Autowired(required=false)
    private UserTransaction userTransaction;

    @Bean
    @Primary
    public PlatformTransactionManager platformTransactionManager() {
        if (this.transactionManager != null) {
            return new JtaTransactionManager(this.userTransaction, this.transactionManager);
        }
        return new DelegatingPlatformTransactionManager();
    }

    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return this.platformTransactionManager();
    }
}

