/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Driver;
import java.util.List;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.jboss.vfs.VirtualFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.Scope;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.jdbc.datasource.embedded.ConnectionProperties;
import org.springframework.jdbc.datasource.embedded.DataSourceFactory;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactory;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheFactory;
import org.teiid.core.util.LRUCache;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.metadatastore.DeploymentBasedDatabaseStore;
import org.teiid.query.metadata.PureZipFileSystem;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.spring.autoconfigure.PlatformTransactionManagerAdapter;
import org.teiid.spring.autoconfigure.TeiidDatabaseConfigurer;
import org.teiid.spring.autoconfigure.TeiidInitializer;
import org.teiid.spring.autoconfigure.TeiidPostProcessor;
import org.teiid.spring.autoconfigure.TeiidProperties;
import org.teiid.spring.autoconfigure.TeiidServer;
import org.teiid.spring.data.file.FileConnectionFactory;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.xml.sax.SAXException;

@Configuration
@ConditionalOnClass(value={EmbeddedServer.class, ExecutionFactory.class})
@EnableConfigurationProperties(value={TeiidProperties.class})
@Import(value={TeiidPostProcessor.Registrar.class})
@PropertySource(value={"classpath:teiid.properties"})
public class TeiidAutoConfiguration
implements Ordered {
    public static ThreadLocal<TeiidServer> serverContext = new ThreadLocal();
    private static final Log logger = LogFactory.getLog(TeiidAutoConfiguration.class);
    @Autowired(required=false)
    private EmbeddedConfiguration embeddedConfiguration;
    @Autowired
    private TeiidProperties properties;
    @Autowired
    ApplicationContext context;
    @Value(value="${spring.jpa.hibernate.naming.physical-strategy:org.springframework.boot.orm.jpa.hibernate.SpringPhysicalNamingStrategy}")
    String hibernateNamingClass;
    @Autowired(required=false)
    private TransactionManager transactionManager;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Bean
    @ConditionalOnMissingBean
    public TeiidInitializer teiidInitializer(ApplicationContext applicationContext) {
        return new TeiidInitializer(applicationContext);
    }

    @Bean(name={"dataSource"})
    @Primary
    @ConfigurationProperties(prefix="spring.datasource")
    public DataSource getDataSource(final TeiidServer server) {
        EmbeddedDatabaseFactory edf = new EmbeddedDatabaseFactory();
        edf.setDatabaseConfigurer((EmbeddedDatabaseConfigurer)new TeiidDatabaseConfigurer(server));
        edf.setDataSourceFactory(new DataSourceFactory(){

            public DataSource getDataSource() {
                String url = TeiidAutoConfiguration.this.context.getEnvironment().getProperty("spring.datasource.teiid.url");
                return new SimpleDriverDataSource((Driver)server.getDriver(), url);
            }

            public ConnectionProperties getConnectionProperties() {
                return new ConnectionProperties(){

                    public void setDriverClass(Class<? extends Driver> driverClass) {
                    }

                    public void setUrl(String url) {
                    }

                    public void setUsername(String username) {
                    }

                    public void setPassword(String password) {
                    }
                };
            }
        });
        return edf.getDatabase();
    }

    @Bean
    @ConditionalOnMissingBean
    public VDBMetaData teiidVDB() {
        List<Resource> resources = TeiidInitializer.getScripts("teiid.vdb-file", this.properties.getVdbFile(), "teiid.ddl", this.context);
        VDBMetaData vdb = null;
        if (!resources.isEmpty()) {
            for (Resource resource : resources) {
                if (resource.getFilename().endsWith(".ddl")) {
                    try {
                        DeploymentBasedDatabaseStore store = new DeploymentBasedDatabaseStore(new VDBRepository());
                        String db = "CREATE DATABASE spring VERSION '1.0.0';\n";
                        db = db + "USE DATABASE " + "spring" + " VERSION '" + "1.0.0" + "';\n";
                        db = db + ObjectConverterUtil.convertToString((InputStream)resources.get(0).getInputStream());
                        vdb = store.getVDBMetadata(db);
                        logger.info((Object)("Predefined VDB found :" + resources.get(0).getFilename()));
                        break;
                    }
                    catch (FileNotFoundException store) {
                        break;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to parse the VDB defined");
                    }
                }
                if (resource.getFilename().endsWith("-vdb.xml")) {
                    try {
                        vdb = VDBMetadataParser.unmarshell((InputStream)resources.get(0).getInputStream());
                        continue;
                    }
                    catch (IOException | XMLStreamException e) {
                        throw new IllegalStateException("Failed to load the VDB defined", e);
                    }
                }
                if (!resource.getFilename().endsWith(".vdb")) continue;
                try {
                    vdb = this.loadVDB(new File(resource.getFilename()).toURI().toURL());
                }
                catch (IOException | URISyntaxException | VirtualDatabaseException | ConnectorManagerRepository.ConnectorManagerException | TranslatorException e) {
                    throw new IllegalStateException("Failed to load the VDB defined", e);
                }
            }
        }
        if (vdb == null) {
            vdb = new VDBMetaData();
            vdb.addProperty("implicit", "true");
        }
        vdb.setName("spring");
        vdb.setVersion("1.0.0");
        return vdb;
    }

    private VDBMetaData loadVDB(URL url) throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException, IOException, URISyntaxException {
        VDBMetaData metadata;
        VirtualFile root = PureZipFileSystem.mount((URL)url);
        VirtualFile vdbMetadata = root.getChild("/META-INF/vdb.xml");
        if (vdbMetadata.exists()) {
            try {
                VDBMetadataParser.validate((InputStream)vdbMetadata.openStream());
            }
            catch (SAXException e) {
                throw new VirtualDatabaseException((Exception)e);
            }
            InputStream is = vdbMetadata.openStream();
            try {
                metadata = VDBMetadataParser.unmarshell((InputStream)is);
            }
            catch (XMLStreamException e) {
                throw new VirtualDatabaseException((Exception)e);
            }
        }
        vdbMetadata = root.getChild("/META-INF/vdb.ddl");
        DeploymentBasedDatabaseStore store = new DeploymentBasedDatabaseStore(new VDBRepository());
        metadata = store.getVDBMetadata(ObjectConverterUtil.convertToString((InputStream)vdbMetadata.openStream()));
        return metadata;
    }

    @Bean(name={"teiid"})
    @ConditionalOnMissingBean
    @Scope(value="singleton")
    public TeiidServer teiidServer() {
        logger.info((Object)"Starting Teiid Server.");
        System.setProperty("org.teiid.addPGMetadata", "false");
        TeiidServer server = new TeiidServer();
        if (this.embeddedConfiguration == null) {
            this.embeddedConfiguration = new EmbeddedConfiguration();
            this.embeddedConfiguration.setCacheFactory(new CacheFactory(){

                public <K, V> Cache<K, V> get(String name) {
                    return new LocalCache(name, 10);
                }

                public void destroy() {
                }
            });
        }
        if (this.embeddedConfiguration.getTransactionManager() == null) {
            PlatformTransactionManagerAdapter ptma = server.getPlatformTransactionManagerAdapter();
            ptma.setJTATransactionManager(this.transactionManager);
            this.embeddedConfiguration.setTransactionManager((TransactionManager)ptma);
        }
        server.start(this.embeddedConfiguration);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("spring");
        vdb.setVersion("1.0.0");
        server.deployVDB(vdb, false);
        serverContext.set(server);
        return server;
    }

    @Bean(name={"file"})
    public FileConnectionFactory fileConnectionFactory() {
        return new FileConnectionFactory();
    }

    @Bean(name={"teiidNamingStrategy"})
    public PhysicalNamingStrategy teiidNamingStrategy() {
        try {
            return (PhysicalNamingStrategy)Class.forName(this.hibernateNamingClass).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    static class LocalCache<K, V>
    extends LRUCache<K, V>
    implements Cache<K, V> {
        private static final long serialVersionUID = -7894312381042966398L;
        private String name;

        public LocalCache(String cacheName, int maxSize) {
            super(maxSize < 0 ? Integer.MAX_VALUE : maxSize);
            this.name = cacheName;
        }

        public V put(K key, V value, Long ttl) {
            return (V)this.put(key, value);
        }

        public String getName() {
            return this.name;
        }

        public boolean isTransactional() {
            return false;
        }
    }
}

