/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.autoconfigure.jdbc.DataSourceInitializedEvent;
import org.springframework.boot.context.config.ResourceNotFoundException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.config.SortedResourcesFactoryBean;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.util.StringUtils;

class MultiDataSourceInitializer
implements ApplicationListener<DataSourceInitializedEvent> {
    private static final Log logger = LogFactory.getLog(MultiDataSourceInitializer.class);
    private final ApplicationContext applicationContext;
    private DataSource dataSource;
    private boolean initialized = false;
    String sourceName;

    MultiDataSourceInitializer(DataSource dataSource, String sourceName, ApplicationContext applicationContext) {
        this.dataSource = dataSource;
        this.sourceName = sourceName;
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        if (this.dataSource == null) {
            logger.debug((Object)"No DataSource found so not initializing");
            return;
        }
        this.runSchemaScripts();
    }

    private void runSchemaScripts() {
        List<Object> resources = null;
        resources = this.getProperty("schema") == null ? Collections.emptyList() : Arrays.asList(this.getProperty("schema"));
        List<Resource> scripts = this.getScripts("spring.datasource." + this.sourceName + ".schema", resources, "schema");
        if (!scripts.isEmpty()) {
            String username = this.getProperty("schema-username");
            String password = this.getProperty("schema-password");
            this.runScripts(scripts, username, password);
            try {
                this.applicationContext.publishEvent((ApplicationEvent)new DataSourceInitializedEvent(this.dataSource));
                if (!this.initialized) {
                    this.runDataScripts();
                    this.initialized = true;
                }
            }
            catch (IllegalStateException ex) {
                logger.warn((Object)("Could not send event to complete DataSource initialization (" + ex.getMessage() + ")"));
            }
        }
    }

    public void onApplicationEvent(DataSourceInitializedEvent event) {
        String initialize = this.getProperty("initialize");
        if (initialize != null && !Boolean.parseBoolean(initialize)) {
            logger.debug((Object)"Initialization disabled (not running data scripts)");
            return;
        }
        if (!this.initialized) {
            this.runDataScripts();
            this.initialized = true;
        }
    }

    private void runDataScripts() {
        List<Object> resources = null;
        resources = this.getProperty("data") == null ? Collections.emptyList() : Arrays.asList(this.getProperty("schema"));
        List<Resource> scripts = this.getScripts("spring.datasource." + this.sourceName + ".data", resources, "data");
        String username = this.getProperty("data-username");
        String password = this.getProperty("data-password");
        this.runScripts(scripts, username, password);
    }

    List<Resource> getScripts(String propertyName, List<String> resources, String fallback) {
        if (resources != null && !resources.isEmpty()) {
            return this.getResources(propertyName, resources, true);
        }
        String platform = this.getProperty("platform");
        ArrayList<String> fallbackResources = new ArrayList<String>();
        fallbackResources.add("classpath*:" + fallback + "-" + platform + ".sql");
        fallbackResources.add("classpath*:" + fallback + ".sql");
        return this.getResources(propertyName, fallbackResources, false);
    }

    List<Resource> getResources(String propertyName, List<String> locations, boolean validate) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String location : locations) {
            for (Resource resource : this.doGetResources(location)) {
                if (resource.exists()) {
                    resources.add(resource);
                    continue;
                }
                if (!validate) continue;
                throw new ResourceNotFoundException(propertyName, resource);
            }
        }
        return resources;
    }

    private Resource[] doGetResources(String location) {
        try {
            SortedResourcesFactoryBean factory = new SortedResourcesFactoryBean((ResourceLoader)this.applicationContext, Collections.singletonList(location));
            factory.afterPropertiesSet();
            return (Resource[])factory.getObject();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to load resources from " + location, ex);
        }
    }

    private String getProperty(String key) {
        String k = "spring.datasource." + this.sourceName + "." + key;
        String value = this.applicationContext.getEnvironment().getProperty(k);
        if (value == null) {
            k = "spring.xa.datasource." + this.sourceName + "." + key;
            value = this.applicationContext.getEnvironment().getProperty(k);
        }
        return value;
    }

    private void runScripts(List<Resource> resources, String username, String password) {
        if (resources.isEmpty()) {
            return;
        }
        boolean continueOnError = Boolean.parseBoolean(this.getProperty("continue-on-error"));
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setContinueOnError(continueOnError);
        populator.setSeparator(this.getProperty("seperator"));
        if (this.getProperty("sql-script-encoding") != null) {
            populator.setSqlScriptEncoding(this.getProperty("sql-script-encoding"));
        }
        for (Resource resource : resources) {
            populator.addScript(resource);
        }
        DataSource dataSource = this.dataSource;
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
            String driver = this.getProperty("driver-class-name");
            String url = this.getProperty("url");
            dataSource = DataSourceBuilder.create((ClassLoader)this.getClass().getClassLoader()).driverClassName(driver).url(url).username(username).password(password).build();
        }
        DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)dataSource);
    }
}

