/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.teiid.spring.autoconfigure.DelegatingPlatformTransactionManager;
import org.teiid.spring.data.BaseConnectionFactory;

public final class PlatformTransactionManagerAdapter
implements TransactionManager {
    private List<PlatformTransactionManager> txnManagersForEachDataSource = new ArrayList<PlatformTransactionManager>();
    private static DefaultTransactionDefinition DEFAULT_TRANSACTION_DEFINITION = new DefaultTransactionDefinition();
    private PlatformTransactionManager platformTransactionManager;
    private WeakHashMap<TransactionStatus, PlatformTransactionAdapter> transactions = new WeakHashMap();
    private TransactionManager jtaTransactionManager;

    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
        if (this.platformTransactionManager instanceof DelegatingPlatformTransactionManager) {
            ((DelegatingPlatformTransactionManager)this.platformTransactionManager).setTransactionManagers(this.txnManagersForEachDataSource);
        }
    }

    public void setJTATransactionManager(TransactionManager txnManager) {
        this.jtaTransactionManager = txnManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransaction() throws SystemException {
        try {
            if (this.allowJTA()) {
                return this.jtaTransactionManager.getTransaction();
            }
            if (this.platformTransactionManager == null) {
                return null;
            }
            TransactionStatus status = null;
            try {
                status = TransactionAspectSupport.currentTransactionStatus();
            }
            catch (NoTransactionException e) {
                return null;
            }
            WeakHashMap<TransactionStatus, PlatformTransactionAdapter> weakHashMap = this.transactions;
            synchronized (weakHashMap) {
                PlatformTransactionAdapter adapter = this.transactions.get(status);
                if (adapter == null) {
                    adapter = new PlatformTransactionAdapter(status);
                    this.transactions.put(status, adapter);
                }
                return adapter;
            }
        }
        catch (IllegalTransactionStateException e) {
            return null;
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.allowJTA()) {
            this.jtaTransactionManager.rollback();
            return;
        }
        throw new SystemException();
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        if (this.allowJTA()) {
            this.jtaTransactionManager.commit();
            return;
        }
        throw new SystemException();
    }

    public void begin() throws NotSupportedException, SystemException {
        if (this.allowJTA()) {
            this.jtaTransactionManager.begin();
            return;
        }
        throw new SystemException();
    }

    public Transaction suspend() throws SystemException {
        if (this.allowJTA()) {
            return this.jtaTransactionManager.suspend();
        }
        throw new SystemException();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (this.allowJTA()) {
            this.jtaTransactionManager.setTransactionTimeout(seconds);
            return;
        }
        throw new SystemException();
    }

    public void resume(Transaction tobj) throws IllegalStateException, InvalidTransactionException, SystemException {
        if (this.allowJTA()) {
            this.jtaTransactionManager.resume(tobj);
            return;
        }
        throw new SystemException();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.allowJTA()) {
            this.jtaTransactionManager.setRollbackOnly();
            return;
        }
        throw new SystemException();
    }

    public int getStatus() throws SystemException {
        if (this.allowJTA()) {
            return this.jtaTransactionManager.getStatus();
        }
        throw new SystemException();
    }

    public void addDataSource(DataSource ds) {
        this.txnManagersForEachDataSource.add((PlatformTransactionManager)new DataSourceTransactionManager(ds));
    }

    public void addDataSource(BaseConnectionFactory bean) {
    }

    private boolean allowJTA() {
        return this.jtaTransactionManager != null;
    }

    static {
        DEFAULT_TRANSACTION_DEFINITION.setPropagationBehavior(2);
    }

    private static final class PlatformTransactionAdapter
    implements Transaction {
        private WeakReference<TransactionStatus> transactionStatus;

        PlatformTransactionAdapter(TransactionStatus status) {
            this.transactionStatus = new WeakReference<TransactionStatus>(status);
        }

        public void registerSynchronization(final Synchronization synch) throws IllegalStateException, RollbackException, SystemException {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void beforeCompletion() {
                    synch.beforeCompletion();
                }

                public void afterCompletion(int status) {
                    switch (status) {
                        case 0: {
                            status = 3;
                            break;
                        }
                        case 1: {
                            status = 4;
                            break;
                        }
                        case 2: {
                            status = 5;
                        }
                    }
                    synch.afterCompletion(status);
                }
            });
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            TransactionStatus status = (TransactionStatus)this.transactionStatus.get();
            if (status == null) {
                throw new IllegalStateException();
            }
            status.setRollbackOnly();
        }

        public void rollback() throws IllegalStateException, SystemException {
            throw new SystemException();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
            throw new SystemException();
        }

        public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
            throw new SystemException();
        }

        public boolean enlistResource(XAResource xaRes) throws IllegalStateException, RollbackException, SystemException {
            throw new SystemException();
        }

        public int getStatus() throws SystemException {
            throw new SystemException();
        }
    }
}

