/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.cfg.JDBCBinder;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.MappingsDatabaseCollector;
import org.hibernate.cfg.reveng.ReverseEngineeringRuntimeInfo;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.cfg.reveng.dialect.JDBCMetaDataDialect;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.HibernateMappingExporter;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.type.TypeResolver;
import org.springframework.context.ApplicationContext;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.dialect.TeiidDialect;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.spring.autoconfigure.RedirectionSchemaBuilder;
import org.teiid.spring.views.EntityBaseView;

public class SchemaBuilderUtility {
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir") + "/teiid");

    public void generateVBLSchema(ApplicationContext context, MetadataFactory source, MetadataFactory target, Dialect dialect, MetadataSources metadataSources) {
        this.generateVBLSchema(source, target);
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder((BootstrapServiceRegistry)metadataSources.getServiceRegistry()).applySetting("hibernate.dialect", (Object)dialect).build();
        ArtifactCollector files = SchemaBuilderUtility.generateHibernateModel(source, serviceRegistry);
        for (File f : files.getFiles("hbm.xml")) {
            metadataSources.addFile(f);
        }
    }

    public void generateVBLSchema(MetadataFactory source, MetadataFactory target) {
        for (org.teiid.metadata.Table srcTable : source.getSchema().getTables().values()) {
            org.teiid.metadata.Table table = target.addTable(srcTable.getName());
            for (org.teiid.metadata.Column srcColumn : srcTable.getColumns()) {
                org.teiid.metadata.Column c = target.addColumn(srcColumn.getName(), srcColumn.getRuntimeType(), (ColumnSet)table);
                c.setUpdatable(true);
                if (srcColumn.isAutoIncremented()) {
                    c.setAutoIncremented(true);
                }
                c.setLength(srcColumn.getLength());
                c.setScale(srcColumn.getScale());
                c.setPrecision(srcColumn.getPrecision());
                c.setNullType(srcColumn.getNullType());
                c.setDefaultValue(srcColumn.getDefaultValue());
            }
            table.setVirtual(true);
            table.setSupportsUpdate(true);
            if (srcTable.getPrimaryKey() != null) {
                target.addPrimaryKey(srcTable.getPrimaryKey().getName(), RedirectionSchemaBuilder.getColumnNames(srcTable.getPrimaryKey().getColumns()), table);
            }
            if (!srcTable.getForeignKeys().isEmpty()) {
                for (ForeignKey fk : srcTable.getForeignKeys()) {
                    target.addForeignKey(fk.getName(), RedirectionSchemaBuilder.getColumnNames(fk.getColumns()), fk.getReferenceColumns(), fk.getReferenceTableName(), table);
                }
            }
            if (!srcTable.getUniqueKeys().isEmpty()) {
                for (KeyRecord kr : srcTable.getUniqueKeys()) {
                    target.addIndex(kr.getName(), false, RedirectionSchemaBuilder.getColumnNames(kr.getColumns()), table);
                }
            }
            if (!srcTable.getIndexes().isEmpty()) {
                for (KeyRecord kr : srcTable.getIndexes()) {
                    target.addIndex(kr.getName(), true, RedirectionSchemaBuilder.getColumnNames(kr.getColumns()), table);
                }
            }
            table.setSelectTransformation(EntityBaseView.buildSelectPlan(table, source.getSchema().getName()));
        }
    }

    public static Metadata generateHbmModel(ConnectionProvider provider, Dialect dialect) throws SQLException {
        MetadataSources metadataSources = new MetadataSources();
        ServiceRegistry registry = metadataSources.getServiceRegistry();
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder((BootstrapServiceRegistry)registry).applySetting("hibernate.dialect", TeiidDialect.class).addService(ConnectionProvider.class, (Service)provider).addService(JdbcEnvironment.class, (Service)new JdbcEnvironmentImpl(provider.getConnection().getMetaData(), dialect)).build();
        DefaultReverseEngineeringStrategy strategy = new DefaultReverseEngineeringStrategy();
        MetadataBuilderImpl.MetadataBuildingOptionsImpl options = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(serviceRegistry);
        BasicTypeRegistry basicTypeRegistry = new BasicTypeRegistry();
        TypeResolver typeResolver = new TypeResolver(basicTypeRegistry, new TypeFactory());
        InFlightMetadataCollectorImpl metadataCollector = new InFlightMetadataCollectorImpl((MetadataBuildingOptions)options, typeResolver);
        MetadataBuildingContextRootImpl buildingContext = new MetadataBuildingContextRootImpl((MetadataBuildingOptions)options, null, (InFlightMetadataCollector)metadataCollector);
        JDBCBinder binder = new JDBCBinder((ServiceRegistry)serviceRegistry, new Properties(), (MetadataBuildingContext)buildingContext, (ReverseEngineeringStrategy)strategy, false);
        MetadataImpl metadata = metadataCollector.buildMetadataInstance((MetadataBuildingContext)buildingContext);
        binder.readFromDatabase(null, null, SchemaBuilderUtility.buildMapping((Metadata)metadata));
        HibernateMappingExporter exporter = new HibernateMappingExporter((Metadata)metadata){
            final /* synthetic */ Metadata val$metadata;
            {
                this.val$metadata = metadata;
            }

            protected Metadata getMetadata() {
                return this.val$metadata;
            }
        };
        exporter.start();
        return metadata;
    }

    private static Mapping buildMapping(final Metadata metadata) {
        return new Mapping(){

            public Type getIdentifierType(String persistentClass) throws MappingException {
                PersistentClass pc = metadata.getEntityBinding(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                return pc.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String persistentClass) throws MappingException {
                PersistentClass pc = metadata.getEntityBinding(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                if (!pc.hasIdentifierProperty()) {
                    return null;
                }
                return pc.getIdentifierProperty().getName();
            }

            public Type getReferencedPropertyType(String persistentClass, String propertyName) throws MappingException {
                PersistentClass pc = metadata.getEntityBinding(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                Property prop = pc.getProperty(propertyName);
                if (prop == null) {
                    throw new MappingException("property not known: " + persistentClass + '.' + propertyName);
                }
                return prop.getType();
            }

            public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
                return null;
            }
        };
    }

    public static ArtifactCollector generateHibernateModel(MetadataFactory source, StandardServiceRegistry serviceRegistry) {
        DefaultReverseEngineeringStrategy strategy = new DefaultReverseEngineeringStrategy();
        MetadataBuilderImpl.MetadataBuildingOptionsImpl options = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(serviceRegistry);
        BasicTypeRegistry basicTypeRegistry = new BasicTypeRegistry();
        TypeResolver typeResolver = new TypeResolver(basicTypeRegistry, new TypeFactory());
        InFlightMetadataCollectorImpl metadataCollector = new InFlightMetadataCollectorImpl((MetadataBuildingOptions)options, typeResolver);
        MetadataBuildingContextRootImpl buildingContext = new MetadataBuildingContextRootImpl((MetadataBuildingOptions)options, null, (InFlightMetadataCollector)metadataCollector);
        TeiidJDBCBinder binder = new TeiidJDBCBinder((ServiceRegistry)serviceRegistry, new Properties(), (MetadataBuildingContext)buildingContext, (ReverseEngineeringStrategy)strategy, false, metadataCollector, source);
        MetadataImpl metadata = metadataCollector.buildMetadataInstance((MetadataBuildingContext)buildingContext);
        binder.readFromDatabase(null, null, SchemaBuilderUtility.buildMapping((Metadata)metadata));
        HibernateMappingExporter exporter = new HibernateMappingExporter((Metadata)metadata){
            final /* synthetic */ Metadata val$metadata;
            {
                this.val$metadata = metadata;
            }

            protected Metadata getMetadata() {
                return this.val$metadata;
            }
        };
        exporter.setOutputDirectory(TMP_DIR);
        exporter.start();
        return exporter.getArtifactCollector();
    }

    static class TeiidJDBCBinder
    extends JDBCBinder {
        private InFlightMetadataCollectorImpl metadataCollector;
        private MetadataFactory source;
        private ReverseEngineeringStrategy strategy;

        TeiidJDBCBinder(ServiceRegistry serviceRegistry, Properties properties, MetadataBuildingContext mdbc, ReverseEngineeringStrategy revengStrategy, boolean preferBasicCompositeIds, InFlightMetadataCollectorImpl metadataCollector, MetadataFactory source) {
            super(serviceRegistry, properties, mdbc, revengStrategy, preferBasicCompositeIds);
            this.metadataCollector = metadataCollector;
            this.source = source;
            this.strategy = revengStrategy;
        }

        public DatabaseCollector readDatabaseSchema(String catalog, String schema) throws SQLException {
            MappingsDatabaseCollector dbs = new MappingsDatabaseCollector((InFlightMetadataCollector)this.metadataCollector, (MetaDataDialect)new JDBCMetaDataDialect());
            HashMap<String, Table> foundTables = new HashMap<String, Table>();
            for (org.teiid.metadata.Table table : this.source.getSchema().getTables().values()) {
                Table ht = this.metadataCollector.addTable(null, null, table.getName(), null, false);
                dbs.addTable(null, null, table.getName());
                for (org.teiid.metadata.Column column : table.getColumns()) {
                    Column hc = new Column();
                    hc.setName(column.getName());
                    hc.setSqlTypeCode(new Integer(JDBCSQLTypeInfo.getSQLType((String)column.getRuntimeType())));
                    hc.setLength(column.getLength());
                    hc.setPrecision(column.getPrecision());
                    hc.setScale(column.getScale());
                    hc.setNullable(column.getNullType() == BaseColumn.NullType.Nullable);
                    ht.addColumn(hc);
                }
                KeyRecord pk = table.getPrimaryKey();
                if (pk != null) {
                    PrimaryKey hpk = new PrimaryKey(ht);
                    hpk.setName(pk.getName());
                    for (org.teiid.metadata.Column column : pk.getColumns()) {
                        hpk.addColumn(ht.getColumn(new Column(column.getName())));
                    }
                    ht.setPrimaryKey(hpk);
                }
                if (!table.getUniqueKeys().isEmpty()) {
                    for (KeyRecord key : table.getUniqueKeys()) {
                        UniqueKey uk = new UniqueKey();
                        uk.setName(key.getName());
                        uk.setTable(ht);
                        ht.addUniqueKey(uk);
                        for (org.teiid.metadata.Column column : key.getColumns()) {
                            uk.addColumn(ht.getColumn(new Column(column.getName())));
                        }
                    }
                }
                if (!table.getIndexes().isEmpty()) {
                    for (KeyRecord key : table.getIndexes()) {
                        Index idx = new Index();
                        idx.setName(key.getName());
                        idx.setTable(ht);
                        ht.addIndex(idx);
                        for (org.teiid.metadata.Column column : key.getColumns()) {
                            idx.addColumn(ht.getColumn(new Column(column.getName())));
                        }
                    }
                }
                foundTables.put(table.getName(), ht);
            }
            HashMap<String, ArrayList<org.hibernate.mapping.ForeignKey>> oneToManyCandidates = new HashMap<String, ArrayList<org.hibernate.mapping.ForeignKey>>();
            for (org.teiid.metadata.Table table : this.source.getSchema().getTables().values()) {
                Table ht = (Table)foundTables.get(table.getName());
                for (ForeignKey fk : table.getForeignKeys()) {
                    Table refht = (Table)foundTables.get(fk.getReferenceTableName());
                    ArrayList<Column> columns = new ArrayList<Column>();
                    ArrayList<Column> refColumns = new ArrayList<Column>();
                    for (Object column : fk.getColumns()) {
                        columns.add(ht.getColumn(new Column(column.getName())));
                    }
                    for (Object column : fk.getReferenceColumns()) {
                        refColumns.add(refht.getColumn(new Column((String)column)));
                    }
                    String className = this.strategy.tableToClassName(TableIdentifier.create((Table)ht));
                    org.hibernate.mapping.ForeignKey key = ht.createForeignKey(fk.getName(), columns, className, null, refColumns);
                    key.setReferencedTable(refht);
                    ArrayList<org.hibernate.mapping.ForeignKey> existing = (ArrayList<org.hibernate.mapping.ForeignKey>)oneToManyCandidates.get(className);
                    if (existing == null) {
                        existing = new ArrayList<org.hibernate.mapping.ForeignKey>();
                        oneToManyCandidates.put(className, existing);
                    }
                    existing.add(key);
                }
            }
            dbs.setOneToManyCandidates(oneToManyCandidates);
            this.strategy.configure(ReverseEngineeringRuntimeInfo.createInstance(null, null, (DatabaseCollector)dbs));
            return dbs;
        }
    }
}

