/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.data.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.file.JavaVirtualFile;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.spring.data.BaseConnection;
import org.teiid.translator.TranslatorException;

public class FileConnection
extends BaseConnection
implements VirtualFileConnection {
    private File parentDirectory;
    private Map<String, String> fileMapping;
    private boolean allowParentPaths;
    private static final Pattern parentRef = Pattern.compile("(^\\.\\.(\\\\{2}|/)?.*)|((\\\\{2}|/)\\.\\.)");

    public FileConnection(String parentDirectory, Map<String, String> fileMapping, boolean allowParentPaths) {
        this.parentDirectory = new File(parentDirectory);
        if (fileMapping == null) {
            fileMapping = Collections.emptyMap();
        }
        this.fileMapping = fileMapping;
        this.allowParentPaths = allowParentPaths;
    }

    public void add(InputStream in, String path) throws TranslatorException {
        try {
            ObjectConverterUtil.write((InputStream)in, (File)this.getFile(path));
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public boolean remove(String path) throws TranslatorException {
        File f = this.getFile(path);
        if (!f.exists()) {
            return false;
        }
        return f.delete();
    }

    public VirtualFile[] getFiles(String location) throws TranslatorException {
        File datafile = this.getFile(location);
        if (datafile.isDirectory()) {
            return this.convert(datafile.listFiles());
        }
        if (datafile.exists()) {
            return new VirtualFile[]{new JavaVirtualFile(datafile)};
        }
        File parentDir = datafile.getParentFile();
        if (parentDir == null || !parentDir.exists()) {
            return null;
        }
        if (location.contains("*")) {
            location = location.replaceAll("\\\\", "\\\\\\\\");
            location = location.replaceAll("\\?", "\\\\?");
            location = location.replaceAll("\\[", "\\\\[");
            location = location.replaceAll("\\{", "\\\\{");
            final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + location);
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && matcher.matches(FileSystems.getDefault().getPath(pathname.getName(), new String[0]));
                }
            };
            return this.convert(parentDir.listFiles(fileFilter));
        }
        return null;
    }

    VirtualFile[] convert(File[] files) {
        VirtualFile[] result = new VirtualFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = new JavaVirtualFile(files[i]);
        }
        return result;
    }

    File getFile(String path) throws TranslatorException {
        if (path == null) {
            return this.parentDirectory;
        }
        String altPath = this.fileMapping.get(path);
        if (altPath != null) {
            path = altPath;
        }
        if (!this.allowParentPaths && parentRef.matcher(path).matches()) {
            throw new TranslatorException("parentpath_not_allowed");
        }
        return new File(this.parentDirectory, path);
    }

    public void close() throws Exception {
    }
}

