/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.data.file;

import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.teiid.core.util.StringUtil;
import org.teiid.spring.data.BaseConnectionFactory;
import org.teiid.spring.data.file.FileConnection;

@ConfigurationProperties(prefix="spring.teiid.file")
public class FileConnectionFactory
extends BaseConnectionFactory<FileConnection> {
    private String parentDirectory;
    private String fileMapping;
    private boolean allowParentPaths = true;

    public FileConnectionFactory() {
        super.setTranslatorName("file");
    }

    public FileConnection getConnection() throws Exception {
        if (this.parentDirectory == null) {
            this.parentDirectory = System.getProperty("user.dir");
        }
        Map map = (Map)StringUtil.valueOf((String)this.fileMapping, Map.class);
        return new FileConnection(this.parentDirectory, map, this.allowParentPaths);
    }

    public String getParentDirectory() {
        return this.parentDirectory;
    }

    public void setParentDirectory(String parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    public String getFileMapping() {
        return this.fileMapping;
    }

    public void setFileMapping(String fileMapping) {
        this.fileMapping = fileMapping;
    }

    public Boolean isAllowParentPaths() {
        return this.allowParentPaths;
    }

    public void setAllowParentPaths(Boolean allowParentPaths) {
        this.allowParentPaths = allowParentPaths != null && allowParentPaths != false;
    }
}

