/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.xa;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.xa.datasource")
public class XADataSourceBuilder
implements BeanClassLoaderAware,
EnvironmentAware,
InitializingBean,
XADataSource {
    private ClassLoader classLoader;
    private Environment environment;
    private String dataSourceClassName;
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private boolean initialize = true;
    private String platform = "all";
    private List<String> schema;
    private String schemaUsername;
    private String schemaPassword;
    private List<String> data;
    private String dataUsername;
    private String dataPassword;
    private boolean continueOnError = false;
    private XADataSource delegate;

    public void afterPropertiesSet() throws Exception {
        this.delegate = this.createXaDataSource();
    }

    public void setEnvironment(Environment env) {
        this.environment = env;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public XADataSourceBuilder() {
        this(null);
    }

    public XADataSourceBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public XADataSource build() throws Exception {
        return this;
    }

    public static XADataSourceBuilder create() throws Exception {
        return new XADataSourceBuilder();
    }

    protected XADataSource createXaDataSource() {
        String className = this.getDataSourceClassName();
        if (!StringUtils.hasLength((String)className)) {
            className = DatabaseDriver.fromJdbcUrl((String)this.getUrl()).getXaDataSourceClassName();
        }
        Assert.state((boolean)StringUtils.hasLength((String)className), (String)"No XA DataSource class name specified");
        XADataSource dataSource = this.createXaDataSourceInstance(className);
        this.bindXaProperties(dataSource);
        return dataSource;
    }

    private XADataSource createXaDataSourceInstance(String className) {
        try {
            Class dataSourceClass = ClassUtils.forName((String)className, (ClassLoader)this.classLoader);
            Object instance = BeanUtils.instantiate((Class)dataSourceClass);
            Assert.isInstanceOf(XADataSource.class, (Object)instance);
            return (XADataSource)instance;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create XADataSource instance from '" + className + "'");
        }
    }

    private void bindXaProperties(XADataSource target) {
        MutablePropertyValues values = new MutablePropertyValues();
        values.add("user", (Object)this.getUsername());
        values.add("password", (Object)this.getPassword());
        values.add("url", (Object)this.getUrl());
        values.addPropertyValues(this.getProperties());
        new RelaxedDataBinder((Object)target).withAlias("user", new String[]{"username"}).withAlias("port", new String[]{"portNumber"}).withAlias("server", new String[]{"serverName"}).withAlias("database", new String[]{"databaseName"}).bind((PropertyValues)values);
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public void setDataSourceClassName(String dataSourceClassName) {
        this.dataSourceClassName = dataSourceClassName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isInitialize() {
        return this.initialize;
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public List<String> getSchema() {
        return this.schema;
    }

    public void setSchema(List<String> schema) {
        this.schema = schema;
    }

    public String getSchemaUsername() {
        return this.schemaUsername;
    }

    public void setSchemaUsername(String schemaUsername) {
        this.schemaUsername = schemaUsername;
    }

    public String getSchemaPassword() {
        return this.schemaPassword;
    }

    public void setSchemaPassword(String schemaPassword) {
        this.schemaPassword = schemaPassword;
    }

    public List<String> getData() {
        return this.data;
    }

    public void setData(List<String> data) {
        this.data = data;
    }

    public String getDataUsername() {
        return this.dataUsername;
    }

    public void setDataUsername(String dataUsername) {
        this.dataUsername = dataUsername;
    }

    public String getDataPassword() {
        return this.dataPassword;
    }

    public void setDataPassword(String dataPassword) {
        this.dataPassword = dataPassword;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.delegate.getXAConnection();
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return this.delegate.getXAConnection(user, password);
    }
}

