/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.teiid.spring.data.file.FileConnectionFactory;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;

public enum ExternalSource {
    DB2("DB2", new String[]{"com.ibm.db2.jcc.DB2Driver"}, new String[]{"com.ibm.db2.jcc.DB2XADataSource"}, "db2", "org.hibernate.dialect.DB2Dialect"),
    DERBY("Derby", new String[]{"org.apache.derby.jdbc.ClientDriver"}, new String[0], "derby", "org.hibernate.dialect.DerbyTenSevenDialect"),
    H2("H2", new String[]{"org.h2.Driver"}, new String[]{"org.h2.jdbcx.JdbcDataSource"}, "h2", "org.hibernate.dialect.H2Dialect"),
    HANA("Hana", new String[]{"com.sap.db.jdbc.Driver"}, new String[0], "hana", "org.hibernate.dialect.HANARowStoreDialect"),
    HIVE("Hive", new String[]{"org.apache.hive.jdbc.HiveDriver"}, new String[0], "hive", null),
    HSQL("HSQL", new String[]{"org.hsqldb.jdbc.JDBCDriver"}, new String[]{"org.hsqldb.jdbc.pool.JDBCXADataSource"}, "hsql", "org.hibernate.dialect.HSQLDialect"),
    IMPALA("Impala", new String[]{"org.apache.hadoop.hive.jdbc.HiveDriver"}, new String[0], "impala", null),
    INFORMIX("Informix", new String[]{"com.informix.jdbc.IfxDriver"}, new String[0], "informix", "org.hibernate.dialect.InformixDialect"),
    INGRES("Ingres", new String[]{"com.ingres.jdbc.IngresDriver"}, new String[0], "ingres", "org.hibernate.dialect.Ingres10Dialect"),
    MYSQL("MySQL", new String[]{"com.mysql.jdbc.Driver"}, new String[]{"com.mysql.jdbc.jdbc2.optional.MysqlXADataSource"}, "mysql5", "org.hibernate.dialect.MySQL5InnoDBDialect"),
    ORACLE("Oracle", new String[]{"oracle.jdbc.OracleDriver"}, new String[]{"oracle.jdbc.xa.client.OracleXADataSource"}, "oracle", "org.hibernate.dialect.Oracle12cDialect"),
    OSISOFTPI("OSISOFT PI", new String[]{"com.osisoft.jdbc.Driver"}, new String[0], "osisoft-pi", null),
    PHOENIX("Phoenix", new String[]{"org.apache.phoenix.jdbc.PhoenixDriver"}, new String[0], "phoenix", null),
    POSTGRESQL("PostgreSQL", new String[]{"org.postgresql.Driver"}, new String[]{"org.postgresql.xa.PGXADataSource"}, "postgresql", "org.hibernate.dialect.PostgreSQL9Dialect"),
    PRESTODB("PrestoDB", new String[]{"com.facebook.presto.jdbc.PrestoDriver"}, new String[0], "prestodb", null),
    SQLSERVER("MS-SQL Server", new String[]{"com.microsoft.sqlserver.jdbc.SQLServerDriver"}, new String[]{"com.microsoft.sqlserver.jdbc.SQLServerXADataSource"}, "sqlserver", "org.hibernate.dialect.SQLServer2012Dialect"),
    JTDS("MS-SQL Server", new String[]{"net.sourceforge.jtds.jdbc.Driver"}, new String[0], "sqlserver", "org.hibernate.dialect.SQLServer2012Dialect"),
    SYBASE("Sybase", new String[]{"com.sybase.jdbc2.jdbc.SybDriver", "com.sybase.jdbc4.jdbc.SybDriver"}, new String[0], "sybase", "org.hibernate.dialect.SybaseDialect"),
    TEIID("Teiid", new String[]{"org.teiid.jdbc.TeiidDriver"}, new String[0], "teiid", "org.teiid.dialect.TeiidDialect"),
    VERTICA("Vertica", new String[]{"com.vertica.jdbc.Driver"}, new String[0], "vertica", null),
    NETEZZA("Netezza", new String[]{"org.netezza.Driver "}, new String[0], "netezza", null),
    TERADATA("Teradata", new String[]{"com.teradata.jdbc.TeraDriver"}, new String[0], "teradata", "org.hibernate.dialect.Teradata14Dialect"),
    FILE("file", new String[]{FileConnectionFactory.class.getName()}, new String[0], "file", null),
    LOOPBACK("loopback", new String[0], new String[0], "loopback", null),
    REST("rest", new String[]{"org.teiid.spring.data.rest.RestConnectionFactory"}, new String[0], "ws", null),
    EXCEL("excel", new String[]{"org.teiid.spring.data.excel.ExcelConnectionFactory"}, new String[0], "excel", null),
    MONGODB("mongodb", new String[]{"org.teiid.spring.data.mongodb.MongoDBConnectionFactory"}, new String[0], "mongodb", null);

    private String name;
    private String[] driverNames;
    private String[] datasourceNames;
    private String translatorName;
    private String dialect;

    private ExternalSource(String name, String[] driverNames, String[] datasourceNames, String translatorName, String dialect) {
        this.name = name;
        this.driverNames = driverNames;
        this.datasourceNames = datasourceNames;
        this.translatorName = translatorName;
        this.dialect = dialect;
    }

    public String getName() {
        return this.name;
    }

    public String[] getDriverName() {
        return this.driverNames;
    }

    public String getTranslatorName() {
        return this.translatorName;
    }

    public String getDialect() {
        return this.dialect;
    }

    public static String findTransaltorNameFromDriverName(String driverName) {
        for (ExternalSource source : ExternalSource.values()) {
            for (String driver : source.driverNames) {
                if (!driver.equals(driverName)) continue;
                return source.getTranslatorName();
            }
            for (String driver : source.datasourceNames) {
                if (!driver.equals(driverName)) continue;
                return source.getTranslatorName();
            }
        }
        return "loopback";
    }

    public static String findDialectFromDriverName(String driverName) {
        for (ExternalSource source : ExternalSource.values()) {
            for (String driver : source.driverNames) {
                if (!driver.equals(driverName)) continue;
                return source.getDialect();
            }
            for (String driver : source.datasourceNames) {
                if (!driver.equals(driverName)) continue;
                return source.getDialect();
            }
        }
        return null;
    }

    public static Class<? extends ExecutionFactory<?, ?>> translatorClass(String translatorName, String basePackage) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Translator.class));
        Class<? extends ExecutionFactory<?, ?>> clazz = ExternalSource.findTranslatorInPackage(translatorName, provider, "org.teiid.translator");
        if (clazz == null) {
            clazz = ExternalSource.findTranslatorInPackage(translatorName, provider, basePackage);
        }
        return clazz;
    }

    static Class<? extends ExecutionFactory<?, ?>> findTranslatorInPackage(String translatorName, ClassPathScanningCandidateComponentProvider provider, String packageName) {
        Set components = provider.findCandidateComponents(packageName);
        for (BeanDefinition c : components) {
            try {
                Class<?> clazz = Class.forName(c.getBeanClassName());
                String name = clazz.getAnnotation(Translator.class).name();
                if (!name.equals(translatorName)) continue;
                return clazz;
            }
            catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
                throw new IllegalStateException("Error loading translators", e);
            }
        }
        return null;
    }

    public static String findTransaltorNameFromAlias(String sourceName) {
        for (ExternalSource source : ExternalSource.values()) {
            if (!source.name.equalsIgnoreCase(sourceName)) continue;
            return source.getTranslatorName();
        }
        return null;
    }

    public static String[] findDriverNameFromAlias(String sourceName) {
        for (ExternalSource source : ExternalSource.values()) {
            if (!source.name.equalsIgnoreCase(sourceName)) continue;
            return source.getDriverName();
        }
        return null;
    }
}

