/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.config.SortedResourcesFactoryBean;
import org.teiid.spring.autoconfigure.TeiidInitializedEvent;
import org.teiid.spring.autoconfigure.TeiidServer;

class TeiidInitializer
implements ApplicationListener<TeiidInitializedEvent> {
    private static final Log logger = LogFactory.getLog(TeiidInitializer.class);
    private final ApplicationContext applicationContext;
    private TeiidServer teiidServer;
    private boolean initialized = false;

    TeiidInitializer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        if (this.applicationContext.getBeanNamesForType(TeiidServer.class, false, false).length > 0) {
            this.teiidServer = (TeiidServer)((Object)this.applicationContext.getBean(TeiidServer.class));
        }
        if (this.teiidServer == null) {
            logger.debug((Object)"No DataSource found so not initializing");
            return;
        }
        this.runSchemaScripts();
    }

    private void runSchemaScripts() {
    }

    public void onApplicationEvent(TeiidInitializedEvent event) {
        if (!this.initialized) {
            this.runDataScripts();
            this.initialized = true;
        }
    }

    private void runDataScripts() {
    }

    static List<Resource> getScripts(String propertyName, String vdb, String fallback, ApplicationContext context) {
        if (vdb == null) {
            vdb = fallback;
        }
        ArrayList<String> fallbackResources = new ArrayList<String>();
        fallbackResources.add("classpath*:" + vdb);
        return TeiidInitializer.getResources(propertyName, fallbackResources, context);
    }

    private static List<Resource> getResources(String propertyName, List<String> locations, ApplicationContext context) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String location : locations) {
            for (Resource resource : TeiidInitializer.doGetResources(location, context)) {
                if (!resource.exists()) continue;
                resources.add(resource);
            }
        }
        return resources;
    }

    private static Resource[] doGetResources(String location, ApplicationContext context) {
        try {
            SortedResourcesFactoryBean factory = new SortedResourcesFactoryBean((ResourceLoader)context, Collections.singletonList(location));
            factory.afterPropertiesSet();
            return (Resource[])factory.getObject();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to load resources from " + location, ex);
        }
    }
}

