/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.spring.autoconfigure.TeiidServer;

public class TeiidSpringDriver
implements Driver {
    private Driver delegate;
    private TeiidServer server;
    private VDBMetaData vdb;

    public TeiidSpringDriver(Driver d, TeiidServer server, VDBMetaData vdb) {
        this.delegate = d;
        this.server = server;
        this.vdb = vdb;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.delegate.acceptsURL(url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        boolean exists = false;
        try {
            exists = this.server.getAdmin().getVDB(this.vdb.getName(), this.vdb.getVersion()) != null;
        }
        catch (AdminException adminException) {
            // empty catch block
        }
        if (!this.vdb.getName().equals("spring") && exists) {
            url = url.replace("spring", this.vdb.getName());
        }
        return this.delegate.connect(url, info);
    }

    @Override
    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.delegate.getPropertyInfo(url, info);
    }

    @Override
    public boolean jdbcCompliant() {
        return this.delegate.jdbcCompliant();
    }
}

