/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.identity;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.teiid.security.Credentials;
import org.teiid.security.GSSResult;
import org.teiid.security.SecurityHelper;
import org.teiid.spring.identity.SimpleGroup;
import org.teiid.spring.identity.SimplePrincipal;
import org.teiid.spring.identity.TeiidSecurityContext;

public class SpringSecurityHelper
implements SecurityHelper {
    private static ThreadLocal<TeiidSecurityContext> securityContext = new ThreadLocal();
    private static final Log logger = LogFactory.getLog(SpringSecurityHelper.class);

    public TeiidSecurityContext associateSecurityContext(Object newContext) {
        TeiidSecurityContext context = securityContext.get();
        if (newContext != context) {
            securityContext.set((TeiidSecurityContext)newContext);
        }
        return context;
    }

    public void clearSecurityContext() {
        securityContext.remove();
    }

    public TeiidSecurityContext getSecurityContext() {
        return securityContext.get();
    }

    public Subject getSubjectInContext(String securityDomain) {
        TeiidSecurityContext tsc = securityContext.get();
        if (tsc != null && tsc.getSecurityDomain().equals(securityDomain)) {
            return this.getSubjectInContext(tsc);
        }
        return null;
    }

    public Subject getSubjectInContext(Object context) {
        if (!(context instanceof TeiidSecurityContext)) {
            return null;
        }
        TeiidSecurityContext sc = (TeiidSecurityContext)context;
        return sc.getSubject();
    }

    public Object authenticate(String securityDomain, String baseUserName, Credentials credentials, String applicationName) throws LoginException {
        Subject s = null;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && !(authentication instanceof AnonymousAuthenticationToken)) {
            s = this.buildSubject(authentication);
            baseUserName = authentication.getName();
        } else {
            s = new Subject();
            s.getPrincipals().add(new SimplePrincipal(baseUserName));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Logged in user: " + s));
        }
        TeiidSecurityContext tsc = new TeiidSecurityContext(s, baseUserName, securityDomain);
        this.associateSecurityContext(tsc);
        return tsc;
    }

    public GSSResult negotiateGssLogin(String securityDomain, byte[] serviceTicket) throws LoginException {
        return null;
    }

    private Subject buildSubject(Authentication authentication) {
        Subject s = new Subject();
        s.getPrincipals().add(new SimplePrincipal(authentication == null ? "anonymous" : authentication.getName()));
        if (authentication != null) {
            SimpleGroup g = new SimpleGroup("Roles");
            for (GrantedAuthority ga : authentication.getAuthorities()) {
                String role = ga.getAuthority();
                if (!role.startsWith("ROLE_")) continue;
                role = role.substring(5);
                g.addMember(new SimplePrincipal(role));
            }
            s.getPrincipals().add(g);
        }
        return s;
    }
}

