/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.hibernate.types;

import java.sql.Array;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.usertype.DynamicParameterizedType;
import org.teiid.hibernate.types.ArrayUtil;

public abstract class AbstractArrayTypeDescriptor<T>
extends AbstractTypeDescriptor<T>
implements DynamicParameterizedType {
    private static final long serialVersionUID = 7698345570957205617L;
    private Class<T> arrayObjectClass;

    public void setParameterValues(Properties parameters) {
        this.arrayObjectClass = ((DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType")).getReturnedClass();
    }

    public AbstractArrayTypeDescriptor(Class<T> arrayObjectClass) {
        super(arrayObjectClass, (MutabilityPlan)new MutableMutabilityPlan<Object>(){

            protected T deepCopyNotNull(Object value) {
                return ArrayUtil.deepCopy(value);
            }
        });
        this.arrayObjectClass = arrayObjectClass;
    }

    public boolean areEqual(Object one, Object another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return ArrayUtil.isEquals(one, another);
    }

    public String toString(Object value) {
        return Arrays.deepToString((Object[])value);
    }

    public T fromString(String string) {
        return ArrayUtil.fromString(string, this.arrayObjectClass);
    }

    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        return (X)ArrayUtil.wrapArray(value);
    }

    public <X> T wrap(X value, WrapperOptions options) {
        if (value instanceof Array) {
            Array array = (Array)value;
            try {
                return ArrayUtil.unwrapArray((Object[])array.getArray(), this.arrayObjectClass);
            }
            catch (SQLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return (T)value;
    }

    protected abstract String getSqlArrayType();
}

