/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.teiid.spring.autoconfigure.DelegatingPlatformTransactionManager;
import org.teiid.spring.data.BaseConnectionFactory;

public final class PlatformTransactionManagerAdapter
implements TransactionManager {
    private List<PlatformTransactionManager> txnManagersForEachDataSource = new ArrayList<PlatformTransactionManager>();
    private static DefaultTransactionDefinition NEW_TRANSACTION_DEFINITION = new DefaultTransactionDefinition();
    private static DefaultTransactionDefinition EXISTING_TRANSACTION_DEFINITION;
    private static final ThreadLocal<TransactionHolder> TRANSACTION_HOLDERS;
    private PlatformTransactionManager platformTransactionManager;
    private WeakHashMap<TransactionStatus, PlatformTransactionAdapter> transactions = new WeakHashMap();

    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
        if (this.platformTransactionManager instanceof DelegatingPlatformTransactionManager) {
            ((DelegatingPlatformTransactionManager)this.platformTransactionManager).setTransactionManagers(this.txnManagersForEachDataSource);
        }
    }

    public Transaction getTransaction() throws SystemException {
        try {
            if (this.platformTransactionManager == null) {
                return null;
            }
            TransactionHolder holder = this.getOrCreateTransaction(false);
            if (holder == null) {
                return null;
            }
            return holder.transaction;
        }
        catch (IllegalTransactionStateException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionHolder getOrCreateTransaction(boolean start) {
        TransactionStatus status = null;
        try {
            status = TransactionAspectSupport.currentTransactionStatus();
        }
        catch (NoTransactionException e) {
            if (start) {
                status = this.platformTransactionManager.getTransaction((TransactionDefinition)NEW_TRANSACTION_DEFINITION);
                TransactionHolder holder = new TransactionHolder(status, new PlatformTransactionAdapter(status));
                TRANSACTION_HOLDERS.set(holder);
                return holder;
            }
            try {
                status = this.platformTransactionManager.getTransaction((TransactionDefinition)EXISTING_TRANSACTION_DEFINITION);
                return TRANSACTION_HOLDERS.get();
            }
            catch (TransactionException e1) {
                TRANSACTION_HOLDERS.remove();
            }
        }
        if (status == null) {
            return null;
        }
        WeakHashMap<TransactionStatus, PlatformTransactionAdapter> weakHashMap = this.transactions;
        synchronized (weakHashMap) {
            PlatformTransactionAdapter adapter = this.transactions.get(status);
            if (adapter == null) {
                adapter = new PlatformTransactionAdapter(status);
                this.transactions.put(status, adapter);
            }
            return new TransactionHolder(status, adapter);
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        throw this.useTransactionManager();
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        throw this.useTransactionManager();
    }

    public void begin() throws NotSupportedException, SystemException {
        throw this.useTransactionManager();
    }

    public Transaction suspend() throws SystemException {
        throw this.useTransactionManager();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        throw this.useTransactionManager();
    }

    public void resume(Transaction tobj) throws IllegalStateException, InvalidTransactionException, SystemException {
        throw this.useTransactionManager();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        throw this.useTransactionManager();
    }

    public int getStatus() throws SystemException {
        throw this.useTransactionManager();
    }

    private SystemException useTransactionManager() {
        return new SystemException("The system is only setup for spring managed transactions.  If you need Teiid to manage transactions, then a third-party transaction manager like narayana-spring-boot-starter needs to be configured.");
    }

    public void addDataSource(DataSource ds) {
        this.txnManagersForEachDataSource.add((PlatformTransactionManager)new DataSourceTransactionManager(ds));
    }

    public void addDataSource(BaseConnectionFactory bean) {
    }

    public void commit(TransactionStatus status) {
        this.platformTransactionManager.commit(status);
        TRANSACTION_HOLDERS.remove();
    }

    public void rollback(TransactionStatus status) {
        this.platformTransactionManager.rollback(status);
        TRANSACTION_HOLDERS.remove();
    }

    static {
        NEW_TRANSACTION_DEFINITION.setPropagationBehavior(3);
        EXISTING_TRANSACTION_DEFINITION = new DefaultTransactionDefinition();
        EXISTING_TRANSACTION_DEFINITION.setPropagationBehavior(2);
        TRANSACTION_HOLDERS = new ThreadLocal();
    }

    private static final class PlatformTransactionAdapter
    implements Transaction {
        private WeakReference<TransactionStatus> transactionStatus;

        PlatformTransactionAdapter(TransactionStatus status) {
            this.transactionStatus = new WeakReference<TransactionStatus>(status);
        }

        public void registerSynchronization(final Synchronization synch) throws IllegalStateException, RollbackException, SystemException {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void beforeCompletion() {
                    synch.beforeCompletion();
                }

                public void afterCompletion(int status) {
                    switch (status) {
                        case 0: {
                            status = 3;
                            break;
                        }
                        case 1: {
                            status = 4;
                            break;
                        }
                        case 2: {
                            status = 5;
                        }
                    }
                    synch.afterCompletion(status);
                }
            });
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            TransactionStatus status = (TransactionStatus)this.transactionStatus.get();
            if (status == null) {
                throw new IllegalStateException();
            }
            status.setRollbackOnly();
        }

        public void rollback() throws IllegalStateException, SystemException {
            throw new SystemException("This is a spring managed transaction, it should not direclty manipulated");
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
            throw new SystemException("This is a spring managed transaction, it should not direclty manipulated");
        }

        public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
            throw new SystemException("This is a spring managed transaction, it should not direclty manipulated");
        }

        public boolean enlistResource(XAResource xaRes) throws IllegalStateException, RollbackException, SystemException {
            throw new SystemException("This is a spring managed transaction, it should not direclty manipulated");
        }

        public int getStatus() throws SystemException {
            throw new SystemException("This is a spring managed transation.  This method isn not implemented.");
        }
    }

    public static class TransactionHolder {
        public final TransactionStatus status;
        public final Transaction transaction;

        TransactionHolder(TransactionStatus status, PlatformTransactionAdapter adapter) {
            this.status = status;
            this.transaction = adapter;
        }
    }
}

