/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.sql.Driver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.Scope;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.jdbc.datasource.embedded.ConnectionProperties;
import org.springframework.jdbc.datasource.embedded.DataSourceFactory;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactory;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.cache.CacheFactory;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.metadatastore.DeploymentBasedDatabaseStore;
import org.teiid.query.metadata.NioVirtualFile;
import org.teiid.query.metadata.VDBResources;
import org.teiid.query.metadata.VirtualFile;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.security.SecurityHelper;
import org.teiid.spring.autoconfigure.NioZipFileSystem;
import org.teiid.spring.autoconfigure.PlatformTransactionManagerAdapter;
import org.teiid.spring.autoconfigure.TeiidDatabaseConfigurer;
import org.teiid.spring.autoconfigure.TeiidInitializer;
import org.teiid.spring.autoconfigure.TeiidPostProcessor;
import org.teiid.spring.autoconfigure.TeiidProperties;
import org.teiid.spring.autoconfigure.TeiidServer;
import org.teiid.spring.autoconfigure.TeiidSpringDriver;
import org.teiid.spring.data.file.FileConnectionFactory;
import org.teiid.spring.identity.SpringSecurityHelper;
import org.teiid.spring.util.KeystoreUtil;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.WireProtocol;
import org.xml.sax.SAXException;

@Configuration
@ConditionalOnClass(value={EmbeddedServer.class, ExecutionFactory.class})
@EnableConfigurationProperties(value={TeiidProperties.class})
@Import(value={TeiidPostProcessor.Registrar.class})
@PropertySource(value={"classpath:teiid.properties"})
public class TeiidAutoConfiguration
implements Ordered {
    static final String IMPLICIT_VDB = "implicit";
    public static ThreadLocal<TeiidServer> serverContext = new ThreadLocal();
    private static final Log logger = LogFactory.getLog(TeiidAutoConfiguration.class);
    private static String KEY_STORE_NAME = "keystore";
    private static String KEY_STORE_TYPE = "jks";
    private static String KEY_STORE_PASSWORD = "changeit";
    @Autowired(required=false)
    private EmbeddedConfiguration embeddedConfiguration;
    @Autowired
    private TeiidProperties properties;
    @Autowired
    ApplicationContext context;
    @Value(value="${spring.jpa.hibernate.naming.physical-strategy:org.springframework.boot.orm.jpa.hibernate.SpringPhysicalNamingStrategy}")
    private String hibernateNamingClass;
    @Autowired(required=false)
    private TransactionManager transactionManager;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Bean
    @ConditionalOnMissingBean
    public TeiidInitializer teiidInitializer(ApplicationContext applicationContext) {
        return new TeiidInitializer(applicationContext);
    }

    @Bean(name={"dataSource"})
    @Primary
    @ConfigurationProperties(prefix="spring.datasource")
    public DataSource getDataSource(final TeiidServer server, final VDBMetaData vdb) {
        EmbeddedDatabaseFactory edf = new EmbeddedDatabaseFactory();
        edf.setDatabaseConfigurer((EmbeddedDatabaseConfigurer)new TeiidDatabaseConfigurer(server));
        edf.setDataSourceFactory(new DataSourceFactory(){

            public DataSource getDataSource() {
                String url = TeiidAutoConfiguration.this.context.getEnvironment().getProperty("spring.datasource.teiid.url");
                return new SimpleDriverDataSource((Driver)new TeiidSpringDriver((Driver)server.getDriver(), server, vdb), url);
            }

            public ConnectionProperties getConnectionProperties() {
                return new ConnectionProperties(){

                    public void setDriverClass(Class<? extends Driver> driverClass) {
                    }

                    public void setUrl(String url) {
                    }

                    public void setUsername(String username) {
                    }

                    public void setPassword(String password) {
                    }
                };
            }
        });
        return edf.getDatabase();
    }

    @Bean
    @ConditionalOnMissingBean
    public VDBMetaData teiidVDB() {
        List<Resource> resources = null;
        if (this.properties.getVdbFile() != null) {
            resources = TeiidInitializer.getClasspathResources(this.context, this.properties.getVdbFile());
            if (resources.isEmpty()) {
                throw new IllegalStateException("Failed to find" + this.properties.getVdbFile());
            }
        } else {
            resources = TeiidInitializer.getClasspathResources(this.context, "teiid.ddl", "teiid.vdb");
        }
        VDBMetaData vdb = null;
        if (!resources.isEmpty()) {
            Resource resource = resources.iterator().next();
            if (resource.getFilename().endsWith(".ddl")) {
                try {
                    DeploymentBasedDatabaseStore store = new DeploymentBasedDatabaseStore(new VDBRepository());
                    String db = ObjectConverterUtil.convertToString((InputStream)resources.get(0).getInputStream());
                    vdb = store.getVDBMetadata(db);
                    logger.info((Object)("Predefined VDB found = " + resource.getFilename()));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to parse the VDB defined");
                }
            }
            if (resource.getFilename().endsWith("-vdb.xml")) {
                try {
                    vdb = VDBMetadataParser.unmarshall((InputStream)resource.getInputStream());
                    logger.info((Object)("Predefined VDB found = " + resource.getFilename()));
                }
                catch (IOException | XMLStreamException e) {
                    throw new IllegalStateException("Failed to load the VDB defined", e);
                }
            }
            if (resource.getFilename().endsWith(".vdb")) {
                try {
                    vdb = this.loadVDB(resource);
                    logger.info((Object)("Predefined VDB found = " + resource.getFilename()));
                }
                catch (IOException | URISyntaxException | VirtualDatabaseException | ConnectorManagerRepository.ConnectorManagerException | TranslatorException e) {
                    throw new IllegalStateException("Failed to load the VDB defined", e);
                }
            }
        }
        if (vdb == null) {
            vdb = new VDBMetaData();
            vdb.addProperty(IMPLICIT_VDB, "true");
            vdb.setName("spring");
            vdb.setVersion("1.0.0");
        }
        return vdb;
    }

    private VDBMetaData loadVDB(Resource resource) throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException, IOException, URISyntaxException {
        VDBMetaData metadata;
        NioVirtualFile root = NioZipFileSystem.mount(resource.getInputStream());
        VirtualFile vdbMetadata = root.getChild("/vdb.xml");
        if (!vdbMetadata.exists()) {
            vdbMetadata = root.getChild("/META-INF/vdb.xml");
        }
        if (vdbMetadata.exists()) {
            try {
                VDBMetadataParser.validate((InputStream)vdbMetadata.openStream());
            }
            catch (SAXException e) {
                throw new VirtualDatabaseException((Exception)e);
            }
            InputStream is = vdbMetadata.openStream();
            try {
                metadata = VDBMetadataParser.unmarshall((InputStream)is);
            }
            catch (XMLStreamException e) {
                throw new VirtualDatabaseException((Exception)e);
            }
        }
        vdbMetadata = root.getChild("/vdb.ddl");
        if (!vdbMetadata.exists()) {
            vdbMetadata = root.getChild("/META-INF/vdb.ddl");
        }
        DeploymentBasedDatabaseStore store = new DeploymentBasedDatabaseStore(new VDBRepository());
        try {
            metadata = store.getVDBMetadata(ObjectConverterUtil.convertToString((InputStream)vdbMetadata.openStream()));
        }
        catch (IOException e) {
            throw new VirtualDatabaseException("Could not find a vdb.xml or vdb.ddl file in " + resource.getFilename());
        }
        VDBResources resources = new VDBResources((VirtualFile)root);
        metadata.addAttachment(VDBResources.class, (Object)resources);
        return metadata;
    }

    @Bean(name={"teiid"})
    @ConditionalOnMissingBean
    @Scope(value="singleton")
    public TeiidServer teiidServer(SpringSecurityHelper securityHelper) {
        logger.info((Object)"Starting Teiid Server.");
        System.setProperty("org.teiid.addPGMetadata", Boolean.toString(this.properties.isPgEnable() || this.properties.isPgSecureEnable()));
        System.setProperty("org.teiid.hiddenMetadataResolvable", "false");
        System.setProperty("org.teiid.allowAlter", Boolean.toString(this.properties.isAllowAlter()));
        TeiidServer server = new TeiidServer();
        if (this.embeddedConfiguration == null) {
            SocketConfiguration sc;
            this.embeddedConfiguration = new EmbeddedConfiguration();
            this.embeddedConfiguration.setCacheFactory((CacheFactory)new CaffeineCacheFactory());
            if (this.properties.isJdbcEnable()) {
                sc = new SocketConfiguration();
                sc.setBindAddress(this.properties.getHostName());
                sc.setPortNumber(this.properties.getJdbcPort());
                sc.setProtocol(WireProtocol.teiid);
                this.embeddedConfiguration.addTransport(sc);
                logger.info((Object)("JDBC is opened on = " + this.properties.getHostName() + ":" + this.properties.getJdbcPort()));
            }
            if (this.properties.isJdbcSecureEnable() || this.properties.isPgSecureEnable()) {
                if (this.properties.getTlsCertificate() != null && this.properties.getTlsKey() != null) {
                    try {
                        File keystore = File.createTempFile(KEY_STORE_NAME, KEY_STORE_TYPE);
                        keystore.deleteOnExit();
                        String keystoreFileName = keystore.getAbsolutePath();
                        KeystoreUtil.createKeystore(this.properties.getTlsKey(), this.properties.getTlsCertificate(), this.properties.getCaCertificateFile(), keystoreFileName, KEY_STORE_PASSWORD);
                        this.properties.getSsl().setKeystoreFilename(keystoreFileName);
                        this.properties.getSsl().setKeystorePassword(KEY_STORE_PASSWORD);
                        this.properties.getSsl().setKeystoreKeyPassword(KEY_STORE_PASSWORD);
                        logger.info((Object)"Created a Java JKS keystore from the tls keys provided.");
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to convert tls.key and tls.crt files into Java keystore for use in secured JDBC/PG ", (Throwable)e);
                    }
                } else {
                    logger.info((Object)"No tls.key and tls.crt files provided for SSL, going to use SSL configuration directly");
                }
            }
            if (this.properties.isJdbcSecureEnable()) {
                sc = new SocketConfiguration();
                sc.setBindAddress(this.properties.getHostName());
                sc.setPortNumber(this.properties.getJdbcSecurePort());
                sc.setProtocol(WireProtocol.teiid);
                sc.setSSLConfiguration(this.properties.getSsl());
                this.embeddedConfiguration.addTransport(sc);
                logger.info((Object)("Secure JDBC is opened on = " + this.properties.getHostName() + ":" + this.properties.getJdbcSecurePort()));
            }
            if (this.properties.isPgEnable()) {
                sc = new SocketConfiguration();
                sc.setBindAddress(this.properties.getHostName());
                sc.setPortNumber(this.properties.getPgPort());
                sc.setProtocol(WireProtocol.pg);
                this.embeddedConfiguration.addTransport(sc);
                logger.info((Object)("PG is opened on = " + this.properties.getHostName() + ":" + this.properties.getPgPort()));
            }
            if (this.properties.isPgSecureEnable()) {
                sc = new SocketConfiguration();
                sc.setBindAddress(this.properties.getHostName());
                sc.setPortNumber(this.properties.getPgSecurePort());
                sc.setProtocol(WireProtocol.pg);
                sc.setSSLConfiguration(this.properties.getSsl());
                this.embeddedConfiguration.addTransport(sc);
                logger.info((Object)("Secure PG is opened on = " + this.properties.getHostName() + ":" + this.properties.getPgSecurePort()));
            }
        }
        if (this.embeddedConfiguration.getTransactionManager() == null) {
            if (this.transactionManager != null) {
                logger.info((Object)"Transaction Manager found and being registed into Teiid.");
                this.embeddedConfiguration.setTransactionManager(this.transactionManager);
            } else {
                PlatformTransactionManagerAdapter ptma = server.getPlatformTransactionManagerAdapter();
                this.embeddedConfiguration.setTransactionManager((TransactionManager)ptma);
                server.setUsingPlatformTransactionManager(true);
            }
        } else if (this.transactionManager != null && this.transactionManager != this.embeddedConfiguration.getTransactionManager()) {
            throw new IllegalStateException("TransactionManager defined in both Spring and on the EmbeddedConfiguration.  Only one is expected.");
        }
        if (this.embeddedConfiguration.getSecurityHelper() == null) {
            this.embeddedConfiguration.setSecurityDomain("spring-security");
            this.embeddedConfiguration.setSecurityHelper((SecurityHelper)securityHelper);
        }
        server.start(this.embeddedConfiguration);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("spring");
        vdb.setVersion("1.0.0");
        server.deployVDB(vdb, false, this.context);
        serverContext.set(server);
        return server;
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="singleton")
    public SpringSecurityHelper securityHelper() {
        return new SpringSecurityHelper();
    }

    @Bean(name={"file"})
    @ConditionalOnMissingBean
    public FileConnectionFactory fileConnectionFactory() {
        return new FileConnectionFactory();
    }

    @Bean(name={"teiidNamingStrategy"})
    public PhysicalNamingStrategy teiidNamingStrategy() {
        try {
            return (PhysicalNamingStrategy)Class.forName(this.hibernateNamingClass).getDeclaredConstructors()[0].newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    static class CaffeineCache<K, V>
    implements org.teiid.cache.Cache<K, V> {
        private String name;
        private Cache<K, V> delegate;

        CaffeineCache(String cacheName, int maxSize) {
            this.name = cacheName;
            this.delegate = Caffeine.newBuilder().weakKeys().weakValues().maximumSize(maxSize < 0 ? 10000L : (long)maxSize).build();
        }

        public V put(K key, V value, Long ttl) {
            this.delegate.put(key, value);
            return (V)this.delegate.getIfPresent(key);
        }

        public String getName() {
            return this.name;
        }

        public boolean isTransactional() {
            return false;
        }

        public V get(K key) {
            return (V)this.delegate.getIfPresent(key);
        }

        public V remove(K key) {
            Object v = this.delegate.getIfPresent(key);
            this.delegate.invalidate(key);
            return (V)v;
        }

        public int size() {
            return Math.toIntExact(this.delegate.estimatedSize());
        }

        public void clear() {
            this.delegate.invalidateAll();
        }

        public Set<K> keySet() {
            return this.delegate.asMap().keySet();
        }
    }

    static class CaffeineCacheFactory
    implements CacheFactory {
        Map<String, org.teiid.cache.Cache> map = new HashMap<String, org.teiid.cache.Cache>();

        CaffeineCacheFactory() {
        }

        public <K, V> org.teiid.cache.Cache<K, V> get(String name) {
            this.map.put(name, new CaffeineCache(name, 256));
            return this.map.get(name);
        }

        public void destroy() {
            HashSet<String> keys = new HashSet<String>(this.map.keySet());
            keys.forEach(k -> this.map.get(k).clear());
            this.map.clear();
        }
    }
}

