/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.type.classreading.MethodMetadataReadingVisitor;
import org.springframework.stereotype.Component;
import org.teiid.spring.data.BaseConnectionFactory;

@Component
public class TeiidBeanDefinitionPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final Log logger = LogFactory.getLog(TeiidBeanDefinitionPostProcessor.class);

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ArrayList<String> datasources = new ArrayList<String>();
        BeanDefinition datasourceBeanDefinition = registry.getBeanDefinition("dataSource");
        for (String beanName : registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition;
            if (beanName.startsWith("org.springframework") || beanName.contentEquals("dataSource") || !this.isMatch(beanDefinition = registry.getBeanDefinition(beanName), beanName)) continue;
            datasources.add(beanName);
        }
        logger.info((Object)("Found data sources: " + datasources));
        datasourceBeanDefinition.setDependsOn(datasources.toArray(new String[datasources.size()]));
    }

    private boolean isMatch(BeanDefinition beanDefinition, String beanName) {
        Object source;
        String className = beanDefinition.getBeanClassName();
        if (className == null && beanDefinition.getFactoryMethodName() != null && beanDefinition.getFactoryMethodName().contentEquals(beanName) && (source = beanDefinition.getSource()) instanceof MethodMetadataReadingVisitor) {
            String returnType = ((MethodMetadataReadingVisitor)source).getReturnTypeName();
            if (returnType.contentEquals("javax.sql.DataSource")) {
                return true;
            }
            if (returnType.startsWith("org.springframework") || returnType.startsWith("io.micrometer") || returnType.startsWith("com.fasterxml.") || returnType.startsWith("org.hibernate.")) {
                return false;
            }
            className = returnType;
        }
        if (className != null) {
            try {
                Class<?> beanClass = Class.forName(className);
                if (DataSource.class.isAssignableFrom(beanClass) || BaseConnectionFactory.class.isAssignableFrom(beanClass)) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

