/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.jdbc.XADataSourceWrapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.teiid.PreParser;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.spring.autoconfigure.MultiDataSourceInitializer;
import org.teiid.spring.autoconfigure.TeiidInitializer;
import org.teiid.spring.autoconfigure.TeiidServer;
import org.teiid.spring.data.BaseConnectionFactory;
import org.teiid.spring.identity.SpringSecurityHelper;
import org.teiid.translator.ExecutionFactory;

class TeiidPostProcessor
implements BeanPostProcessor,
Ordered,
ApplicationListener<ContextRefreshedEvent> {
    private static final Log logger = LogFactory.getLog(TeiidPostProcessor.class);
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private ApplicationContext context;
    @Autowired(required=false)
    private XADataSourceWrapper xaWrapper;

    TeiidPostProcessor() {
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource) {
            this.beanFactory.getBean("teiid", TeiidServer.class);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        SpringSecurityHelper springSecurityHelper;
        if (bean instanceof TeiidServer) {
            this.beanFactory.getBean(TeiidInitializer.class);
        } else if ((bean instanceof DataSource || bean instanceof XADataSource) && !beanName.equals("dataSource")) {
            TeiidServer server = (TeiidServer)((Object)this.beanFactory.getBean(TeiidServer.class));
            VDBMetaData vdb = (VDBMetaData)this.beanFactory.getBean(VDBMetaData.class);
            DataSource ds = null;
            if (bean instanceof XADataSource) {
                try {
                    if (this.xaWrapper == null) {
                        throw new IllegalStateException("XA data source is configured, however no JTA transaction manager is defined in the pom.xml as dependency to this project");
                    }
                    ds = this.xaWrapper.wrapDataSource((XADataSource)bean);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            } else {
                ds = (DataSource)bean;
                server.getPlatformTransactionManagerAdapter().addDataSource(ds);
            }
            new MultiDataSourceInitializer(ds, beanName, this.context).init();
            server.addDataSource(vdb, beanName, ds, this.context);
            logger.info((Object)("Datasource added to Teiid = " + beanName));
        } else if (bean instanceof BaseConnectionFactory) {
            TeiidServer server = (TeiidServer)((Object)this.beanFactory.getBean(TeiidServer.class));
            VDBMetaData vdb = (VDBMetaData)this.beanFactory.getBean(VDBMetaData.class);
            server.addDataSource(vdb, beanName, bean, this.context);
            logger.info((Object)("Non JDBC Datasource added to Teiid = " + beanName));
            server.getPlatformTransactionManagerAdapter().addDataSource((BaseConnectionFactory)bean);
        } else if (bean instanceof PlatformTransactionManager) {
            TeiidServer server = (TeiidServer)((Object)this.beanFactory.getBean(TeiidServer.class));
            server.getPlatformTransactionManagerAdapter().setPlatformTransactionManager((PlatformTransactionManager)bean);
        } else if (bean instanceof ExecutionFactory) {
            TeiidServer server = (TeiidServer)((Object)this.beanFactory.getBean(TeiidServer.class));
            server.addTranslator(beanName, (ExecutionFactory)bean);
        } else if (bean instanceof PreParser) {
            TeiidServer server = (TeiidServer)((Object)this.beanFactory.getBean(TeiidServer.class));
            server.setPreParser((PreParser)bean);
        } else if (bean instanceof AuthenticationManager && (springSecurityHelper = (SpringSecurityHelper)this.beanFactory.getBean(SpringSecurityHelper.class)) != null) {
            springSecurityHelper.setAuthenticationManager((AuthenticationManager)bean);
        }
        return bean;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        boolean deploy = true;
        VDBMetaData vdb = (VDBMetaData)this.beanFactory.getBean(VDBMetaData.class);
        TeiidServer server = (TeiidServer)((Object)this.beanFactory.getBean(TeiidServer.class));
        if (Boolean.valueOf(vdb.getPropertyValue("implicit")).booleanValue()) {
            PhysicalNamingStrategy namingStrategy = (PhysicalNamingStrategy)this.beanFactory.getBean(PhysicalNamingStrategy.class);
            deploy = server.findAndConfigureViews(vdb, event.getApplicationContext(), namingStrategy);
        }
        if (deploy) {
            server.undeployVDB("spring");
            server.undeployVDB(vdb.getName(), vdb.getVersion());
            server.deployVDB(vdb, true, this.context);
        }
    }

    static class Registrar
    implements ImportBeanDefinitionRegistrar {
        private static final String BEAN_NAME = "teiidInitializerPostProcessor";

        Registrar() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition(BEAN_NAME)) {
                GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
                beanDefinition.setBeanClass(TeiidPostProcessor.class);
                beanDefinition.setRole(0);
                beanDefinition.setSynthetic(true);
                registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)beanDefinition);
            }
        }
    }
}

