/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.teiid.spring.util.PKCS1Util;

public class KeystoreUtil {
    public static void createKeystore(String tlsKey, String tlsCert, String caCertFile, String keystoreFile, String password) throws Exception {
        PrivateKey privateKey;
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, password.toCharArray());
        List<X509Certificate> certificateChain = KeystoreUtil.readCertificateChain(tlsCert);
        for (X509Certificate certificate : certificateChain) {
            X500Principal principal = certificate.getSubjectX500Principal();
            ks.setCertificateEntry(principal.getName("RFC2253"), certificate);
        }
        List<byte[]> keyBytes = KeystoreUtil.decodePem(tlsKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        try {
            privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes.get(0)));
        }
        catch (InvalidKeySpecException e) {
            RSAPrivateCrtKeySpec keySpec = PKCS1Util.decodePKCS1(keyBytes.get(0));
            privateKey = keyFactory.generatePrivate(keySpec);
        }
        ks.setKeyEntry("key-alias", privateKey, password.toCharArray(), (Certificate[])certificateChain.stream().toArray(Certificate[]::new));
        File caCert = new File(caCertFile);
        if (caCert.exists()) {
            KeystoreUtil.updateWithCaPem(ks, caCert);
        }
        try (FileOutputStream fos = new FileOutputStream(keystoreFile);){
            ks.store(fos, password.toCharArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateWithCaPem(KeyStore pTrustStore, File pCaCert) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try (FileInputStream is = new FileInputStream(pCaCert);){
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            Collection<? extends Certificate> certificates = certFactory.generateCertificates(is);
            for (Certificate certificate : certificates) {
                X509Certificate cert = (X509Certificate)certificate;
                String alias = cert.getSubjectX500Principal().getName();
                pTrustStore.setCertificateEntry(alias, cert);
            }
        }
    }

    private static List<X509Certificate> readCertificateChain(String tlsCert) throws IOException, GeneralSecurityException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        List<byte[]> certs = KeystoreUtil.decodePem(tlsCert);
        for (byte[] cert : certs) {
            certificates.add((X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(cert)));
        }
        return certificates;
    }

    private static byte[] base64Decode(String base64) {
        return Base64.getMimeDecoder().decode(base64.getBytes(StandardCharsets.US_ASCII));
    }

    private static List<byte[]> decodePem(String pemFile) throws IOException {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        try (BufferedReader reader = new BufferedReader(new StringReader(pemFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("-----BEGIN ")) continue;
                list.add(KeystoreUtil.readBytes(reader, line.trim().replace("BEGIN", "END")));
            }
            if (!list.isEmpty()) {
                ArrayList<byte[]> arrayList = list;
                return arrayList;
            }
            throw new IOException("PEM " + pemFile + " is invalid: no begin marker");
        }
    }

    private static byte[] readBytes(BufferedReader reader, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(endMarker) != -1) {
                return KeystoreUtil.base64Decode(buf.toString());
            }
            buf.append(line.trim());
        }
        throw new IOException("Certificate is invalid : No end marker");
    }
}

