/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.spring.autoconfigure.RedirectionSchemaBuilder;
import org.teiid.spring.autoconfigure.TeiidServer;

public class TestModelGenerator {
    private TeiidServer server;
    private ApplicationContext context;

    @Before
    public void setup() {
        this.server = (TeiidServer)Mockito.mock(TeiidServer.class);
        this.context = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        Environment env = (Environment)Mockito.mock(Environment.class);
        Mockito.stub((Object)env.getProperty(Mockito.anyString())).toReturn(null);
        Mockito.stub((Object)this.context.getEnvironment()).toReturn((Object)env);
    }

    private ModelMetaData buildSourceTable() {
        ModelMetaData model = new ModelMetaData();
        model.setName("source");
        model.setModelType(Model.Type.PHYSICAL);
        MetadataFactory target = new MetadataFactory("spring", (Object)"1.0.0", SystemMetadata.getInstance().getRuntimeTypeMap(), model);
        Table t = target.addTable("Person");
        target.addColumn("id", "integer", (ColumnSet)t);
        target.addColumn("name", "string", (ColumnSet)t);
        target.addColumn("dob", "date", (ColumnSet)t);
        model.addAttchment(MetadataFactory.class, (Object)target);
        String ddl = DDLStringVisitor.getDDLString((Schema)target.getSchema(), null, null);
        model.addSourceMetadata("ddl", ddl);
        return model;
    }

    private ModelMetaData buildSourceTableWithPK() {
        ModelMetaData model = new ModelMetaData();
        model.setName("source");
        model.setModelType(Model.Type.PHYSICAL);
        MetadataFactory target = new MetadataFactory("spring", (Object)"1.0.0", SystemMetadata.getInstance().getRuntimeTypeMap(), model);
        Table t = target.addTable("Person");
        target.addColumn("id", "integer", (ColumnSet)t);
        target.addColumn("name", "string", (ColumnSet)t);
        target.addColumn("dob", "date", (ColumnSet)t);
        target.addPrimaryKey("PK", Arrays.asList("id"), t);
        Table addr = target.addTable("address");
        target.addColumn("id", "integer", (ColumnSet)addr);
        target.addColumn("street", "string", (ColumnSet)addr);
        target.addColumn("pid", "integer", (ColumnSet)addr);
        target.addPrimaryKey("PK", Arrays.asList("id"), addr);
        target.addForeignKey("FK", Arrays.asList("pid"), Arrays.asList("id"), "Person", addr);
        String ddl = DDLStringVisitor.getDDLString((Schema)target.getSchema(), null, null);
        model.addSourceMetadata("ddl", ddl);
        model.addAttchment(MetadataFactory.class, (Object)target);
        return model;
    }

    private ModelMetaData buildSourceTableWithCompositePK() {
        ModelMetaData model = new ModelMetaData();
        model.setName("source");
        model.setModelType(Model.Type.PHYSICAL);
        MetadataFactory target = new MetadataFactory("spring", (Object)"1.0.0", SystemMetadata.getInstance().getRuntimeTypeMap(), model);
        Table t = target.addTable("Person");
        target.addColumn("id", "integer", (ColumnSet)t);
        target.addColumn("name", "string", (ColumnSet)t);
        target.addColumn("dob", "date", (ColumnSet)t);
        target.addPrimaryKey("PK", Arrays.asList("id", "name"), t);
        String ddl = DDLStringVisitor.getDDLString((Schema)target.getSchema(), null, null);
        model.addSourceMetadata("ddl", ddl);
        model.addAttchment(MetadataFactory.class, (Object)target);
        return model;
    }

    @Test(expected=IllegalStateException.class)
    public void testRedirectionLayer_noPK() {
        RedirectionSchemaBuilder mg = new RedirectionSchemaBuilder(this.context, "redirected");
        VDBMetaData vdb = new VDBMetaData();
        vdb.addModel(this.buildSourceTable());
        mg.buildRedirectionLayer((MetadataFactory)this.buildSourceTable().getAttachment(MetadataFactory.class), "base");
    }

    @Test
    public void testRedirectionLayerSelectPlan() {
        RedirectionSchemaBuilder mg = new RedirectionSchemaBuilder(this.context, "redirected");
        VDBMetaData vdb = new VDBMetaData();
        vdb.addModel(this.buildSourceTable());
        ModelMetaData model = mg.buildRedirectionLayer((MetadataFactory)this.buildSourceTableWithPK().getAttachment(MetadataFactory.class), "base");
        String expected = "SELECT o.id, o.name, o.dob FROM internal.Person AS o LEFT OUTER JOIN redirected.Person_REDIRECTED AS m ON (o.id = m.id) WHERE m.ROW__STATUS IS NULL \n UNION ALL \nSELECT id, name, dob FROM redirected.Person_REDIRECTED WHERE ROW__STATUS <> 3";
        MetadataFactory mf = (MetadataFactory)model.getAttachment(MetadataFactory.class);
        Table table = mf.getSchema().getTable("Person");
        Assert.assertEquals((Object)expected, (Object)table.getSelectTransformation());
    }

    @Test
    public void testRedirectionLayerInsertPlan() {
        RedirectionSchemaBuilder mg = new RedirectionSchemaBuilder(this.context, "redirected");
        VDBMetaData vdb = new VDBMetaData();
        vdb.addModel(this.buildSourceTable());
        ModelMetaData model = mg.buildRedirectionLayer((MetadataFactory)this.buildSourceTableWithPK().getAttachment(MetadataFactory.class), "base");
        String expected = "FOR EACH ROW\nBEGIN ATOMIC\n    DECLARE boolean VARIABLES.Person_PK_EXISTS = (SELECT true FROM source.Person WHERE id = NEW.id);\n    IF (VARIABLES.Person_PK_EXISTS)\n    BEGIN\n        RAISE SQLEXCEPTION 'duplicate key';\n    END\n    ELSE\n    BEGIN\n        INSERT INTO redirected.Person_REDIRECTED (id, name, dob, ROW__STATUS) VALUES (NEW.id, NEW.name, NEW.dob, 1);\n    END\nEND";
        MetadataFactory mf = (MetadataFactory)model.getAttachment(MetadataFactory.class);
        Table table = mf.getSchema().getTable("Person");
        Assert.assertEquals((Object)expected, (Object)table.getInsertPlan().replace("\t", "    "));
    }

    @Test
    public void testRedirectionLayerUpdatePlan() {
        RedirectionSchemaBuilder mg = new RedirectionSchemaBuilder(this.context, "redirected");
        ModelMetaData model = mg.buildRedirectionLayer((MetadataFactory)this.buildSourceTableWithPK().getAttachment(MetadataFactory.class), "base");
        String expected = "FOR EACH ROW\nBEGIN ATOMIC\nIF (CHANGING.id)\nBEGIN\n    DECLARE boolean VARIABLES.Person_PK_EXISTS = (SELECT true FROM source.Person WHERE id = NEW.id);\n    IF (VARIABLES.Person_PK_EXISTS)\n    BEGIN\n        RAISE SQLEXCEPTION 'duplicate key';\n    END\n    ELSE\n    BEGIN\n        DECLARE boolean VARIABLES.address_FK_EXISTS = (SELECT COUNT(*) > 0 FROM teiid.address WHERE pid = OLD.id);\n        IF (VARIABLES.address_FK_EXISTS)\n        BEGIN\n            RAISE SQLEXCEPTION 'referential integrity check failed on address table, cascade deletes are not supported';\n        END\n        UPSERT INTO redirected.Person_REDIRECTED(id, ROW__STATUS) VALUES (OLD.id, 3);\n        UPSERT INTO redirected.Person_REDIRECTED(id, name, dob, ROW__STATUS) VALUES (NEW.id, NEW.name, NEW.dob, 1);\n    END\nEND\nELSE\nBEGIN\n    UPSERT INTO redirected.Person_REDIRECTED(id, name, dob, ROW__STATUS) VALUES (NEW.id, NEW.name, NEW.dob, 2);\nEND\nEND";
        MetadataFactory mf = (MetadataFactory)model.getAttachment(MetadataFactory.class);
        Table table = mf.getSchema().getTable("Person");
        Assert.assertEquals((Object)expected, (Object)table.getUpdatePlan().replace("\t", "    "));
    }

    @Test
    public void testRedirectionLayerDeletePlan() {
        RedirectionSchemaBuilder mg = new RedirectionSchemaBuilder(this.context, "redirected");
        ModelMetaData model = mg.buildRedirectionLayer((MetadataFactory)this.buildSourceTableWithPK().getAttachment(MetadataFactory.class), "base");
        String expected = "FOR EACH ROW\nBEGIN ATOMIC\n        DECLARE boolean VARIABLES.address_FK_EXISTS = (SELECT COUNT(*) > 0 FROM teiid.address WHERE pid = OLD.id);\n        IF (VARIABLES.address_FK_EXISTS)\n        BEGIN\n            RAISE SQLEXCEPTION 'referential integrity check failed on address table, cascade deletes are not supported';\n        END\n        UPSERT INTO redirected.Person_REDIRECTED(id, ROW__STATUS) VALUES (OLD.id, 3);\nEND";
        MetadataFactory mf = (MetadataFactory)model.getAttachment(MetadataFactory.class);
        Table table = mf.getSchema().getTable("Person");
        Assert.assertEquals((Object)expected, (Object)table.getDeletePlan().replace("\t", "    "));
    }
}

