/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.internal.ExceptionHandlerHaltImpl;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.SchemaCreatorImpl;
import org.hibernate.tool.schema.internal.SchemaDropperImpl;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.metadata.Schema;
import org.teiid.spring.autoconfigure.MultiDataSourceInitializer;
import org.teiid.spring.autoconfigure.RedirectionSchemaBuilder;
import org.teiid.translator.TypeFacility;

class RedirectionSchemaInitializer
extends MultiDataSourceInitializer {
    private static final Log logger = LogFactory.getLog(RedirectionSchemaInitializer.class);
    private Dialect dialect;
    private Schema schema;
    private Metadata metadata;
    private ServiceRegistry registry;

    RedirectionSchemaInitializer(DataSource dataSource, String sourceName, Dialect dialect, Metadata metadata, ServiceRegistry registry, Schema schema, ApplicationContext applicationContext) {
        super(dataSource, sourceName, applicationContext);
        this.dialect = dialect;
        this.metadata = metadata;
        this.schema = schema;
        this.registry = registry;
    }

    @Override
    List<Resource> getScripts(String propertyName, List<String> resources, String fallback) {
        List<Resource> found = super.getScripts(propertyName, resources, fallback);
        String key = "spring.datasource." + this.sourceName + ".schema";
        if (key.equals(propertyName)) {
            if (!found.isEmpty()) {
                return Collections.emptyList();
            }
            found = this.generatedScripts();
        }
        return found;
    }

    List<Resource> generatedScripts() {
        List<Resource> resources = Collections.emptyList();
        for (PersistentClass clazz : this.metadata.getEntityBindings()) {
            Table ormTable = clazz.getTable();
            String tableName = ormTable.getQuotedName();
            if (this.schema.getTable(tableName) == null) continue;
            Column c = new Column(RedirectionSchemaBuilder.ROW_STATUS_COLUMN);
            c.setSqlTypeCode(Integer.valueOf(TypeFacility.getSQLTypeFromRuntimeType(Integer.class)));
            c.setSqlType(JDBCSQLTypeInfo.getTypeName((int)TypeFacility.getSQLTypeFromRuntimeType(Integer.class)));
            ormTable.addColumn(c);
            ormTable.setName(tableName + "_REDIRECTED");
        }
        List<String> statements = this.createScript(this.metadata, this.dialect, true);
        StringBuilder sb = new StringBuilder();
        for (String s : statements) {
            if (s.startsWith("drop sequence") || s.startsWith("create sequence")) continue;
            sb.append(s).append(";\n");
        }
        logger.debug((Object)("Redirected Schema:\n" + sb.toString()));
        resources = Arrays.asList(new ByteArrayResource(sb.toString().getBytes()));
        return resources;
    }

    List<String> createScript(Metadata metadata, Dialect d, boolean includeDrops) {
        JournalingGenerationTarget target = new JournalingGenerationTarget();
        ExecutionOptions options = new ExecutionOptions(){

            public boolean shouldManageNamespaces() {
                return false;
            }

            public Map getConfigurationValues() {
                return Collections.emptyMap();
            }

            public ExceptionHandler getExceptionHandler() {
                return ExceptionHandlerHaltImpl.INSTANCE;
            }
        };
        HibernateSchemaManagementTool tool = new HibernateSchemaManagementTool();
        tool.injectServices((ServiceRegistryImplementor)this.registry);
        SourceDescriptor sd = new SourceDescriptor(){

            public SourceType getSourceType() {
                return SourceType.METADATA;
            }

            public ScriptSourceInput getScriptSourceInput() {
                return null;
            }
        };
        if (includeDrops) {
            new SchemaDropperImpl(tool).doDrop(metadata, options, d, sd, new GenerationTarget[]{target});
        }
        new SchemaCreatorImpl(tool).doCreation(metadata, d, options, sd, new GenerationTarget[]{target});
        return target.commands;
    }

    private static class JournalingGenerationTarget
    implements GenerationTarget {
        private final ArrayList<String> commands = new ArrayList();

        private JournalingGenerationTarget() {
        }

        public void prepare() {
        }

        public void accept(String command) {
            this.commands.add(command);
        }

        public void release() {
        }
    }
}

