/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.util.List;
import org.springframework.data.transaction.ChainedTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.util.Assert;

public class DelegatingPlatformTransactionManager
implements PlatformTransactionManager {
    private List<PlatformTransactionManager> tms;
    private ChainedTransactionManager delegate;

    public TransactionStatus getTransaction(TransactionDefinition definition) throws TransactionException {
        this.check();
        return this.delegate.getTransaction(definition);
    }

    public void commit(TransactionStatus status) throws TransactionException {
        this.check();
        this.delegate.commit(status);
    }

    public void rollback(TransactionStatus status) throws TransactionException {
        this.check();
        this.delegate.rollback(status);
    }

    void setTransactionManagers(List<PlatformTransactionManager> tms) {
        this.tms = tms;
    }

    void check() throws TransactionException {
        if (this.delegate == null) {
            Assert.notNull(this.tms, (String)"No registered data sources found");
            Assert.isTrue((!this.tms.isEmpty() ? 1 : 0) != 0, (String)"No registered data sources found");
            this.delegate = new ChainedTransactionManager(this.tms.toArray(new PlatformTransactionManager[this.tms.size()]));
        }
    }
}

