/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class EnvironmentPropertiesPostProcessor
implements EnvironmentPostProcessor {
    private static final String LOG_PREFIX = "LOGGING_LEVEL_ORG_TEIID_";
    private static List<String> PROPERTIES = Arrays.asList("LOGGING_LEVEL_ORG_TEIID_COMMAND_LOG", "LOGGING_LEVEL_ORG_TEIID_AUDIT_LOG", "LOGGING_LEVEL_ORG_TEIID_COMMAND_LOG_SOURCE", "LOGGING_LEVEL_ORG_TEIID_RUNTIME", "LOGGING_LEVEL_ORG_TEIID_TXN_LOG", "LOGGING_LEVEL_ORG_TEIID_CONNECTOR", "LOGGING_LEVEL_ORG_TEIID_PLANNER", "LOGGING_LEVEL_ORG_TEIID_PROCESSOR", "LOGGING_LEVEL_ORG_TEIID_BUFFER_MGR", "LOGGING_LEVEL_ORG_TEIID");

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        PropertySource system = environment.getPropertySources().get("systemEnvironment");
        LinkedHashMap<Object, Object> prefixed = new LinkedHashMap<Object, Object>();
        for (String property : PROPERTIES) {
            if (!system.containsProperty(property)) continue;
            if (property.startsWith(LOG_PREFIX)) {
                prefixed.put("logging.level.org.teiid." + property.substring(LOG_PREFIX.length()), system.getProperty(property));
                continue;
            }
            if (!property.equals("LOGGING_LEVEL_ORG_TEIID")) continue;
            prefixed.put("logging.level.org.teiid", system.getProperty(property));
        }
        environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)new MapPropertySource("prefixer", prefixed));
    }
}

