/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.context.ApplicationContext;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.SystemMetadata;

public class RedirectionSchemaBuilder {
    static String ROW_STATUS_COLUMN = "ROW__STATUS";
    private static String TAB = "\t";
    private ApplicationContext context;
    private String redirectedDS;
    private HashMap<String, List<Table>> relations = new HashMap();

    public RedirectionSchemaBuilder(ApplicationContext context, String redirectedDS) {
        this.context = context;
        this.redirectedDS = redirectedDS;
    }

    public ModelMetaData buildRedirectionLayer(MetadataFactory source, String modelName) {
        ModelMetaData model = new ModelMetaData();
        model.setName(modelName);
        model.setModelType(Model.Type.VIRTUAL);
        MetadataFactory target = new MetadataFactory("spring", (Object)"1.0.0", SystemMetadata.getInstance().getRuntimeTypeMap(), model);
        this.populateRedirectionSchema(source, target);
        model.addAttachment(MetadataFactory.class, (Object)target);
        String ddl = DDLStringVisitor.getDDLString((Schema)target.getSchema(), null, null);
        model.addSourceMetadata("DDL", ddl);
        return model;
    }

    private String buildSelectPlan(Table srcTable, String redirected) {
        StringBuilder plan = new StringBuilder();
        plan.append("SELECT ");
        this.appendColumnNames(srcTable, plan, "o");
        plan.append("FROM ");
        plan.append("internal.").append(srcTable.getName());
        plan.append(" AS o LEFT OUTER JOIN ");
        plan.append(this.redirectedTable(srcTable, redirected)).append(" AS m ");
        plan.append("ON (");
        KeyRecord pk = RedirectionSchemaBuilder.getPK(srcTable);
        if (pk == null) {
            throw new IllegalStateException("Redirection on table " + srcTable.getName() + " can not be performed, becuase there is no PK. You can skip redirection of this table by setting property\nspring.teiid.redirected." + srcTable.getName() + ".skip=true");
        }
        boolean first = true;
        for (String str : RedirectionSchemaBuilder.getColumnNames(pk.getColumns())) {
            if (first) {
                first = false;
            } else {
                plan.append(" AND ");
            }
            plan.append("o.").append(str).append(" = m.").append(str);
        }
        plan.append(") WHERE m.");
        plan.append(ROW_STATUS_COLUMN).append(" IS NULL \n UNION ALL \n");
        plan.append("SELECT ");
        this.appendColumnNames(srcTable, plan, null);
        plan.append("FROM ");
        plan.append(this.redirectedTable(srcTable, redirected));
        plan.append(" WHERE ").append(ROW_STATUS_COLUMN).append(" <> 3");
        return plan.toString();
    }

    public static KeyRecord getPK(Table srcTable) {
        KeyRecord pk = srcTable.getPrimaryKey();
        if (pk == null && !srcTable.getUniqueKeys().isEmpty()) {
            pk = (KeyRecord)srcTable.getUniqueKeys().get(0);
        }
        return pk;
    }

    private String buildInsertPlan(Table srcTable, String redirected) {
        StringBuilder plan = new StringBuilder();
        plan.append("FOR EACH ROW\n");
        plan.append("BEGIN ATOMIC\n");
        Consumer<StringBuilder> ifPlan = sb -> {
            sb.append(TAB);
            sb.append(TAB);
            sb.append("RAISE SQLEXCEPTION 'duplicate key';\n");
        };
        Consumer<StringBuilder> elsePlan = sb -> {
            Column c;
            int i;
            sb.append(TAB);
            sb.append(TAB);
            sb.append("INSERT INTO ").append(this.redirectedTable(srcTable, redirected)).append(" (");
            for (i = 0; i < srcTable.getColumns().size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                c = (Column)srcTable.getColumns().get(i);
                sb.append(c.getName());
            }
            sb.append(", ").append(ROW_STATUS_COLUMN).append(") VALUES (");
            for (i = 0; i < srcTable.getColumns().size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                c = (Column)srcTable.getColumns().get(i);
                sb.append("NEW.").append(c.getName());
            }
            sb.append(", 1);\n");
        };
        this.ifExists(srcTable, this.pkColumnsAsWhereClause(srcTable, "NEW."), ifPlan, elsePlan, plan);
        plan.append("END");
        return plan.toString();
    }

    private String buildUpdatePlan(Table srcTable, String redirected, List<Table> assosiatedTables) {
        Column c;
        int i;
        Consumer<StringBuilder> ifPlan = sb -> {
            sb.append(TAB);
            sb.append(TAB);
            sb.append("RAISE SQLEXCEPTION 'duplicate key';\n");
        };
        Consumer<StringBuilder> elsePlan = sb -> {
            Column c;
            int i;
            if (assosiatedTables != null && !assosiatedTables.isEmpty()) {
                this.addReferentialChecks(srcTable, assosiatedTables, (StringBuilder)sb);
            }
            sb.append(TAB);
            sb.append(TAB);
            sb.append("UPSERT INTO ").append(this.redirectedTable(srcTable, redirected)).append("(");
            KeyRecord pk = RedirectionSchemaBuilder.getPK(srcTable);
            for (i = 0; i < pk.getColumns().size(); ++i) {
                c = (Column)pk.getColumns().get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(c.getName());
            }
            sb.append(", ").append(ROW_STATUS_COLUMN).append(") VALUES (");
            for (i = 0; i < pk.getColumns().size(); ++i) {
                c = (Column)pk.getColumns().get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("OLD.").append(c.getName());
            }
            sb.append(", 3);\n");
            sb.append(TAB);
            sb.append(TAB);
            sb.append("UPSERT INTO ").append(this.redirectedTable(srcTable, redirected)).append("(");
            for (i = 0; i < srcTable.getColumns().size(); ++i) {
                c = (Column)srcTable.getColumns().get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(c.getName());
            }
            sb.append(", ").append(ROW_STATUS_COLUMN).append(") VALUES (");
            for (i = 0; i < srcTable.getColumns().size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                c = (Column)srcTable.getColumns().get(i);
                sb.append("NEW.").append(c.getName());
            }
            sb.append(", 1);\n");
        };
        StringBuilder plan = new StringBuilder();
        plan.append("FOR EACH ROW\n");
        plan.append("BEGIN ATOMIC\n");
        plan.append("IF (");
        KeyRecord pk = RedirectionSchemaBuilder.getPK(srcTable);
        for (i = 0; i < pk.getColumns().size(); ++i) {
            c = (Column)pk.getColumns().get(i);
            if (i > 0) {
                plan.append(" OR ");
            }
            plan.append("CHANGING.").append(c.getName());
        }
        plan.append(")\n");
        plan.append("BEGIN\n");
        this.ifExists(srcTable, this.pkColumnsAsWhereClause(srcTable, "NEW."), ifPlan, elsePlan, plan);
        plan.append("END\n");
        plan.append("ELSE\n");
        plan.append("BEGIN\n");
        plan.append(TAB);
        plan.append("UPSERT INTO ").append(this.redirectedTable(srcTable, redirected)).append("(");
        for (i = 0; i < srcTable.getColumns().size(); ++i) {
            c = (Column)srcTable.getColumns().get(i);
            if (i > 0) {
                plan.append(", ");
            }
            plan.append(c.getName());
        }
        plan.append(", ").append(ROW_STATUS_COLUMN).append(") VALUES (");
        for (i = 0; i < srcTable.getColumns().size(); ++i) {
            if (i > 0) {
                plan.append(", ");
            }
            c = (Column)srcTable.getColumns().get(i);
            plan.append("NEW.").append(c.getName());
        }
        plan.append(", 2);\n");
        plan.append("END\n");
        plan.append("END");
        return plan.toString();
    }

    private void addReferentialChecks(Table srcTable, List<Table> assosiatedTables, StringBuilder sb) {
        for (Table table : assosiatedTables) {
            for (ForeignKey fk : table.getForeignKeys()) {
                if (!fk.getReferenceTableName().equals(srcTable.getName())) continue;
                String check = table.getName() + "_" + fk.getName() + "_EXISTS";
                sb.append(TAB).append(TAB);
                sb.append("DECLARE boolean VARIABLES.").append(check).append(" = (SELECT COUNT(*) > 0 FROM ").append("teiid").append(".").append(table.getName()).append(" WHERE ");
                for (int i = 0; i < fk.getColumns().size(); ++i) {
                    if (i > 0) {
                        sb.append(" AND ");
                    }
                    sb.append(((Column)fk.getColumns().get(i)).getName()).append(" = ").append("OLD.").append((String)fk.getReferenceColumns().get(i));
                }
                sb.append(");\n");
                sb.append(TAB).append(TAB);
                sb.append("IF (").append("VARIABLES.").append(check).append(")\n");
                sb.append(TAB).append(TAB);
                sb.append("BEGIN\n");
                sb.append(TAB).append(TAB).append(TAB).append("RAISE SQLEXCEPTION 'referential integrity check failed on ").append(table.getName()).append(" table, cascade deletes are not supported';\n");
                sb.append(TAB).append(TAB).append("END\n");
            }
        }
    }

    private String buildDeletePlan(Table srcTable, String redirected, List<Table> assosiatedTables) {
        Column c;
        int i;
        StringBuilder plan = new StringBuilder();
        plan.append("FOR EACH ROW\n");
        plan.append("BEGIN ATOMIC\n");
        if (assosiatedTables != null && !assosiatedTables.isEmpty()) {
            this.addReferentialChecks(srcTable, assosiatedTables, plan);
        }
        plan.append(TAB);
        plan.append(TAB);
        plan.append("UPSERT INTO ").append(this.redirectedTable(srcTable, redirected)).append("(");
        for (i = 0; i < RedirectionSchemaBuilder.getPK(srcTable).getColumns().size(); ++i) {
            c = (Column)RedirectionSchemaBuilder.getPK(srcTable).getColumns().get(i);
            if (i > 0) {
                plan.append(", ");
            }
            plan.append(c.getName());
        }
        plan.append(", ").append(ROW_STATUS_COLUMN).append(") VALUES (");
        for (i = 0; i < RedirectionSchemaBuilder.getPK(srcTable).getColumns().size(); ++i) {
            c = (Column)RedirectionSchemaBuilder.getPK(srcTable).getColumns().get(i);
            if (i > 0) {
                plan.append(", ");
            }
            plan.append("OLD.").append(c.getName());
        }
        plan.append(", 3);\n");
        plan.append("END");
        return plan.toString();
    }

    private String pkColumnsAsWhereClause(Table t, String prefix) {
        KeyRecord pk = RedirectionSchemaBuilder.getPK(t);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pk.getColumns().size(); ++i) {
            Column c = (Column)pk.getColumns().get(i);
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append(c.getName()).append(" = ").append(prefix).append(c.getName());
        }
        return sb.toString();
    }

    void ifExists(Table view, String args, Consumer<StringBuilder> ifPlan, Consumer<StringBuilder> elsePlan, StringBuilder sb) {
        sb.append(TAB);
        sb.append("DECLARE boolean VARIABLES.").append(view.getName()).append("_PK_EXISTS").append(" = (SELECT true FROM ").append(view.getFullName()).append(" WHERE ").append(args).append(");\n");
        sb.append(TAB);
        sb.append("IF (").append("VARIABLES.").append(view.getName()).append("_PK_EXISTS").append(")\n");
        sb.append(TAB);
        sb.append("BEGIN\n");
        ifPlan.accept(sb);
        sb.append(TAB);
        sb.append("END\n");
        if (elsePlan != null) {
            sb.append(TAB);
            sb.append("ELSE\n");
            sb.append(TAB);
            sb.append("BEGIN\n");
            elsePlan.accept(sb);
            sb.append(TAB);
            sb.append("END\n");
        }
    }

    private String redirectedTable(Table srcTable, String redirected) {
        return redirected + "." + srcTable.getName() + "_REDIRECTED";
    }

    private void appendColumnNames(Table srcTable, StringBuilder sb, String alias) {
        boolean first = true;
        for (Column srcColumn : srcTable.getColumns()) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            if (alias != null) {
                sb.append(alias).append(".");
            }
            sb.append(srcColumn.getName());
        }
        sb.append(" ");
    }

    private void populateRedirectionSchema(MetadataFactory source, MetadataFactory target) {
        for (Table srcTable : source.getSchema().getTables().values()) {
            if (this.skipRedirection(srcTable.getName())) continue;
            Table table = target.addTable(srcTable.getName());
            for (Column srcColumn : srcTable.getColumns()) {
                Column c = target.addColumn(srcColumn.getName(), srcColumn.getRuntimeType(), (ColumnSet)table);
                c.setUpdatable(true);
                if (srcColumn.isAutoIncremented()) {
                    c.setAutoIncremented(true);
                }
                c.setLength(srcColumn.getLength());
                c.setScale(srcColumn.getScale());
                c.setPrecision(srcColumn.getPrecision());
                c.setNullType(srcColumn.getNullType());
                c.setDefaultValue(srcColumn.getDefaultValue());
            }
            table.setVirtual(true);
            table.setSupportsUpdate(true);
            if (srcTable.getPrimaryKey() != null) {
                target.addPrimaryKey(srcTable.getPrimaryKey().getName(), RedirectionSchemaBuilder.getColumnNames(srcTable.getPrimaryKey().getColumns()), table);
            }
            if (!srcTable.getForeignKeys().isEmpty()) {
                for (ForeignKey fk : srcTable.getForeignKeys()) {
                    target.addForeignKey(fk.getName(), RedirectionSchemaBuilder.getColumnNames(fk.getColumns()), fk.getReferenceColumns(), fk.getReferenceTableName(), table);
                }
            }
            if (!srcTable.getUniqueKeys().isEmpty()) {
                for (KeyRecord kr : srcTable.getUniqueKeys()) {
                    target.addIndex(kr.getName(), false, RedirectionSchemaBuilder.getColumnNames(kr.getColumns()), table);
                }
            }
            if (!srcTable.getIndexes().isEmpty()) {
                for (KeyRecord kr : srcTable.getIndexes()) {
                    target.addIndex(kr.getName(), true, RedirectionSchemaBuilder.getColumnNames(kr.getColumns()), table);
                }
            }
            table.setSelectTransformation(this.buildSelectPlan(srcTable, this.redirectedDS));
            table.setInsertPlan(this.buildInsertPlan(srcTable, this.redirectedDS));
            for (ForeignKey fk : srcTable.getForeignKeys()) {
                List<Table> relatives = this.relations.get(fk.getReferenceTableName());
                if (relatives == null) {
                    relatives = new ArrayList<Table>();
                    this.relations.put(fk.getReferenceTableName(), relatives);
                }
                relatives.add(srcTable);
            }
        }
        for (Table table : target.getSchema().getTables().values()) {
            Table srcTable = (Table)source.getSchema().getTables().get(table.getName());
            table.setUpdatePlan(this.buildUpdatePlan(srcTable, this.redirectedDS, this.relations.get(table.getName())));
            table.setDeletePlan(this.buildDeletePlan(srcTable, this.redirectedDS, this.relations.get(table.getName())));
        }
    }

    private boolean skipRedirection(String tblName) {
        return Boolean.parseBoolean(this.context.getEnvironment().getProperty("spring.teiid.redirected." + tblName.toLowerCase() + ".skip"));
    }

    public static List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> list = new ArrayList<String>();
        columns.forEach(i -> list.add(i.getName()));
        return list;
    }
}

