/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.xa;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.xa.datasource")
public class XADataSourceBuilder
implements BeanClassLoaderAware,
InitializingBean,
XADataSource {
    private ClassLoader classLoader;
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private XADataSource delegate;

    public void afterPropertiesSet() throws Exception {
        this.delegate = this.createXaDataSource();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public XADataSourceBuilder() {
        this(null);
    }

    public XADataSourceBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public XADataSource build() throws Exception {
        return this;
    }

    public static XADataSourceBuilder create() throws Exception {
        return new XADataSourceBuilder();
    }

    protected XADataSource createXaDataSource() {
        String className = this.dataSourceClassName();
        Assert.state((boolean)StringUtils.hasLength((String)className), (String)"No XA DataSource class name specified");
        XADataSource dataSource = this.createXaDataSourceInstance(className);
        Bindable bindable = Bindable.ofInstance((Object)dataSource);
        this.bindXaProperties((Bindable<XADataSource>)bindable);
        return dataSource;
    }

    private XADataSource createXaDataSourceInstance(String className) {
        try {
            Class dataSourceClass = ClassUtils.forName((String)className, (ClassLoader)this.classLoader);
            Object instance = BeanUtils.instantiateClass((Class)dataSourceClass);
            Assert.isInstanceOf(XADataSource.class, (Object)instance);
            return (XADataSource)instance;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create XADataSource instance from '" + className + "'");
        }
    }

    private void bindXaProperties(Bindable<XADataSource> target) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(this.properties);
        ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
        aliases.addAliases("url", new String[]{"jdbc-url"});
        aliases.addAliases("username", new String[]{"user"});
        aliases.addAliases("portNumber", new String[]{"port"});
        aliases.addAliases("serverName", new String[]{"server"});
        aliases.addAliases("databaseName", new String[]{"database"});
        Binder binder = new Binder(new ConfigurationPropertySource[]{source.withAliases(aliases)});
        binder.bind(ConfigurationPropertyName.EMPTY, target);
    }

    public XADataSourceBuilder driverClassName(String driverClassName) {
        this.properties.put("driverClassName", driverClassName);
        return this;
    }

    public XADataSourceBuilder username(String username) {
        this.properties.put("username", username);
        return this;
    }

    public XADataSourceBuilder password(String password) {
        this.properties.put("password", password);
        return this;
    }

    public XADataSourceBuilder port(String port) {
        this.properties.put("port", port);
        return this;
    }

    public XADataSourceBuilder server(String server) {
        this.properties.put("server", server);
        return this;
    }

    public XADataSourceBuilder database(String database) {
        this.properties.put("database", database);
        return this;
    }

    public XADataSourceBuilder dataSourceClassName(String dataSourceClassName) {
        this.properties.put("dataSourceClassName", dataSourceClassName);
        return this;
    }

    public String dataSourceClassName() {
        String className = this.properties.get("dataSourceClassName");
        if (!StringUtils.hasLength((String)className)) {
            String url = this.properties.get("url");
            className = DatabaseDriver.fromJdbcUrl((String)url).getXaDataSourceClassName();
        }
        return className;
    }

    public XADataSourceBuilder url(String url) {
        this.properties.put("url", url);
        return this;
    }

    public XADataSourceBuilder initialize(boolean initialize) {
        this.properties.put("initialize", Boolean.toString(initialize));
        return this;
    }

    public XADataSourceBuilder platform(String platform) {
        this.properties.put("platform", platform);
        return this;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.delegate.getXAConnection();
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return this.delegate.getXAConnection(user, password);
    }
}

