/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.teiid;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=teiid/transport=*")
@ResourceType(value="transport")
public class Transport<T extends Transport<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="SO_RCVBUF size, 0 indicates that system default should be used (default 0)")
    private Integer inputBufferSize;
    @AttributeDocumentation(value="key alias name")
    private String keystoreKeyAlias;
    @AttributeDocumentation(value="key password")
    private String keystoreKeyPassword;
    @AttributeDocumentation(value="Keystore file name")
    private String keystoreName;
    @AttributeDocumentation(value="Keystore password")
    private String keystorePassword;
    @AttributeDocumentation(value="Keystore type")
    private String keystoreType;
    @AttributeDocumentation(value="Max number of threads dedicated to initial request processing. Zero indicates the system default of max available processors. (default 0)  Setting this value above the max available processors is not recommended.")
    private Integer maxSocketThreads;
    @AttributeDocumentation(value="SO_SNDBUF size, 0 indicates that system default should be used (default 0)")
    private Integer outputBufferSize;
    @AttributeDocumentation(value="Max LOB size in Postgres protocol, as streaming is not supported")
    private Integer pgMaxLobSizeInBytes;
    @AttributeDocumentation(value="Transport protocol (allowed=teiid, pg) ")
    private Protocol protocol;
    @AttributeDocumentation(value="Socket binding to be used for the transport")
    private String socketBinding;
    @AttributeDocumentation(value="Authentication Mode (1-way, 2-way, anonymous)             ")
    private SslAuthenticationMode sslAuthenticationMode;
    @AttributeDocumentation(value="Comma separated cipher suites that are allowed to be used for SSL. Use to restrict encryption strength(128 bit, 256 bit). Only provide encryption suites that are supported by the server JVM. ex:SSL_RSA_WITH_RC4_128_MD5, SSL_RSA_WITH_RC4_128_SHA, SSL_RSA_WITH_3DES_EDE_CBC_SHA, SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA, SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DHE_RSA_WITH_AES_128_CBC_SHA, TLS_DHE_DSS_WITH_AES_128_CBC_SHA, TLS_KRB5_WITH_RC4_128_MD5, TLS_KRB5_WITH_RC4_128_SHA, TLS_RSA_WITH_AES_128_CBC_SHA, TLS_KRB5_WITH_3DES_EDE_CBC_MD5, TLS_KRB5_WITH_3DES_EDE_CBC_SHA, TLS_DHE_RSA_WITH_AES_256_CBC_SHA, TLS_DHE_DSS_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_256_CBC_SHA")
    private String sslEnabledCipherSuites;
    @AttributeDocumentation(value="Use key management algorithm")
    private String sslKeymanagementAlgorithm;
    @AttributeDocumentation(value="can be one of disabled, login, or enabled disabled = no transport or message level security will be used; login = only the login traffic will be encrypted at a message level using 128 bit AES with an ephemerial DH key exchange. No other config values are needed in this mode; and it only applies to the JDBC transport enabled = traffic will be secured using this configuration, if the client supports SSL")
    private SslMode sslMode;
    @AttributeDocumentation(value="SSL protocol used")
    private String sslSslProtocol;
    @AttributeDocumentation(value="Truststore check expired")
    private Boolean truststoreCheckExpired;
    @AttributeDocumentation(value="Truststore file name")
    private String truststoreName;
    @AttributeDocumentation(value="Truststore password")
    private String truststorePassword;

    public Transport(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="input-buffer-size")
    public Integer inputBufferSize() {
        return this.inputBufferSize;
    }

    public T inputBufferSize(Integer value) {
        Integer oldValue = this.inputBufferSize;
        this.inputBufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("inputBufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keystore-key-alias")
    public String keystoreKeyAlias() {
        return this.keystoreKeyAlias;
    }

    public T keystoreKeyAlias(String value) {
        String oldValue = this.keystoreKeyAlias;
        this.keystoreKeyAlias = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keystoreKeyAlias", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keystore-key-password")
    public String keystoreKeyPassword() {
        return this.keystoreKeyPassword;
    }

    public T keystoreKeyPassword(String value) {
        String oldValue = this.keystoreKeyPassword;
        this.keystoreKeyPassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keystoreKeyPassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keystore-name")
    public String keystoreName() {
        return this.keystoreName;
    }

    public T keystoreName(String value) {
        String oldValue = this.keystoreName;
        this.keystoreName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keystoreName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keystore-password")
    public String keystorePassword() {
        return this.keystorePassword;
    }

    public T keystorePassword(String value) {
        String oldValue = this.keystorePassword;
        this.keystorePassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keystorePassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keystore-type")
    public String keystoreType() {
        return this.keystoreType;
    }

    public T keystoreType(String value) {
        String oldValue = this.keystoreType;
        this.keystoreType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keystoreType", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-socket-threads")
    public Integer maxSocketThreads() {
        return this.maxSocketThreads;
    }

    public T maxSocketThreads(Integer value) {
        Integer oldValue = this.maxSocketThreads;
        this.maxSocketThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxSocketThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="output-buffer-size")
    public Integer outputBufferSize() {
        return this.outputBufferSize;
    }

    public T outputBufferSize(Integer value) {
        Integer oldValue = this.outputBufferSize;
        this.outputBufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("outputBufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pg-max-lob-size-in-bytes")
    public Integer pgMaxLobSizeInBytes() {
        return this.pgMaxLobSizeInBytes;
    }

    public T pgMaxLobSizeInBytes(Integer value) {
        Integer oldValue = this.pgMaxLobSizeInBytes;
        this.pgMaxLobSizeInBytes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("pgMaxLobSizeInBytes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="protocol")
    public Protocol protocol() {
        return this.protocol;
    }

    public T protocol(Protocol value) {
        Protocol oldValue = this.protocol;
        this.protocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("protocol", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-binding")
    public String socketBinding() {
        return this.socketBinding;
    }

    public T socketBinding(String value) {
        String oldValue = this.socketBinding;
        this.socketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-authentication-mode")
    public SslAuthenticationMode sslAuthenticationMode() {
        return this.sslAuthenticationMode;
    }

    public T sslAuthenticationMode(SslAuthenticationMode value) {
        SslAuthenticationMode oldValue = this.sslAuthenticationMode;
        this.sslAuthenticationMode = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslAuthenticationMode", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-enabled-cipher-suites")
    public String sslEnabledCipherSuites() {
        return this.sslEnabledCipherSuites;
    }

    public T sslEnabledCipherSuites(String value) {
        String oldValue = this.sslEnabledCipherSuites;
        this.sslEnabledCipherSuites = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslEnabledCipherSuites", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-keymanagement-algorithm")
    public String sslKeymanagementAlgorithm() {
        return this.sslKeymanagementAlgorithm;
    }

    public T sslKeymanagementAlgorithm(String value) {
        String oldValue = this.sslKeymanagementAlgorithm;
        this.sslKeymanagementAlgorithm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslKeymanagementAlgorithm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-mode")
    public SslMode sslMode() {
        return this.sslMode;
    }

    public T sslMode(SslMode value) {
        SslMode oldValue = this.sslMode;
        this.sslMode = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslMode", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-ssl-protocol")
    public String sslSslProtocol() {
        return this.sslSslProtocol;
    }

    public T sslSslProtocol(String value) {
        String oldValue = this.sslSslProtocol;
        this.sslSslProtocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslSslProtocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="truststore-check-expired")
    public Boolean truststoreCheckExpired() {
        return this.truststoreCheckExpired;
    }

    public T truststoreCheckExpired(Boolean value) {
        Boolean oldValue = this.truststoreCheckExpired;
        this.truststoreCheckExpired = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("truststoreCheckExpired", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="truststore-name")
    public String truststoreName() {
        return this.truststoreName;
    }

    public T truststoreName(String value) {
        String oldValue = this.truststoreName;
        this.truststoreName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("truststoreName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="truststore-password")
    public String truststorePassword() {
        return this.truststorePassword;
    }

    public T truststorePassword(String value) {
        String oldValue = this.truststorePassword;
        this.truststorePassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("truststorePassword", oldValue, value);
        }
        return (T)this;
    }

    public static enum SslMode {
        LOGIN("login"),
        ENABLED("enabled"),
        DISABLED("disabled");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private SslMode(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum SslAuthenticationMode {
        ONE_WAY("1-way"),
        TWO_WAY("2-way"),
        ANONYMOUS("anonymous");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private SslAuthenticationMode(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum Protocol {
        TEIID("teiid"),
        PG("pg");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Protocol(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

