/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.teiid.Translator;
import org.wildfly.swarm.config.teiid.TranslatorConsumer;
import org.wildfly.swarm.config.teiid.TranslatorSupplier;
import org.wildfly.swarm.config.teiid.Transport;
import org.wildfly.swarm.config.teiid.TransportConsumer;
import org.wildfly.swarm.config.teiid.TransportSupplier;

@Address(value="/subsystem=teiid")
@ResourceType(value="subsystem")
@Implicit
public class Teiid<T extends Teiid<T>>
implements Keyed {
    private String key = "teiid";
    private PropertyChangeSupport pcs;
    private TeiidResources subresources = new TeiidResources();
    @AttributeDocumentation(value="Number of active sessions in the system")
    private Integer activeSessionCount;
    @AttributeDocumentation(value="Allow the execution of ENV, ENV_VAR, and SYS_PROP function. (default false)")
    private Boolean allowEnvFunction;
    @AttributeDocumentation(value="Maximum number of threads for asynchronous processing")
    private Integer asyncThreadPoolMaxThreadCount;
    @AttributeDocumentation(value="Maximum number of sessions allowed by the system (default 10000)")
    private Integer authenticationMaxSessionsAllowed;
    @AttributeDocumentation(value="Security domain to be enforced with the transport")
    private String authenticationSecurityDomain;
    @AttributeDocumentation(value="Max allowed time in milliseconds before the session is terminated by the system, 0 indicates unlimited (default 0)")
    private Integer authenticationSessionsExpirationTimelimit;
    @AttributeDocumentation(value="Allow all local pass-through connections regardless of whether they are in the configured security domain.")
    private Boolean authenticationTrustAllLocal;
    @AttributeDocumentation(value="Default authentication type to use with this transport. Allowed values are (USERPASSWORD, GSS)  ")
    private AuthenticationType authenticationType;
    @AttributeDocumentation(value="Authorization Module; Implementation of org.teiid.dqp.internal.process.AuthorizationValidator class.")
    private String authorizationValidatorModule;
    @AttributeDocumentation(value="Set to true to encrypt temporary data files with 128-bit AES. (default false)")
    private Boolean bufferServiceEncryptFiles;
    @AttributeDocumentation(value="Set to true to allow inlining of memory based and small lobs into results. However inline lob values are not supported by pre-7.6 clients, so disable this property if using older clients utilizing lobs. (default true)\t")
    private Boolean bufferServiceInlineLobs;
    @AttributeDocumentation(value="Max storage space, in MB, to be used for buffer files (default 50G)")
    private Long bufferServiceMaxBufferSpace;
    @AttributeDocumentation(value="Max File size in MB (default 2GB)")
    private Long bufferServiceMaxFileSize;
    @AttributeDocumentation(value="Max open buffer files (default 64)")
    private Integer bufferServiceMaxOpenFiles;
    @AttributeDocumentation(value="The approximate amount of buffer memory in kilobytes allowable for a single processing operation (sort, grouping, etc.) regardless of existing memory commitments. -1 means to automatically calculate a value (default -1)")
    private Integer bufferServiceMaxProcessingKb;
    @AttributeDocumentation(value="The approximate amount of memory in kilobytes allowed to be held by the buffer manager. -1 means to automatically calculate a value (default -1)")
    private Integer bufferServiceMaxReserveKb;
    @AttributeDocumentation(value="The maximum size of a buffer managed object (typically a table page or a results batch) in bytes (default 8388608 or 8MB). Setting this value too high will reduce the effectiveness of the memory buffer.")
    private Integer bufferServiceMaxStorageObjectSize;
    @AttributeDocumentation(value="Set to true to hold the memory buffer off-heap. If true you must ensure that the VM can allocate that much direct memory (default false).")
    private Boolean bufferServiceMemoryBufferOffHeap;
    @AttributeDocumentation(value="Memory buffer space used by the buffer manager in MB.  -1 determines the setting automatically from the max-reserve-kb (default -1). This value cannot be smaller than max-storage-object-size")
    private Integer bufferServiceMemoryBufferSpace;
    @AttributeDocumentation(value="The nominal row count of a batch sent internally within the query processor.  The actual batch size used will depend upon the data width as well. (default 256)")
    private Integer bufferServiceProcessorBatchSize;
    @AttributeDocumentation(value="Use disk for buffer management")
    private Boolean bufferServiceUseDisk;
    @AttributeDocumentation(value="WorkManager name to use in processing. (default name is \"default\")")
    private Boolean dataRolesRequired;
    @AttributeDocumentation(value="Set to true for the engine to detect local change events. Should be disabled if using external change data capture tools. (default true)")
    private Boolean detectChangeEvents;
    @AttributeDocumentation(value="JGroups stack name for cache replication channel")
    private String distributedCacheJgroupsStack;
    @AttributeDocumentation(value="Indicates if an exception should be thrown if the specified value for Maximum Source Rows is exceeded; only up to the maximum rows will be consumed. (default true)")
    private Boolean exceptionOnMaxSourceRows;
    @AttributeDocumentation(value="The max lob chunk size in KB transferred each time when processing blobs, clobs (100KB default)")
    private Integer lobChunkSizeInKb;
    @AttributeDocumentation(value="Max active plans (default 20).  Increase this value on highly concurrent systems - but ensure that the underlying pools can handle the increased load without timeouts.")
    private Integer maxActivePlans;
    @AttributeDocumentation(value="Maximum allowed fetch size, set via JDBC. User requested value ignored above this value. (default 20480)")
    private Integer maxRowFetchSize;
    @AttributeDocumentation(value="Maximum rows allowed from a source query. -1 indicates no limit. (default -1)")
    private Integer maxSourceRowsAllowed;
    @AttributeDocumentation(value="Process pool maximum thread count. (default 64)")
    private Integer maxThreads;
    @AttributeDocumentation(value="Policy Module; Implementation of org.teiid.PolicyDecider class ")
    private String policyDeciderModule;
    @AttributeDocumentation(value="Prepared Plan cache enabled (default true)")
    private Boolean preparedplanCacheEnable;
    @AttributeDocumentation(value="Infinispan cache container name")
    private String preparedplanCacheInfinispanContainer;
    @AttributeDocumentation(value="Infinispan cache name for prepared plans")
    private String preparedplanCacheName;
    @AttributeDocumentation(value="Incoming SQL can be modified by an \"org.teiid.PreParser\"")
    private String preparserModule;
    @AttributeDocumentation(value="Long running query threshold, after which a alert can be generated by tooling if configured")
    private Integer queryThresholdInSeconds;
    @AttributeDocumentation(value="Set the default query timeout for all queries in milliseconds. 0 indicates no timeout.  Lesser timeout values may be set per VDB or by clients. (default 0)")
    private Long queryTimeout;
    @AttributeDocumentation(value="Resultset cache enabled (default true)")
    private Boolean resultsetCacheEnable;
    @AttributeDocumentation(value="Infinispan cache container name")
    private String resultsetCacheInfinispanContainer;
    @AttributeDocumentation(value="Max staleness in seconds.  Modifications are based upon data updates -1 indicates no max. (default 60 - 1 minute)")
    private Integer resultsetCacheMaxStaleness;
    @AttributeDocumentation(value="Infinispan cache name for resultset; if not specified default cache on infinispan container is used.")
    private String resultsetCacheName;
    @AttributeDocumentation(value="Teiid Runtime Version")
    private String runtimeVersion;
    @AttributeDocumentation(value="Max source query concurrency per user request (default 0).  0 indicates use the default calculated value based on max active plans and max threads - approximately 2*(max threads)/(max active plans).   ")
    private Integer threadCountForSourceConcurrency;
    @AttributeDocumentation(value="Query processor time slice, in milliseconds. (default 2000)")
    private Integer timeSliceInMilliseconds;
    @AttributeDocumentation(value="WorkManager name to use in processing. (default name is \"default\")")
    private String workmanager;

    public Teiid() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public TeiidResources subresources() {
        return this.subresources;
    }

    public T translators(List<Translator> value) {
        this.subresources.translators = value;
        return (T)this;
    }

    public T translator(Translator value) {
        this.subresources.translators.add(value);
        return (T)this;
    }

    public T translator(String childKey, TranslatorConsumer consumer) {
        Translator child = new Translator(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.translator(child);
        return (T)this;
    }

    public T translator(String childKey) {
        this.translator(childKey, null);
        return (T)this;
    }

    public T translator(TranslatorSupplier supplier) {
        this.translator(supplier.get());
        return (T)this;
    }

    public T transports(List<Transport> value) {
        this.subresources.transports = value;
        return (T)this;
    }

    public T transport(Transport value) {
        this.subresources.transports.add(value);
        return (T)this;
    }

    public T transport(String childKey, TransportConsumer consumer) {
        Transport child = new Transport(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.transport(child);
        return (T)this;
    }

    public T transport(String childKey) {
        this.transport(childKey, null);
        return (T)this;
    }

    public T transport(TransportSupplier supplier) {
        this.transport(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="active-session-count")
    public Integer activeSessionCount() {
        return this.activeSessionCount;
    }

    public T activeSessionCount(Integer value) {
        Integer oldValue = this.activeSessionCount;
        this.activeSessionCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("activeSessionCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allow-env-function")
    public Boolean allowEnvFunction() {
        return this.allowEnvFunction;
    }

    public T allowEnvFunction(Boolean value) {
        Boolean oldValue = this.allowEnvFunction;
        this.allowEnvFunction = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowEnvFunction", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="async-thread-pool-max-thread-count")
    public Integer asyncThreadPoolMaxThreadCount() {
        return this.asyncThreadPoolMaxThreadCount;
    }

    public T asyncThreadPoolMaxThreadCount(Integer value) {
        Integer oldValue = this.asyncThreadPoolMaxThreadCount;
        this.asyncThreadPoolMaxThreadCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("asyncThreadPoolMaxThreadCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-max-sessions-allowed")
    public Integer authenticationMaxSessionsAllowed() {
        return this.authenticationMaxSessionsAllowed;
    }

    public T authenticationMaxSessionsAllowed(Integer value) {
        Integer oldValue = this.authenticationMaxSessionsAllowed;
        this.authenticationMaxSessionsAllowed = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationMaxSessionsAllowed", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-security-domain")
    public String authenticationSecurityDomain() {
        return this.authenticationSecurityDomain;
    }

    public T authenticationSecurityDomain(String value) {
        String oldValue = this.authenticationSecurityDomain;
        this.authenticationSecurityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationSecurityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-sessions-expiration-timelimit")
    public Integer authenticationSessionsExpirationTimelimit() {
        return this.authenticationSessionsExpirationTimelimit;
    }

    public T authenticationSessionsExpirationTimelimit(Integer value) {
        Integer oldValue = this.authenticationSessionsExpirationTimelimit;
        this.authenticationSessionsExpirationTimelimit = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationSessionsExpirationTimelimit", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-trust-all-local")
    public Boolean authenticationTrustAllLocal() {
        return this.authenticationTrustAllLocal;
    }

    public T authenticationTrustAllLocal(Boolean value) {
        Boolean oldValue = this.authenticationTrustAllLocal;
        this.authenticationTrustAllLocal = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationTrustAllLocal", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-type")
    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public T authenticationType(AuthenticationType value) {
        AuthenticationType oldValue = this.authenticationType;
        this.authenticationType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationType", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authorization-validator-module")
    public String authorizationValidatorModule() {
        return this.authorizationValidatorModule;
    }

    public T authorizationValidatorModule(String value) {
        String oldValue = this.authorizationValidatorModule;
        this.authorizationValidatorModule = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authorizationValidatorModule", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-service-encrypt-files")
    public Boolean bufferServiceEncryptFiles() {
        return this.bufferServiceEncryptFiles;
    }

    public T bufferServiceEncryptFiles(Boolean value) {
        Boolean oldValue = this.bufferServiceEncryptFiles;
        this.bufferServiceEncryptFiles = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferServiceEncryptFiles", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-service-inline-lobs")
    public Boolean bufferServiceInlineLobs() {
        return this.bufferServiceInlineLobs;
    }

    public T bufferServiceInlineLobs(Boolean value) {
        Boolean oldValue = this.bufferServiceInlineLobs;
        this.bufferServiceInlineLobs = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferServiceInlineLobs", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-service-max-buffer-space")
    public Long bufferServiceMaxBufferSpace() {
        return this.bufferServiceMaxBufferSpace;
    }

    public T bufferServiceMaxBufferSpace(Long value) {
        Long oldValue = this.bufferServiceMaxBufferSpace;
        this.bufferServiceMaxBufferSpace = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferServiceMaxBufferSpace", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-service-max-file-size")
    public Long bufferServiceMaxFileSize() {
        return this.bufferServiceMaxFileSize;
    }

    public T bufferServiceMaxFileSize(Long value) {
        Long oldValue = this.bufferServiceMaxFileSize;
        this.bufferServiceMaxFileSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferServiceMaxFileSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-service-max-open-files")
    public Integer bufferServiceMaxOpenFiles() {
        return this.bufferServiceMaxOpenFiles;
    }

    public T bufferServiceMaxOpenFiles(Integer value) {
        Integer oldValue = this.bufferServiceMaxOpenFiles;
        this.bufferServiceMaxOpenFiles = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferServiceMaxOpenFiles", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-service-max-processing-kb")
    public Integer bufferServiceMaxProcessingKb() {
        return this.bufferServiceMaxProcessingKb;
    }

    public T bufferServiceMaxProcessingKb(Integer value) {
        Integer oldValue = this.bufferServiceMaxProcessingKb;
        this.bufferServiceMaxProcessingKb = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferServiceMaxProcessingKb", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-service-max-reserve-kb")
    public Integer bufferServiceMaxReserveKb() {
        return this.bufferServiceMaxReserveKb;
    }

    public T bufferServiceMaxReserveKb(Integer value) {
        Integer oldValue = this.bufferServiceMaxReserveKb;
        this.bufferServiceMaxReserveKb = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferServiceMaxReserveKb", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-service-max-storage-object-size")
    public Integer bufferServiceMaxStorageObjectSize() {
        return this.bufferServiceMaxStorageObjectSize;
    }

    public T bufferServiceMaxStorageObjectSize(Integer value) {
        Integer oldValue = this.bufferServiceMaxStorageObjectSize;
        this.bufferServiceMaxStorageObjectSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferServiceMaxStorageObjectSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-service-memory-buffer-off-heap")
    public Boolean bufferServiceMemoryBufferOffHeap() {
        return this.bufferServiceMemoryBufferOffHeap;
    }

    public T bufferServiceMemoryBufferOffHeap(Boolean value) {
        Boolean oldValue = this.bufferServiceMemoryBufferOffHeap;
        this.bufferServiceMemoryBufferOffHeap = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferServiceMemoryBufferOffHeap", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-service-memory-buffer-space")
    public Integer bufferServiceMemoryBufferSpace() {
        return this.bufferServiceMemoryBufferSpace;
    }

    public T bufferServiceMemoryBufferSpace(Integer value) {
        Integer oldValue = this.bufferServiceMemoryBufferSpace;
        this.bufferServiceMemoryBufferSpace = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferServiceMemoryBufferSpace", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-service-processor-batch-size")
    public Integer bufferServiceProcessorBatchSize() {
        return this.bufferServiceProcessorBatchSize;
    }

    public T bufferServiceProcessorBatchSize(Integer value) {
        Integer oldValue = this.bufferServiceProcessorBatchSize;
        this.bufferServiceProcessorBatchSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferServiceProcessorBatchSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-service-use-disk")
    public Boolean bufferServiceUseDisk() {
        return this.bufferServiceUseDisk;
    }

    public T bufferServiceUseDisk(Boolean value) {
        Boolean oldValue = this.bufferServiceUseDisk;
        this.bufferServiceUseDisk = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferServiceUseDisk", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="data-roles-required")
    public Boolean dataRolesRequired() {
        return this.dataRolesRequired;
    }

    public T dataRolesRequired(Boolean value) {
        Boolean oldValue = this.dataRolesRequired;
        this.dataRolesRequired = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("dataRolesRequired", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="detect-change-events")
    public Boolean detectChangeEvents() {
        return this.detectChangeEvents;
    }

    public T detectChangeEvents(Boolean value) {
        Boolean oldValue = this.detectChangeEvents;
        this.detectChangeEvents = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("detectChangeEvents", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="distributed-cache-jgroups-stack")
    public String distributedCacheJgroupsStack() {
        return this.distributedCacheJgroupsStack;
    }

    public T distributedCacheJgroupsStack(String value) {
        String oldValue = this.distributedCacheJgroupsStack;
        this.distributedCacheJgroupsStack = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("distributedCacheJgroupsStack", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="exception-on-max-source-rows")
    public Boolean exceptionOnMaxSourceRows() {
        return this.exceptionOnMaxSourceRows;
    }

    public T exceptionOnMaxSourceRows(Boolean value) {
        Boolean oldValue = this.exceptionOnMaxSourceRows;
        this.exceptionOnMaxSourceRows = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exceptionOnMaxSourceRows", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="lob-chunk-size-in-kb")
    public Integer lobChunkSizeInKb() {
        return this.lobChunkSizeInKb;
    }

    public T lobChunkSizeInKb(Integer value) {
        Integer oldValue = this.lobChunkSizeInKb;
        this.lobChunkSizeInKb = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("lobChunkSizeInKb", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-active-plans")
    public Integer maxActivePlans() {
        return this.maxActivePlans;
    }

    public T maxActivePlans(Integer value) {
        Integer oldValue = this.maxActivePlans;
        this.maxActivePlans = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxActivePlans", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-row-fetch-size")
    public Integer maxRowFetchSize() {
        return this.maxRowFetchSize;
    }

    public T maxRowFetchSize(Integer value) {
        Integer oldValue = this.maxRowFetchSize;
        this.maxRowFetchSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRowFetchSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-source-rows-allowed")
    public Integer maxSourceRowsAllowed() {
        return this.maxSourceRowsAllowed;
    }

    public T maxSourceRowsAllowed(Integer value) {
        Integer oldValue = this.maxSourceRowsAllowed;
        this.maxSourceRowsAllowed = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxSourceRowsAllowed", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-threads")
    public Integer maxThreads() {
        return this.maxThreads;
    }

    public T maxThreads(Integer value) {
        Integer oldValue = this.maxThreads;
        this.maxThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="policy-decider-module")
    public String policyDeciderModule() {
        return this.policyDeciderModule;
    }

    public T policyDeciderModule(String value) {
        String oldValue = this.policyDeciderModule;
        this.policyDeciderModule = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("policyDeciderModule", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="preparedplan-cache-enable")
    public Boolean preparedplanCacheEnable() {
        return this.preparedplanCacheEnable;
    }

    public T preparedplanCacheEnable(Boolean value) {
        Boolean oldValue = this.preparedplanCacheEnable;
        this.preparedplanCacheEnable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("preparedplanCacheEnable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="preparedplan-cache-infinispan-container")
    public String preparedplanCacheInfinispanContainer() {
        return this.preparedplanCacheInfinispanContainer;
    }

    public T preparedplanCacheInfinispanContainer(String value) {
        String oldValue = this.preparedplanCacheInfinispanContainer;
        this.preparedplanCacheInfinispanContainer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("preparedplanCacheInfinispanContainer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="preparedplan-cache-name")
    public String preparedplanCacheName() {
        return this.preparedplanCacheName;
    }

    public T preparedplanCacheName(String value) {
        String oldValue = this.preparedplanCacheName;
        this.preparedplanCacheName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("preparedplanCacheName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="preparser-module")
    public String preparserModule() {
        return this.preparserModule;
    }

    public T preparserModule(String value) {
        String oldValue = this.preparserModule;
        this.preparserModule = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("preparserModule", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="query-threshold-in-seconds")
    public Integer queryThresholdInSeconds() {
        return this.queryThresholdInSeconds;
    }

    public T queryThresholdInSeconds(Integer value) {
        Integer oldValue = this.queryThresholdInSeconds;
        this.queryThresholdInSeconds = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queryThresholdInSeconds", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="query-timeout")
    public Long queryTimeout() {
        return this.queryTimeout;
    }

    public T queryTimeout(Long value) {
        Long oldValue = this.queryTimeout;
        this.queryTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queryTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="resultset-cache-enable")
    public Boolean resultsetCacheEnable() {
        return this.resultsetCacheEnable;
    }

    public T resultsetCacheEnable(Boolean value) {
        Boolean oldValue = this.resultsetCacheEnable;
        this.resultsetCacheEnable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("resultsetCacheEnable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="resultset-cache-infinispan-container")
    public String resultsetCacheInfinispanContainer() {
        return this.resultsetCacheInfinispanContainer;
    }

    public T resultsetCacheInfinispanContainer(String value) {
        String oldValue = this.resultsetCacheInfinispanContainer;
        this.resultsetCacheInfinispanContainer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("resultsetCacheInfinispanContainer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="resultset-cache-max-staleness")
    public Integer resultsetCacheMaxStaleness() {
        return this.resultsetCacheMaxStaleness;
    }

    public T resultsetCacheMaxStaleness(Integer value) {
        Integer oldValue = this.resultsetCacheMaxStaleness;
        this.resultsetCacheMaxStaleness = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("resultsetCacheMaxStaleness", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="resultset-cache-name")
    public String resultsetCacheName() {
        return this.resultsetCacheName;
    }

    public T resultsetCacheName(String value) {
        String oldValue = this.resultsetCacheName;
        this.resultsetCacheName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("resultsetCacheName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="runtime-version")
    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    public T runtimeVersion(String value) {
        String oldValue = this.runtimeVersion;
        this.runtimeVersion = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("runtimeVersion", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="thread-count-for-source-concurrency")
    public Integer threadCountForSourceConcurrency() {
        return this.threadCountForSourceConcurrency;
    }

    public T threadCountForSourceConcurrency(Integer value) {
        Integer oldValue = this.threadCountForSourceConcurrency;
        this.threadCountForSourceConcurrency = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("threadCountForSourceConcurrency", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="time-slice-in-milliseconds")
    public Integer timeSliceInMilliseconds() {
        return this.timeSliceInMilliseconds;
    }

    public T timeSliceInMilliseconds(Integer value) {
        Integer oldValue = this.timeSliceInMilliseconds;
        this.timeSliceInMilliseconds = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("timeSliceInMilliseconds", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="workmanager")
    public String workmanager() {
        return this.workmanager;
    }

    public T workmanager(String value) {
        String oldValue = this.workmanager;
        this.workmanager = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workmanager", oldValue, value);
        }
        return (T)this;
    }

    public static enum AuthenticationType {
        USERPASSWORD("USERPASSWORD"),
        GSS("GSS");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private AuthenticationType(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class TeiidResources {
        @ResourceDocumentation(value="Teiid Translator")
        @SubresourceInfo(value="translator")
        private List<Translator> translators = new ArrayList<Translator>();
        @ResourceDocumentation(value="Teiid transport ")
        @SubresourceInfo(value="transport")
        private List<Transport> transports = new ArrayList<Transport>();

        @Subresource
        public List<Translator> translators() {
            return this.translators;
        }

        public Translator translator(String key) {
            return this.translators.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Transport> transports() {
            return this.transports;
        }

        public Transport transport(String key) {
            return this.transports.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

