/*
 * Decompiled with CFR 0.152.
 */
package org.thorntail.teiid.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.thorntail.teiid.TeiidFraction;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.teiid.Transport;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.SocketBinding;
import org.wildfly.swarm.spi.api.SocketBindingGroup;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Pre
@ApplicationScoped
public class TransportCustomizer
implements Customizer {
    @Configurable(value="thorntail.teiid.jdbc.port")
    @AttributeDocumentation(value="JDBC Connection Port")
    private Defaultable<Integer> jdbcPort = Defaultable.integer((int)31000);
    @Configurable(value="thorntail.teiid.odbc.port")
    @AttributeDocumentation(value="ODBC Connection Port")
    private Defaultable<Integer> odbcPort = Defaultable.integer((int)35432);
    @Configurable(value="thorntail.teiid.jdbc.enable")
    @AttributeDocumentation(value="Enable JDBC Connections")
    private Defaultable<Boolean> enableJDBC = Defaultable.bool((boolean)true);
    @Configurable(value="thorntail.teiid.odbc.enable")
    @AttributeDocumentation(value="Enable ODBC Connections")
    private Defaultable<Boolean> enableODBC = Defaultable.bool((boolean)false);
    @Inject
    @Named(value="standard-sockets")
    private SocketBindingGroup group;
    @Inject
    TeiidFraction fraction;

    public void customize() {
        this.fraction.transport("local");
        this.fraction.transport("odata");
        if (((Boolean)this.enableJDBC.get()).booleanValue()) {
            this.group.socketBinding(new SocketBinding("teiid-jdbc").port(((Integer)this.jdbcPort.get()).intValue()));
            this.fraction.transport("jdbc", t -> t.socketBinding("teiid-jdbc").protocol(Transport.Protocol.TEIID));
        }
        if (((Boolean)this.enableODBC.get()).booleanValue()) {
            this.group.socketBinding(new SocketBinding("teiid-odbc").port(((Integer)this.odbcPort.get()).intValue()));
            this.fraction.transport("odbc", t -> t.socketBinding("teiid-odbc").protocol(Transport.Protocol.TEIID));
        }
    }
}

