/*
 * Decompiled with CFR 0.152.
 */
package org.thorntail.teiid.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.thorntail.teiid.TeiidFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Pre
@ApplicationScoped
public class TranslatorCustomizer
implements Customizer {
    private static final String PRE = "org.jboss.teiid.translator.";
    @Inject
    TeiidFraction fraction;

    public void customize() throws Exception {
        HashMap<String, String> ras = new HashMap<String, String>();
        ras.put("org.jboss.teiid.translator.accumulo", "accumulo");
        ras.put("org.jboss.teiid.translator.amazon.s3", "amazon-s3");
        ras.put("org.jboss.teiid.translator.cassandra", "cassandra");
        ras.put("org.jboss.teiid.translator.couchbase", "couchbase");
        ras.put("org.jboss.teiid.translator.excel", "excel");
        ras.put("org.jboss.teiid.translator.file", "file");
        ras.put("org.jboss.teiid.translator.ftp", "ftp");
        ras.put("org.jboss.teiid.translator.google", "google");
        ras.put("org.jboss.teiid.translator.hive", "hive");
        ras.put("org.jboss.teiid.translator.infinispan-hotrod", "infinispan-hotrod");
        ras.put("org.jboss.teiid.translator.jdbc", "jdbc");
        ras.put("org.jboss.teiid.translator.ldap", "ldap");
        ras.put("org.jboss.teiid.translator.loopback", "loopback");
        ras.put("org.jboss.teiid.translator.mongodb", "mongodb");
        ras.put("org.jboss.teiid.translator.odata", "odata");
        ras.put("org.jboss.teiid.translator.odata4", "odata4");
        ras.put("org.jboss.teiid.translator.olap", "olap");
        ras.put("org.jboss.teiid.translator.pheonix", "pheonix");
        ras.put("org.jboss.teiid.translator.prestodb", "prestodb");
        ras.put("org.jboss.teiid.translator.salesforce", "salesforce");
        ras.put("org.jboss.teiid.translator.salesforce-34", "salesforce-34");
        ras.put("org.jboss.teiid.translator.salesforce-41", "salesforce-41");
        ras.put("org.jboss.teiid.translator.simpledb", "simpledb");
        ras.put("org.jboss.teiid.translator.solr", "solr");
        ras.put("org.jboss.teiid.translator.swagger", "swagger");
        ras.put("org.jboss.teiid.translator.ws", "ws");
        for (Map.Entry e : ras.entrySet()) {
            this.loadTranslators((String)e.getKey());
        }
    }

    private void loadTranslators(String moduleName) {
        ClassLoader translatorLoader = this.getClass().getClassLoader();
        try {
            ServiceLoader<ExecutionFactory> serviceLoader;
            Module module = Module.getBootModuleLoader().loadModule(moduleName);
            if (module != null && (serviceLoader = ServiceLoader.load(ExecutionFactory.class, translatorLoader = module.getClassLoader())) != null) {
                for (ExecutionFactory ef : serviceLoader) {
                    Translator t = ef.getClass().getAnnotation(Translator.class);
                    this.fraction.translator(t.name(), x -> x.module(moduleName));
                }
            }
        }
        catch (ModuleLoadException moduleLoadException) {
            // empty catch block
        }
    }
}

