/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.eval;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.Streamable;
import org.teiid.language.NamedTable;
import org.teiid.language.QueryExpression;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.runtime.HardCodedExecutionFactory;

class AutoGenExecutionFactory
extends HardCodedExecutionFactory {
    private static final Character CHAR_VAL = new Character('c');
    private static final Byte BYTE_VAL = new Byte(0);
    private static final Clob CLOB_VAL = new ClobImpl(new InputStreamFactory(){

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream("hello world".getBytes(Streamable.CHARSET));
        }
    }, -1L);
    private static final Boolean BOOLEAN_VAL = Boolean.FALSE;
    private static final BigInteger BIG_INTEGER_VAL = new BigInteger("0");
    private static final Date SQL_DATE_VAL = TimestampUtil.createDate((int)69, (int)11, (int)31);
    private static final Time TIME_VAL = new Time(0L);
    private static final Timestamp TIMESTAMP_VAL = new Timestamp(0L);
    private static final Timestamp IN_RANGE = TimestampUtil.createTimestamp((int)117, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0);
    private Map<String, Integer> rowCounts = new HashMap<String, Integer>();

    AutoGenExecutionFactory() {
    }

    static Object getValue(Class<?> type, int row, int max) {
        if (type.equals(DataTypeManager.DefaultDataClasses.STRING)) {
            return String.valueOf(10000000 + row % max);
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.INTEGER)) {
            return row % max;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.SHORT)) {
            return (short)row % max;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.LONG)) {
            return (long)row % (long)max;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.FLOAT)) {
            return Float.valueOf(row % max);
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.DOUBLE)) {
            return (double)(row % max);
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.CHAR)) {
            return CHAR_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BYTE)) {
            return BYTE_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
            return BOOLEAN_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER)) {
            return BIG_INTEGER_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL)) {
            return BigDecimal.valueOf(row % max);
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
            return SQL_DATE_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
            return TIME_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            if (row % 3 == 0) {
                return IN_RANGE;
            }
            return TIMESTAMP_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.CLOB)) {
            return CLOB_VAL;
        }
        return null;
    }

    protected List<? extends List<?>> getData(QueryExpression command) {
        List result = super.getData(command);
        if (result != null) {
            return result;
        }
        Class[] types = command.getColumnTypes();
        String name = ((NamedTable)command.getProjectedQuery().getFrom().get(0)).getMetadataObject().getName();
        int rowCount = this.rowCounts.get(name);
        ArrayList resultList = new ArrayList();
        for (int i = 0; i < rowCount; ++i) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int j = 0; j < types.length; ++j) {
                Object value = AutoGenExecutionFactory.getValue(types[j], i, Integer.MAX_VALUE);
                row.add(value);
            }
            resultList.add(row);
        }
        return resultList;
    }

    public void addRowCount(String name, int count) {
        this.rowCounts.put(name, count);
    }
}

