/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.sticker.set;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLObject;

public class TLStickerSet
extends TLObject {
    public static final int CLASS_ID = -852477119;
    private static final int FLAG_INSTALLED = 1;
    private static final int FLAG_ARCHIVED = 2;
    private static final int FLAG_OFFICIAL = 4;
    private static final int FLAG_MASK = 8;
    private int flags;
    private long id;
    private long accessHash;
    private String title;
    private String shortName;
    private int count;
    private int hash;

    @Override
    public int getClassId() {
        return -852477119;
    }

    public long getId() {
        return this.id;
    }

    public long getAccessHash() {
        return this.accessHash;
    }

    public String getTitle() {
        return this.title;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getCount() {
        return this.count;
    }

    public int getHash() {
        return this.hash;
    }

    public boolean isInstalled() {
        return (this.flags & 1) != 0;
    }

    public boolean isArchived() {
        return (this.flags & 2) != 0;
    }

    public boolean isOffcial() {
        return (this.flags & 4) != 0;
    }

    public boolean isMask() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        StreamingUtils.writeLong(this.id, stream);
        StreamingUtils.writeLong(this.accessHash, stream);
        StreamingUtils.writeTLString(this.title, stream);
        StreamingUtils.writeTLString(this.shortName, stream);
        StreamingUtils.writeInt(this.count, stream);
        StreamingUtils.writeInt(this.hash, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        this.id = StreamingUtils.readLong(stream);
        this.accessHash = StreamingUtils.readLong(stream);
        this.title = StreamingUtils.readTLString(stream);
        this.shortName = StreamingUtils.readTLString(stream);
        this.count = StreamingUtils.readInt(stream);
        this.hash = StreamingUtils.readInt(stream);
    }

    @Override
    public String toString() {
        return "stickerSet#cd303b41";
    }
}

