/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.structure;

public class Chat {
    private static final int FLAG_CREATOR = 1;
    private static final int FLAG_KICKED = 2;
    private static final int FLAG_LEFT = 4;
    private static final int FLAG_EDITOR = 8;
    private static final int FLAG_MODERATOR = 16;
    private static final int FLAG_BROADCAST = 32;
    private static final int FLAG_USERNAME = 64;
    private static final int FLAG_VERIFIED = 128;
    private static final int FLAG_MEGAGROUP = 256;
    private static final int FLAG_RESTRICTED = 512;
    private static final int FLAG_INVITES_ENABLED = 1024;
    private static final int FLAG_SIGNATURES = 2048;
    private static final int FLAG_MIN = 4096;
    private static final int FLAG_ACCESS_HASH = 8192;
    private static final int FLAG_USER_CREATOR = 1;
    private static final int FLAG_USER_KICKED = 2;
    private static final int FLAG_USER_LEFT = 4;
    private static final int FLAG_ADMINS_ENABLED = 8;
    private static final int FLAG_USER_ADMIN = 16;
    private static final int FLAG_DEACTIVATED = 32;
    private static final int FLAG_MIGRATED_TO = 64;
    private int id;
    private boolean isChannel;
    private int flags;
    private Long accessHash;
    private String title;
    private String username;
    private String restrictionReason;
    private boolean forbidden;
    private Integer migratedTo;

    public int getId() {
        return this.id;
    }

    public Chat(int id) {
        this.id = id;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public Long getAccessHash() {
        return this.accessHash;
    }

    public void setAccessHash(Long accessHash) {
        this.accessHash = accessHash;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getRestrictionReason() {
        return this.restrictionReason;
    }

    public boolean isChannel() {
        return this.isChannel;
    }

    public void setChannel(boolean channel) {
        this.isChannel = channel;
    }

    public void setRestrictionReason(String restrictionReason) {
        this.restrictionReason = restrictionReason;
    }

    public Integer getMigratedTo() {
        return this.migratedTo;
    }

    public void setMigratedTo(Integer migratedTo) {
        this.migratedTo = migratedTo;
    }

    public void setForbidden(boolean forbidden) {
        this.forbidden = forbidden;
    }

    public boolean isForbidden() {
        return this.forbidden;
    }

    public boolean hasUsername() {
        return (this.flags & 0x40) != 0;
    }

    public boolean hasRestrictionReason() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isSupergroup() {
        return this.isChannel && (this.flags & 0x100) != 0;
    }

    public boolean isMigratedTo() {
        return !this.isChannel && (this.flags & 0x40) != 0;
    }

    public boolean hasAccess() {
        return (this.flags & 2) == 0 && (this.flags & 4) == 0;
    }

    public String toString() {
        return this.title;
    }
}

