/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.tl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.mtproto.log.Logger;
import org.telegram.tl.DeserializeException;
import org.telegram.tl.TLBytes;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLIntVector;
import org.telegram.tl.TLLongVector;
import org.telegram.tl.TLMethod;
import org.telegram.tl.TLObject;
import org.telegram.tl.TLStringVector;
import org.telegram.tl.TLVector;

public class StreamingUtils {
    public static void writeByte(int v, OutputStream stream) throws IOException {
        stream.write(v);
    }

    public static void writeByte(byte v, OutputStream stream) throws IOException {
        stream.write(v);
    }

    public static void writeInt(int v, OutputStream stream) throws IOException {
        StreamingUtils.writeByte((byte)(v & 0xFF), stream);
        StreamingUtils.writeByte((byte)(v >> 8 & 0xFF), stream);
        StreamingUtils.writeByte((byte)(v >> 16 & 0xFF), stream);
        StreamingUtils.writeByte((byte)(v >> 24 & 0xFF), stream);
    }

    public static void writeLong(long v, OutputStream stream) throws IOException {
        StreamingUtils.writeByte((byte)(v & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 8 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 16 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 24 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 32 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 40 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 48 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 56 & 0xFFL), stream);
    }

    public static void writeDouble(double v, OutputStream stream) throws IOException {
        StreamingUtils.writeLong(Double.doubleToLongBits(v), stream);
    }

    public static void writeByteArray(byte[] data, OutputStream stream) throws IOException {
        stream.write(data);
    }

    public static void writeByteArray(byte[] data, int offset, int len, OutputStream stream) throws IOException {
        stream.write(data, offset, len);
    }

    public static void writeTLBool(boolean v, OutputStream stream) throws IOException {
        if (v) {
            StreamingUtils.writeInt(-1720552011, stream);
        } else {
            StreamingUtils.writeInt(-1132882121, stream);
        }
    }

    public static void writeTLString(String v, OutputStream stream) throws IOException {
        StreamingUtils.writeTLBytes(v.getBytes(), stream);
    }

    public static void writeTLBytes(byte[] v, OutputStream stream) throws IOException {
        int startOffset = 1;
        if (v.length >= 254) {
            startOffset = 4;
            StreamingUtils.writeByte(254, stream);
            StreamingUtils.writeByte(v.length & 0xFF, stream);
            StreamingUtils.writeByte(v.length >> 8 & 0xFF, stream);
            StreamingUtils.writeByte(v.length >> 16 & 0xFF, stream);
        } else {
            StreamingUtils.writeByte(v.length, stream);
        }
        StreamingUtils.writeByteArray(v, stream);
        int offset = (v.length + startOffset) % 4;
        if (offset != 0) {
            int offsetCount = 4 - offset;
            StreamingUtils.writeByteArray(new byte[offsetCount], stream);
        }
    }

    public static void writeTLBytes(TLBytes v, OutputStream stream) throws IOException {
        int startOffset = 1;
        if (v.getLength() >= 254) {
            startOffset = 4;
            StreamingUtils.writeByte(254, stream);
            StreamingUtils.writeByte(v.getLength() & 0xFF, stream);
            StreamingUtils.writeByte(v.getLength() >> 8 & 0xFF, stream);
            StreamingUtils.writeByte(v.getLength() >> 16 & 0xFF, stream);
        } else {
            StreamingUtils.writeByte(v.getLength(), stream);
        }
        StreamingUtils.writeByteArray(v.getData(), v.getOffset(), v.getLength(), stream);
        int offset = (v.getLength() + startOffset) % 4;
        if (offset != 0) {
            int offsetCount = 4 - offset;
            StreamingUtils.writeByteArray(new byte[offsetCount], stream);
        }
    }

    public static void writeTLObject(TLObject v, OutputStream stream) throws IOException {
        v.serialize(stream);
    }

    public static void writeTLMethod(TLMethod v, OutputStream stream) throws IOException {
        StreamingUtils.writeTLObject(v, stream);
    }

    public static void writeTLVector(TLVector v, OutputStream stream) throws IOException {
        StreamingUtils.writeTLObject(v, stream);
    }

    public static int \u00bareadInt(InputStream stream) throws IOException {
        int a = stream.read();
        if (a < 0) {
            throw new IOException();
        }
        int b = stream.read();
        if (b < 0) {
            throw new IOException();
        }
        int c = stream.read();
        if (c < 0) {
            throw new IOException();
        }
        int d = stream.read();
        if (d < 0) {
            throw new IOException();
        }
        return a + (b << 8) + (c << 16) + (d << 24);
    }

    public static long readUInt(InputStream stream) throws IOException {
        long a = stream.read();
        if (a < 0L) {
            throw new IOException();
        }
        long b = stream.read();
        if (b < 0L) {
            throw new IOException();
        }
        long c = stream.read();
        if (c < 0L) {
            throw new IOException();
        }
        long d = stream.read();
        if (d < 0L) {
            throw new IOException();
        }
        return a + (b << 8) + (c << 16) + (d << 24);
    }

    public static long readLong(InputStream stream) throws IOException {
        long a = StreamingUtils.readUInt(stream);
        long b = StreamingUtils.readUInt(stream);
        return a + (b << 32);
    }

    public static double readDouble(InputStream stream) throws IOException {
        return Double.longBitsToDouble(StreamingUtils.readLong(stream));
    }

    public static String readTLString(InputStream stream) throws IOException {
        return new String(StreamingUtils.readTLBytes(stream));
    }

    public static TLObject readTLObject(InputStream stream, TLContext context) throws IOException {
        return context.deserializeMessage(stream);
    }

    public static <T extends TLObject> T readTLObject(InputStream stream, TLContext context, Class<T> type) throws IOException {
        return (T)context.deserializeMessage(stream);
    }

    public static TLMethod readTLMethod(InputStream stream, TLContext context) throws IOException {
        return (TLMethod)context.deserializeMessage(stream);
    }

    public static byte[] readBytes(int count, InputStream stream) throws IOException {
        byte[] res = new byte[count];
        int offset = 0;
        while (offset < res.length) {
            int readed = stream.read(res, offset, res.length - offset);
            if (readed > 0) {
                offset += readed;
                continue;
            }
            if (readed < 0) {
                throw new IOException();
            }
            Thread.yield();
        }
        return res;
    }

    public static void skipBytes(int count, InputStream stream) throws IOException {
        byte[] bytes = new byte[count];
        stream.read(bytes);
        Logger.d("SKIPED", "Skypped " + count + " bytes: " + bytes);
    }

    public static void readBytes(byte[] buffer, int offset, int count, InputStream stream) throws IOException {
        int woffset = 0;
        while (woffset < count) {
            int readed = stream.read(buffer, woffset + offset, count - woffset);
            if (readed > 0) {
                woffset += readed;
                continue;
            }
            if (readed < 0) {
                throw new IOException();
            }
            Thread.yield();
        }
    }

    public static byte[] readTLBytes(InputStream stream) throws IOException {
        int count = stream.read();
        int startOffset = 1;
        if (count >= 254) {
            count = stream.read() + (stream.read() << 8) + (stream.read() << 16);
            startOffset = 4;
        }
        byte[] raw = StreamingUtils.readBytes(count, stream);
        int offset = (count + startOffset) % 4;
        if (offset != 0) {
            int offsetCount = 4 - offset;
            StreamingUtils.skipBytes(offsetCount, stream);
        }
        return raw;
    }

    public static TLBytes readTLBytes(InputStream stream, TLContext context) throws IOException {
        int count = stream.read();
        int startOffset = 1;
        if (count >= 254) {
            count = stream.read() + (stream.read() << 8) + (stream.read() << 16);
            startOffset = 4;
        }
        TLBytes res = context.allocateBytes(count);
        StreamingUtils.readBytes(res.getData(), res.getOffset(), res.getLength(), stream);
        int offset = (count + startOffset) % 4;
        if (offset != 0) {
            int offsetCount = 4 - offset;
            StreamingUtils.skipBytes(offsetCount, stream);
        }
        return res;
    }

    public static TLVector readTLVector(InputStream stream, TLContext context) throws IOException {
        return context.deserializeVector(stream);
    }

    public static <T> TLVector<T> readTLVector(InputStream stream, TLContext context, Class<T> vectorType) throws IOException {
        return context.deserializeVector(stream);
    }

    public static TLIntVector readTLIntVector(InputStream stream, TLContext context) throws IOException {
        return context.deserializeIntVector(stream);
    }

    public static TLLongVector readTLLongVector(InputStream stream, TLContext context) throws IOException {
        return context.deserializeLongVector(stream);
    }

    public static TLStringVector readTLStringVector(InputStream stream, TLContext context) throws IOException {
        return context.deserializeStringVector(stream);
    }

    public static boolean readTLBool(InputStream stream) throws IOException {
        int v = StreamingUtils.readInt(stream);
        if (v == -1720552011) {
            return true;
        }
        if (v == -1132882121) {
            return false;
        }
        throw new DeserializeException("Not bool value: " + Integer.toHexString(v));
    }

    public static byte[] intToBytes(int value) {
        return new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
    }

    public static byte[] longToBytes(long value) {
        return new byte[]{(byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 56 & 0xFFL)};
    }

    public static int readInt(byte[] src) {
        return StreamingUtils.readInt(src, 0);
    }

    public static int readInt(byte[] src, int offset) {
        int a = src[offset + 0] & 0xFF;
        int b = src[offset + 1] & 0xFF;
        int c = src[offset + 2] & 0xFF;
        int d = src[offset + 3] & 0xFF;
        return a + (b << 8) + (c << 16) + (d << 24);
    }

    public static int readInt(InputStream stream) throws IOException {
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            i |= stream.read() << j * 8;
        }
        return i;
    }

    public static long readUInt(byte[] src) {
        return StreamingUtils.readUInt(src, 0);
    }

    public static long readUInt(byte[] src, int offset) {
        long a = src[offset + 0] & 0xFF;
        long b = src[offset + 1] & 0xFF;
        long c = src[offset + 2] & 0xFF;
        long d = src[offset + 3] & 0xFF;
        return a + (b << 8) + (c << 16) + (d << 24);
    }

    public static long readLong(byte[] src, int offset) {
        long a = StreamingUtils.readUInt(src, offset);
        long b = StreamingUtils.readUInt(src, offset + 4);
        return (a & 0xFFFFFFFFFFFFFFFFL) + ((b & 0xFFFFFFFFFFFFFFFFL) << 32);
    }
}

