/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.kernel.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.telegram.api.TLConfig;
import org.telegram.api.TLDcOption;
import org.telegram.api.auth.TLAuthorization;
import org.telegram.api.engine.storage.AbsApiState;
import org.telegram.api.user.TLUser;
import org.telegram.bot.kernel.engine.TLPersistence;
import org.telegram.bot.kernel.engine.storage.TLDcInfo;
import org.telegram.bot.kernel.engine.storage.TLKey;
import org.telegram.bot.kernel.engine.storage.TLLastKnownSalt;
import org.telegram.bot.kernel.engine.storage.TLStorage;
import org.telegram.mtproto.state.AbsMTProtoState;
import org.telegram.mtproto.state.ConnectionInfo;
import org.telegram.mtproto.state.KnownSalt;
import org.telegram.tl.TLVector;

public class MemoryApiState
extends TLPersistence<TLStorage>
implements AbsApiState {
    private static final String TAG = "ApiStorage";

    public MemoryApiState(String filename) {
        super(filename, TLStorage.class);
        if (((TLStorage)this.getObj()).getDcInfos().isEmpty()) {
            ((TLStorage)this.getObj()).getDcInfos().add(new TLDcInfo(0, 1, "149.154.175.50", 443, 0));
            ((TLStorage)this.getObj()).getDcInfos().add(new TLDcInfo(0, 2, "149.154.167.51", 443, 0));
            ((TLStorage)this.getObj()).getDcInfos().add(new TLDcInfo(0, 3, "149.154.175.100", 443, 0));
            ((TLStorage)this.getObj()).getDcInfos().add(new TLDcInfo(0, 4, "149.154.167.91", 443, 0));
            ((TLStorage)this.getObj()).getDcInfos().add(new TLDcInfo(0, 5, "149.154.171.5", 443, 0));
            ((TLStorage)this.getObj()).getDcInfos().add(new TLDcInfo(0, 6, "173.240.5.1", 443, 0));
        }
    }

    public int[] getKnownDc() {
        HashSet<Integer> dcs = new HashSet<Integer>();
        for (TLDcInfo dcInfo : ((TLStorage)this.getObj()).getDcInfos()) {
            dcs.add(dcInfo.getDcId());
        }
        Integer[] dcsArray = dcs.toArray(new Integer[0]);
        int[] res = new int[dcs.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = dcsArray[i];
        }
        return res;
    }

    private TLKey findKey(int dc) {
        for (TLKey key : ((TLStorage)this.getObj()).getKeys()) {
            if (key.getDcId() != dc) continue;
            return key;
        }
        return null;
    }

    @Override
    public synchronized boolean isAuthenticated() {
        return this.isAuthenticated(this.getPrimaryDc());
    }

    @Override
    public synchronized void doAuth(@NotNull TLAuthorization authorization) {
        if (authorization.getUser() instanceof TLUser) {
            TLUser user = (TLUser)authorization.getUser();
            TLKey key = this.findKey(this.getPrimaryDc());
            key.setAuthorised(true);
            ((TLStorage)this.getObj()).setUid(user.getId());
            ((TLStorage)this.getObj()).setPhone(user.getPhone());
            this.write();
        }
    }

    public synchronized void doAuth(int uid, String phone) {
        TLKey key = this.findKey(this.getPrimaryDc());
        key.setAuthorised(true);
        ((TLStorage)this.getObj()).setUid(uid);
        ((TLStorage)this.getObj()).setPhone(phone);
        this.write();
    }

    @Override
    public synchronized int getPrimaryDc() {
        return ((TLStorage)this.getObj()).getPrimaryDc();
    }

    @Override
    public synchronized void setPrimaryDc(int dc) {
        ((TLStorage)this.getObj()).setPrimaryDc(dc);
        this.write();
    }

    @Override
    public synchronized boolean isAuthenticated(int dcId) {
        TLKey key = this.findKey(dcId);
        return key != null && key.isAuthorised();
    }

    @Override
    public synchronized void setAuthenticated(int dcId, boolean auth) {
        TLKey key = this.findKey(dcId);
        key.setAuthorised(auth);
        this.write();
    }

    @Override
    public synchronized void updateSettings(TLConfig config) {
        TLVector<TLDcInfo> var;
        int version = 0;
        for (TLDcInfo tLDcInfo : ((TLStorage)this.getObj()).getDcInfos()) {
            version = Math.max(version, tLDcInfo.getVersion());
        }
        boolean hasUpdates = false;
        for (TLDcOption option : config.getDcOptions()) {
            if (option.getFlags() != 0) continue;
            boolean contains = false;
            var = ((TLStorage)this.getObj()).getDcInfos();
            for (TLDcInfo info : var.toArray((T1[])new TLDcInfo[var.size()])) {
                if (!info.getAddress().equals(option.getIpAddress()) || info.getPort() != option.getPort() || info.getDcId() != option.getId() || info.getVersion() != version) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            hasUpdates = true;
        }
        if (!hasUpdates) {
            return;
        }
        int n = version + 1;
        for (TLDcOption option : config.getDcOptions()) {
            if (option.getFlags() != 0) continue;
            var = ((TLStorage)this.getObj()).getDcInfos();
            for (TLDcInfo info : var.toArray((T1[])new TLDcInfo[var.size()])) {
                if (!info.getAddress().equals(option.getIpAddress()) || info.getDcId() != option.getId()) continue;
                ((TLStorage)this.getObj()).getDcInfos().remove(info);
            }
            ((TLStorage)this.getObj()).getDcInfos().add(new TLDcInfo(option.getFlags(), option.getId(), option.getIpAddress(), option.getPort(), n));
        }
        this.write();
    }

    public synchronized void updateDCInfo(int flags, int dcId, String ip, int port) {
        TLVector<TLDcInfo> var = ((TLStorage)this.getObj()).getDcInfos();
        for (TLDcInfo info : var.toArray((T1[])new TLDcInfo[var.size()])) {
            if (!info.getAddress().equals(ip) || info.getPort() != port || info.getDcId() != dcId) continue;
            ((TLStorage)this.getObj()).getDcInfos().remove(info);
        }
        int version = 0;
        for (TLDcInfo info : ((TLStorage)this.getObj()).getDcInfos()) {
            version = Math.max(version, info.getVersion());
        }
        ((TLStorage)this.getObj()).getDcInfos().add(new TLDcInfo(flags, dcId, ip, port, version));
        this.write();
    }

    @Override
    public synchronized byte[] getAuthKey(int dcId) {
        TLKey key = this.findKey(dcId);
        return key != null ? key.getAuthKey() : null;
    }

    @Override
    public synchronized void putAuthKey(int dcId, byte[] authKey) {
        TLKey key = this.findKey(dcId);
        if (key != null) {
            return;
        }
        ((TLStorage)this.getObj()).getKeys().add(new TLKey(dcId, authKey));
        this.write();
    }

    @Override
    public ConnectionInfo[] getAvailableConnections(int dcId) {
        ArrayList<TLDcInfo> infos = new ArrayList<TLDcInfo>();
        int maxVersion = 0;
        for (TLDcInfo info : ((TLStorage)this.getObj()).getDcInfos()) {
            if (info.getDcId() != dcId) continue;
            infos.add(info);
            maxVersion = Math.max(maxVersion, info.getVersion());
        }
        ArrayList<ConnectionInfo> res = new ArrayList<ConnectionInfo>();
        HashMap<String, DcAddress> mainAddresses = new HashMap<String, DcAddress>();
        for (TLDcInfo i : infos) {
            if (i.getVersion() != maxVersion) continue;
            if (mainAddresses.containsKey(i.getAddress())) {
                ((DcAddress)mainAddresses.get((Object)i.getAddress())).ports.put(i.getPort(), 1);
                continue;
            }
            DcAddress address = new DcAddress();
            address.ports.put(i.getPort(), 1);
            address.host = i.getAddress();
            mainAddresses.put(i.getAddress(), address);
        }
        for (Iterator address : mainAddresses.values()) {
            ((DcAddress)((Object)address)).ports.put(443, 2);
            ((DcAddress)((Object)address)).ports.put(80, 1);
            ((DcAddress)((Object)address)).ports.put(25, 0);
        }
        HashMap otherAddresses = new HashMap();
        for (TLDcInfo i : infos) {
            Object addressHashMap;
            if (i.getVersion() == maxVersion) continue;
            if (!otherAddresses.containsKey(i.getVersion())) {
                otherAddresses.put(i.getVersion(), new HashMap());
            }
            if (((HashMap)(addressHashMap = (HashMap)otherAddresses.get(i.getVersion()))).containsKey(i.getAddress())) {
                ((DcAddress)((HashMap)addressHashMap).get((Object)i.getAddress())).ports.put(i.getPort(), 1);
                continue;
            }
            DcAddress address = new DcAddress();
            address.ports.put(i.getPort(), 1);
            address.host = i.getAddress();
            ((HashMap)addressHashMap).put(i.getAddress(), address);
        }
        for (Integer version : otherAddresses.keySet()) {
            for (DcAddress address : ((HashMap)otherAddresses.get(version)).values()) {
                if (mainAddresses.containsKey(address.host)) continue;
                address.ports.put(443, 2);
                address.ports.put(80, 1);
                address.ports.put(25, 0);
            }
        }
        int index = 0;
        for (DcAddress address : mainAddresses.values()) {
            for (Integer port : address.ports.keySet()) {
                int priority = maxVersion + address.ports.get(port);
                res.add(new ConnectionInfo(index++, priority, address.host, port));
            }
        }
        for (Integer version : otherAddresses.keySet()) {
            for (DcAddress address : ((HashMap)otherAddresses.get(version)).values()) {
                for (Integer port : address.ports.keySet()) {
                    int priority = version + address.ports.get(port);
                    res.add(new ConnectionInfo(index++, priority, address.host, port));
                }
            }
        }
        return res.toArray(new ConnectionInfo[res.size()]);
    }

    private synchronized void writeKnownSalts(int dcId, KnownSalt[] salts) {
        TLKey key = this.findKey(dcId);
        key.getSalts().clear();
        for (KnownSalt salt : salts) {
            key.getSalts().add(new TLLastKnownSalt(salt.getValidSince(), salt.getValidUntil(), salt.getSalt()));
        }
        this.write();
    }

    private synchronized KnownSalt[] readKnownSalts(int dcId) {
        TLKey key = this.findKey(dcId);
        KnownSalt[] salts = new KnownSalt[key.getSalts().size()];
        for (int i = 0; i < salts.length; ++i) {
            TLLastKnownSalt sourceSalt = key.getSalts().get(i);
            salts[i] = new KnownSalt(sourceSalt.getValidSince(), sourceSalt.getValidUntil(), sourceSalt.getSalt());
        }
        return salts;
    }

    @Override
    public synchronized AbsMTProtoState getMtProtoState(final int dcId) {
        return new AbsMTProtoState(){
            private KnownSalt[] knownSalts = null;

            @Override
            public byte[] getAuthKey() {
                return MemoryApiState.this.getAuthKey(dcId);
            }

            @Override
            public ConnectionInfo[] getAvailableConnections() {
                return MemoryApiState.this.getAvailableConnections(dcId);
            }

            @Override
            public KnownSalt[] readKnownSalts() {
                if (this.knownSalts == null) {
                    this.knownSalts = MemoryApiState.this.readKnownSalts(dcId);
                }
                return this.knownSalts;
            }

            @Override
            protected void writeKnownSalts(KnownSalt[] salts) {
                MemoryApiState.this.writeKnownSalts(dcId, salts);
                this.knownSalts = null;
            }
        };
    }

    @Override
    public synchronized void resetAuth() {
        for (TLKey key : ((TLStorage)this.getObj()).getKeys()) {
            key.setAuthorised(false);
        }
        ((TLStorage)this.getObj()).setAuthorized(false);
        ((TLStorage)this.getObj()).setUid(0);
        this.write();
    }

    @Override
    public synchronized void reset() {
        ((TLStorage)this.getObj()).getKeys().clear();
        ((TLStorage)this.getObj()).setAuthorized(false);
        ((TLStorage)this.getObj()).setUid(0);
        this.write();
    }

    @Override
    public int getUserId() {
        return ((TLStorage)this.getObj()).getUid();
    }

    private class DcAddress {
        public final HashMap<Integer, Integer> ports = new HashMap();
        public String host;

        private DcAddress() {
        }
    }
}

