/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.handlers;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.telegram.api.chat.TLAbsChat;
import org.telegram.api.message.TLAbsMessage;
import org.telegram.api.message.TLMessage;
import org.telegram.api.message.TLMessageService;
import org.telegram.api.notify.peer.TLAbsNotifyPeer;
import org.telegram.api.notify.peer.TLNotifyPeer;
import org.telegram.api.peer.TLAbsPeer;
import org.telegram.api.peer.TLPeerUser;
import org.telegram.api.update.TLAbsUpdate;
import org.telegram.api.update.TLFakeUpdate;
import org.telegram.api.update.TLUpdateBotCallbackQuery;
import org.telegram.api.update.TLUpdateBotInlineQuery;
import org.telegram.api.update.TLUpdateBotInlineSend;
import org.telegram.api.update.TLUpdateChannel;
import org.telegram.api.update.TLUpdateChannelMessageViews;
import org.telegram.api.update.TLUpdateChannelNewMessage;
import org.telegram.api.update.TLUpdateChannelPinnedMessage;
import org.telegram.api.update.TLUpdateChannelTooLong;
import org.telegram.api.update.TLUpdateChatAdmin;
import org.telegram.api.update.TLUpdateChatParticipantAdd;
import org.telegram.api.update.TLUpdateChatParticipantAdmin;
import org.telegram.api.update.TLUpdateChatParticipantDelete;
import org.telegram.api.update.TLUpdateChatParticipants;
import org.telegram.api.update.TLUpdateChatUserTyping;
import org.telegram.api.update.TLUpdateConfig;
import org.telegram.api.update.TLUpdateContactLink;
import org.telegram.api.update.TLUpdateContactRegistered;
import org.telegram.api.update.TLUpdateDcOptions;
import org.telegram.api.update.TLUpdateDeleteChannelMessages;
import org.telegram.api.update.TLUpdateDeleteMessages;
import org.telegram.api.update.TLUpdateDraftMessage;
import org.telegram.api.update.TLUpdateEditChannelMessage;
import org.telegram.api.update.TLUpdateEditMessage;
import org.telegram.api.update.TLUpdateInlineBotCallbackQuery;
import org.telegram.api.update.TLUpdateMessageId;
import org.telegram.api.update.TLUpdateNewAuthorization;
import org.telegram.api.update.TLUpdateNewMessage;
import org.telegram.api.update.TLUpdateNewStickerSet;
import org.telegram.api.update.TLUpdateNotifySettings;
import org.telegram.api.update.TLUpdatePrivacy;
import org.telegram.api.update.TLUpdatePtsChanged;
import org.telegram.api.update.TLUpdateReadChannelInbox;
import org.telegram.api.update.TLUpdateReadChannelOutbox;
import org.telegram.api.update.TLUpdateReadFeaturedStickers;
import org.telegram.api.update.TLUpdateReadMessagesContents;
import org.telegram.api.update.TLUpdateReadMessagesInbox;
import org.telegram.api.update.TLUpdateReadMessagesOutbox;
import org.telegram.api.update.TLUpdateRecentStickers;
import org.telegram.api.update.TLUpdateSavedGifs;
import org.telegram.api.update.TLUpdateServiceNotification;
import org.telegram.api.update.TLUpdateStickerSets;
import org.telegram.api.update.TLUpdateStickerSetsOrder;
import org.telegram.api.update.TLUpdateUserBlocked;
import org.telegram.api.update.TLUpdateUserName;
import org.telegram.api.update.TLUpdateUserPhone;
import org.telegram.api.update.TLUpdateUserPhoto;
import org.telegram.api.update.TLUpdateUserStatus;
import org.telegram.api.update.TLUpdateUserTyping;
import org.telegram.api.update.TLUpdateWebPage;
import org.telegram.api.update.encrypted.TLUpdateEncryptedChatTyping;
import org.telegram.api.update.encrypted.TLUpdateEncryptedMessagesRead;
import org.telegram.api.update.encrypted.TLUpdateEncryption;
import org.telegram.api.update.encrypted.TLUpdateNewEncryptedMessage;
import org.telegram.api.updates.TLUpdateShortChatMessage;
import org.telegram.api.updates.TLUpdateShortMessage;
import org.telegram.api.updates.TLUpdateShortSentMessage;
import org.telegram.api.updates.TLUpdatesState;
import org.telegram.api.updates.difference.TLAbsDifference;
import org.telegram.api.user.TLAbsUser;
import org.telegram.bot.handlers.DifferencesHandler;
import org.telegram.bot.handlers.interfaces.IDifferencesHandler;
import org.telegram.bot.handlers.interfaces.IUpdatesHandler;
import org.telegram.bot.kernel.IKernelComm;
import org.telegram.bot.kernel.UpdateWrapper;
import org.telegram.bot.kernel.database.DatabaseManager;
import org.telegram.bot.kernel.differenceparameters.IDifferenceParametersService;
import org.telegram.bot.services.BotLogger;
import org.telegram.bot.structure.Chat;
import org.telegram.tl.TLObject;

public abstract class UpdatesHandlerBase
implements IUpdatesHandler {
    private static final String LOGTAG = "UPDATESHANDLERBASE";
    private final IDifferenceParametersService differenceParametersService;
    private final IDifferencesHandler differencesHandler;
    private final DatabaseManager databaseManager;

    protected UpdatesHandlerBase(IKernelComm kernelComm, IDifferenceParametersService differenceParametersService, DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
        this.differenceParametersService = differenceParametersService;
        this.differencesHandler = new DifferencesHandler(kernelComm, differenceParametersService, this);
    }

    @Override
    public final void processUpdate(UpdateWrapper updateWrapper) {
        boolean canHandle = true;
        if (updateWrapper.isCheckPts()) {
            canHandle = this.checkPts(updateWrapper);
        }
        if (canHandle) {
            TLObject update = updateWrapper.getUpdate();
            if (update instanceof TLUpdateShortMessage) {
                this.onTLUpdateShortMessage((TLUpdateShortMessage)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateShortChatMessage) {
                this.onTLUpdateShortChatMessage((TLUpdateShortChatMessage)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateShortSentMessage) {
                this.onTLUpdateShortSentMessage((TLUpdateShortSentMessage)update);
            } else if (update instanceof TLUpdateNewMessage) {
                this.onTLUpdateNewMessage((TLUpdateNewMessage)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateChatParticipants) {
                this.onTLUpdateChatParticipants((TLUpdateChatParticipants)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateChannelNewMessage) {
                this.onTLUpdateChannelNewMessage((TLUpdateChannelNewMessage)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateChannel) {
                this.onTLUpdateChannel((TLUpdateChannel)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateBotInlineQuery) {
                this.onTLUpdateBotInlineQuery((TLUpdateBotInlineQuery)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateBotInlineSend) {
                this.onTLUpdateBotInlineSend((TLUpdateBotInlineSend)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateChannelMessageViews) {
                this.onTLUpdateChannelMessageViews((TLUpdateChannelMessageViews)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateChannelPinnedMessage) {
                this.onTLUpdateChannelPinnedMessage((TLUpdateChannelPinnedMessage)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateChannelTooLong) {
                this.onTLUpdateChannelTooLong((TLUpdateChannelTooLong)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateChatAdmin) {
                this.onTLUpdateChatAdmin((TLUpdateChatAdmin)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateChatParticipantAdd) {
                this.onTLUpdateChatParticipantAdd((TLUpdateChatParticipantAdd)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateChatParticipantAdmin) {
                this.onTLUpdateChatParticipantAdmin((TLUpdateChatParticipantAdmin)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateChatParticipantDelete) {
                this.onTLUpdateChatParticipantDelete((TLUpdateChatParticipantDelete)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateChatUserTyping) {
                this.onTLUpdateChatUserTyping((TLUpdateChatUserTyping)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateContactLink) {
                this.onTLUpdateContactLink((TLUpdateContactLink)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateContactRegistered) {
                this.onTLUpdateContactRegistered((TLUpdateContactRegistered)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateDcOptions) {
                this.onTLUpdateDcOptions((TLUpdateDcOptions)update);
            } else if (update instanceof TLUpdateDeleteChannelMessages) {
                this.onTLUpdateDeleteChannelMessages((TLUpdateDeleteChannelMessages)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateDeleteMessages) {
                this.onTLUpdateDeleteMessages((TLUpdateDeleteMessages)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateEditChannelMessage) {
                this.onTLUpdateEditChannelMessage((TLUpdateEditChannelMessage)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateMessageId) {
                this.onTLUpdateMessageId((TLUpdateMessageId)update);
            } else if (update instanceof TLUpdateNewAuthorization) {
                this.onTLUpdateNewAuthorization((TLUpdateNewAuthorization)update);
            } else if (update instanceof TLUpdateNewStickerSet) {
                this.onTLUpdateNewStickerSet((TLUpdateNewStickerSet)update);
            } else if (update instanceof TLUpdateNotifySettings) {
                this.onTLUpdateNotifySettings((TLUpdateNotifySettings)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdatePrivacy) {
                this.onTLUpdatePrivacy((TLUpdatePrivacy)update);
            } else if (update instanceof TLUpdateReadChannelInbox) {
                this.onTLUpdateReadChannelInbox((TLUpdateReadChannelInbox)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateReadMessagesContents) {
                this.onTLUpdateReadMessagesContents((TLUpdateReadMessagesContents)update);
            } else if (update instanceof TLUpdateReadMessagesInbox) {
                this.onTLUpdateReadMessagesInbox((TLUpdateReadMessagesInbox)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateReadMessagesOutbox) {
                this.onTLUpdateReadMessagesOutbox((TLUpdateReadMessagesOutbox)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateSavedGifs) {
                this.onTLUpdateSavedGifs((TLUpdateSavedGifs)update);
            } else if (update instanceof TLUpdateServiceNotification) {
                this.onTLUpdateServiceNotification((TLUpdateServiceNotification)update);
            } else if (update instanceof TLUpdateStickerSets) {
                this.onTLUpdateStickerSets((TLUpdateStickerSets)update);
            } else if (update instanceof TLUpdateStickerSetsOrder) {
                this.onTLUpdateStickerSetsOrder((TLUpdateStickerSetsOrder)update);
            } else if (update instanceof TLUpdateUserBlocked) {
                this.onTLUpdateUserBlocked((TLUpdateUserBlocked)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateUserName) {
                this.onTLUpdateUserName((TLUpdateUserName)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateUserPhone) {
                this.onTLUpdateUserPhone((TLUpdateUserPhone)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateUserPhoto) {
                this.onTLUpdateUserPhoto((TLUpdateUserPhoto)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateUserStatus) {
                this.onTLUpdateUserStatus((TLUpdateUserStatus)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateUserTyping) {
                this.onTLUpdateUserTyping((TLUpdateUserTyping)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateWebPage) {
                this.onTLUpdateWebPage((TLUpdateWebPage)update);
            } else if (update instanceof TLFakeUpdate) {
                this.onTLFakeUpdate((TLFakeUpdate)update);
            } else if (update instanceof TLUpdateBotCallbackQuery) {
                this.onTLUpdateBotCallbackQuery((TLUpdateBotCallbackQuery)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateEditMessage) {
                this.onTLUpdateEditMessage((TLUpdateEditMessage)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateInlineBotCallbackQuery) {
                this.onTLUpdateInlineBotCallbackQuery((TLUpdateInlineBotCallbackQuery)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateEncryption) {
                this.onTLUpdateEncryption((TLUpdateEncryption)update);
            } else if (update instanceof TLUpdateEncryptedChatTyping) {
                this.onTLUpdateEncryptedChatTyping((TLUpdateEncryptedChatTyping)update);
            } else if (update instanceof TLUpdateEncryptedMessagesRead) {
                this.onTLUpdateEncryptedMessagesRead((TLUpdateEncryptedMessagesRead)update);
            } else if (update instanceof TLUpdateNewEncryptedMessage) {
                this.onTLUpdateNewEncryptedMessage((TLUpdateNewEncryptedMessage)update);
            } else if (update instanceof TLUpdateConfig) {
                this.onTLUpdateConfig((TLUpdateConfig)update);
            } else if (update instanceof TLUpdateDraftMessage) {
                this.onTLUpdateDraftMessage((TLUpdateDraftMessage)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdatePtsChanged) {
                this.onTLUpdatePtsChanged((TLUpdatePtsChanged)update);
            } else if (update instanceof TLUpdateReadChannelOutbox) {
                this.onTLUpdateReadChannelOutbox((TLUpdateReadChannelOutbox)update, updateWrapper.isGettingDifferences());
            } else if (update instanceof TLUpdateReadFeaturedStickers) {
                this.onTLUpdateReadFeaturedStickers((TLUpdateReadFeaturedStickers)update);
            } else if (update instanceof TLUpdateRecentStickers) {
                this.onTLUpdateRecentStickers((TLUpdateRecentStickers)update);
            } else {
                BotLogger.debug(LOGTAG, "Unsupported TLAbsUpdate: " + update.toString());
            }
            if (updateWrapper.isUpdatePts()) {
                this.updatePts(updateWrapper);
            }
        }
    }

    private boolean checkPts(UpdateWrapper updateWrapper) {
        boolean canHandle;
        int pts = this.differenceParametersService.getPts(updateWrapper.getChannelId());
        int newPts = pts + updateWrapper.getPtsCount();
        if (updateWrapper.getPts() == 0 || newPts == updateWrapper.getPts()) {
            canHandle = true;
        } else {
            BotLogger.warn(LOGTAG, "Discarded " + updateWrapper.toString() + " with newPts: " + newPts + "(" + pts + ") and pts: " + updateWrapper.getPts());
            canHandle = false;
            if (newPts < updateWrapper.getPts()) {
                if (!updateWrapper.isChannel() || this.isChatMissing(updateWrapper.getChannelId())) {
                    this.getDifferences();
                } else {
                    Chat chat = this.databaseManager.getChatById(updateWrapper.getChannelId());
                    if (chat != null) {
                        this.differencesHandler.getChannelDifferences(chat.getId(), chat.getAccessHash());
                    }
                }
            }
        }
        return canHandle;
    }

    @Override
    public final boolean checkSeq(int seq, int seqStart, int date) {
        boolean canHandle = false;
        int n = seqStart = seqStart == 0 ? seq : seqStart;
        if (seqStart == this.differenceParametersService.getSeq(0) + 1) {
            canHandle = true;
        }
        return canHandle;
    }

    @Override
    public final void getDifferences() {
        this.differencesHandler.getDifferences();
    }

    private void updatePts(UpdateWrapper updateWrapper) {
        this.differenceParametersService.setNewUpdateParams(updateWrapper.getChannelId(), updateWrapper.getPts(), updateWrapper.getSeq(), updateWrapper.getDate());
    }

    private void onTLUpdateShortMessage(TLUpdateShortMessage update, boolean gettingDifferences) {
        if (this.isUserFromShortMessageMissing(update)) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateShortMessageCustom(update);
        }
    }

    private void onTLUpdateShortChatMessage(TLUpdateShortChatMessage update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChatId()) || this.isUserMissing(update.getFromId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateShortChatMessageCustom(update);
        }
    }

    private void onTLUpdateShortSentMessage(TLUpdateShortSentMessage update) {
        this.onTLUpdateShortSentMessageCustom(update);
    }

    private void onTLUpdateChatParticipants(TLUpdateChatParticipants update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getParticipants().getChatId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateChatParticipantsCustom(update);
        }
    }

    private void onTLUpdateNewMessage(TLUpdateNewMessage update, boolean gettingDifferences) {
        if (this.isUserFromMessageMissing(update.getMessage())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateNewMessageCustom(update);
        }
    }

    private void onTLUpdateChannelNewMessage(TLUpdateChannelNewMessage update, boolean gettingDifferences) {
        if (this.isUserFromMessageMissing(update.getMessage(), false)) {
            if (this.isChatMissing(update.getChannelId())) {
                if (!gettingDifferences) {
                    this.differencesHandler.getDifferences();
                }
            } else {
                Chat channel = this.databaseManager.getChatById(update.getMessage().getChatId());
                if (channel != null) {
                    this.differencesHandler.getChannelDifferences(channel.getId(), channel.getAccessHash());
                }
            }
        } else {
            this.onTLUpdateChannelNewMessageCustom(update);
        }
    }

    private void onTLUpdateChannel(TLUpdateChannel update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChannelId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateChannelCustom(update);
        }
    }

    private void onTLUpdateBotInlineQuery(TLUpdateBotInlineQuery update, boolean gettingDifferences) {
        if (this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateBotInlineQueryCustom(update);
        }
    }

    private void onTLUpdateBotInlineSend(TLUpdateBotInlineSend update, boolean gettingDifferences) {
        if (this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateBotInlineSendCustom(update);
        }
    }

    private void onTLUpdateChannelMessageViews(TLUpdateChannelMessageViews update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChannelId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateChannelMessageViewsCustom(update);
        }
    }

    private void onTLUpdateChannelPinnedMessage(TLUpdateChannelPinnedMessage update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChannelId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateChannelPinnedMessageCustom(update);
        }
    }

    private void onTLUpdateChannelTooLong(TLUpdateChannelTooLong update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChannelId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            Chat channel = this.databaseManager.getChatById(update.getChannelId());
            if (channel != null) {
                this.differencesHandler.getChannelDifferences(channel.getId(), channel.getAccessHash());
            }
        }
    }

    private void onTLUpdateChatAdmin(TLUpdateChatAdmin update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChatId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateChatAdminCustom(update);
        }
    }

    private void onTLUpdateChatParticipantAdd(TLUpdateChatParticipantAdd update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChatId()) || this.isUserMissing(update.getUserId()) || this.isUserMissing(update.getInviterId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateChatParticipantAddCustom(update);
        }
    }

    private void onTLUpdateChatParticipantAdmin(TLUpdateChatParticipantAdmin update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChatId()) || this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateChatParticipantAdminCustom(update);
        }
    }

    private void onTLUpdateChatParticipantDelete(TLUpdateChatParticipantDelete update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChatId()) || this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateChatParticipantDeleteCustom(update);
        }
    }

    private void onTLUpdateChatUserTyping(TLUpdateChatUserTyping update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChatId()) || this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateChatUserTypingCustom(update);
        }
    }

    private void onTLUpdateContactLink(TLUpdateContactLink update, boolean gettingDifferences) {
        if (this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateContactLinkCustom(update);
        }
    }

    private void onTLUpdateContactRegistered(TLUpdateContactRegistered update, boolean gettingDifferences) {
        if (this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateContactRegisteredCustom(update);
        }
    }

    private void onTLUpdateDcOptions(TLUpdateDcOptions update) {
        this.onTLUpdateDcOptionsCustom(update);
    }

    private void onTLUpdateDeleteChannelMessages(TLUpdateDeleteChannelMessages update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChannelId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateDeleteChannelMessagesCustom(update);
        }
    }

    private void onTLUpdateDeleteMessages(TLUpdateDeleteMessages update, boolean gettingDifferences) {
        this.onTLUpdateDeleteMessagesCustom(update);
    }

    private void onTLUpdateEditChannelMessage(TLUpdateEditChannelMessage update, boolean gettingDifferences) {
        if (this.isUserFromMessageMissing(update.getMessage(), false)) {
            if (this.isChatMissing(update.getChannelId())) {
                if (!gettingDifferences) {
                    this.differencesHandler.getDifferences();
                }
            } else {
                Chat channel = this.databaseManager.getChatById(update.getMessage().getChatId());
                if (channel != null) {
                    this.differencesHandler.getChannelDifferences(channel.getId(), channel.getAccessHash());
                }
            }
        } else {
            this.onTLUpdateEditChannelMessageCustom(update);
        }
    }

    private void onTLUpdateMessageId(TLUpdateMessageId update) {
        this.onTLUpdateMessageIdCustom(update);
    }

    private void onTLUpdateNewAuthorization(TLUpdateNewAuthorization update) {
        this.onTLUpdateNewAuthorizationCustom(update);
    }

    private void onTLUpdateNewStickerSet(TLUpdateNewStickerSet update) {
        this.onTLUpdateNewStickerSetCustom(update);
    }

    private void onTLUpdateNotifySettings(TLUpdateNotifySettings update, boolean gettingDifferences) {
        if (this.isNotifyPeerMissing(update.getPeer())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateNotifySettingsCustom(update);
        }
    }

    private void onTLUpdatePrivacy(TLUpdatePrivacy update) {
        this.onTLUpdatePrivacyCustom(update);
    }

    private void onTLUpdateReadChannelInbox(TLUpdateReadChannelInbox update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChannelId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateReadChannelInboxCustom(update);
        }
    }

    private void onTLUpdateReadMessagesContents(TLUpdateReadMessagesContents update) {
        this.onTLUpdateReadMessagesContentsCustom(update);
    }

    private void onTLUpdateReadMessagesInbox(TLUpdateReadMessagesInbox update, boolean gettingDifferences) {
        if (this.isPeerMissing(update.getPeer())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateReadMessagesInboxCustom(update);
        }
    }

    private void onTLUpdateReadMessagesOutbox(TLUpdateReadMessagesOutbox update, boolean gettingDifferences) {
        if (this.isPeerMissing(update.getPeer())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateReadMessagesOutboxCustom(update);
        }
    }

    private void onTLUpdateSavedGifs(TLUpdateSavedGifs update) {
        this.onTLUpdateSavedGifsCustom(update);
    }

    private void onTLUpdateServiceNotification(TLUpdateServiceNotification update) {
        this.onTLUpdateServiceNotificationCustom(update);
    }

    private void onTLUpdateStickerSets(TLUpdateStickerSets update) {
        this.onTLUpdateStickerSetsCustom(update);
    }

    private void onTLUpdateStickerSetsOrder(TLUpdateStickerSetsOrder update) {
        this.onTLUpdateStickerSetsOrderCustom(update);
    }

    private void onTLUpdateUserBlocked(TLUpdateUserBlocked update, boolean gettingDifferences) {
        if (this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateUserBlockedCustom(update);
        }
    }

    private void onTLUpdateUserName(TLUpdateUserName update, boolean gettingDifferences) {
        if (this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateUserNameCustom(update);
        }
    }

    private void onTLUpdateUserPhone(TLUpdateUserPhone update, boolean gettingDifferences) {
        if (this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateUserPhoneCustom(update);
        }
    }

    private void onTLUpdateUserPhoto(TLUpdateUserPhoto update, boolean gettingDifferences) {
        if (this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateUserPhotoCustom(update);
        }
    }

    private void onTLUpdateUserStatus(TLUpdateUserStatus update, boolean gettingDifferences) {
        if (this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateUserStatusCustom(update);
        }
    }

    private void onTLUpdateUserTyping(TLUpdateUserTyping update, boolean gettingDifferences) {
        if (this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateUserTypingCustom(update);
        }
    }

    private void onTLUpdateWebPage(TLUpdateWebPage update) {
        this.onTLUpdateWebPageCustom(update);
    }

    private void onTLUpdateBotCallbackQuery(TLUpdateBotCallbackQuery update, boolean gettingDifferences) {
        if (this.isUserMissing(update.getUserId()) || this.isPeerMissing(update.getPeer())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateBotCallbackQueryCustom(update);
        }
    }

    private void onTLUpdateEditMessage(TLUpdateEditMessage update, boolean gettingDifferences) {
        if (this.isUserFromMessageMissing(update.getMessage())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateEditMessageCustom(update);
        }
    }

    private void onTLUpdateInlineBotCallbackQuery(TLUpdateInlineBotCallbackQuery update, boolean gettingDifferences) {
        if (this.isUserMissing(update.getUserId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateInlineBotCallbackQueryCustom(update);
        }
    }

    private void onTLUpdateEncryption(TLUpdateEncryption update) {
        this.onTLUpdateEncryptionCustom(update);
    }

    private void onTLUpdateEncryptedChatTyping(TLUpdateEncryptedChatTyping update) {
        this.onTLUpdateEncryptedChatTypingCustom(update);
    }

    private void onTLUpdateEncryptedMessagesRead(TLUpdateEncryptedMessagesRead update) {
        this.onTLUpdateEncryptedMessagesReadCustom(update);
    }

    private void onTLUpdateNewEncryptedMessage(TLUpdateNewEncryptedMessage update) {
        this.onTLUpdateNewEncryptedMessageCustom(update);
    }

    private void onTLUpdateConfig(TLUpdateConfig update) {
        this.onTLUpdateConfigCustom(update);
    }

    private void onTLUpdateDraftMessage(TLUpdateDraftMessage update, boolean gettingDifferences) {
        if (this.isPeerMissing(update.getPeer())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateDraftMessageCustom(update);
        }
    }

    private void onTLUpdatePtsChanged(TLUpdatePtsChanged update) {
        this.onTLUpdatePtsChangedCustom(update);
    }

    private void onTLUpdateReadChannelOutbox(TLUpdateReadChannelOutbox update, boolean gettingDifferences) {
        if (this.isChatMissing(update.getChannelId())) {
            if (!gettingDifferences) {
                this.differencesHandler.getDifferences();
            }
        } else {
            this.onTLUpdateReadChannelOutboxCustom(update);
        }
    }

    private void onTLUpdateReadFeaturedStickers(TLUpdateReadFeaturedStickers update) {
        this.onTLUpdateReadFeaturedStickersCustom(update);
    }

    private void onTLUpdateRecentStickers(TLUpdateRecentStickers update) {
        this.onTLUpdateRecentStickersCustom(update);
    }

    @Override
    public final void updateStateModification(TLUpdatesState state) {
        this.differencesHandler.updateStateModification(state, false);
    }

    @Override
    public final void onTLUpdatesTooLong() {
        this.differencesHandler.getDifferences();
    }

    private void onTLFakeUpdate(TLFakeUpdate update) {
        this.onTLFakeUpdateCustom(update);
    }

    @Override
    public final void onTLAbsDifference(@NotNull TLAbsDifference absDifference) {
        this.onUsers(absDifference.getUsers());
        this.onChats(absDifference.getChats());
        absDifference.getNewMessages().stream().forEach(this::onTLAbsMessageCustom);
        absDifference.getOtherUpdates().stream().map(x -> {
            UpdateWrapper updateWrapper = new UpdateWrapper((TLObject)x);
            updateWrapper.disablePtsCheck();
            updateWrapper.disableUpdatePts();
            updateWrapper.enableGettingDifferences();
            return updateWrapper;
        }).forEach(this::processUpdate);
    }

    @Override
    public final void onTLChannelDifferences(List<TLAbsUser> users, List<TLAbsMessage> messages, List<TLAbsUpdate> newUpdates, List<TLAbsChat> chats) {
        this.onUsers(users);
        this.onChats(chats);
        messages.stream().forEach(this::onTLAbsMessageCustom);
        newUpdates.stream().map(x -> {
            UpdateWrapper updateWrapper = new UpdateWrapper((TLObject)x);
            updateWrapper.disablePtsCheck();
            updateWrapper.disableUpdatePts();
            return updateWrapper;
        }).forEach(this::processUpdate);
    }

    @Override
    public final void onUsers(List<TLAbsUser> users) {
        this.onUsersCustom(users);
    }

    @Override
    public final void onChats(List<TLAbsChat> chats) {
        this.onChatsCustom(chats);
    }

    private boolean isUserFromMessageMissing(TLAbsMessage message, boolean checkChatId) {
        boolean isMissing = true;
        if (message instanceof TLMessage) {
            TLMessage tlMessage = (TLMessage)message;
            boolean isFromMissing = true;
            if (tlMessage.hasFromId()) {
                isFromMissing = this.isUserMissing(tlMessage.getFromId());
            }
            boolean isToMissing = true;
            if (tlMessage.getToId() instanceof TLPeerUser) {
                isToMissing = this.isUserMissing(tlMessage.getToId().getId());
            } else if (checkChatId) {
                isToMissing = this.isChatMissing(tlMessage.getChatId());
            }
            boolean isForwardedMissing = true;
            if (tlMessage.isForwarded()) {
                isForwardedMissing = this.isUserMissing(tlMessage.getFwdFrom().getFromId());
            }
            isMissing = isFromMissing && isToMissing && isForwardedMissing;
        } else if (message instanceof TLMessageService) {
            TLMessageService tlMessageService = (TLMessageService)message;
            boolean isFromMissing = true;
            if (tlMessageService.hasFromId()) {
                isFromMissing = this.isUserMissing(tlMessageService.getFromId());
            }
            boolean isToMissing = true;
            if (tlMessageService.getToId() instanceof TLPeerUser) {
                isToMissing = this.isUserMissing(tlMessageService.getToId().getId());
            } else if (checkChatId) {
                isToMissing = this.isChatMissing(tlMessageService.getChatId());
            }
            isMissing = isFromMissing && isToMissing;
        }
        return isMissing;
    }

    private boolean isUserFromMessageMissing(TLAbsMessage message) {
        return this.isUserFromMessageMissing(message, false);
    }

    private boolean isChatMissing(int chatId) {
        return this.databaseManager.getChatById(chatId) == null;
    }

    private boolean isUserMissing(int userId) {
        return this.databaseManager.getUserById(userId) == null;
    }

    private boolean isPeerMissing(TLAbsPeer peer) {
        boolean isMissing = peer instanceof TLPeerUser ? this.databaseManager.getUserById(peer.getId()) == null : this.databaseManager.getChatById(peer.getId()) == null;
        return isMissing;
    }

    private boolean isNotifyPeerMissing(TLAbsNotifyPeer notifyPeer) {
        boolean isMissing = false;
        if (notifyPeer instanceof TLNotifyPeer) {
            isMissing = this.isPeerMissing(((TLNotifyPeer)notifyPeer).getPeer());
        }
        return isMissing;
    }

    private boolean isUserFromShortMessageMissing(@NotNull TLUpdateShortMessage updateShortMessage) {
        return this.databaseManager.getUserById(updateShortMessage.getUserId()) == null || updateShortMessage.isForwarded() && this.databaseManager.getUserById(updateShortMessage.getFwdFrom().getFromId()) == null;
    }

    protected abstract void onTLUpdateChatParticipantsCustom(TLUpdateChatParticipants var1);

    protected abstract void onTLUpdateNewMessageCustom(TLUpdateNewMessage var1);

    protected abstract void onTLUpdateChannelNewMessageCustom(TLUpdateChannelNewMessage var1);

    protected abstract void onTLUpdateChannelCustom(TLUpdateChannel var1);

    protected abstract void onTLUpdateBotInlineQueryCustom(TLUpdateBotInlineQuery var1);

    protected abstract void onTLUpdateBotInlineSendCustom(TLUpdateBotInlineSend var1);

    protected abstract void onTLUpdateChannelMessageViewsCustom(TLUpdateChannelMessageViews var1);

    protected abstract void onTLUpdateChannelPinnedMessageCustom(TLUpdateChannelPinnedMessage var1);

    protected abstract void onTLUpdateChatAdminCustom(TLUpdateChatAdmin var1);

    protected abstract void onTLUpdateChatParticipantAddCustom(TLUpdateChatParticipantAdd var1);

    protected abstract void onTLUpdateChatParticipantAdminCustom(TLUpdateChatParticipantAdmin var1);

    protected abstract void onTLUpdateChatParticipantDeleteCustom(TLUpdateChatParticipantDelete var1);

    protected abstract void onTLUpdateChatUserTypingCustom(TLUpdateChatUserTyping var1);

    protected abstract void onTLUpdateContactLinkCustom(TLUpdateContactLink var1);

    protected abstract void onTLUpdateContactRegisteredCustom(TLUpdateContactRegistered var1);

    protected abstract void onTLUpdateDcOptionsCustom(TLUpdateDcOptions var1);

    protected abstract void onTLUpdateDeleteChannelMessagesCustom(TLUpdateDeleteChannelMessages var1);

    protected abstract void onTLUpdateDeleteMessagesCustom(TLUpdateDeleteMessages var1);

    protected abstract void onTLUpdateEditChannelMessageCustom(TLUpdateEditChannelMessage var1);

    protected abstract void onTLUpdateMessageIdCustom(TLUpdateMessageId var1);

    protected abstract void onTLUpdateNewAuthorizationCustom(TLUpdateNewAuthorization var1);

    protected abstract void onTLUpdateNewStickerSetCustom(TLUpdateNewStickerSet var1);

    protected abstract void onTLUpdateNotifySettingsCustom(TLUpdateNotifySettings var1);

    protected abstract void onTLUpdatePrivacyCustom(TLUpdatePrivacy var1);

    protected abstract void onTLUpdateReadChannelInboxCustom(TLUpdateReadChannelInbox var1);

    protected abstract void onTLUpdateReadMessagesContentsCustom(TLUpdateReadMessagesContents var1);

    protected abstract void onTLUpdateReadMessagesInboxCustom(TLUpdateReadMessagesInbox var1);

    protected abstract void onTLUpdateReadMessagesOutboxCustom(TLUpdateReadMessagesOutbox var1);

    protected abstract void onTLUpdateSavedGifsCustom(TLUpdateSavedGifs var1);

    protected abstract void onTLUpdateServiceNotificationCustom(TLUpdateServiceNotification var1);

    protected abstract void onTLUpdateStickerSetsCustom(TLUpdateStickerSets var1);

    protected abstract void onTLUpdateStickerSetsOrderCustom(TLUpdateStickerSetsOrder var1);

    protected abstract void onTLUpdateUserBlockedCustom(TLUpdateUserBlocked var1);

    protected abstract void onTLUpdateUserNameCustom(TLUpdateUserName var1);

    protected abstract void onTLUpdateUserPhoneCustom(TLUpdateUserPhone var1);

    protected abstract void onTLUpdateUserPhotoCustom(TLUpdateUserPhoto var1);

    protected abstract void onTLUpdateUserStatusCustom(TLUpdateUserStatus var1);

    protected abstract void onTLUpdateUserTypingCustom(TLUpdateUserTyping var1);

    protected abstract void onTLUpdateWebPageCustom(TLUpdateWebPage var1);

    protected abstract void onTLFakeUpdateCustom(TLFakeUpdate var1);

    protected abstract void onTLUpdateShortMessageCustom(TLUpdateShortMessage var1);

    protected abstract void onTLUpdateShortChatMessageCustom(TLUpdateShortChatMessage var1);

    protected abstract void onTLUpdateShortSentMessageCustom(TLUpdateShortSentMessage var1);

    protected abstract void onTLUpdateBotCallbackQueryCustom(TLUpdateBotCallbackQuery var1);

    protected abstract void onTLUpdateEditMessageCustom(TLUpdateEditMessage var1);

    protected abstract void onTLUpdateInlineBotCallbackQueryCustom(TLUpdateInlineBotCallbackQuery var1);

    protected abstract void onTLAbsMessageCustom(TLAbsMessage var1);

    protected abstract void onUsersCustom(List<TLAbsUser> var1);

    protected abstract void onChatsCustom(List<TLAbsChat> var1);

    protected abstract void onTLUpdateEncryptionCustom(TLUpdateEncryption var1);

    protected abstract void onTLUpdateEncryptedMessagesReadCustom(TLUpdateEncryptedMessagesRead var1);

    protected abstract void onTLUpdateNewEncryptedMessageCustom(TLUpdateNewEncryptedMessage var1);

    protected abstract void onTLUpdateEncryptedChatTypingCustom(TLUpdateEncryptedChatTyping var1);

    protected abstract void onTLUpdateConfigCustom(TLUpdateConfig var1);

    protected abstract void onTLUpdateDraftMessageCustom(TLUpdateDraftMessage var1);

    protected abstract void onTLUpdatePtsChangedCustom(TLUpdatePtsChanged var1);

    protected abstract void onTLUpdateReadChannelOutboxCustom(TLUpdateReadChannelOutbox var1);

    protected abstract void onTLUpdateReadFeaturedStickersCustom(TLUpdateReadFeaturedStickers var1);

    protected abstract void onTLUpdateRecentStickersCustom(TLUpdateRecentStickers var1);
}

