package org.telegram.api;

import org.telegram.api.account.TLAccountAuthorizations;
import org.telegram.api.account.TLAccountDaysTTL;
import org.telegram.api.account.TLAccountNoPassword;
import org.telegram.api.account.TLAccountPassword;
import org.telegram.api.account.TLAccountPasswordInputSettings;
import org.telegram.api.account.TLAccountPasswordSettings;
import org.telegram.api.account.TLAccountPrivacyRules;
import org.telegram.api.auth.TLCheckedPhone;
import org.telegram.api.auth.TLExportedAuthorization;
import org.telegram.api.auth.TLPasswordRecovery;
import org.telegram.api.auth.TLSentCode;
import org.telegram.api.auth.codetype.TLCodeTypeCall;
import org.telegram.api.auth.codetype.TLCodeTypeFlashCall;
import org.telegram.api.auth.codetype.TLCodeTypeSms;
import org.telegram.api.auth.sentcodetype.TLSentCodeTypeApp;
import org.telegram.api.auth.sentcodetype.TLSentCodeTypeCall;
import org.telegram.api.auth.sentcodetype.TLSentCodeTypeFlashCall;
import org.telegram.api.auth.sentcodetype.TLSentCodeTypeSms;
import org.telegram.api.bot.TLBotCommand;
import org.telegram.api.bot.TLBotInfo;
import org.telegram.api.bot.TLInlineBotSwitchPm;
import org.telegram.api.bot.inlinemessage.TLBotInlineMessageMediaAuto;
import org.telegram.api.bot.inlinemessage.TLBotInlineMessageMediaContact;
import org.telegram.api.bot.inlinemessage.TLBotInlineMessageMediaGeo;
import org.telegram.api.bot.inlinemessage.TLBotInlineMessageMediaVenue;
import org.telegram.api.bot.inlinemessage.TLBotInlineMessageText;
import org.telegram.api.bot.inlineresult.TLBotInlineMediaResult;
import org.telegram.api.bot.inlineresult.TLBotInlineResult;
import org.telegram.api.channel.TLChannelParticipants;
import org.telegram.api.channel.filters.TLChannelMessagesFilter;
import org.telegram.api.channel.filters.TLChannelMessagesFilterEmpty;
import org.telegram.api.channel.participants.TLChannelParticipant;
import org.telegram.api.channel.participants.TLChannelParticipantCreator;
import org.telegram.api.channel.participants.TLChannelParticipantEditor;
import org.telegram.api.channel.participants.TLChannelParticipantKicked;
import org.telegram.api.channel.participants.TLChannelParticipantModerator;
import org.telegram.api.channel.participants.TLChannelParticipantSelf;
import org.telegram.api.channel.participants.filters.TLChannelParticipantsFilterAdmins;
import org.telegram.api.channel.participants.filters.TLChannelParticipantsFilterBots;
import org.telegram.api.channel.participants.filters.TLChannelParticipantsFilterKicked;
import org.telegram.api.channel.participants.filters.TLChannelParticipantsFilterRecent;
import org.telegram.api.channel.participants.role.TLChannelParticipantRoleEditor;
import org.telegram.api.channel.participants.role.TLChannelParticipantRoleEmpty;
import org.telegram.api.channel.participants.role.TLChannelParticipantRoleModerator;
import org.telegram.api.chat.TLChat;
import org.telegram.api.chat.TLChatEmpty;
import org.telegram.api.chat.TLChatForbidden;
import org.telegram.api.chat.TLChatFull;
import org.telegram.api.chat.channel.TLChannel;
import org.telegram.api.chat.channel.TLChannelForbidden;
import org.telegram.api.chat.channel.TLChannelFull;
import org.telegram.api.chat.invite.TLChatInvite;
import org.telegram.api.chat.invite.TLChatInviteAlready;
import org.telegram.api.chat.invite.TLChatInviteEmpty;
import org.telegram.api.chat.invite.TLChatInviteExported;
import org.telegram.api.chat.participant.chatparticipant.TLChatParticipant;
import org.telegram.api.chat.participant.chatparticipant.TLChatParticipantAdmin;
import org.telegram.api.chat.participant.chatparticipant.TLChatParticipantCreator;
import org.telegram.api.chat.participant.chatparticipants.TLChatParticipants;
import org.telegram.api.chat.participant.chatparticipants.TLChatParticipantsForbidden;
import org.telegram.api.chat.photo.TLChatPhoto;
import org.telegram.api.chat.photo.TLChatPhotoEmpty;
import org.telegram.api.contact.TLContact;
import org.telegram.api.contact.TLContactBlocked;
import org.telegram.api.contact.TLContactStatus;
import org.telegram.api.contact.TLImportedContact;
import org.telegram.api.contact.link.TLContactLinkContact;
import org.telegram.api.contact.link.TLContactLinkHasPhone;
import org.telegram.api.contact.link.TLContactLinkNone;
import org.telegram.api.contact.link.TLContactLinkUnknown;
import org.telegram.api.contacts.TLContacts;
import org.telegram.api.contacts.TLContactsFound;
import org.telegram.api.contacts.TLContactsLink;
import org.telegram.api.contacts.TLContactsNotModified;
import org.telegram.api.contacts.TLImportedContacts;
import org.telegram.api.contacts.TLResolvedPeer;
import org.telegram.api.contacts.blocked.TLBlocked;
import org.telegram.api.contacts.blocked.TLBlockedSlice;
import org.telegram.api.contacts.toppeers.TLContactsTopPeers;
import org.telegram.api.contacts.toppeers.TLContactsTopPeersNotModified;
import org.telegram.api.decryptedmessage.TLDecryptedMessage;
import org.telegram.api.decryptedmessage.TLDecryptedMessageActionAbortKey;
import org.telegram.api.decryptedmessage.TLDecryptedMessageActionAcceptKey;
import org.telegram.api.decryptedmessage.TLDecryptedMessageActionCommitKey;
import org.telegram.api.decryptedmessage.TLDecryptedMessageActionFlushHistory;
import org.telegram.api.decryptedmessage.TLDecryptedMessageActionNoop;
import org.telegram.api.decryptedmessage.TLDecryptedMessageActionNotifyLayer;
import org.telegram.api.decryptedmessage.TLDecryptedMessageActionReadMessages;
import org.telegram.api.decryptedmessage.TLDecryptedMessageActionRequestKey;
import org.telegram.api.decryptedmessage.TLDecryptedMessageActionResend;
import org.telegram.api.decryptedmessage.TLDecryptedMessageActionSetMessageTTL;
import org.telegram.api.decryptedmessage.TLDecryptedMessageLayer;
import org.telegram.api.decryptedmessage.TLDecryptedMessageMediaAudio;
import org.telegram.api.decryptedmessage.TLDecryptedMessageMediaContact;
import org.telegram.api.decryptedmessage.TLDecryptedMessageMediaDocument;
import org.telegram.api.decryptedmessage.TLDecryptedMessageMediaEmpty;
import org.telegram.api.decryptedmessage.TLDecryptedMessageMediaExternalDocument;
import org.telegram.api.decryptedmessage.TLDecryptedMessageMediaGeoPoint;
import org.telegram.api.decryptedmessage.TLDecryptedMessageMediaPhoto;
import org.telegram.api.decryptedmessage.TLDecryptedMessageMediaVideo;
import org.telegram.api.decryptedmessage.TLDecryptedMessageService;
import org.telegram.api.dialog.TLDialog;
import org.telegram.api.disablefeature.TLDisabledFeature;
import org.telegram.api.document.TLDocument;
import org.telegram.api.document.TLDocumentEmpty;
import org.telegram.api.document.attribute.TLDocumentAttributeAnimated;
import org.telegram.api.document.attribute.TLDocumentAttributeAudio;
import org.telegram.api.document.attribute.TLDocumentAttributeFilename;
import org.telegram.api.document.attribute.TLDocumentAttributeHasStickers;
import org.telegram.api.document.attribute.TLDocumentAttributeImageSize;
import org.telegram.api.document.attribute.TLDocumentAttributeSticker;
import org.telegram.api.document.attribute.TLDocumentAttributeVideo;
import org.telegram.api.draft.TLDraftMessage;
import org.telegram.api.draft.TLDraftMessageEmpty;
import org.telegram.api.encrypted.chat.TLEncryptedChat;
import org.telegram.api.encrypted.chat.TLEncryptedChatDiscarded;
import org.telegram.api.encrypted.chat.TLEncryptedChatEmpty;
import org.telegram.api.encrypted.chat.TLEncryptedChatRequested;
import org.telegram.api.encrypted.chat.TLEncryptedChatWaiting;
import org.telegram.api.encrypted.file.TLEncryptedFile;
import org.telegram.api.encrypted.file.TLEncryptedFileEmpty;
import org.telegram.api.encrypted.message.TLEncryptedMessage;
import org.telegram.api.encrypted.message.TLEncryptedMessageService;
import org.telegram.api.file.location.TLFileLocation;
import org.telegram.api.file.location.TLFileLocationUnavailable;
import org.telegram.api.foundgif.TLFoundGif;
import org.telegram.api.foundgif.TLFoundGifCached;
import org.telegram.api.functions.TLRequestInitConnection;
import org.telegram.api.functions.TLRequestInvokeAfterMsg;
import org.telegram.api.functions.TLRequestInvokeAfterMsgs;
import org.telegram.api.functions.TLRequestInvokeWithLayer;
import org.telegram.api.functions.TLRequestInvokeWithoutUpdates;
import org.telegram.api.functions.account.TLRequestAccountChangePhone;
import org.telegram.api.functions.account.TLRequestAccountCheckUsername;
import org.telegram.api.functions.account.TLRequestAccountConfirmPhone;
import org.telegram.api.functions.account.TLRequestAccountDeleteAccount;
import org.telegram.api.functions.account.TLRequestAccountGetAccountTTL;
import org.telegram.api.functions.account.TLRequestAccountGetAuthorizations;
import org.telegram.api.functions.account.TLRequestAccountGetNotifySettings;
import org.telegram.api.functions.account.TLRequestAccountGetPassword;
import org.telegram.api.functions.account.TLRequestAccountGetPasswordSettings;
import org.telegram.api.functions.account.TLRequestAccountGetPrivacy;
import org.telegram.api.functions.account.TLRequestAccountGetWallPapers;
import org.telegram.api.functions.account.TLRequestAccountRegisterDevice;
import org.telegram.api.functions.account.TLRequestAccountReportPeer;
import org.telegram.api.functions.account.TLRequestAccountResetAuthorization;
import org.telegram.api.functions.account.TLRequestAccountResetNotifySettings;
import org.telegram.api.functions.account.TLRequestAccountSendChangePhoneCode;
import org.telegram.api.functions.account.TLRequestAccountSendConfirmPhoneCode;
import org.telegram.api.functions.account.TLRequestAccountSetAccountTTL;
import org.telegram.api.functions.account.TLRequestAccountSetPrivacy;
import org.telegram.api.functions.account.TLRequestAccountUnregisterDevice;
import org.telegram.api.functions.account.TLRequestAccountUpdateDeviceLocked;
import org.telegram.api.functions.account.TLRequestAccountUpdateNotifySettings;
import org.telegram.api.functions.account.TLRequestAccountUpdatePasswordSettings;
import org.telegram.api.functions.account.TLRequestAccountUpdateProfile;
import org.telegram.api.functions.account.TLRequestAccountUpdateStatus;
import org.telegram.api.functions.account.TLRequestAccountUpdateUsername;
import org.telegram.api.functions.auth.TLRequestAuthBindTempAuthKey;
import org.telegram.api.functions.auth.TLRequestAuthCancelCode;
import org.telegram.api.functions.auth.TLRequestAuthCheckPassword;
import org.telegram.api.functions.auth.TLRequestAuthCheckPhone;
import org.telegram.api.functions.auth.TLRequestAuthDropTempAuthKeys;
import org.telegram.api.functions.auth.TLRequestAuthExportAuthorization;
import org.telegram.api.functions.auth.TLRequestAuthImportAuthorization;
import org.telegram.api.functions.auth.TLRequestAuthImportBotAuthorization;
import org.telegram.api.functions.auth.TLRequestAuthLogOut;
import org.telegram.api.functions.auth.TLRequestAuthRecoverPassword;
import org.telegram.api.functions.auth.TLRequestAuthRequestPasswordRecovery;
import org.telegram.api.functions.auth.TLRequestAuthResendCode;
import org.telegram.api.functions.auth.TLRequestAuthResetAuthorizations;
import org.telegram.api.functions.auth.TLRequestAuthSendCode;
import org.telegram.api.functions.auth.TLRequestAuthSendInvites;
import org.telegram.api.functions.auth.TLRequestAuthSignIn;
import org.telegram.api.functions.auth.TLRequestAuthSignUp;
import org.telegram.api.functions.channels.TLRequestChannelsCheckUsername;
import org.telegram.api.functions.channels.TLRequestChannelsCreateChannel;
import org.telegram.api.functions.channels.TLRequestChannelsDeleteChannel;
import org.telegram.api.functions.channels.TLRequestChannelsDeleteMessages;
import org.telegram.api.functions.channels.TLRequestChannelsDeleteUserHistory;
import org.telegram.api.functions.channels.TLRequestChannelsEditAbout;
import org.telegram.api.functions.channels.TLRequestChannelsEditAdmin;
import org.telegram.api.functions.channels.TLRequestChannelsEditPhoto;
import org.telegram.api.functions.channels.TLRequestChannelsEditTitle;
import org.telegram.api.functions.channels.TLRequestChannelsExportInvite;
import org.telegram.api.functions.channels.TLRequestChannelsExportMessageLink;
import org.telegram.api.functions.channels.TLRequestChannelsGetAdminedPublicChannels;
import org.telegram.api.functions.channels.TLRequestChannelsGetChannels;
import org.telegram.api.functions.channels.TLRequestChannelsGetFullChannel;
import org.telegram.api.functions.channels.TLRequestChannelsGetMessages;
import org.telegram.api.functions.channels.TLRequestChannelsGetParticipant;
import org.telegram.api.functions.channels.TLRequestChannelsGetParticipants;
import org.telegram.api.functions.channels.TLRequestChannelsInviteToChannel;
import org.telegram.api.functions.channels.TLRequestChannelsJoinChannel;
import org.telegram.api.functions.channels.TLRequestChannelsKickFromChannel;
import org.telegram.api.functions.channels.TLRequestChannelsLeaveChannel;
import org.telegram.api.functions.channels.TLRequestChannelsReadHistory;
import org.telegram.api.functions.channels.TLRequestChannelsReportSpam;
import org.telegram.api.functions.channels.TLRequestChannelsToggleInvites;
import org.telegram.api.functions.channels.TLRequestChannelsToggleSignatures;
import org.telegram.api.functions.channels.TLRequestChannelsUpdatePinnedMessage;
import org.telegram.api.functions.channels.TLRequestChannelsUpdateUsername;
import org.telegram.api.functions.contacts.TLRequestContactsBlock;
import org.telegram.api.functions.contacts.TLRequestContactsDeleteContact;
import org.telegram.api.functions.contacts.TLRequestContactsDeleteContacts;
import org.telegram.api.functions.contacts.TLRequestContactsExportCard;
import org.telegram.api.functions.contacts.TLRequestContactsGetBlocked;
import org.telegram.api.functions.contacts.TLRequestContactsGetContacts;
import org.telegram.api.functions.contacts.TLRequestContactsGetStatuses;
import org.telegram.api.functions.contacts.TLRequestContactsGetTopPeers;
import org.telegram.api.functions.contacts.TLRequestContactsImportCard;
import org.telegram.api.functions.contacts.TLRequestContactsImportContacts;
import org.telegram.api.functions.contacts.TLRequestContactsResetTopPeerRating;
import org.telegram.api.functions.contacts.TLRequestContactsResolveUsername;
import org.telegram.api.functions.contacts.TLRequestContactsSearch;
import org.telegram.api.functions.contacts.TLRequestContactsUnblock;
import org.telegram.api.functions.help.TLRequestHelpGetAppChangelog;
import org.telegram.api.functions.help.TLRequestHelpGetAppUpdate;
import org.telegram.api.functions.help.TLRequestHelpGetConfig;
import org.telegram.api.functions.help.TLRequestHelpGetInviteText;
import org.telegram.api.functions.help.TLRequestHelpGetNearestDc;
import org.telegram.api.functions.help.TLRequestHelpGetSupport;
import org.telegram.api.functions.help.TLRequestHelpGetTermsOfService;
import org.telegram.api.functions.help.TLRequestHelpSaveAppLog;
import org.telegram.api.functions.messages.TLRequestMessagesAcceptEncryption;
import org.telegram.api.functions.messages.TLRequestMessagesAddChatUser;
import org.telegram.api.functions.messages.TLRequestMessagesCheckChatInvite;
import org.telegram.api.functions.messages.TLRequestMessagesClearRecentStickers;
import org.telegram.api.functions.messages.TLRequestMessagesCreateChat;
import org.telegram.api.functions.messages.TLRequestMessagesDeleteChatUser;
import org.telegram.api.functions.messages.TLRequestMessagesDeleteHistory;
import org.telegram.api.functions.messages.TLRequestMessagesDeleteMessages;
import org.telegram.api.functions.messages.TLRequestMessagesDiscardEncryption;
import org.telegram.api.functions.messages.TLRequestMessagesEditChatAdmin;
import org.telegram.api.functions.messages.TLRequestMessagesEditChatPhoto;
import org.telegram.api.functions.messages.TLRequestMessagesEditChatTitle;
import org.telegram.api.functions.messages.TLRequestMessagesEditInlineBotMessage;
import org.telegram.api.functions.messages.TLRequestMessagesEditMessage;
import org.telegram.api.functions.messages.TLRequestMessagesExportChatInvite;
import org.telegram.api.functions.messages.TLRequestMessagesForwardMessage;
import org.telegram.api.functions.messages.TLRequestMessagesForwardMessages;
import org.telegram.api.functions.messages.TLRequestMessagesGetAllDrafts;
import org.telegram.api.functions.messages.TLRequestMessagesGetAllStickers;
import org.telegram.api.functions.messages.TLRequestMessagesGetArchivedStickers;
import org.telegram.api.functions.messages.TLRequestMessagesGetAttachedStickers;
import org.telegram.api.functions.messages.TLRequestMessagesGetBotCallbackAnswer;
import org.telegram.api.functions.messages.TLRequestMessagesGetChats;
import org.telegram.api.functions.messages.TLRequestMessagesGetDhConfig;
import org.telegram.api.functions.messages.TLRequestMessagesGetDialogs;
import org.telegram.api.functions.messages.TLRequestMessagesGetDocumentByHash;
import org.telegram.api.functions.messages.TLRequestMessagesGetFeaturedStickers;
import org.telegram.api.functions.messages.TLRequestMessagesGetFullChat;
import org.telegram.api.functions.messages.TLRequestMessagesGetGameHighScores;
import org.telegram.api.functions.messages.TLRequestMessagesGetHistory;
import org.telegram.api.functions.messages.TLRequestMessagesGetInlineBotResults;
import org.telegram.api.functions.messages.TLRequestMessagesGetInlineGameHighScores;
import org.telegram.api.functions.messages.TLRequestMessagesGetMaskStickers;
import org.telegram.api.functions.messages.TLRequestMessagesGetMessageEditData;
import org.telegram.api.functions.messages.TLRequestMessagesGetMessages;
import org.telegram.api.functions.messages.TLRequestMessagesGetMessagesViews;
import org.telegram.api.functions.messages.TLRequestMessagesGetPeerDialogs;
import org.telegram.api.functions.messages.TLRequestMessagesGetPeerSettings;
import org.telegram.api.functions.messages.TLRequestMessagesGetRecentStickers;
import org.telegram.api.functions.messages.TLRequestMessagesGetSavedGifs;
import org.telegram.api.functions.messages.TLRequestMessagesGetStickersSet;
import org.telegram.api.functions.messages.TLRequestMessagesGetWebPagePreview;
import org.telegram.api.functions.messages.TLRequestMessagesHideReportSpam;
import org.telegram.api.functions.messages.TLRequestMessagesImportChatInvite;
import org.telegram.api.functions.messages.TLRequestMessagesInstallStickersSet;
import org.telegram.api.functions.messages.TLRequestMessagesMigrateChat;
import org.telegram.api.functions.messages.TLRequestMessagesReadContents;
import org.telegram.api.functions.messages.TLRequestMessagesReadEncryptedHistory;
import org.telegram.api.functions.messages.TLRequestMessagesReadFeaturedStickers;
import org.telegram.api.functions.messages.TLRequestMessagesReadHistory;
import org.telegram.api.functions.messages.TLRequestMessagesReceivedMessages;
import org.telegram.api.functions.messages.TLRequestMessagesReceivedQueue;
import org.telegram.api.functions.messages.TLRequestMessagesReorderStickerSets;
import org.telegram.api.functions.messages.TLRequestMessagesReportSpam;
import org.telegram.api.functions.messages.TLRequestMessagesRequestEncryption;
import org.telegram.api.functions.messages.TLRequestMessagesSaveDraft;
import org.telegram.api.functions.messages.TLRequestMessagesSaveGif;
import org.telegram.api.functions.messages.TLRequestMessagesSaveRecentStickers;
import org.telegram.api.functions.messages.TLRequestMessagesSearch;
import org.telegram.api.functions.messages.TLRequestMessagesSearchGifs;
import org.telegram.api.functions.messages.TLRequestMessagesSearchGlobal;
import org.telegram.api.functions.messages.TLRequestMessagesSendEncrypted;
import org.telegram.api.functions.messages.TLRequestMessagesSendEncryptedFile;
import org.telegram.api.functions.messages.TLRequestMessagesSendEncryptedService;
import org.telegram.api.functions.messages.TLRequestMessagesSendInlineBotResults;
import org.telegram.api.functions.messages.TLRequestMessagesSendMedia;
import org.telegram.api.functions.messages.TLRequestMessagesSendMessage;
import org.telegram.api.functions.messages.TLRequestMessagesSetBotCallbackAnswer;
import org.telegram.api.functions.messages.TLRequestMessagesSetEncryptedTyping;
import org.telegram.api.functions.messages.TLRequestMessagesSetGameScore;
import org.telegram.api.functions.messages.TLRequestMessagesSetInlineBotResults;
import org.telegram.api.functions.messages.TLRequestMessagesSetInlineGameScore;
import org.telegram.api.functions.messages.TLRequestMessagesSetTyping;
import org.telegram.api.functions.messages.TLRequestMessagesStartBot;
import org.telegram.api.functions.messages.TLRequestMessagesToggleChatAdmins;
import org.telegram.api.functions.messages.TLRequestMessagesUninstallStickersSet;
import org.telegram.api.functions.photos.TLRequestPhotosDeletePhotos;
import org.telegram.api.functions.photos.TLRequestPhotosGetUserPhotos;
import org.telegram.api.functions.photos.TLRequestPhotosUpdateProfilePhoto;
import org.telegram.api.functions.photos.TLRequestPhotosUploadProfilePhoto;
import org.telegram.api.functions.updates.TLRequestUpdatesGetChannelDifference;
import org.telegram.api.functions.updates.TLRequestUpdatesGetDifference;
import org.telegram.api.functions.updates.TLRequestUpdatesGetState;
import org.telegram.api.functions.upload.TLRequestUploadGetFile;
import org.telegram.api.functions.upload.TLRequestUploadSaveBigFilePart;
import org.telegram.api.functions.upload.TLRequestUploadSaveFilePart;
import org.telegram.api.functions.users.TLRequestUsersGetFullUser;
import org.telegram.api.functions.users.TLRequestUsersGetUsers;
import org.telegram.api.game.TLGame;
import org.telegram.api.geo.point.TLGeoPoint;
import org.telegram.api.geo.point.TLGeoPointEmpty;
import org.telegram.api.help.TLAppUpdate;
import org.telegram.api.help.TLInviteText;
import org.telegram.api.help.TLNoAppUpdate;
import org.telegram.api.help.TLSupport;
import org.telegram.api.help.TLTermsOfService;
import org.telegram.api.help.changelog.TLAppChangelog;
import org.telegram.api.help.changelog.TLAppChangelogEmpty;
import org.telegram.api.input.TLInputAppEvent;
import org.telegram.api.input.TLInputPhoneContact;
import org.telegram.api.input.bot.TLInputBotInlineMessageId;
import org.telegram.api.input.bot.inlinemessage.TLInputBotInlineMessageGame;
import org.telegram.api.input.bot.inlinemessage.TLInputBotInlineMessageMediaAuto;
import org.telegram.api.input.bot.inlinemessage.TLInputBotInlineMessageMediaContact;
import org.telegram.api.input.bot.inlinemessage.TLInputBotInlineMessageMediaGeo;
import org.telegram.api.input.bot.inlinemessage.TLInputBotInlineMessageMediaVenue;
import org.telegram.api.input.bot.inlinemessage.TLInputBotInlineMessageText;
import org.telegram.api.input.bot.inlineresult.TLInputBotInlineResult;
import org.telegram.api.input.bot.inlineresult.TLInputBotInlineResultDocument;
import org.telegram.api.input.bot.inlineresult.TLInputBotInlineResultGame;
import org.telegram.api.input.bot.inlineresult.TLInputBotInlineResultPhoto;
import org.telegram.api.input.chat.TLInputChannel;
import org.telegram.api.input.chat.TLInputChannelEmpty;
import org.telegram.api.input.chat.photo.TLInputChatPhoto;
import org.telegram.api.input.chat.photo.TLInputChatPhotoEmpty;
import org.telegram.api.input.chat.photo.TLInputChatUploadedPhoto;
import org.telegram.api.input.document.TLInputDocument;
import org.telegram.api.input.document.TLInputDocumentEmpty;
import org.telegram.api.input.encrypted.TLInputEncryptedChat;
import org.telegram.api.input.encrypted.file.TLInputEncryptedFile;
import org.telegram.api.input.encrypted.file.TLInputEncryptedFileBigUploaded;
import org.telegram.api.input.encrypted.file.TLInputEncryptedFileEmpty;
import org.telegram.api.input.encrypted.file.TLInputEncryptedFileUploaded;
import org.telegram.api.input.encrypted.file.location.TLInputEncryptedFileLocation;
import org.telegram.api.input.file.TLInputFile;
import org.telegram.api.input.file.TLInputFileBig;
import org.telegram.api.input.filelocation.TLInputDocumentFileLocation;
import org.telegram.api.input.filelocation.TLInputFileLocation;
import org.telegram.api.input.game.TLInputGameId;
import org.telegram.api.input.game.TLInputGameShortName;
import org.telegram.api.input.geopoint.TLInputGeoPoint;
import org.telegram.api.input.geopoint.TLInputGeoPointEmpty;
import org.telegram.api.input.media.TLInputMediaContact;
import org.telegram.api.input.media.TLInputMediaDocument;
import org.telegram.api.input.media.TLInputMediaDocumentExternal;
import org.telegram.api.input.media.TLInputMediaEmpty;
import org.telegram.api.input.media.TLInputMediaGame;
import org.telegram.api.input.media.TLInputMediaGeoPoint;
import org.telegram.api.input.media.TLInputMediaGifExternal;
import org.telegram.api.input.media.TLInputMediaPhoto;
import org.telegram.api.input.media.TLInputMediaPhotoExternal;
import org.telegram.api.input.media.TLInputMediaUploadedDocument;
import org.telegram.api.input.media.TLInputMediaUploadedPhoto;
import org.telegram.api.input.media.TLInputMediaUploadedThumbDocument;
import org.telegram.api.input.media.TLInputMediaVenue;
import org.telegram.api.input.messages.entity.TLInputMessageEntityMentionName;
import org.telegram.api.input.messages.filter.TLMessagesFilterChatPhoto;
import org.telegram.api.input.messages.filter.TLMessagesFilterDocument;
import org.telegram.api.input.messages.filter.TLMessagesFilterEmpty;
import org.telegram.api.input.messages.filter.TLMessagesFilterGif;
import org.telegram.api.input.messages.filter.TLMessagesFilterMusic;
import org.telegram.api.input.messages.filter.TLMessagesFilterPhotoVideo;
import org.telegram.api.input.messages.filter.TLMessagesFilterPhotoVideoDocuments;
import org.telegram.api.input.messages.filter.TLMessagesFilterPhotos;
import org.telegram.api.input.messages.filter.TLMessagesFilterUrl;
import org.telegram.api.input.messages.filter.TLMessagesFilterVideo;
import org.telegram.api.input.messages.filter.TLMessagesFilterVoice;
import org.telegram.api.input.notify.TLInputNotifyAll;
import org.telegram.api.input.notify.TLInputNotifyChats;
import org.telegram.api.input.notify.TLInputNotifyPeer;
import org.telegram.api.input.notify.TLInputNotifyUsers;
import org.telegram.api.input.peer.TLInputPeerChannel;
import org.telegram.api.input.peer.TLInputPeerChat;
import org.telegram.api.input.peer.TLInputPeerEmpty;
import org.telegram.api.input.peer.TLInputPeerSelf;
import org.telegram.api.input.peer.TLInputPeerUser;
import org.telegram.api.input.peer.notify.TLInputPeerNotifySettings;
import org.telegram.api.input.peer.notify.events.TLInputPeerNotifyEventsAll;
import org.telegram.api.input.peer.notify.events.TLInputPeerNotifyEventsEmpty;
import org.telegram.api.input.photo.TLInputPhoto;
import org.telegram.api.input.photo.TLInputPhotoEmpty;
import org.telegram.api.input.privacy.inputprivacykey.TLInputPrivacyKeyChatInvite;
import org.telegram.api.input.privacy.inputprivacykey.TLInputPrivacyKeyStatusTimestamp;
import org.telegram.api.input.privacy.inputprivacyrule.TLInputPrivacyValueAllowAll;
import org.telegram.api.input.privacy.inputprivacyrule.TLInputPrivacyValueAllowContacts;
import org.telegram.api.input.privacy.inputprivacyrule.TLInputPrivacyValueAllowUsers;
import org.telegram.api.input.privacy.inputprivacyrule.TLInputPrivacyValueDisallowAll;
import org.telegram.api.input.privacy.inputprivacyrule.TLInputPrivacyValueDisallowContacts;
import org.telegram.api.input.privacy.inputprivacyrule.TLInputPrivacyValueDisallowUsers;
import org.telegram.api.input.reportspamreason.TLReportSpamReasonOther;
import org.telegram.api.input.reportspamreason.TLReportSpamReasonPornography;
import org.telegram.api.input.reportspamreason.TLReportSpamReasonSpam;
import org.telegram.api.input.reportspamreason.TLReportSpamReasonViolence;
import org.telegram.api.input.sticker.media.TLInputStickeredMediaDocument;
import org.telegram.api.input.sticker.media.TLInputStickeredMediaPhoto;
import org.telegram.api.input.sticker.set.TLInputStickerSetEmpty;
import org.telegram.api.input.sticker.set.TLInputStickerSetId;
import org.telegram.api.input.sticker.set.TLInputStickerSetShortName;
import org.telegram.api.input.user.TLInputUser;
import org.telegram.api.input.user.TLInputUserEmpty;
import org.telegram.api.input.user.TLInputUserSelf;
import org.telegram.api.keyboard.TLKeyboardButtonRow;
import org.telegram.api.keyboard.button.TLKeyboardButton;
import org.telegram.api.keyboard.button.TLKeyboardButtonCallback;
import org.telegram.api.keyboard.button.TLKeyboardButtonGame;
import org.telegram.api.keyboard.button.TLKeyboardButtonRequestGeoLocation;
import org.telegram.api.keyboard.button.TLKeyboardButtonRequestPhone;
import org.telegram.api.keyboard.button.TLKeyboardButtonRequestSwitchInline;
import org.telegram.api.keyboard.button.TLKeyboardButtonUrl;
import org.telegram.api.keyboard.replymarkup.TLReplayInlineKeyboardMarkup;
import org.telegram.api.keyboard.replymarkup.TLReplayKeyboardForceReply;
import org.telegram.api.keyboard.replymarkup.TLReplayKeyboardHide;
import org.telegram.api.keyboard.replymarkup.TLReplayKeyboardMarkup;
import org.telegram.api.message.TLExportedMessageLink;
import org.telegram.api.message.TLMessage;
import org.telegram.api.message.TLMessageEmpty;
import org.telegram.api.message.TLMessageFwdHeader;
import org.telegram.api.message.TLMessageRange;
import org.telegram.api.message.TLMessageService;
import org.telegram.api.message.action.TLMessageActionChannelCreate;
import org.telegram.api.message.action.TLMessageActionChannelMigratedFrom;
import org.telegram.api.message.action.TLMessageActionChatAddUser;
import org.telegram.api.message.action.TLMessageActionChatCreate;
import org.telegram.api.message.action.TLMessageActionChatDeletePhoto;
import org.telegram.api.message.action.TLMessageActionChatDeleteUser;
import org.telegram.api.message.action.TLMessageActionChatEditPhoto;
import org.telegram.api.message.action.TLMessageActionChatEditTitle;
import org.telegram.api.message.action.TLMessageActionChatJoinedByLink;
import org.telegram.api.message.action.TLMessageActionEmpty;
import org.telegram.api.message.action.TLMessageActionGameScore;
import org.telegram.api.message.action.TLMessageActionHistoryClear;
import org.telegram.api.message.action.TLMessageActionMigrateTo;
import org.telegram.api.message.action.TLMessageActionPinMessage;
import org.telegram.api.message.entity.TLMessageEntityBold;
import org.telegram.api.message.entity.TLMessageEntityBotCommand;
import org.telegram.api.message.entity.TLMessageEntityCode;
import org.telegram.api.message.entity.TLMessageEntityEmail;
import org.telegram.api.message.entity.TLMessageEntityHashtag;
import org.telegram.api.message.entity.TLMessageEntityItalic;
import org.telegram.api.message.entity.TLMessageEntityMention;
import org.telegram.api.message.entity.TLMessageEntityMentionName;
import org.telegram.api.message.entity.TLMessageEntityPre;
import org.telegram.api.message.entity.TLMessageEntityTextUrl;
import org.telegram.api.message.entity.TLMessageEntityUnknown;
import org.telegram.api.message.entity.TLMessageEntityUrl;
import org.telegram.api.message.media.TLMessageMediaContact;
import org.telegram.api.message.media.TLMessageMediaDocument;
import org.telegram.api.message.media.TLMessageMediaEmpty;
import org.telegram.api.message.media.TLMessageMediaGame;
import org.telegram.api.message.media.TLMessageMediaGeo;
import org.telegram.api.message.media.TLMessageMediaPhoto;
import org.telegram.api.message.media.TLMessageMediaUnsupported;
import org.telegram.api.message.media.TLMessageMediaVenue;
import org.telegram.api.message.media.TLMessageMediaWebPage;
import org.telegram.api.messages.TLAffectedHistory;
import org.telegram.api.messages.TLAffectedMessages;
import org.telegram.api.messages.TLBotResults;
import org.telegram.api.messages.TLChannelMessages;
import org.telegram.api.messages.TLFoundGifs;
import org.telegram.api.messages.TLMessages;
import org.telegram.api.messages.TLMessagesArchivedStickers;
import org.telegram.api.messages.TLMessagesBotCallbackAnswer;
import org.telegram.api.messages.TLMessagesChatFull;
import org.telegram.api.messages.TLMessagesChats;
import org.telegram.api.messages.TLMessagesEditData;
import org.telegram.api.messages.TLMessagesHighScores;
import org.telegram.api.messages.TLMessagesPeerDialogs;
import org.telegram.api.messages.TLMessagesSlice;
import org.telegram.api.messages.dhconfig.TLDhConfig;
import org.telegram.api.messages.dhconfig.TLDhConfigNotModified;
import org.telegram.api.messages.dialogs.TLDialogs;
import org.telegram.api.messages.dialogs.TLDialogsSlice;
import org.telegram.api.messages.savedgifs.TLSavedGifs;
import org.telegram.api.messages.savedgifs.TLSavedGifsNotModified;
import org.telegram.api.messages.sentencrypted.TLSentEncryptedFile;
import org.telegram.api.messages.sentencrypted.TLSentEncryptedMessage;
import org.telegram.api.messages.stickers.TLAllStickers;
import org.telegram.api.messages.stickers.TLAllStickersNotModified;
import org.telegram.api.messages.stickers.TLMessagesStickerSet;
import org.telegram.api.messages.stickers.TLStickers;
import org.telegram.api.messages.stickers.TLStickersNotModified;
import org.telegram.api.messages.stickers.featured.TLMessagesFeaturedStickers;
import org.telegram.api.messages.stickers.featured.TLMessagesFeaturedStickersNotModified;
import org.telegram.api.messages.stickers.recent.TLMessagesRecentStickers;
import org.telegram.api.messages.stickers.recent.TLMessagesRecentStickersNotModified;
import org.telegram.api.messages.stickers.setintallresult.TLMessagesStickerSetInstallResultArchive;
import org.telegram.api.messages.stickers.setintallresult.TLMessagesStickerSetInstallResultSuccess;
import org.telegram.api.notify.peer.TLNotifyAll;
import org.telegram.api.notify.peer.TLNotifyChats;
import org.telegram.api.notify.peer.TLNotifyPeer;
import org.telegram.api.notify.peer.TLNotifyUsers;
import org.telegram.api.peer.TLPeerChannel;
import org.telegram.api.peer.TLPeerChat;
import org.telegram.api.peer.TLPeerSettings;
import org.telegram.api.peer.TLPeerUser;
import org.telegram.api.peer.notify.events.TLPeerNotifyEventsAll;
import org.telegram.api.peer.notify.events.TLPeerNotifyEventsEmpty;
import org.telegram.api.peer.notify.settings.TLPeerNotifySettings;
import org.telegram.api.peer.notify.settings.TLPeerNotifySettingsEmpty;
import org.telegram.api.photo.TLPhoto;
import org.telegram.api.photo.TLPhotoEmpty;
import org.telegram.api.photo.size.TLPhotoCachedSize;
import org.telegram.api.photo.size.TLPhotoSize;
import org.telegram.api.photo.size.TLPhotoSizeEmpty;
import org.telegram.api.photos.TLPhotos;
import org.telegram.api.photos.TLPhotosPhoto;
import org.telegram.api.photos.TLPhotosSlice;
import org.telegram.api.privacy.privacykey.TLPrivacyKeyChatInvite;
import org.telegram.api.privacy.privacykey.TLPrivacyKeyStatusTimestamp;
import org.telegram.api.privacy.privacyrule.TLPrivacyValueAllowAll;
import org.telegram.api.privacy.privacyrule.TLPrivacyValueAllowContacts;
import org.telegram.api.privacy.privacyrule.TLPrivacyValueAllowUsers;
import org.telegram.api.privacy.privacyrule.TLPrivacyValueDisallowAll;
import org.telegram.api.privacy.privacyrule.TLPrivacyValueDisallowContacts;
import org.telegram.api.privacy.privacyrule.TLPrivacyValueDisallowUsers;
import org.telegram.api.sendmessage.action.TLSendMessageCancelAction;
import org.telegram.api.sendmessage.action.TLSendMessageChooseContactAction;
import org.telegram.api.sendmessage.action.TLSendMessageGamePlayAction;
import org.telegram.api.sendmessage.action.TLSendMessageGeoLocationAction;
import org.telegram.api.sendmessage.action.TLSendMessageRecordAudioAction;
import org.telegram.api.sendmessage.action.TLSendMessageRecordVideoAction;
import org.telegram.api.sendmessage.action.TLSendMessageTypingAction;
import org.telegram.api.sendmessage.action.TLSendMessageUploadAudioAction;
import org.telegram.api.sendmessage.action.TLSendMessageUploadDocumentAction;
import org.telegram.api.sendmessage.action.TLSendMessageUploadPhotoAction;
import org.telegram.api.sendmessage.action.TLSendMessageUploadVideoAction;
import org.telegram.api.sticker.TLMaskCoords;
import org.telegram.api.sticker.pack.TLStickerPack;
import org.telegram.api.sticker.set.TLStickerSet;
import org.telegram.api.sticker.stickersetconvered.TLStickerSetCovered;
import org.telegram.api.sticker.stickersetconvered.TLStickerSetMultiCovered;
import org.telegram.api.storage.file.TLFileGif;
import org.telegram.api.storage.file.TLFileJpeg;
import org.telegram.api.storage.file.TLFileMov;
import org.telegram.api.storage.file.TLFileMp3;
import org.telegram.api.storage.file.TLFileMp4;
import org.telegram.api.storage.file.TLFilePartial;
import org.telegram.api.storage.file.TLFilePdf;
import org.telegram.api.storage.file.TLFilePng;
import org.telegram.api.storage.file.TLFileUnknown;
import org.telegram.api.storage.file.TLFileWebp;
import org.telegram.api.toppeer.TLTopPeer;
import org.telegram.api.toppeer.TLTopPeerCategoryPeers;
import org.telegram.api.toppeer.category.TLTopPeerCategoryBotsInline;
import org.telegram.api.toppeer.category.TLTopPeerCategoryBotsPM;
import org.telegram.api.toppeer.category.TLTopPeerCategoryChannels;
import org.telegram.api.toppeer.category.TLTopPeerCategoryCorrespondents;
import org.telegram.api.toppeer.category.TLTopPeerCategoryGroups;
import org.telegram.api.update.TLUpdateBotCallbackQuery;
import org.telegram.api.update.TLUpdateBotInlineQuery;
import org.telegram.api.update.TLUpdateBotInlineSend;
import org.telegram.api.update.TLUpdateChannel;
import org.telegram.api.update.TLUpdateChannelMessageViews;
import org.telegram.api.update.TLUpdateChannelNewMessage;
import org.telegram.api.update.TLUpdateChannelPinnedMessage;
import org.telegram.api.update.TLUpdateChannelTooLong;
import org.telegram.api.update.TLUpdateChatAdmin;
import org.telegram.api.update.TLUpdateChatParticipantAdd;
import org.telegram.api.update.TLUpdateChatParticipantAdmin;
import org.telegram.api.update.TLUpdateChatParticipantDelete;
import org.telegram.api.update.TLUpdateChatParticipants;
import org.telegram.api.update.TLUpdateChatUserTyping;
import org.telegram.api.update.TLUpdateConfig;
import org.telegram.api.update.TLUpdateContactLink;
import org.telegram.api.update.TLUpdateContactRegistered;
import org.telegram.api.update.TLUpdateDcOptions;
import org.telegram.api.update.TLUpdateDeleteChannelMessages;
import org.telegram.api.update.TLUpdateDeleteMessages;
import org.telegram.api.update.TLUpdateDraftMessage;
import org.telegram.api.update.TLUpdateEditChannelMessage;
import org.telegram.api.update.TLUpdateEditMessage;
import org.telegram.api.update.TLUpdateInlineBotCallbackQuery;
import org.telegram.api.update.TLUpdateMessageId;
import org.telegram.api.update.TLUpdateNewAuthorization;
import org.telegram.api.update.TLUpdateNewMessage;
import org.telegram.api.update.TLUpdateNewStickerSet;
import org.telegram.api.update.TLUpdateNotifySettings;
import org.telegram.api.update.TLUpdatePrivacy;
import org.telegram.api.update.TLUpdatePtsChanged;
import org.telegram.api.update.TLUpdateReadChannelInbox;
import org.telegram.api.update.TLUpdateReadChannelOutbox;
import org.telegram.api.update.TLUpdateReadFeaturedStickers;
import org.telegram.api.update.TLUpdateReadMessagesContents;
import org.telegram.api.update.TLUpdateReadMessagesInbox;
import org.telegram.api.update.TLUpdateReadMessagesOutbox;
import org.telegram.api.update.TLUpdateRecentStickers;
import org.telegram.api.update.TLUpdateSavedGifs;
import org.telegram.api.update.TLUpdateServiceNotification;
import org.telegram.api.update.TLUpdateStickerSets;
import org.telegram.api.update.TLUpdateStickerSetsOrder;
import org.telegram.api.update.TLUpdateUserBlocked;
import org.telegram.api.update.TLUpdateUserName;
import org.telegram.api.update.TLUpdateUserPhone;
import org.telegram.api.update.TLUpdateUserPhoto;
import org.telegram.api.update.TLUpdateUserStatus;
import org.telegram.api.update.TLUpdateUserTyping;
import org.telegram.api.update.TLUpdateWebPage;
import org.telegram.api.update.encrypted.TLUpdateEncryptedChatTyping;
import org.telegram.api.update.encrypted.TLUpdateEncryptedMessagesRead;
import org.telegram.api.update.encrypted.TLUpdateEncryption;
import org.telegram.api.update.encrypted.TLUpdateNewEncryptedMessage;
import org.telegram.api.updates.TLUpdateShort;
import org.telegram.api.updates.TLUpdateShortChatMessage;
import org.telegram.api.updates.TLUpdateShortMessage;
import org.telegram.api.updates.TLUpdateShortSentMessage;
import org.telegram.api.updates.TLUpdates;
import org.telegram.api.updates.TLUpdatesCombined;
import org.telegram.api.updates.TLUpdatesState;
import org.telegram.api.updates.TLUpdatesTooLong;
import org.telegram.api.updates.channel.differences.TLUpdatesChannelDifferences;
import org.telegram.api.updates.channel.differences.TLUpdatesChannelDifferencesEmpty;
import org.telegram.api.updates.channel.differences.TLUpdatesChannelDifferencesTooLong;
import org.telegram.api.updates.difference.TLDifference;
import org.telegram.api.updates.difference.TLDifferenceEmpty;
import org.telegram.api.updates.difference.TLDifferenceSlice;
import org.telegram.api.upload.TLFile;
import org.telegram.api.user.TLUser;
import org.telegram.api.user.TLUserEmpty;
import org.telegram.api.user.TLUserFull;
import org.telegram.api.user.profile.photo.TLUserProfilePhoto;
import org.telegram.api.user.profile.photo.TLUserProfilePhotoEmpty;
import org.telegram.api.user.status.TLUserStatusEmpty;
import org.telegram.api.user.status.TLUserStatusLastMonth;
import org.telegram.api.user.status.TLUserStatusLastWeek;
import org.telegram.api.user.status.TLUserStatusOffline;
import org.telegram.api.user.status.TLUserStatusOnline;
import org.telegram.api.user.status.TLUserStatusRecently;
import org.telegram.api.wallpaper.TLWallPaper;
import org.telegram.api.wallpaper.TLWallPaperSolid;
import org.telegram.api.webpage.TLWebPage;
import org.telegram.api.webpage.TLWebPageEmpty;
import org.telegram.api.webpage.TLWebPagePending;
import org.telegram.tl.TLBoolFalse;
import org.telegram.tl.TLBoolTrue;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLError;
import org.telegram.tl.TLNull;
import org.telegram.tl.TLTrue;
import org.telegram.tl.TLVector;

/**
 * The type TL api context.
 */
@SuppressWarnings("OverlyLongMethod")
public class TLApiContext extends TLContext {
    protected void init() {
        registerClass(TLNull.CLASS_ID, TLNull.class);
        registerClass(TLError.CLASS_ID, TLError.class);
        registerClass(TLBoolFalse.CLASS_ID, TLBoolFalse.class);
        registerClass(TLBoolTrue.CLASS_ID, TLBoolTrue.class);
        registerClass(TLVector.CLASS_ID, TLVector.class);
        registerClass(TLUserEmpty.CLASS_ID, TLUserEmpty.class);
        registerClass(TLInputNotifyPeer.CLASS_ID, TLInputNotifyPeer.class);
        registerClass(TLInputNotifyUsers.CLASS_ID, TLInputNotifyUsers.class);
        registerClass(TLInputNotifyChats.CLASS_ID, TLInputNotifyChats.class);
        registerClass(TLInputNotifyAll.CLASS_ID, TLInputNotifyAll.class);
        registerClass(TLFile.CLASS_ID, TLFile.class);
        registerClass(TLDecryptedMessage.CLASS_ID, TLDecryptedMessage.class);
        registerClass(TLDecryptedMessageService.CLASS_ID, TLDecryptedMessageService.class);
        registerClass(TLGeoPointEmpty.CLASS_ID, TLGeoPointEmpty.class);
        registerClass(TLGeoPoint.CLASS_ID, TLGeoPoint.class);
        registerClass(TLInputPeerEmpty.CLASS_ID, TLInputPeerEmpty.class);
        registerClass(TLInputPeerSelf.CLASS_ID, TLInputPeerSelf.class);
        registerClass(TLInputPeerUser.CLASS_ID, TLInputPeerUser.class);
        registerClass(TLInputPeerChat.CLASS_ID, TLInputPeerChat.class);
        registerClass(TLContacts.CLASS_ID, TLContacts.class);
        registerClass(TLContactsNotModified.CLASS_ID, TLContactsNotModified.class);
        registerClass(TLEncryptedMessage.CLASS_ID, TLEncryptedMessage.class);
        registerClass(TLEncryptedMessageService.CLASS_ID, TLEncryptedMessageService.class);
        registerClass(TLDifferenceEmpty.CLASS_ID, TLDifferenceEmpty.class);
        registerClass(TLDifference.CLASS_ID, TLDifference.class);
        registerClass(TLDifferenceSlice.CLASS_ID, TLDifferenceSlice.class);
        registerClass(TLInputPhotoEmpty.CLASS_ID, TLInputPhotoEmpty.class);
        registerClass(TLInputPhoto.CLASS_ID, TLInputPhoto.class);
        registerClass(TLCheckedPhone.CLASS_ID, TLCheckedPhone.class);
        registerClass(TLDecryptedMessageMediaEmpty.CLASS_ID, TLDecryptedMessageMediaEmpty.class);
        registerClass(TLDecryptedMessageMediaPhoto.CLASS_ID, TLDecryptedMessageMediaPhoto.class);
        registerClass(TLDecryptedMessageMediaVideo.CLASS_ID, TLDecryptedMessageMediaVideo.class);
        registerClass(TLDecryptedMessageMediaGeoPoint.CLASS_ID, TLDecryptedMessageMediaGeoPoint.class);
        registerClass(TLDecryptedMessageMediaContact.CLASS_ID, TLDecryptedMessageMediaContact.class);
        registerClass(TLDecryptedMessageMediaDocument.CLASS_ID, TLDecryptedMessageMediaDocument.class);
        registerClass(TLDecryptedMessageMediaAudio.CLASS_ID, TLDecryptedMessageMediaAudio.class);
        registerClass(TLInputPhoneContact.CLASS_ID, TLInputPhoneContact.class);
        registerClass(TLWallPaper.CLASS_ID, TLWallPaper.class);
        registerClass(TLWallPaperSolid.CLASS_ID, TLWallPaperSolid.class);
        registerClass(TLDcOption.CLASS_ID, TLDcOption.class);
        registerClass(TLContactBlocked.CLASS_ID, TLContactBlocked.class);
        registerClass(TLChatEmpty.CLASS_ID, TLChatEmpty.class);
        registerClass(TLChat.CLASS_ID, TLChat.class);
        registerClass(TLChatForbidden.CLASS_ID, TLChatForbidden.class);
        registerClass(TLChatFull.CLASS_ID, TLChatFull.class);
        registerClass(TLPhotoSizeEmpty.CLASS_ID, TLPhotoSizeEmpty.class);
        registerClass(TLPhotoSize.CLASS_ID, TLPhotoSize.class);
        registerClass(TLPhotoCachedSize.CLASS_ID, TLPhotoCachedSize.class);
        registerClass(TLBlocked.CLASS_ID, TLBlocked.class);
        registerClass(TLBlockedSlice.CLASS_ID, TLBlockedSlice.class);
        registerClass(TLChatPhotoEmpty.CLASS_ID, TLChatPhotoEmpty.class);
        registerClass(TLChatPhoto.CLASS_ID, TLChatPhoto.class);
        registerClass(TLDecryptedMessageActionSetMessageTTL.CLASS_ID, TLDecryptedMessageActionSetMessageTTL.class);
        registerClass(TLConfig.CLASS_ID, TLConfig.class);
        registerClass(TLContactsLink.CLASS_ID, TLContactsLink.class);
        registerClass(TLUpdatesState.CLASS_ID, TLUpdatesState.class);
        registerClass(TLImportedContacts.CLASS_ID, TLImportedContacts.class);
        registerClass(TLEncryptedChatEmpty.CLASS_ID, TLEncryptedChatEmpty.class);
        registerClass(TLEncryptedChatWaiting.CLASS_ID, TLEncryptedChatWaiting.class);
        registerClass(TLEncryptedChatRequested.CLASS_ID, TLEncryptedChatRequested.class);
        registerClass(TLEncryptedChat.CLASS_ID, TLEncryptedChat.class);
        registerClass(TLEncryptedChatDiscarded.CLASS_ID, TLEncryptedChatDiscarded.class);
        registerClass(TLInputFile.CLASS_ID, TLInputFile.class);
        registerClass(TLInputFileBig.CLASS_ID, TLInputFileBig.class);
        registerClass(TLMessages.CLASS_ID, TLMessages.class);
        registerClass(TLMessagesSlice.CLASS_ID, TLMessagesSlice.class);
        registerClass(TLMessageEmpty.CLASS_ID, TLMessageEmpty.class);
        registerClass(TLMessage.CLASS_ID, TLMessage.class);
        registerClass(TLMessageService.CLASS_ID, TLMessageService.class);
        registerClass(TLPhotos.CLASS_ID, TLPhotos.class);
        registerClass(TLPhotosSlice.CLASS_ID, TLPhotosSlice.class);
        registerClass(TLMessagesChats.CLASS_ID, TLMessagesChats.class);
        registerClass(TLInputEncryptedFileEmpty.CLASS_ID, TLInputEncryptedFileEmpty.class);
        registerClass(TLInputEncryptedFileUploaded.CLASS_ID, TLInputEncryptedFileUploaded.class);
        registerClass(TLInputEncryptedFile.CLASS_ID, TLInputEncryptedFile.class);
        registerClass(TLInputEncryptedFileBigUploaded.CLASS_ID, TLInputEncryptedFileBigUploaded.class);
        registerClass(TLPeerUser.CLASS_ID, TLPeerUser.class);
        registerClass(TLPeerChat.CLASS_ID, TLPeerChat.class);
        registerClass(TLPeerNotifySettingsEmpty.CLASS_ID, TLPeerNotifySettingsEmpty.class);
        registerClass(TLPeerNotifySettings.CLASS_ID, TLPeerNotifySettings.class);
        registerClass(TLMessageActionEmpty.CLASS_ID, TLMessageActionEmpty.class);
        registerClass(TLMessageActionChatCreate.CLASS_ID, TLMessageActionChatCreate.class);
        registerClass(TLMessageActionChatEditTitle.CLASS_ID, TLMessageActionChatEditTitle.class);
        registerClass(TLMessageActionChatEditPhoto.CLASS_ID, TLMessageActionChatEditPhoto.class);
        registerClass(TLMessageActionChatDeletePhoto.CLASS_ID, TLMessageActionChatDeletePhoto.class);
        registerClass(TLMessageActionChatAddUser.CLASS_ID, TLMessageActionChatAddUser.class);
        registerClass(TLMessageActionChatDeleteUser.CLASS_ID, TLMessageActionChatDeleteUser.class);
        registerClass(TLMessagesFilterEmpty.CLASS_ID, TLMessagesFilterEmpty.class);
        registerClass(TLMessagesFilterPhotos.CLASS_ID, TLMessagesFilterPhotos.class);
        registerClass(TLMessagesFilterVideo.CLASS_ID, TLMessagesFilterVideo.class);
        registerClass(TLMessagesFilterPhotoVideo.CLASS_ID, TLMessagesFilterPhotoVideo.class);
        registerClass(TLMessagesFilterDocument.CLASS_ID, TLMessagesFilterDocument.class);
        registerClass(TLDecryptedMessageLayer.CLASS_ID, TLDecryptedMessageLayer.class);
        registerClass(TLFileUnknown.CLASS_ID, TLFileUnknown.class);
        registerClass(TLFileJpeg.CLASS_ID, TLFileJpeg.class);
        registerClass(TLFileGif.CLASS_ID, TLFileGif.class);
        registerClass(TLFilePng.CLASS_ID, TLFilePng.class);
        registerClass(TLFilePdf.CLASS_ID, TLFilePdf.class);
        registerClass(TLFileMp3.CLASS_ID, TLFileMp3.class);
        registerClass(TLFileMov.CLASS_ID, TLFileMov.class);
        registerClass(TLFilePartial.CLASS_ID, TLFilePartial.class);
        registerClass(TLFileMp4.CLASS_ID, TLFileMp4.class);
        registerClass(TLFileWebp.CLASS_ID, TLFileWebp.class);
        registerClass(TLFileLocationUnavailable.CLASS_ID, TLFileLocationUnavailable.class);
        registerClass(TLFileLocation.CLASS_ID, TLFileLocation.class);
        registerClass(TLInputPeerNotifyEventsEmpty.CLASS_ID, TLInputPeerNotifyEventsEmpty.class);
        registerClass(TLInputPeerNotifyEventsAll.CLASS_ID, TLInputPeerNotifyEventsAll.class);
        registerClass(TLImportedContact.CLASS_ID, TLImportedContact.class);
        registerClass(TLNearestDc.CLASS_ID, TLNearestDc.class);
        registerClass(TLUserProfilePhotoEmpty.CLASS_ID, TLUserProfilePhotoEmpty.class);
        registerClass(TLUserProfilePhoto.CLASS_ID, TLUserProfilePhoto.class);
        registerClass(TLMessagesChatFull.CLASS_ID, TLMessagesChatFull.class);
        registerClass(TLSentCode.CLASS_ID, TLSentCode.class);
        registerClass(TLChatParticipant.CLASS_ID, TLChatParticipant.class);
        registerClass(TLMessageMediaEmpty.CLASS_ID, TLMessageMediaEmpty.class);
        registerClass(TLMessageMediaPhoto.CLASS_ID, TLMessageMediaPhoto.class);
        registerClass(TLMessageMediaGeo.CLASS_ID, TLMessageMediaGeo.class);
        registerClass(TLMessageMediaContact.CLASS_ID, TLMessageMediaContact.class);
        registerClass(TLMessageMediaUnsupported.CLASS_ID, TLMessageMediaUnsupported.class);
        registerClass(TLMessageMediaDocument.CLASS_ID, TLMessageMediaDocument.class);
        registerClass(TLEncryptedFileEmpty.CLASS_ID, TLEncryptedFileEmpty.class);
        registerClass(TLEncryptedFile.CLASS_ID, TLEncryptedFile.class);
        registerClass(TLUserStatusEmpty.CLASS_ID, TLUserStatusEmpty.class);
        registerClass(TLUserStatusOnline.CLASS_ID, TLUserStatusOnline.class);
        registerClass(TLUserStatusOffline.CLASS_ID, TLUserStatusOffline.class);
        registerClass(TLContactsFound.CLASS_ID, TLContactsFound.class);
        registerClass(TLInviteText.CLASS_ID, TLInviteText.class);
        registerClass(TLDhConfigNotModified.CLASS_ID, TLDhConfigNotModified.class);
        registerClass(TLDhConfig.CLASS_ID, TLDhConfig.class);
        registerClass(TLSentEncryptedMessage.CLASS_ID, TLSentEncryptedMessage.class);
        registerClass(TLSentEncryptedFile.CLASS_ID, TLSentEncryptedFile.class);
        registerClass(TLPhotoEmpty.CLASS_ID, TLPhotoEmpty.class);
        registerClass(TLPhoto.CLASS_ID, TLPhoto.class);
        registerClass(TLChatParticipantsForbidden.CLASS_ID, TLChatParticipantsForbidden.class);
        registerClass(TLChatParticipants.CLASS_ID, TLChatParticipants.class);
        registerClass(TLInputMediaEmpty.CLASS_ID, TLInputMediaEmpty.class);
        registerClass(TLInputMediaUploadedPhoto.CLASS_ID, TLInputMediaUploadedPhoto.class);
        registerClass(TLInputMediaPhoto.CLASS_ID, TLInputMediaPhoto.class);
        registerClass(TLInputMediaGeoPoint.CLASS_ID, TLInputMediaGeoPoint.class);
        registerClass(TLInputMediaContact.CLASS_ID, TLInputMediaContact.class);
        registerClass(TLInputMediaUploadedDocument.CLASS_ID, TLInputMediaUploadedDocument.class);
        registerClass(TLInputMediaDocument.CLASS_ID, TLInputMediaDocument.class);
        registerClass(TLUpdatesTooLong.CLASS_ID, TLUpdatesTooLong.class);
        registerClass(TLUpdateShortMessage.CLASS_ID, TLUpdateShortMessage.class);
        registerClass(TLUpdateShortChatMessage.CLASS_ID, TLUpdateShortChatMessage.class);
        registerClass(TLUpdateShort.CLASS_ID, TLUpdateShort.class);
        registerClass(TLUpdatesCombined.CLASS_ID, TLUpdatesCombined.class);
        registerClass(TLUpdates.CLASS_ID, TLUpdates.class);
        registerClass(TLAuthorization.CLASS_ID, TLAuthorization.class);
        registerClass(TLDialogs.CLASS_ID, TLDialogs.class);
        registerClass(TLDialogsSlice.CLASS_ID, TLDialogsSlice.class);
        registerClass(TLPeerNotifyEventsEmpty.CLASS_ID, TLPeerNotifyEventsEmpty.class);
        registerClass(TLPeerNotifyEventsAll.CLASS_ID, TLPeerNotifyEventsAll.class);
        registerClass(TLInputPeerNotifySettings.CLASS_ID, TLInputPeerNotifySettings.class);
        registerClass(TLInputGeoPointEmpty.CLASS_ID, TLInputGeoPointEmpty.class);
        registerClass(TLInputGeoPoint.CLASS_ID, TLInputGeoPoint.class);
        registerClass(TLContactStatus.CLASS_ID, TLContactStatus.class);
        registerClass(TLUpdateNewMessage.CLASS_ID, TLUpdateNewMessage.class);
        registerClass(TLUpdateMessageId.CLASS_ID, TLUpdateMessageId.class);
        registerClass(TLUpdateDeleteMessages.CLASS_ID, TLUpdateDeleteMessages.class);
        registerClass(TLUpdateUserTyping.CLASS_ID, TLUpdateUserTyping.class);
        registerClass(TLUpdateChatUserTyping.CLASS_ID, TLUpdateChatUserTyping.class);
        registerClass(TLUpdateChatParticipants.CLASS_ID, TLUpdateChatParticipants.class);
        registerClass(TLUpdateUserStatus.CLASS_ID, TLUpdateUserStatus.class);
        registerClass(TLUpdateUserName.CLASS_ID, TLUpdateUserName.class);
        registerClass(TLUpdateUserPhoto.CLASS_ID, TLUpdateUserPhoto.class);
        registerClass(TLUpdateContactRegistered.CLASS_ID, TLUpdateContactRegistered.class);
        registerClass(TLUpdateContactLink.CLASS_ID, TLUpdateContactLink.class);
        registerClass(TLUpdateNewAuthorization.CLASS_ID, TLUpdateNewAuthorization.class);
        registerClass(TLUpdateNewEncryptedMessage.CLASS_ID, TLUpdateNewEncryptedMessage.class);
        registerClass(TLUpdateEncryptedChatTyping.CLASS_ID, TLUpdateEncryptedChatTyping.class);
        registerClass(TLUpdateEncryption.CLASS_ID, TLUpdateEncryption.class);
        registerClass(TLUpdateEncryptedMessagesRead.CLASS_ID, TLUpdateEncryptedMessagesRead.class);
        registerClass(TLUpdateChatParticipantAdd.CLASS_ID, TLUpdateChatParticipantAdd.class);
        registerClass(TLUpdateChatParticipantDelete.CLASS_ID, TLUpdateChatParticipantDelete.class);
        registerClass(TLUpdateDcOptions.CLASS_ID, TLUpdateDcOptions.class);
        registerClass(TLInputAppEvent.CLASS_ID, TLInputAppEvent.class);
        registerClass(TLInputEncryptedChat.CLASS_ID, TLInputEncryptedChat.class);
        registerClass(TLInputFileLocation.CLASS_ID, TLInputFileLocation.class);
        registerClass(TLInputEncryptedFileLocation.CLASS_ID, TLInputEncryptedFileLocation.class);
        registerClass(TLInputDocumentFileLocation.CLASS_ID, TLInputDocumentFileLocation.class);
        registerClass(TLSupport.CLASS_ID, TLSupport.class);
        registerClass(TLDocumentEmpty.CLASS_ID, TLDocumentEmpty.class);
        registerClass(TLAppUpdate.CLASS_ID, TLAppUpdate.class);
        registerClass(TLNoAppUpdate.CLASS_ID, TLNoAppUpdate.class);
        registerClass(TLAffectedHistory.CLASS_ID, TLAffectedHistory.class);
        registerClass(TLContact.CLASS_ID, TLContact.class);
        registerClass(TLUserFull.CLASS_ID, TLUserFull.class);
        registerClass(TLDialog.CLASS_ID, TLDialog.class);
        registerClass(TLInputUserEmpty.CLASS_ID, TLInputUserEmpty.class);
        registerClass(TLInputUserSelf.CLASS_ID, TLInputUserSelf.class);
        registerClass(TLInputUser.CLASS_ID, TLInputUser.class);
        registerClass(TLInputDocumentEmpty.CLASS_ID, TLInputDocumentEmpty.class);
        registerClass(TLInputDocument.CLASS_ID, TLInputDocument.class);
        registerClass(TLExportedAuthorization.CLASS_ID, TLExportedAuthorization.class);
        registerClass(TLInputChatPhotoEmpty.CLASS_ID, TLInputChatPhotoEmpty.class);
        registerClass(TLInputChatUploadedPhoto.CLASS_ID, TLInputChatUploadedPhoto.class);
        registerClass(TLInputChatPhoto.CLASS_ID, TLInputChatPhoto.class);
        registerClass(TLDecryptedMessageActionFlushHistory.CLASS_ID, TLDecryptedMessageActionFlushHistory.class);
        registerClass(TLDecryptedMessageActionNotifyLayer.CLASS_ID, TLDecryptedMessageActionNotifyLayer.class);
        registerClass(TLDecryptedMessageActionReadMessages.CLASS_ID, TLDecryptedMessageActionReadMessages.class);
        registerClass(TLDecryptedMessageActionResend.CLASS_ID, TLDecryptedMessageActionResend.class);
        registerClass(TLNotifyUsers.CLASS_ID, TLNotifyUsers.class);
        registerClass(TLNotifyAll.CLASS_ID, TLNotifyAll.class);
        registerClass(TLNotifyChats.CLASS_ID, TLNotifyChats.class);
        registerClass(TLNotifyPeer.CLASS_ID, TLNotifyPeer.class);
        registerClass(TLPhotosPhoto.CLASS_ID, TLPhotosPhoto.class);
        registerClass(TLRequestAccountGetNotifySettings.CLASS_ID, TLRequestAccountGetNotifySettings.class);
        registerClass(TLRequestAccountGetWallPapers.CLASS_ID, TLRequestAccountGetWallPapers.class);
        registerClass(TLRequestAccountRegisterDevice.CLASS_ID, TLRequestAccountRegisterDevice.class);
        registerClass(TLRequestAccountResetNotifySettings.CLASS_ID, TLRequestAccountResetNotifySettings.class);
        registerClass(TLRequestAccountUnregisterDevice.CLASS_ID, TLRequestAccountUnregisterDevice.class);
        registerClass(TLRequestAccountUpdateNotifySettings.CLASS_ID, TLRequestAccountUpdateNotifySettings.class);
        registerClass(TLRequestAccountUpdateProfile.CLASS_ID, TLRequestAccountUpdateProfile.class);
        registerClass(TLRequestAccountUpdateStatus.CLASS_ID, TLRequestAccountUpdateStatus.class);
        registerClass(TLRequestAuthCheckPhone.CLASS_ID, TLRequestAuthCheckPhone.class);
        registerClass(TLRequestAuthExportAuthorization.CLASS_ID, TLRequestAuthExportAuthorization.class);
        registerClass(TLRequestAuthImportAuthorization.CLASS_ID, TLRequestAuthImportAuthorization.class);
        registerClass(TLRequestAuthLogOut.CLASS_ID, TLRequestAuthLogOut.class);
        registerClass(TLRequestAuthResetAuthorizations.CLASS_ID, TLRequestAuthResetAuthorizations.class);
        registerClass(TLRequestAuthSendCode.CLASS_ID, TLRequestAuthSendCode.class);
        registerClass(TLRequestAuthSendInvites.CLASS_ID, TLRequestAuthSendInvites.class);
        registerClass(TLRequestAuthSignIn.CLASS_ID, TLRequestAuthSignIn.class);
        registerClass(TLRequestAuthSignUp.CLASS_ID, TLRequestAuthSignUp.class);
        registerClass(TLRequestContactsBlock.CLASS_ID, TLRequestContactsBlock.class);
        registerClass(TLRequestContactsDeleteContact.CLASS_ID, TLRequestContactsDeleteContact.class);
        registerClass(TLRequestContactsDeleteContacts.CLASS_ID, TLRequestContactsDeleteContacts.class);
        registerClass(TLRequestContactsGetBlocked.CLASS_ID, TLRequestContactsGetBlocked.class);
        registerClass(TLRequestContactsGetContacts.CLASS_ID, TLRequestContactsGetContacts.class);
        registerClass(TLRequestContactsGetStatuses.CLASS_ID, TLRequestContactsGetStatuses.class);
        registerClass(TLRequestContactsSearch.CLASS_ID, TLRequestContactsSearch.class);
        registerClass(TLRequestContactsImportContacts.CLASS_ID, TLRequestContactsImportContacts.class);
        registerClass(TLRequestContactsUnblock.CLASS_ID, TLRequestContactsUnblock.class);
        registerClass(TLRequestHelpGetAppUpdate.CLASS_ID, TLRequestHelpGetAppUpdate.class);
        registerClass(TLRequestHelpGetConfig.CLASS_ID, TLRequestHelpGetConfig.class);
        registerClass(TLRequestHelpGetInviteText.CLASS_ID, TLRequestHelpGetInviteText.class);
        registerClass(TLRequestHelpGetNearestDc.CLASS_ID, TLRequestHelpGetNearestDc.class);
        registerClass(TLRequestHelpGetSupport.CLASS_ID, TLRequestHelpGetSupport.class);
        registerClass(TLRequestHelpSaveAppLog.CLASS_ID, TLRequestHelpSaveAppLog.class);
        registerClass(TLRequestInitConnection.CLASS_ID, TLRequestInitConnection.class);
        registerClass(TLRequestInvokeAfterMsg.CLASS_ID, TLRequestInvokeAfterMsg.class);
        registerClass(TLRequestInvokeAfterMsgs.CLASS_ID, TLRequestInvokeAfterMsgs.class);
        registerClass(TLRequestMessagesAcceptEncryption.CLASS_ID, TLRequestMessagesAcceptEncryption.class);
        registerClass(TLRequestMessagesAddChatUser.CLASS_ID, TLRequestMessagesAddChatUser.class);
        registerClass(TLRequestMessagesCreateChat.CLASS_ID, TLRequestMessagesCreateChat.class);
        registerClass(TLRequestMessagesDeleteChatUser.CLASS_ID, TLRequestMessagesDeleteChatUser.class);
        registerClass(TLRequestMessagesDeleteHistory.CLASS_ID, TLRequestMessagesDeleteHistory.class);
        registerClass(TLRequestMessagesDiscardEncryption.CLASS_ID, TLRequestMessagesDiscardEncryption.class);
        registerClass(TLRequestMessagesEditChatPhoto.CLASS_ID, TLRequestMessagesEditChatPhoto.class);
        registerClass(TLRequestMessagesEditChatTitle.CLASS_ID, TLRequestMessagesEditChatTitle.class);
        registerClass(TLRequestMessagesForwardMessage.CLASS_ID, TLRequestMessagesForwardMessage.class);
        registerClass(TLRequestMessagesForwardMessages.CLASS_ID, TLRequestMessagesForwardMessages.class);
        registerClass(TLRequestMessagesGetChats.CLASS_ID, TLRequestMessagesGetChats.class);
        registerClass(TLRequestMessagesGetDhConfig.CLASS_ID, TLRequestMessagesGetDhConfig.class);
        registerClass(TLRequestMessagesGetDialogs.CLASS_ID, TLRequestMessagesGetDialogs.class);
        registerClass(TLRequestMessagesGetFullChat.CLASS_ID, TLRequestMessagesGetFullChat.class);
        registerClass(TLRequestMessagesGetHistory.CLASS_ID, TLRequestMessagesGetHistory.class);
        registerClass(TLRequestMessagesGetMessages.CLASS_ID, TLRequestMessagesGetMessages.class);
        registerClass(TLRequestMessagesReadEncryptedHistory.CLASS_ID, TLRequestMessagesReadEncryptedHistory.class);
        registerClass(TLRequestMessagesReadHistory.CLASS_ID, TLRequestMessagesReadHistory.class);
        registerClass(TLRequestMessagesReceivedMessages.CLASS_ID, TLRequestMessagesReceivedMessages.class);
        registerClass(TLRequestMessagesReceivedQueue.CLASS_ID, TLRequestMessagesReceivedQueue.class);
        registerClass(TLRequestMessagesRequestEncryption.CLASS_ID, TLRequestMessagesRequestEncryption.class);
        registerClass(TLRequestMessagesSearch.CLASS_ID, TLRequestMessagesSearch.class);
        registerClass(TLRequestMessagesSendEncrypted.CLASS_ID, TLRequestMessagesSendEncrypted.class);
        registerClass(TLRequestMessagesSendEncryptedFile.CLASS_ID, TLRequestMessagesSendEncryptedFile.class);
        registerClass(TLRequestMessagesSendEncryptedService.CLASS_ID, TLRequestMessagesSendEncryptedService.class);
        registerClass(TLRequestMessagesSendMedia.CLASS_ID, TLRequestMessagesSendMedia.class);
        registerClass(TLRequestMessagesSendMessage.CLASS_ID, TLRequestMessagesSendMessage.class);
        registerClass(TLRequestMessagesSetEncryptedTyping.CLASS_ID, TLRequestMessagesSetEncryptedTyping.class);
        registerClass(TLRequestMessagesSetTyping.CLASS_ID, TLRequestMessagesSetTyping.class);
        registerClass(TLRequestPhotosGetUserPhotos.CLASS_ID, TLRequestPhotosGetUserPhotos.class);
        registerClass(TLRequestPhotosUpdateProfilePhoto.CLASS_ID, TLRequestPhotosUpdateProfilePhoto.class);
        registerClass(TLRequestPhotosUploadProfilePhoto.CLASS_ID, TLRequestPhotosUploadProfilePhoto.class);
        registerClass(TLRequestUpdatesGetDifference.CLASS_ID, TLRequestUpdatesGetDifference.class);
        registerClass(TLRequestUpdatesGetState.CLASS_ID, TLRequestUpdatesGetState.class);
        registerClass(TLRequestUploadGetFile.CLASS_ID, TLRequestUploadGetFile.class);
        registerClass(TLRequestUploadSaveBigFilePart.CLASS_ID, TLRequestUploadSaveBigFilePart.class);
        registerClass(TLRequestUploadSaveFilePart.CLASS_ID, TLRequestUploadSaveFilePart.class);
        registerClass(TLRequestUsersGetFullUser.CLASS_ID, TLRequestUsersGetFullUser.class);
        registerClass(TLRequestUsersGetUsers.CLASS_ID, TLRequestUsersGetUsers.class);
        registerClass(TLSendMessageCancelAction.CLASS_ID, TLSendMessageCancelAction.class);
        registerClass(TLSendMessageChooseContactAction.CLASS_ID, TLSendMessageChooseContactAction.class);
        registerClass(TLSendMessageGeoLocationAction.CLASS_ID, TLSendMessageGeoLocationAction.class);
        registerClass(TLSendMessageRecordAudioAction.CLASS_ID, TLSendMessageRecordAudioAction.class);
        registerClass(TLSendMessageRecordVideoAction.CLASS_ID, TLSendMessageRecordVideoAction.class);
        registerClass(TLSendMessageTypingAction.CLASS_ID, TLSendMessageTypingAction.class);
        registerClass(TLSendMessageUploadAudioAction.CLASS_ID, TLSendMessageUploadAudioAction.class);
        registerClass(TLSendMessageUploadDocumentAction.CLASS_ID, TLSendMessageUploadDocumentAction.class);
        registerClass(TLSendMessageUploadPhotoAction.CLASS_ID, TLSendMessageUploadPhotoAction.class);
        registerClass(TLSendMessageUploadVideoAction.CLASS_ID, TLSendMessageUploadVideoAction.class);
        registerClass(TLUpdateNotifySettings.CLASS_ID, TLUpdateNotifySettings.class);
        registerClass(TLUpdateServiceNotification.CLASS_ID, TLUpdateServiceNotification.class);
        registerClass(TLUpdateUserBlocked.CLASS_ID, TLUpdateUserBlocked.class);
        registerClass(TLRequestMessagesReadContents.CLASS_ID, TLRequestMessagesReadContents.class);
        registerClass(TLRequestAccountUpdateUsername.CLASS_ID, TLRequestAccountUpdateUsername.class);
        registerClass(TLRequestAccountCheckUsername.CLASS_ID, TLRequestAccountCheckUsername.class);
        registerClass(TLRequestPhotosDeletePhotos.CLASS_ID, TLRequestPhotosDeletePhotos.class);
        registerClass(TLRequestChannelsToggleInvites.CLASS_ID, TLRequestChannelsToggleInvites.class);
        // InvokeWithLayer
        registerClass(TLRequestInvokeWithLayer.CLASS_ID, TLRequestInvokeWithLayer.class);
        // Layer 19
        addApiLayer19();
        // Layer 22
        addApiLayer22();
        // Layer 26
        addApiLayer26();
        // Api Layer 28
        addApiLayer28();
        // Api Layer 32
        addApiLayer32();
        // Api layer 38
        addApiLayer38();
        // Api layer 45
        addApiLayer45();
        // Api layer 50
        addApiLayer50();
        // Api layer 51
        addApiLayer51();
        // api layer 55
        addApiLayer55();
        // api layer 56
        addApiLayer56();
        // api layer 57
        addApiLayer57();
    }

    private void addApiLayer19() {
        registerClass(TLPrivacyKeyStatusTimestamp.CLASS_ID, TLPrivacyKeyStatusTimestamp.class);
        registerClass(TLAccountPrivacyRules.CLASS_ID, TLAccountPrivacyRules.class);
        registerClass(TLPrivacyValueAllowUsers.CLASS_ID, TLPrivacyValueAllowUsers.class);
        registerClass(TLPrivacyValueDisallowAll.CLASS_ID, TLPrivacyValueDisallowAll.class);
        registerClass(TLPrivacyValueAllowContacts.CLASS_ID, TLPrivacyValueAllowContacts.class);
        registerClass(TLPrivacyValueDisallowContacts.CLASS_ID, TLPrivacyValueDisallowContacts.class);
        registerClass(TLPrivacyValueAllowAll.CLASS_ID, TLPrivacyValueAllowAll.class);
        registerClass(TLPrivacyValueDisallowUsers.CLASS_ID, TLPrivacyValueDisallowUsers.class);
        registerClass(TLInputPrivacyKeyStatusTimestamp.CLASS_ID, TLInputPrivacyKeyStatusTimestamp.class);
        registerClass(TLInputPrivacyValueDisallowUsers.CLASS_ID, TLInputPrivacyValueDisallowUsers.class);
        registerClass(TLInputPrivacyValueDisallowAll.CLASS_ID, TLInputPrivacyValueDisallowAll.class);
        registerClass(TLInputPrivacyValueDisallowContacts.CLASS_ID, TLInputPrivacyValueDisallowContacts.class);
        registerClass(TLInputPrivacyValueAllowAll.CLASS_ID, TLInputPrivacyValueAllowAll.class);
        registerClass(TLInputPrivacyValueAllowContacts.CLASS_ID, TLInputPrivacyValueAllowContacts.class);
        registerClass(TLInputPrivacyValueAllowUsers.CLASS_ID, TLInputPrivacyValueAllowUsers.class);
        registerClass(TLUpdatePrivacy.CLASS_ID, TLUpdatePrivacy.class);
        registerClass(TLRequestAccountGetPrivacy.CLASS_ID, TLRequestAccountGetPrivacy.class);
        registerClass(TLRequestAccountSetPrivacy.CLASS_ID, TLRequestAccountSetPrivacy.class);
        registerClass(TLAccountDaysTTL.CLASS_ID, TLAccountDaysTTL.class);
        registerClass(TLRequestAccountSetAccountTTL.CLASS_ID, TLRequestAccountSetAccountTTL.class);
        registerClass(TLRequestAccountGetAccountTTL.CLASS_ID, TLRequestAccountGetAccountTTL.class);
        registerClass(TLUserStatusLastWeek.CLASS_ID, TLUserStatusLastWeek.class);
        registerClass(TLUserStatusLastMonth.CLASS_ID, TLUserStatusLastMonth.class);
        registerClass(TLUserStatusRecently.CLASS_ID, TLUserStatusRecently.class);
    }

    private void addApiLayer22() {
        registerClass(TLDocumentAttributeAnimated.CLASS_ID, TLDocumentAttributeAnimated.class);
        registerClass(TLDocumentAttributeFilename.CLASS_ID, TLDocumentAttributeFilename.class);
        registerClass(TLDocumentAttributeVideo.CLASS_ID, TLDocumentAttributeVideo.class);
        registerClass(TLDocumentAttributeSticker.CLASS_ID, TLDocumentAttributeSticker.class);
        registerClass(TLDocumentAttributeImageSize.CLASS_ID, TLDocumentAttributeImageSize.class);
        registerClass(TLDocumentAttributeAudio.CLASS_ID, TLDocumentAttributeAudio.class);
        registerClass(TLDocument.CLASS_ID, TLDocument.class);
        registerClass(TLInputMediaUploadedThumbDocument.CLASS_ID, TLInputMediaUploadedThumbDocument.class);
        registerClass(TLUpdateUserPhone.CLASS_ID, TLUpdateUserPhone.class);
        registerClass(TLDecryptedMessageActionAcceptKey.CLASS_ID, TLDecryptedMessageActionAcceptKey.class);
        registerClass(TLDecryptedMessageActionRequestKey.CLASS_ID, TLDecryptedMessageActionRequestKey.class);
        registerClass(TLAllStickers.CLASS_ID, TLAllStickers.class);
        registerClass(TLAllStickersNotModified.CLASS_ID, TLAllStickersNotModified.class);
        registerClass(TLAccountPassword.CLASS_ID, TLAccountPassword.class);
        registerClass(TLAccountNoPassword.CLASS_ID, TLAccountNoPassword.class);
        registerClass(TLRequestAccountSendChangePhoneCode.CLASS_ID, TLRequestAccountSendChangePhoneCode.class);
        registerClass(TLRequestAccountChangePhone.CLASS_ID, TLRequestAccountChangePhone.class);
        registerClass(TLRequestAccountGetPassword.CLASS_ID, TLRequestAccountGetPassword.class);
        registerClass(TLRequestAuthCheckPassword.CLASS_ID, TLRequestAuthCheckPassword.class);
        registerClass(TLRequestMessagesGetAllStickers.CLASS_ID, TLRequestMessagesGetAllStickers.class);
        registerClass(TLRequestContactsResolveUsername.CLASS_ID, TLRequestContactsResolveUsername.class);
        registerClass(TLDecryptedMessageMediaExternalDocument.CLASS_ID, TLDecryptedMessageMediaExternalDocument.class);
        registerClass(TLStickerPack.CLASS_ID, TLStickerPack.class);
        registerClass(TLDecryptedMessageActionNoop.CLASS_ID, TLDecryptedMessageActionNoop.class);
        registerClass(TLDecryptedMessageActionAbortKey.CLASS_ID, TLDecryptedMessageActionAbortKey.class);
        registerClass(TLDecryptedMessageActionCommitKey.CLASS_ID, TLDecryptedMessageActionCommitKey.class);
    }

    private void addApiLayer26() {
        registerClass(TLAccountPasswordSettings.CLASS_ID, TLAccountPasswordSettings.class);
        registerClass(TLAffectedMessages.CLASS_ID, TLAffectedMessages.class);
        registerClass(org.telegram.api.auth.TLAuthorization.CLASS_ID, org.telegram.api.auth.TLAuthorization.class);
        registerClass(TLMessageMediaWebPage.CLASS_ID, TLMessageMediaWebPage.class);
        registerClass(TLWebPagePending.CLASS_ID, TLWebPagePending.class);
        registerClass(TLWebPageEmpty.CLASS_ID, TLWebPageEmpty.class);
        registerClass(TLPasswordRecovery.CLASS_ID, TLPasswordRecovery.class);
        registerClass(TLWebPage.CLASS_ID, TLWebPage.class);
        registerClass(TLContactLinkNone.CLASS_ID, TLContactLinkNone.class);
        registerClass(TLContactLinkContact.CLASS_ID, TLContactLinkContact.class);
        registerClass(TLContactLinkHasPhone.CLASS_ID, TLContactLinkHasPhone.class);
        registerClass(TLContactLinkUnknown.CLASS_ID, TLContactLinkUnknown.class);
        registerClass(TLDisabledFeature.CLASS_ID, TLDisabledFeature.class);
        registerClass(TLUpdateReadMessagesInbox.CLASS_ID, TLUpdateReadMessagesInbox.class);
        registerClass(TLUpdateWebPage.CLASS_ID, TLUpdateWebPage.class);
        registerClass(TLUpdateReadMessagesOutbox.CLASS_ID, TLUpdateReadMessagesOutbox.class);
        registerClass(TLRequestAccountUpdateDeviceLocked.CLASS_ID, TLRequestAccountUpdateDeviceLocked.class);
        registerClass(TLRequestAccountGetAuthorizations.CLASS_ID, TLRequestAccountGetAuthorizations.class);
        registerClass(TLRequestAccountResetAuthorization.CLASS_ID, TLRequestAccountResetAuthorization.class);
        registerClass(TLRequestMessagesGetWebPagePreview.CLASS_ID, TLRequestMessagesGetWebPagePreview.class);
        registerClass(TLAccountPasswordInputSettings.CLASS_ID, TLAccountPasswordInputSettings.class);
        registerClass(TLAccountAuthorizations.CLASS_ID, TLAccountAuthorizations.class);
        registerClass(TLRequestMessagesDeleteMessages.CLASS_ID, TLRequestMessagesDeleteMessages.class);
        registerClass(TLRequestAccountGetPasswordSettings.CLASS_ID, TLRequestAccountGetPasswordSettings.class);
        registerClass(TLRequestAccountUpdatePasswordSettings.CLASS_ID, TLRequestAccountUpdatePasswordSettings.class);
        registerClass(TLRequestAuthRequestPasswordRecovery.CLASS_ID, TLRequestAuthRequestPasswordRecovery.class);
        registerClass(TLRequestAuthRecoverPassword.CLASS_ID, TLRequestAuthRecoverPassword.class);
        registerClass(TLMessagesFilterPhotoVideoDocuments.CLASS_ID, TLMessagesFilterPhotoVideoDocuments.class);
        registerClass(TLStickersNotModified.CLASS_ID, TLStickersNotModified.class);
        registerClass(TLStickers.CLASS_ID, TLStickers.class);
        registerClass(TLRequestAuthBindTempAuthKey.CLASS_ID, TLRequestAuthBindTempAuthKey.class);
        registerClass(TLRequestContactsImportCard.CLASS_ID, TLRequestContactsImportCard.class);
        registerClass(TLRequestContactsExportCard.CLASS_ID, TLRequestContactsExportCard.class);
    }

    private void addApiLayer28() {
        registerClass(TLInputMediaVenue.CLASS_ID, TLInputMediaVenue.class);
        registerClass(TLMessageMediaVenue.CLASS_ID, TLMessageMediaVenue.class);
        registerClass(TLReceivedNotifyMessage.CLASS_ID, TLReceivedNotifyMessage.class);
        registerClass(TLChatInviteEmpty.CLASS_ID, TLChatInviteEmpty.class);
        registerClass(TLChatInviteExported.CLASS_ID, TLChatInviteExported.class);
        registerClass(TLChatInviteAlready.CLASS_ID, TLChatInviteAlready.class);
        registerClass(TLChatInvite.CLASS_ID, TLChatInvite.class);
        registerClass(TLMessageActionChatJoinedByLink.CLASS_ID, TLMessageActionChatJoinedByLink.class);
        registerClass(TLUpdateReadMessagesContents.CLASS_ID, TLUpdateReadMessagesContents.class);
        registerClass(TLRequestInvokeWithoutUpdates.CLASS_ID, TLRequestInvokeWithoutUpdates.class);
        registerClass(TLRequestMessagesExportChatInvite.CLASS_ID, TLRequestMessagesExportChatInvite.class);
        registerClass(TLRequestMessagesCheckChatInvite.CLASS_ID, TLRequestMessagesCheckChatInvite.class);
        registerClass(TLRequestMessagesImportChatInvite.CLASS_ID, TLRequestMessagesImportChatInvite.class);
    }

    private void addApiLayer32() {
        registerClass(TLBotCommand.CLASS_ID, TLBotCommand.class);
        registerClass(TLBotInfo.CLASS_ID, TLBotInfo.class);
        registerClass(TLInputStickerSetEmpty.CLASS_ID, TLInputStickerSetEmpty.class);
        registerClass(TLInputStickerSetId.CLASS_ID, TLInputStickerSetId.class);
        registerClass(TLInputStickerSetShortName.CLASS_ID, TLInputStickerSetShortName.class);
        registerClass(TLKeyboardButton.CLASS_ID, TLKeyboardButton.class);
        registerClass(TLKeyboardButtonRow.CLASS_ID, TLKeyboardButtonRow.class);
        registerClass(TLReplayKeyboardForceReply.CLASS_ID, TLReplayKeyboardForceReply.class);
        registerClass(TLReplayKeyboardHide.CLASS_ID, TLReplayKeyboardHide.class);
        registerClass(TLReplayKeyboardMarkup.CLASS_ID, TLReplayKeyboardMarkup.class);
        registerClass(TLStickerSet.CLASS_ID, TLStickerSet.class);
        registerClass(TLUser.CLASS_ID, TLUser.class);
        registerClass(TLMessagesFilterUrl.CLASS_ID, TLMessagesFilterUrl.class);
        registerClass(TLMessagesStickerSet.CLASS_ID, TLMessagesStickerSet.class);
        registerClass(TLRequestAuthImportBotAuthorization.CLASS_ID, TLRequestAuthImportBotAuthorization.class);
        registerClass(TLRequestMessagesGetStickersSet.CLASS_ID, TLRequestMessagesGetStickersSet.class);
        registerClass(TLRequestMessagesInstallStickersSet.CLASS_ID, TLRequestMessagesInstallStickersSet.class);
        registerClass(TLRequestMessagesUninstallStickersSet.CLASS_ID, TLRequestMessagesUninstallStickersSet.class);
        registerClass(TLRequestMessagesStartBot.CLASS_ID, TLRequestMessagesStartBot.class);
        registerClass(TLRequestAccountDeleteAccount.CLASS_ID, TLRequestAccountDeleteAccount.class);
    }

    private void addApiLayer38() {
        registerClass(TLAppChangelog.CLASS_ID, TLAppChangelog.class);
        registerClass(TLAppChangelogEmpty.CLASS_ID, TLAppChangelogEmpty.class);
        registerClass(TLChannel.CLASS_ID, TLChannel.class);
        registerClass(TLChannelForbidden.CLASS_ID, TLChannelForbidden.class);
        registerClass(TLChannelFull.CLASS_ID, TLChannelFull.class);
        registerClass(TLChannelMessagesFilter.CLASS_ID, TLChannelMessagesFilter.class);
        registerClass(TLChannelMessagesFilterEmpty.CLASS_ID, TLChannelMessagesFilterEmpty.class);
        registerClass(TLInputChannel.CLASS_ID, TLInputChannel.class);
        registerClass(TLInputChannelEmpty.CLASS_ID, TLInputChannelEmpty.class);
        registerClass(TLInputPeerChannel.CLASS_ID, TLInputPeerChannel.class);
        registerClass(TLMessageActionChannelCreate.CLASS_ID, TLMessageActionChannelCreate.class);
        registerClass(TLMessageEntityBold.CLASS_ID, TLMessageEntityBold.class);
        registerClass(TLMessageEntityBotCommand.CLASS_ID, TLMessageEntityBotCommand.class);
        registerClass(TLMessageEntityCode.CLASS_ID, TLMessageEntityCode.class);
        registerClass(TLMessageEntityEmail.CLASS_ID, TLMessageEntityEmail.class);
        registerClass(TLMessageEntityHashtag.CLASS_ID, TLMessageEntityHashtag.class);
        registerClass(TLMessageEntityItalic.CLASS_ID, TLMessageEntityItalic.class);
        registerClass(TLMessageEntityMention.CLASS_ID, TLMessageEntityMention.class);
        registerClass(TLMessageEntityPre.CLASS_ID, TLMessageEntityPre.class);
        registerClass(TLMessageEntityTextUrl.CLASS_ID, TLMessageEntityTextUrl.class);
        registerClass(TLMessageEntityUnknown.CLASS_ID, TLMessageEntityUnknown.class);
        registerClass(TLMessageEntityUrl.CLASS_ID, TLMessageEntityUrl.class);
        registerClass(TLMessageRange.CLASS_ID, TLMessageRange.class);
        registerClass(TLPeerChannel.CLASS_ID, TLPeerChannel.class);
        registerClass(TLRequestHelpGetAppChangelog.CLASS_ID, TLRequestHelpGetAppChangelog.class);
        registerClass(TLRequestChannelsCreateChannel.CLASS_ID, TLRequestChannelsCreateChannel.class);
        registerClass(TLRequestChannelsDeleteMessages.CLASS_ID, TLRequestChannelsDeleteMessages.class);
        registerClass(TLRequestChannelsReadHistory.CLASS_ID, TLRequestChannelsReadHistory.class);
        registerClass(TLRequestUpdatesGetChannelDifference.CLASS_ID, TLRequestUpdatesGetChannelDifference.class);
        registerClass(TLUpdateChannel.CLASS_ID, TLUpdateChannel.class);
        registerClass(TLUpdateChannelNewMessage.CLASS_ID, TLUpdateChannelNewMessage.class);
        registerClass(TLUpdateChannelTooLong.CLASS_ID, TLUpdateChannelTooLong.class);
        registerClass(TLUpdateChannelMessageViews.CLASS_ID, TLUpdateChannelMessageViews.class);
        registerClass(TLUpdateDeleteChannelMessages.CLASS_ID, TLUpdateDeleteChannelMessages.class);
        registerClass(TLUpdateReadChannelInbox.CLASS_ID, TLUpdateReadChannelInbox.class);
        registerClass(TLUpdatesChannelDifferences.CLASS_ID, TLUpdatesChannelDifferences.class);
        registerClass(TLUpdatesChannelDifferencesEmpty.CLASS_ID, TLUpdatesChannelDifferencesEmpty.class);
        registerClass(TLUpdatesChannelDifferencesTooLong.CLASS_ID, TLUpdatesChannelDifferencesTooLong.class);
        registerClass(TLUpdateShortSentMessage.CLASS_ID, TLUpdateShortSentMessage.class);
        registerClass(TLResolvedPeer.CLASS_ID, TLResolvedPeer.class);
        registerClass(TLChannelMessages.CLASS_ID, TLChannelMessages.class);
        registerClass(TLChannelParticipant.CLASS_ID, TLChannelParticipant.class);
        registerClass(TLChannelParticipantSelf.CLASS_ID, TLChannelParticipantSelf.class);
        registerClass(TLChannelParticipantModerator.CLASS_ID, TLChannelParticipantModerator.class);
        registerClass(TLChannelParticipantEditor.CLASS_ID, TLChannelParticipantEditor.class);
        registerClass(TLChannelParticipantKicked.CLASS_ID, TLChannelParticipantKicked.class);
        registerClass(TLChannelParticipantCreator.CLASS_ID, TLChannelParticipantCreator.class);
        registerClass(TLChannelParticipantsFilterRecent.CLASS_ID, TLChannelParticipantsFilterRecent.class);
        registerClass(TLChannelParticipantsFilterAdmins.CLASS_ID, TLChannelParticipantsFilterAdmins.class);
        registerClass(TLChannelParticipantsFilterKicked.CLASS_ID, TLChannelParticipantsFilterKicked.class);
        registerClass(TLChannelParticipantRoleEmpty.CLASS_ID, TLChannelParticipantRoleEmpty.class);
        registerClass(TLChannelParticipantRoleModerator.CLASS_ID, TLChannelParticipantRoleModerator.class);
        registerClass(TLChannelParticipantRoleEditor.CLASS_ID, TLChannelParticipantRoleEditor.class);
        registerClass(TLChannelParticipants.CLASS_ID, TLChannelParticipants.class);
        registerClass(org.telegram.api.channel.TLChannelParticipant.CLASS_ID, org.telegram.api.channel.TLChannelParticipant.class);
        registerClass(TLRequestMessagesReportSpam.CLASS_ID, TLRequestMessagesReportSpam.class);
        registerClass(TLRequestMessagesGetMessagesViews.CLASS_ID, TLRequestMessagesGetMessagesViews.class);
        registerClass(TLRequestChannelsDeleteUserHistory.CLASS_ID, TLRequestChannelsDeleteUserHistory.class);
        registerClass(TLRequestChannelsReportSpam.CLASS_ID, TLRequestChannelsReportSpam.class);
        registerClass(TLRequestChannelsGetMessages.CLASS_ID, TLRequestChannelsGetMessages.class);
        registerClass(TLRequestChannelsGetParticipants.CLASS_ID, TLRequestChannelsGetParticipants.class);
        registerClass(TLRequestChannelsGetParticipant.CLASS_ID, TLRequestChannelsGetParticipant.class);
        registerClass(TLRequestChannelsGetChannels.CLASS_ID, TLRequestChannelsGetParticipant.class);
        registerClass(TLRequestChannelsGetFullChannel.CLASS_ID, TLRequestChannelsGetFullChannel.class);
        registerClass(TLRequestChannelsEditAbout.CLASS_ID, TLRequestChannelsEditAbout.class);
        registerClass(TLRequestChannelsEditTitle.CLASS_ID, TLRequestChannelsEditTitle.class);
        registerClass(TLRequestChannelsCheckUsername.CLASS_ID, TLRequestChannelsCheckUsername.class);
        registerClass(TLRequestChannelsUpdateUsername.CLASS_ID, TLRequestChannelsUpdateUsername.class);
        registerClass(TLRequestChannelsEditAdmin.CLASS_ID, TLRequestChannelsEditAdmin.class);
        registerClass(TLRequestChannelsEditPhoto.CLASS_ID, TLRequestChannelsEditPhoto.class);
        registerClass(TLRequestChannelsJoinChannel.CLASS_ID, TLRequestChannelsJoinChannel.class);
        registerClass(TLRequestChannelsLeaveChannel.CLASS_ID, TLRequestChannelsLeaveChannel.class);
        registerClass(TLRequestChannelsExportInvite.CLASS_ID, TLRequestChannelsExportInvite.class);
        registerClass(TLRequestChannelsDeleteChannel.CLASS_ID, TLRequestChannelsDeleteChannel.class);
        registerClass(TLRequestChannelsInviteToChannel.CLASS_ID, TLRequestChannelsInviteToChannel.class);
        registerClass(TLRequestChannelsKickFromChannel.CLASS_ID, TLRequestChannelsKickFromChannel.class);
    }

    private void addApiLayer45() {
        registerClass(TLTrue.CLASS_ID, TLTrue.class);
        registerClass(TLInputMediaGifExternal.CLASS_ID, TLInputMediaGifExternal.class);
        registerClass(TLChatParticipantCreator.CLASS_ID, TLChatParticipantCreator.class);
        registerClass(TLChatParticipantAdmin.CLASS_ID, TLChatParticipantAdmin.class);
        registerClass(TLMessageActionMigrateTo.CLASS_ID, TLMessageActionMigrateTo.class);
        registerClass(TLMessageActionChannelMigratedFrom.CLASS_ID, TLMessageActionChannelMigratedFrom.class);
        registerClass(TLReportSpamReasonSpam.CLASS_ID, TLReportSpamReasonSpam.class);
        registerClass(TLReportSpamReasonViolence.CLASS_ID, TLReportSpamReasonViolence.class);
        registerClass(TLReportSpamReasonPornography.CLASS_ID, TLReportSpamReasonPornography.class);
        registerClass(TLReportSpamReasonOther.CLASS_ID, TLReportSpamReasonOther.class);
        registerClass(TLMessagesFilterGif.CLASS_ID, TLMessagesFilterGif.class);
        registerClass(TLMessagesFilterVoice.CLASS_ID, TLMessagesFilterVoice.class);
        registerClass(TLMessagesFilterMusic.CLASS_ID, TLMessagesFilterMusic.class);
        registerClass(TLUpdateChatAdmin.CLASS_ID, TLUpdateChatAdmin.class);
        registerClass(TLUpdateChatParticipantAdmin.CLASS_ID, TLUpdateChatParticipantAdmin.class);
        registerClass(TLUpdateNewStickerSet.CLASS_ID, TLUpdateNewStickerSet.class);
        registerClass(TLUpdateStickerSetsOrder.CLASS_ID, TLUpdateStickerSetsOrder.class);
        registerClass(TLUpdateStickerSets.CLASS_ID, TLUpdateStickerSets.class);
        registerClass(TLUpdateSavedGifs.CLASS_ID, TLUpdateSavedGifs.class);
        registerClass(TLUpdateBotInlineQuery.CLASS_ID, TLUpdateBotInlineQuery.class);
        registerClass(TLUpdateBotInlineSend.CLASS_ID, TLUpdateBotInlineSend.class);
        registerClass(TLInputPrivacyKeyChatInvite.CLASS_ID, TLInputPrivacyKeyChatInvite.class);
        registerClass(TLPrivacyKeyChatInvite.CLASS_ID, TLPrivacyKeyChatInvite.class);
        registerClass(TLChannelParticipantsFilterBots.CLASS_ID, TLChannelParticipantsFilterBots.class);
        registerClass(TLTermsOfService.CLASS_ID, TLTermsOfService.class);
        registerClass(TLFoundGif.CLASS_ID, TLFoundGif.class);
        registerClass(TLFoundGifCached.CLASS_ID, TLFoundGifCached.class);
        registerClass(TLFoundGifs.CLASS_ID, TLFoundGifs.class);
        registerClass(TLSavedGifs.CLASS_ID, TLSavedGifs.class);
        registerClass(TLSavedGifsNotModified.CLASS_ID, TLSavedGifsNotModified.class);
        registerClass(TLInputBotInlineMessageMediaAuto.CLASS_ID, TLInputBotInlineMessageMediaAuto.class);
        registerClass(TLInputBotInlineMessageText.CLASS_ID, TLInputBotInlineMessageText.class);
        registerClass(TLInputBotInlineResult.CLASS_ID, TLInputBotInlineResult.class);
        registerClass(TLBotInlineMessageMediaAuto.CLASS_ID, TLBotInlineMessageMediaAuto.class);
        registerClass(TLBotInlineMessageText.CLASS_ID, TLBotInlineMessageText.class);
        registerClass(TLBotInlineResult.CLASS_ID, TLBotInlineResult.class);
        registerClass(TLBotInlineMediaResult.CLASS_ID, TLBotInlineMediaResult.class);
        registerClass(TLBotResults.CLASS_ID, TLBotResults.class);
        registerClass(TLRequestAccountReportPeer.CLASS_ID, TLRequestAccountReportPeer.class);
        registerClass(TLRequestHelpGetTermsOfService.CLASS_ID, TLRequestHelpGetTermsOfService.class);
        registerClass(TLRequestMessagesToggleChatAdmins.CLASS_ID, TLRequestMessagesToggleChatAdmins.class);
        registerClass(TLRequestMessagesEditChatAdmin.CLASS_ID, TLRequestMessagesEditChatAdmin.class);
        registerClass(TLRequestMessagesMigrateChat.CLASS_ID, TLRequestMessagesMigrateChat.class);
        registerClass(TLRequestMessagesSearchGlobal.CLASS_ID, TLRequestMessagesSearchGlobal.class);
        registerClass(TLRequestMessagesReorderStickerSets.CLASS_ID, TLRequestMessagesReorderStickerSets.class);
        registerClass(TLRequestMessagesGetDocumentByHash.CLASS_ID, TLRequestMessagesGetDocumentByHash.class);
        registerClass(TLRequestMessagesSearchGifs.CLASS_ID, TLRequestMessagesSearchGifs.class);
        registerClass(TLRequestMessagesGetSavedGifs.CLASS_ID, TLRequestMessagesGetSavedGifs.class);
        registerClass(TLRequestMessagesSaveGif.CLASS_ID, TLRequestMessagesSaveGif.class);
        registerClass(TLRequestMessagesGetInlineBotResults.CLASS_ID, TLRequestMessagesGetInlineBotResults.class);
        registerClass(TLRequestMessagesSetInlineBotResults.CLASS_ID, TLRequestMessagesSetInlineBotResults.class);
        registerClass(TLRequestMessagesSendInlineBotResults.CLASS_ID, TLRequestMessagesSendInlineBotResults.class);
    }

    private void addApiLayer50() {
        registerClass(TLMessageActionPinMessage.CLASS_ID, TLMessageActionPinMessage.class);
        registerClass(TLSentCodeTypeApp.CLASS_ID, TLSentCodeTypeApp.class);
        registerClass(TLSentCodeTypeSms.CLASS_ID, TLSentCodeTypeSms.class);
        registerClass(TLSentCodeTypeCall.CLASS_ID, TLSentCodeTypeCall.class);
        registerClass(TLSentCodeTypeFlashCall.CLASS_ID, TLSentCodeTypeFlashCall.class);
        registerClass(TLPeerSettings.CLASS_ID, TLPeerSettings.class);
        registerClass(TLUpdateEditChannelMessage.CLASS_ID, TLUpdateEditChannelMessage.class);
        registerClass(TLUpdateChannelPinnedMessage.CLASS_ID, TLUpdateChannelPinnedMessage.class);
        registerClass(TLExportedMessageLink.CLASS_ID, TLExportedMessageLink.class);
        registerClass(TLMessageFwdHeader.CLASS_ID, TLMessageFwdHeader.class);
        registerClass(TLCodeTypeSms.CLASS_ID, TLCodeTypeSms.class);
        registerClass(TLCodeTypeCall.CLASS_ID, TLCodeTypeCall.class);
        registerClass(TLCodeTypeFlashCall.CLASS_ID, TLCodeTypeFlashCall.class);
        registerClass(TLRequestAuthResendCode.CLASS_ID, TLRequestAuthResendCode.class);
        registerClass(TLRequestAuthCancelCode.CLASS_ID, TLRequestAuthCancelCode.class);
        registerClass(TLRequestMessagesHideReportSpam.CLASS_ID, TLRequestMessagesHideReportSpam.class);
        registerClass(TLRequestMessagesGetPeerSettings.CLASS_ID, TLRequestMessagesGetPeerSettings.class);
        registerClass(TLRequestChannelsExportMessageLink.CLASS_ID, TLRequestChannelsExportMessageLink.class);
        registerClass(TLRequestChannelsToggleSignatures.CLASS_ID, TLRequestChannelsToggleSignatures.class);
        registerClass(TLRequestMessagesGetMessageEditData.CLASS_ID, TLRequestMessagesGetMessageEditData.class);
        registerClass(TLRequestMessagesEditMessage.CLASS_ID, TLRequestMessagesEditMessage.class);
        registerClass(TLRequestChannelsUpdatePinnedMessage.CLASS_ID, TLRequestChannelsUpdatePinnedMessage.class);
    }

    private void addApiLayer51(){
        registerClass(TLUpdateBotCallbackQuery.CLASS_ID, TLUpdateBotCallbackQuery.class);
        registerClass(TLUpdateEditMessage.CLASS_ID, TLUpdateEditMessage.class);
        registerClass(TLUpdateInlineBotCallbackQuery.CLASS_ID, TLUpdateInlineBotCallbackQuery.class);
        registerClass(TLKeyboardButtonCallback.CLASS_ID, TLKeyboardButtonCallback.class);
        registerClass(TLKeyboardButtonUrl.CLASS_ID, TLKeyboardButtonUrl.class);
        registerClass(TLKeyboardButtonRequestPhone.CLASS_ID, TLKeyboardButtonRequestPhone.class);
        registerClass(TLKeyboardButtonRequestGeoLocation.CLASS_ID, TLKeyboardButtonRequestGeoLocation.class);
        registerClass(TLKeyboardButtonRequestSwitchInline.CLASS_ID, TLKeyboardButtonRequestSwitchInline.class);
        registerClass(TLReplayInlineKeyboardMarkup.CLASS_ID, TLReplayInlineKeyboardMarkup.class);
        registerClass(TLInputBotInlineMessageMediaGeo.CLASS_ID, TLInputBotInlineMessageMediaGeo.class);
        registerClass(TLInputBotInlineMessageMediaVenue.CLASS_ID, TLInputBotInlineMessageMediaVenue.class);
        registerClass(TLInputBotInlineMessageMediaContact.CLASS_ID, TLInputBotInlineMessageMediaContact.class);
        registerClass(TLInputBotInlineResultPhoto.CLASS_ID, TLInputBotInlineResultPhoto.class);
        registerClass(TLInputBotInlineResultDocument.CLASS_ID, TLInputBotInlineResultDocument.class);
        registerClass(TLBotInlineMessageMediaGeo.CLASS_ID, TLBotInlineMessageMediaGeo.class);
        registerClass(TLBotInlineMessageMediaVenue.CLASS_ID, TLBotInlineMessageMediaVenue.class);
        registerClass(TLBotInlineMessageMediaContact.CLASS_ID, TLBotInlineMessageMediaContact.class);
        registerClass(TLMessagesEditData.CLASS_ID, TLMessagesEditData.class);
        registerClass(TLMessagesBotCallbackAnswer.CLASS_ID, TLMessagesBotCallbackAnswer.class);
        registerClass(TLInputBotInlineMessageId.CLASS_ID, TLInputBotInlineMessageId.class);
        registerClass(TLInlineBotSwitchPm.CLASS_ID, TLInlineBotSwitchPm.class);
        registerClass(TLRequestMessagesEditInlineBotMessage.CLASS_ID, TLRequestMessagesEditInlineBotMessage.class);
        registerClass(TLRequestMessagesGetBotCallbackAnswer.CLASS_ID, TLRequestMessagesGetBotCallbackAnswer.class);
        registerClass(TLRequestMessagesSetBotCallbackAnswer.CLASS_ID, TLRequestMessagesSetBotCallbackAnswer.class);
    }

    private void addApiLayer55() {
        registerClass(TLContactsTopPeers.CLASS_ID, TLContactsTopPeers.class);
        registerClass(TLContactsTopPeersNotModified.CLASS_ID, TLContactsTopPeersNotModified.class);
        registerClass(TLDraftMessage.CLASS_ID, TLDraftMessage.class);
        registerClass(TLDraftMessageEmpty.CLASS_ID, TLDraftMessageEmpty.class);
        registerClass(TLInputMediaDocumentExternal.CLASS_ID, TLInputMediaDocumentExternal.class);
        registerClass(TLInputMediaPhotoExternal.CLASS_ID, TLInputMediaPhotoExternal.class);
        registerClass(TLInputMessageEntityMentionName.CLASS_ID, TLInputMessageEntityMentionName.class);
        registerClass(TLMessageActionHistoryClear.CLASS_ID, TLMessageActionHistoryClear.class);
        registerClass(TLMessageEntityMentionName.CLASS_ID, TLMessageEntityMentionName.class);
        registerClass(TLMessagesArchivedStickers.CLASS_ID, TLMessagesArchivedStickers.class);
        registerClass(TLMessagesFeaturedStickers.CLASS_ID, TLMessagesFeaturedStickers.class);
        registerClass(TLMessagesFeaturedStickersNotModified.CLASS_ID, TLMessagesFeaturedStickersNotModified.class);
        registerClass(TLMessagesFilterChatPhoto.CLASS_ID, TLMessagesFilterChatPhoto.class);
        registerClass(TLMessagesPeerDialogs.CLASS_ID, TLMessagesPeerDialogs.class);
        registerClass(TLMessagesRecentStickers.CLASS_ID, TLMessagesRecentStickers.class);
        registerClass(TLMessagesRecentStickersNotModified.CLASS_ID, TLMessagesRecentStickersNotModified.class);
        registerClass(TLMessagesStickerSetInstallResultArchive.CLASS_ID, TLMessagesStickerSetInstallResultArchive.class);
        registerClass(TLMessagesStickerSetInstallResultSuccess.CLASS_ID, TLMessagesStickerSetInstallResultSuccess.class);
        registerClass(TLTopPeer.CLASS_ID, TLTopPeer.class);
        registerClass(TLTopPeerCategoryBotsInline.CLASS_ID, TLTopPeerCategoryBotsInline.class);
        registerClass(TLTopPeerCategoryBotsPM.CLASS_ID, TLTopPeerCategoryBotsPM.class);
        registerClass(TLTopPeerCategoryChannels.CLASS_ID, TLTopPeerCategoryChannels.class);
        registerClass(TLTopPeerCategoryCorrespondents.CLASS_ID, TLTopPeerCategoryCorrespondents.class);
        registerClass(TLTopPeerCategoryGroups.CLASS_ID, TLTopPeerCategoryGroups.class);
        registerClass(TLTopPeerCategoryPeers.CLASS_ID, TLTopPeerCategoryPeers.class);
        registerClass(TLUpdateConfig.CLASS_ID, TLUpdateConfig.class);
        registerClass(TLUpdateDraftMessage.CLASS_ID, TLUpdateDraftMessage.class);
        registerClass(TLUpdatePtsChanged.CLASS_ID, TLUpdatePtsChanged.class);
        registerClass(TLUpdateReadChannelOutbox.CLASS_ID, TLUpdateReadChannelOutbox.class);
        registerClass(TLUpdateReadFeaturedStickers.CLASS_ID, TLUpdateReadFeaturedStickers.class);
        registerClass(TLUpdateRecentStickers.CLASS_ID, TLUpdateRecentStickers.class);
        registerClass(TLRequestAccountSendConfirmPhoneCode.CLASS_ID, TLRequestAccountSendConfirmPhoneCode.class);
        registerClass(TLRequestAccountConfirmPhone.CLASS_ID, TLRequestAccountConfirmPhone.class);
        registerClass(TLRequestContactsGetTopPeers.CLASS_ID, TLRequestContactsGetTopPeers.class);
        registerClass(TLRequestContactsResetTopPeerRating.CLASS_ID, TLRequestContactsResetTopPeerRating.class);
        registerClass(TLRequestMessagesGetPeerDialogs.CLASS_ID, TLRequestMessagesGetPeerDialogs.class);
        registerClass(TLRequestMessagesSaveDraft.CLASS_ID, TLRequestMessagesSaveDraft.class);
        registerClass(TLRequestMessagesGetAllDrafts.CLASS_ID, TLRequestMessagesGetAllDrafts.class);
        registerClass(TLRequestMessagesGetFeaturedStickers.CLASS_ID, TLRequestMessagesGetFeaturedStickers.class);
        registerClass(TLRequestMessagesReadFeaturedStickers.CLASS_ID, TLRequestMessagesReadFeaturedStickers.class);
        registerClass(TLRequestMessagesGetRecentStickers.CLASS_ID, TLRequestMessagesGetRecentStickers.class);
        registerClass(TLRequestMessagesSaveRecentStickers.CLASS_ID, TLRequestMessagesSaveRecentStickers.class);
        registerClass(TLRequestMessagesClearRecentStickers.CLASS_ID, TLRequestMessagesClearRecentStickers.class);
        registerClass(TLRequestMessagesGetArchivedStickers.CLASS_ID, TLRequestMessagesGetArchivedStickers.class);
        registerClass(TLRequestChannelsGetAdminedPublicChannels.CLASS_ID, TLRequestChannelsGetAdminedPublicChannels.class);
    }

    private void addApiLayer56() {
        registerClass(TLMessageActionGameScore.CLASS_ID, TLMessageActionGameScore.class);
        registerClass(TLDocumentAttributeHasStickers.CLASS_ID, TLDocumentAttributeHasStickers.class);
        registerClass(TLKeyboardButtonGame.CLASS_ID, TLKeyboardButtonGame.class);
        registerClass(TLStickerSetCovered.CLASS_ID, TLStickerSetCovered.class);
        registerClass(TLStickerSetMultiCovered.CLASS_ID, TLStickerSetMultiCovered.class);
        registerClass(TLMaskCoords.CLASS_ID, TLMaskCoords.class);
        registerClass(TLInputStickeredMediaPhoto.CLASS_ID, TLInputStickeredMediaPhoto.class);
        registerClass(TLInputStickeredMediaDocument.CLASS_ID, TLInputStickeredMediaDocument.class);
        registerClass(TLHighScore.CLASS_ID, TLHighScore.class);
        registerClass(TLMessagesHighScores.CLASS_ID, TLMessagesHighScores.class);
        registerClass(TLRequestAuthDropTempAuthKeys.CLASS_ID, TLRequestAuthDropTempAuthKeys.class);
        registerClass(TLRequestMessagesSetGameScore.CLASS_ID, TLRequestMessagesSetGameScore.class);
        registerClass(TLRequestMessagesGetGameHighScores.CLASS_ID, TLRequestMessagesGetGameHighScores.class);
        registerClass(TLRequestMessagesGetInlineGameHighScores.CLASS_ID, TLRequestMessagesGetInlineGameHighScores.class);
        registerClass(TLRequestMessagesGetMaskStickers.CLASS_ID, TLRequestMessagesGetMaskStickers.class);
        registerClass(TLRequestMessagesGetAttachedStickers.CLASS_ID, TLRequestMessagesGetAttachedStickers.class);
    }

    private void addApiLayer57() {
        registerClass(TLInputMediaGame.CLASS_ID, TLInputMediaGame.class);
        registerClass(TLMessageMediaGame.CLASS_ID, TLMessageMediaGame.class);
        registerClass(TLSendMessageGamePlayAction.CLASS_ID, TLSendMessageGamePlayAction.class);
        registerClass(TLInputBotInlineMessageGame.CLASS_ID, TLInputBotInlineMessageGame.class);
        registerClass(TLInputBotInlineResultGame.CLASS_ID, TLInputBotInlineResultGame.class);
        registerClass(TLGame.CLASS_ID, TLGame.class);
        registerClass(TLInputGameId.CLASS_ID, TLInputGameId.class);
        registerClass(TLInputGameShortName.CLASS_ID, TLInputGameShortName.class);
        registerClass(TLRequestMessagesSetInlineGameScore.CLASS_ID, TLRequestMessagesSetInlineGameScore.class);
    }
}