/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.chat.invite;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.chat.invite.TLAbsChatInvite;
import org.telegram.api.photo.TLAbsPhoto;
import org.telegram.api.user.TLAbsUser;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLVector;

public class TLChatInvite
extends TLAbsChatInvite {
    public static final int CLASS_ID = -613092008;
    private static final int FLAG_CHANNEL = 1;
    private static final int FLAG_BROADCAST = 2;
    private static final int FLAG_PUBLIC = 4;
    private static final int FLAG_MEGAGROUP = 8;
    private static final int FLAG_PARTICIPANTS = 16;
    private int flags;
    private String title;
    private TLAbsPhoto photo;
    private int participantsCount;
    private TLVector<TLAbsUser> participants;

    @Override
    public int getClassId() {
        return -613092008;
    }

    public String getTitle() {
        return this.title;
    }

    public TLAbsPhoto getPhoto() {
        return this.photo;
    }

    public int getParticipantsCount() {
        return this.participantsCount;
    }

    public TLVector<TLAbsUser> getParticipants() {
        return this.participants;
    }

    public boolean isChannel() {
        return (this.flags & 1) != 0;
    }

    public boolean isBroadcast() {
        return (this.flags & 2) != 0;
    }

    public boolean isPublic() {
        return (this.flags & 4) != 0;
    }

    public boolean isMegagroup() {
        return (this.flags & 8) != 0;
    }

    public boolean hasParticipants() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        super.serializeBody(stream);
        StreamingUtils.writeInt(this.flags, stream);
        StreamingUtils.writeTLString(this.title, stream);
        StreamingUtils.writeTLObject(this.photo, stream);
        StreamingUtils.writeInt(this.participantsCount, stream);
        if ((this.flags & 0x10) != 0) {
            StreamingUtils.writeTLVector(this.participants, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        super.deserializeBody(stream, context);
        this.flags = StreamingUtils.readInt(stream);
        this.title = StreamingUtils.readTLString(stream);
        this.photo = (TLAbsPhoto)StreamingUtils.readTLObject(stream, context);
        this.participantsCount = StreamingUtils.readInt(stream);
        if ((this.flags & 0x10) != 0) {
            this.participants = StreamingUtils.readTLVector(stream, context, TLAbsUser.class);
        }
    }

    @Override
    public String toString() {
        return "chatInvite#db74f558";
    }
}

