/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.functions.messages;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.input.peer.TLAbsInputPeer;
import org.telegram.api.message.entity.TLAbsMessageEntity;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLBool;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLMethod;
import org.telegram.tl.TLObject;
import org.telegram.tl.TLVector;

public class TLRequestMessagesSaveDraft
extends TLMethod<TLBool> {
    public static final int CLASS_ID = -1137057461;
    private static final int FLAG_REPLY_TO_MSG_ID = 1;
    private static final int FLAG_NO_WEBPAGE = 2;
    private static final int FLAG_UNUSED_2 = 4;
    private static final int FLAG_ENTITIES = 8;
    private int flags;
    private int replyToMsgId;
    private TLAbsInputPeer peer;
    private String message;
    private TLVector<TLAbsMessageEntity> entitites;

    @Override
    public int getClassId() {
        return -1137057461;
    }

    @Override
    public TLBool deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject res = StreamingUtils.readTLObject(stream, context);
        if (res == null) {
            throw new IOException("Unable to parse response");
        }
        if (res instanceof TLBool) {
            return (TLBool)res;
        }
        throw new IOException("Incorrect response type. Expected " + TLBool.class.getName() + ", got: " + res.getClass().getCanonicalName());
    }

    public int getReplyToMsgId() {
        return this.replyToMsgId;
    }

    public void setReplyToMsgId(int replyToMsgId) {
        this.flags |= 1;
        this.replyToMsgId = replyToMsgId;
    }

    public TLAbsInputPeer getPeer() {
        return this.peer;
    }

    public void setPeer(TLAbsInputPeer peer) {
        this.peer = peer;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public TLVector<TLAbsMessageEntity> getEntitites() {
        return this.entitites;
    }

    public void setEntitites(TLVector<TLAbsMessageEntity> entitites) {
        this.flags |= 8;
        this.entitites = entitites;
    }

    public boolean hasWebPreview() {
        return (this.flags & 2) == 0;
    }

    public void disableWebPreview() {
        this.flags |= 2;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        if ((this.flags & 1) != 0) {
            StreamingUtils.writeInt(this.replyToMsgId, stream);
        }
        StreamingUtils.writeTLObject(this.peer, stream);
        StreamingUtils.writeTLString(this.message, stream);
        if ((this.flags & 8) != 0) {
            StreamingUtils.writeTLVector(this.entitites, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        if ((this.flags & 1) != 0) {
            this.replyToMsgId = StreamingUtils.readInt(stream);
        }
        this.peer = StreamingUtils.readTLObject(stream, context, TLAbsInputPeer.class);
        this.message = StreamingUtils.readTLString(stream);
        if ((this.flags & 8) != 0) {
            this.entitites = StreamingUtils.readTLVector(stream, context, TLAbsMessageEntity.class);
        }
    }

    @Override
    public String toString() {
        return "messages.saveDraft#bc39e14b";
    }
}

