/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.kernel;

import java.lang.reflect.InvocationTargetException;
import org.telegram.api.engine.Logger;
import org.telegram.api.engine.LoggerInterface;
import org.telegram.api.engine.storage.AbsApiState;
import org.telegram.bot.ChatUpdatesBuilder;
import org.telegram.bot.kernel.IKernelComm;
import org.telegram.bot.kernel.KernelAuth;
import org.telegram.bot.kernel.KernelComm;
import org.telegram.bot.kernel.MainHandler;
import org.telegram.bot.kernel.differenceparameters.DifferenceParametersService;
import org.telegram.bot.kernel.engine.MemoryApiState;
import org.telegram.bot.services.BotLogger;
import org.telegram.bot.structure.BotConfig;
import org.telegram.bot.structure.LoginStatus;
import org.telegram.mtproto.log.LogInterface;

public class TelegramBot {
    private static final String LOGTAG = "KERNELMAIN";
    private final BotConfig config;
    private final ChatUpdatesBuilder chatUpdatesBuilder;
    private final int apiKey;
    private final String apiHash;
    private AbsApiState apiState;
    private KernelAuth kernelAuth;
    private MainHandler mainHandler;
    private IKernelComm kernelComm;

    public TelegramBot(BotConfig config, ChatUpdatesBuilder chatUpdatesBuilder, int apiKey, String apiHash) {
        if (config == null) {
            throw new NullPointerException("At least a BotConfig must be added");
        }
        if (chatUpdatesBuilder == null) {
            throw new NullPointerException("At least a ChatUpdatesBuilder must be added");
        }
        BotLogger.info(LOGTAG, "--------------KERNEL CREATED--------------");
        TelegramBot.setLogging();
        this.apiKey = apiKey;
        this.apiHash = apiHash;
        this.config = config;
        this.chatUpdatesBuilder = chatUpdatesBuilder;
        chatUpdatesBuilder.setDifferenceParametersService(new DifferenceParametersService(chatUpdatesBuilder.getDatabaseManager()));
    }

    private static void setLogging() {
        org.telegram.mtproto.log.Logger.registerInterface(new LogInterface(){

            @Override
            public void w(String tag, String message) {
                BotLogger.warn("MTPROTO", message);
            }

            @Override
            public void d(String tag, String message) {
                BotLogger.debug("MTPROTO", message);
            }

            @Override
            public void e(String tag, String message) {
                BotLogger.error("MTPROTO", message);
            }

            @Override
            public void e(String tag, Throwable t) {
                BotLogger.error("MTPROTO", t);
            }
        });
        Logger.registerInterface(new LoggerInterface(){

            @Override
            public void w(String tag, String message) {
                BotLogger.warn("TELEGRAMAPI", message);
            }

            @Override
            public void d(String tag, String message) {
                BotLogger.debug("TELEGRAMAPI", message);
            }

            @Override
            public void e(String tag, Throwable t) {
                BotLogger.error("TELEGRAMAPI", t);
            }
        });
    }

    public LoginStatus init() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        BotLogger.debug(LOGTAG, "Creating API");
        this.apiState = new MemoryApiState(this.config.getAuthfile());
        BotLogger.debug(LOGTAG, "API created");
        this.createKernelComm();
        this.createKernelAuth();
        this.initKernelComm();
        LoginStatus loginResult = this.startKernelAuth();
        this.createKernelHandler();
        BotLogger.info(LOGTAG, "----------------BOT READY-----------------");
        return loginResult;
    }

    public void startBot() {
        this.initKernelHandler();
    }

    public void stopBot() {
        this.mainHandler.stop();
    }

    private void initKernelHandler() {
        long start = System.currentTimeMillis();
        this.mainHandler.start();
        BotLogger.info(LOGTAG, String.format("%s init in %d ms", this.kernelAuth.getClass().getName(), (start - System.currentTimeMillis()) * -1L));
    }

    private void initKernelComm() {
        long start = System.currentTimeMillis();
        this.kernelComm.init();
        BotLogger.info(LOGTAG, String.format("%s init in %d ms", this.kernelComm.getClass().getName(), (start - System.currentTimeMillis()) * -1L));
    }

    private void createKernelAuth() {
        long start = System.currentTimeMillis();
        this.kernelAuth = new KernelAuth(this.apiState, this.config, this.kernelComm, this.apiKey, this.apiHash);
        BotLogger.info(LOGTAG, String.format("%s init in %d ms", this.kernelAuth.getClass().getName(), (start - System.currentTimeMillis()) * -1L));
    }

    private LoginStatus startKernelAuth() {
        long start = System.currentTimeMillis();
        LoginStatus status = this.kernelAuth.start();
        BotLogger.info(LOGTAG, String.format("%s started in %d ms", this.kernelAuth.getClass().getName(), (start - System.currentTimeMillis()) * -1L));
        return status;
    }

    private void createKernelHandler() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        long start = System.currentTimeMillis();
        this.chatUpdatesBuilder.setKernelComm(this.kernelComm);
        this.mainHandler = new MainHandler(this.kernelComm, this.chatUpdatesBuilder.build());
        BotLogger.info(LOGTAG, String.format("%s init in %d ms", this.mainHandler.getClass().getName(), (start - System.currentTimeMillis()) * -1L));
    }

    private void createKernelComm() {
        long start = System.currentTimeMillis();
        this.kernelComm = new KernelComm(this.apiKey, this.apiState);
        BotLogger.info(LOGTAG, String.format("%s init in %d ms", this.getKernelComm().getClass().getName(), (start - System.currentTimeMillis()) * -1L));
    }

    public BotConfig getConfig() {
        return this.config;
    }

    public IKernelComm getKernelComm() {
        return this.kernelComm;
    }

    public KernelAuth getKernelAuth() {
        return this.kernelAuth;
    }

    public MainHandler getMainHandler() {
        return this.mainHandler;
    }

    public boolean isAuthenticated() {
        return this.apiState.isAuthenticated();
    }
}

