/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.functions.contacts;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.contacts.toppeers.TLAbsContactsTopPeers;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLMethod;
import org.telegram.tl.TLObject;

public class TLRequestContactsGetTopPeers
extends TLMethod<TLAbsContactsTopPeers> {
    public static final int CLASS_ID = -728224331;
    private static final int FLAG_CORRESPONDENTS = 1;
    private static final int FLAG_BOTS_PM = 2;
    private static final int FLAG_BOTS_INLINE = 4;
    private static final int FLAG_UNUSED_3 = 8;
    private static final int FLAG_UNUSED_4 = 16;
    private static final int FLAG_UNUSED_5 = 32;
    private static final int FLAG_UNUSED_6 = 64;
    private static final int FLAG_UNUSED_7 = 128;
    private static final int FLAG_UNUSED_8 = 256;
    private static final int FLAG_UNUSED_9 = 512;
    private static final int FLAG_GROUPS = 1024;
    private static final int FLAG_UNUSED_11 = 2048;
    private static final int FLAG_UNUSED_12 = 4096;
    private static final int FLAG_UNUSED_13 = 8192;
    private static final int FLAG_UNUSED_14 = 16384;
    private static final int FLAG_CHANNELS = 32768;
    private int flags;
    private int offset;
    private int limit;
    private int hash;

    @Override
    public int getClassId() {
        return -728224331;
    }

    @Override
    public TLAbsContactsTopPeers deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject res = StreamingUtils.readTLObject(stream, context);
        if (res == null) {
            throw new IOException("Unable to parse response");
        }
        if (res instanceof TLAbsContactsTopPeers) {
            return (TLAbsContactsTopPeers)res;
        }
        throw new IOException("Incorrect response type. Expected " + TLAbsContactsTopPeers.class.getCanonicalName() + ", got: " + res.getClass().getCanonicalName());
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getHash() {
        return this.hash;
    }

    public void setHash(int hash) {
        this.hash = hash;
    }

    public boolean hasCorrespondents() {
        return (this.flags & 1) != 0;
    }

    public void enableCorrespondents() {
        this.flags |= 1;
    }

    public boolean hasBotsPM() {
        return (this.flags & 2) != 0;
    }

    public void enableBotsPM() {
        this.flags |= 2;
    }

    public boolean hasBotsInline() {
        return (this.flags & 4) != 0;
    }

    public void enableBotsInline() {
        this.flags |= 4;
    }

    public boolean hasGroups() {
        return (this.flags & 0x400) != 0;
    }

    public void enableGroups() {
        this.flags |= 0x400;
    }

    public boolean hasChannels() {
        return (this.flags & 0x8000) != 0;
    }

    public void enableChannels() {
        this.flags |= 0x8000;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        StreamingUtils.writeInt(this.offset, stream);
        StreamingUtils.writeInt(this.limit, stream);
        StreamingUtils.writeInt(this.hash, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        this.offset = StreamingUtils.readInt(stream);
        this.limit = StreamingUtils.readInt(stream);
        this.hash = StreamingUtils.readInt(stream);
    }

    @Override
    public String toString() {
        return "contacts.getTopPeers#d4982db5";
    }
}

