/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.paymentapi.payments;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.paymentapi.TLInvoice;
import org.telegram.api.paymentapi.TLPaymentRequestedInfo;
import org.telegram.api.paymentapi.TLShippingOption;
import org.telegram.api.user.TLAbsUser;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLObject;
import org.telegram.tl.TLVector;

public class TLPaymentsPaymentReceipt
extends TLObject {
    public static final int CLASS_ID = 1342771681;
    private static final int FLAG_INFO = 1;
    private static final int FLAG_SHIPPING_OPTIONS = 2;
    private int flags;
    private int date;
    private int botId;
    private TLInvoice invoice;
    private int providerId;
    private TLPaymentRequestedInfo info;
    private TLShippingOption shipping;
    private String currency;
    private long totalAmount;
    private String credentialsTitle;
    private TLVector<TLAbsUser> users;

    @Override
    public int getClassId() {
        return 1342771681;
    }

    public int getDate() {
        return this.date;
    }

    public int getBotId() {
        return this.botId;
    }

    public TLInvoice getInvoice() {
        return this.invoice;
    }

    public int getProviderId() {
        return this.providerId;
    }

    public TLPaymentRequestedInfo getInfo() {
        return this.info;
    }

    public TLShippingOption getShipping() {
        return this.shipping;
    }

    public String getCurrency() {
        return this.currency;
    }

    public long getTotalAmount() {
        return this.totalAmount;
    }

    public String getCredentialsTitle() {
        return this.credentialsTitle;
    }

    public TLVector<TLAbsUser> getUsers() {
        return this.users;
    }

    public boolean hasInfo() {
        return (this.flags & 1) != 0;
    }

    public boolean hasShippingInfo() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        StreamingUtils.writeInt(this.date, stream);
        StreamingUtils.writeInt(this.botId, stream);
        StreamingUtils.writeTLObject(this.invoice, stream);
        StreamingUtils.writeInt(this.providerId, stream);
        if (this.hasInfo()) {
            StreamingUtils.writeTLObject(this.info, stream);
        }
        if (this.hasShippingInfo()) {
            StreamingUtils.writeTLObject(this.shipping, stream);
        }
        StreamingUtils.writeTLString(this.currency, stream);
        StreamingUtils.writeLong(this.totalAmount, stream);
        StreamingUtils.writeTLString(this.credentialsTitle, stream);
        StreamingUtils.writeTLVector(this.users, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        this.date = StreamingUtils.readInt(stream);
        this.botId = StreamingUtils.readInt(stream);
        this.invoice = StreamingUtils.readTLObject(stream, context, TLInvoice.class);
        this.providerId = StreamingUtils.readInt(stream);
        if (this.hasInfo()) {
            this.info = StreamingUtils.readTLObject(stream, context, TLPaymentRequestedInfo.class);
        }
        if (this.hasShippingInfo()) {
            this.shipping = StreamingUtils.readTLObject(stream, context, TLShippingOption.class);
        }
        this.currency = StreamingUtils.readTLString(stream);
        this.totalAmount = StreamingUtils.readLong(stream);
        this.credentialsTitle = StreamingUtils.readTLString(stream);
        this.users = StreamingUtils.readTLVector(stream, context, TLAbsUser.class);
    }

    @Override
    public String toString() {
        return "payments.paymentReceipt#500911e1";
    }
}

