/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.bot;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jersey.repackaged.com.google.common.base.Throwables;
import org.apache.commons.io.IOUtils;
import org.telegram.abilitybots.api.db.DBContext;
import org.telegram.abilitybots.api.db.MapDBContext;
import org.telegram.abilitybots.api.objects.Ability;
import org.telegram.abilitybots.api.objects.EndUser;
import org.telegram.abilitybots.api.objects.Flag;
import org.telegram.abilitybots.api.objects.Locality;
import org.telegram.abilitybots.api.objects.MessageContext;
import org.telegram.abilitybots.api.objects.Privacy;
import org.telegram.abilitybots.api.objects.Reply;
import org.telegram.abilitybots.api.sender.DefaultMessageSender;
import org.telegram.abilitybots.api.sender.MessageSender;
import org.telegram.abilitybots.api.util.AbilityUtils;
import org.telegram.abilitybots.api.util.Pair;
import org.telegram.abilitybots.api.util.Trio;
import org.telegram.telegrambots.api.methods.GetFile;
import org.telegram.telegrambots.api.methods.send.SendDocument;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.Update;
import org.telegram.telegrambots.bots.DefaultAbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.exceptions.TelegramApiException;
import org.telegram.telegrambots.logging.BotLogger;

public abstract class AbilityBot
extends TelegramLongPollingBot {
    private static final String TAG = AbilityBot.class.getSimpleName();
    public static final String ADMINS = "ADMINS";
    public static final String USERS = "USERS";
    public static final String USER_ID = "USER_ID";
    public static final String BLACKLIST = "BLACKLIST";
    protected static final String DEFAULT = "default";
    protected static final String CLAIM = "claim";
    protected static final String BAN = "ban";
    protected static final String PROMOTE = "promote";
    protected static final String DEMOTE = "demote";
    protected static final String UNBAN = "unban";
    protected static final String BACKUP = "backup";
    protected static final String RECOVER = "recover";
    protected static final String COMMANDS = "commands";
    protected static final String RECOVERY_MESSAGE = "I am ready to receive the backup file. Please reply to this message with the backup file attached.";
    protected static final String RECOVER_SUCCESS = "I have successfully recovered.";
    protected final DBContext db;
    protected MessageSender sender;
    private final String botToken;
    private final String botUsername;
    private Map<String, Ability> abilities;
    private List<Reply> replies;

    protected AbilityBot(String botToken, String botUsername, DBContext db, DefaultBotOptions botOptions) {
        super(botOptions);
        this.botToken = botToken;
        this.botUsername = botUsername;
        this.db = db;
        this.sender = new DefaultMessageSender((DefaultAbsSender)this);
        this.registerAbilities();
    }

    protected AbilityBot(String botToken, String botUsername, DBContext db) {
        this(botToken, botUsername, db, new DefaultBotOptions());
    }

    protected AbilityBot(String botToken, String botUsername, DefaultBotOptions botOptions) {
        this(botToken, botUsername, MapDBContext.onlineInstance(botUsername), botOptions);
    }

    protected AbilityBot(String botToken, String botUsername) {
        this(botToken, botUsername, MapDBContext.onlineInstance(botUsername));
    }

    public abstract int creatorId();

    protected Map<Integer, EndUser> users() {
        return this.db.getMap(USERS);
    }

    protected Map<String, Integer> userIds() {
        return this.db.getMap(USER_ID);
    }

    protected Set<Integer> blacklist() {
        return this.db.getSet(BLACKLIST);
    }

    protected Set<Integer> admins() {
        return this.db.getSet(ADMINS);
    }

    public void onUpdateReceived(Update update) {
        BotLogger.info((String)String.format("New update [%s] received at %s", update.getUpdateId(), ZonedDateTime.now()), (String)String.format("%s - %s", TAG, this.botUsername));
        BotLogger.info((String)update.toString(), (String)TAG);
        long millisStarted = System.currentTimeMillis();
        Stream.of(update).filter(this::checkGlobalFlags).filter(this::checkBlacklist).map(this::addUser).filter(this::filterReply).map(this::getAbility).filter(this::validateAbility).filter(this::checkPrivacy).filter(this::checkLocality).filter(this::checkInput).filter(this::checkMessageFlags).map(this::getContext).map(this::consumeUpdate).forEach(this::postConsumption);
        long processingTime = System.currentTimeMillis() - millisStarted;
        BotLogger.info((String)String.format("Processing of update [%s] ended at %s%n---> Processing time: [%d ms] <---%n", update.getUpdateId(), ZonedDateTime.now(), processingTime), (String)String.format("%s - %s", TAG, this.botUsername));
    }

    public String getBotToken() {
        return this.botToken;
    }

    public String getBotUsername() {
        return this.botUsername;
    }

    protected boolean checkGlobalFlags(Update update) {
        return Flag.MESSAGE.test(update);
    }

    protected EndUser getUser(String username) {
        Integer id = this.userIds().get(username.toLowerCase());
        if (id == null) {
            throw new IllegalStateException(String.format("Could not find ID corresponding to username [%s]", username));
        }
        return this.getUser(id);
    }

    protected EndUser getUser(int id) {
        EndUser endUser = this.users().get(id);
        if (endUser == null) {
            throw new IllegalStateException(String.format("Could not find user corresponding to id [%d]", id));
        }
        return endUser;
    }

    protected int getUserIdSendError(String username, long chatId) {
        try {
            return this.getUser(username).id();
        }
        catch (IllegalStateException ex) {
            this.sender.send(String.format("Sorry, I could not find the user [%s].", username), chatId);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public Ability reportCommands() {
        return Ability.builder().name(COMMANDS).locality(Locality.ALL).privacy(Privacy.PUBLIC).input(0).action(ctx -> {
            String commands = this.abilities.entrySet().stream().filter(entry -> Objects.nonNull(((Ability)entry.getValue()).info())).map(entry -> {
                String name = ((Ability)entry.getValue()).name();
                String info = ((Ability)entry.getValue()).info();
                return String.format("%s - %s", name, info);
            }).sorted().reduce((a, b) -> String.format("%s%n%s", a, b)).orElse("No public commands found.");
            this.sender.send(commands, ctx.chatId());
        }).build();
    }

    public Ability backupDB() {
        return Ability.builder().name(BACKUP).locality(Locality.USER).privacy(Privacy.CREATOR).input(0).action(ctx -> {
            File backup = new File("backup.json");
            try (PrintStream printStream = new PrintStream(backup);){
                printStream.print(this.db.backup());
                this.sender.sendDocument(new SendDocument().setNewDocument(backup).setChatId(ctx.chatId()));
            }
            catch (FileNotFoundException e) {
                BotLogger.error((String)"Error while fetching backup", (String)TAG, (Throwable)e);
            }
            catch (TelegramApiException e) {
                BotLogger.error((String)"Error while sending document/backup file", (String)TAG, (Throwable)e);
            }
        }).build();
    }

    public Ability recoverDB() {
        return Ability.builder().name(RECOVER).locality(Locality.USER).privacy(Privacy.CREATOR).input(0).action(ctx -> this.sender.forceReply(RECOVERY_MESSAGE, ctx.chatId())).reply(update -> {
            Long chatId = update.getMessage().getChatId();
            String fileId = update.getMessage().getDocument().getFileId();
            try (FileReader reader = new FileReader(this.downloadFileWithId(fileId));){
                String backupData = IOUtils.toString((Reader)reader);
                if (this.db.recover(backupData)) {
                    this.sender.send(RECOVER_SUCCESS, chatId);
                } else {
                    this.sender.send("Oops, something went wrong during recovery.", chatId);
                }
            }
            catch (Exception e) {
                BotLogger.error((String)"Could not recover DB from backup", (String)TAG, (Throwable)e);
                this.sender.send("I have failed to recover.", chatId);
            }
        }, Flag.MESSAGE, Flag.DOCUMENT, Flag.REPLY, AbilityUtils.isReplyTo(RECOVERY_MESSAGE)).build();
    }

    public Ability banUser() {
        return Ability.builder().name(BAN).locality(Locality.ALL).privacy(Privacy.ADMIN).input(1).action(ctx -> {
            String bannedUser;
            String username = AbilityUtils.stripTag(ctx.firstArg());
            int userId = this.getUserIdSendError(username, ctx.chatId());
            if (userId == this.creatorId()) {
                userId = ctx.user().id();
                bannedUser = Strings.isNullOrEmpty((String)ctx.user().username()) ? AbilityUtils.addTag(ctx.user().username()) : ctx.user().shortName();
            } else {
                bannedUser = AbilityUtils.addTag(username);
            }
            Set<Integer> blacklist = this.blacklist();
            if (blacklist.contains(userId)) {
                this.sender.sendMd(String.format("%s is already *banned*.", bannedUser), ctx.chatId());
            } else {
                blacklist.add(userId);
                this.sender.sendMd(String.format("%s is now *banned*.", bannedUser), ctx.chatId());
            }
        }).post(AbilityUtils.commitTo(this.db)).build();
    }

    public Ability unbanUser() {
        return Ability.builder().name(UNBAN).locality(Locality.ALL).privacy(Privacy.ADMIN).input(1).action(ctx -> {
            String username = AbilityUtils.stripTag(ctx.firstArg());
            Integer userId = this.getUserIdSendError(username, ctx.chatId());
            Set<Integer> blacklist = this.blacklist();
            if (!blacklist.remove(userId)) {
                this.sender.sendMd(String.format("@%s is *not* on the *blacklist*.", username), ctx.chatId());
            } else {
                this.sender.sendMd(String.format("@%s, your ban has been *lifted*.", username), ctx.chatId());
            }
        }).post(AbilityUtils.commitTo(this.db)).build();
    }

    public Ability promoteAdmin() {
        return Ability.builder().name(PROMOTE).locality(Locality.ALL).privacy(Privacy.ADMIN).input(1).action(ctx -> {
            String username = AbilityUtils.stripTag(ctx.firstArg());
            Integer userId = this.getUserIdSendError(username, ctx.chatId());
            Set<Integer> admins = this.admins();
            if (admins.contains(userId)) {
                this.sender.sendMd(String.format("@%s is already an *admin*.", username), ctx.chatId());
            } else {
                admins.add(userId);
                this.sender.sendMd(String.format("@%s has been *promoted*.", username), ctx.chatId());
            }
        }).post(AbilityUtils.commitTo(this.db)).build();
    }

    public Ability demoteAdmin() {
        return Ability.builder().name(DEMOTE).locality(Locality.ALL).privacy(Privacy.ADMIN).input(1).action(ctx -> {
            String username = AbilityUtils.stripTag(ctx.firstArg());
            Integer userId = this.getUserIdSendError(username, ctx.chatId());
            Set<Integer> admins = this.admins();
            if (admins.remove(userId)) {
                this.sender.sendMd(String.format("@%s has been *demoted*.", username), ctx.chatId());
            } else {
                this.sender.sendMd(String.format("@%s is *not* an *admin*.", username), ctx.chatId());
            }
        }).post(AbilityUtils.commitTo(this.db)).build();
    }

    public Ability claimCreator() {
        return Ability.builder().name(CLAIM).locality(Locality.ALL).privacy(Privacy.PUBLIC).input(0).action(ctx -> {
            if (ctx.user().id() == this.creatorId()) {
                Set<Integer> admins = this.admins();
                int id = this.creatorId();
                long chatId = ctx.chatId();
                if (admins.contains(id)) {
                    this.sender.send("You're already my master.", chatId);
                } else {
                    admins.add(id);
                    this.sender.send("You're now my master.", chatId);
                }
            } else {
                this.abilities.get(BAN).action().accept(MessageContext.newContext(ctx.update(), ctx.user(), ctx.chatId(), ctx.user().username()));
            }
        }).post(AbilityUtils.commitTo(this.db)).build();
    }

    private void registerAbilities() {
        try {
            this.abilities = Arrays.stream(((Object)((Object)this)).getClass().getMethods()).filter(method -> method.getReturnType().equals(Ability.class)).map(this::returnAbility).collect(Collectors.toMap(Ability::name, Function.identity()));
            Stream<Reply> methodReplies = Arrays.stream(((Object)((Object)this)).getClass().getMethods()).filter(method -> method.getReturnType().equals(Reply.class)).map(this::returnReply);
            Stream abilityReplies = this.abilities.values().stream().flatMap(ability -> ability.replies().stream());
            this.replies = Stream.concat(methodReplies, abilityReplies).collect(Collectors.toList());
        }
        catch (IllegalStateException e) {
            BotLogger.error((String)TAG, (String)"Duplicate names found while registering abilities. Make sure that the abilities declared don't clash with the reserved ones.", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Ability returnAbility(Method method) {
        try {
            return (Ability)method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            BotLogger.error((String)"Could not add ability", (String)TAG, (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Reply returnReply(Method method) {
        try {
            return (Reply)method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            BotLogger.error((String)"Could not add reply", (String)TAG, (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void postConsumption(Pair<MessageContext, Ability> pair) {
        Optional.ofNullable(pair.b().postAction()).ifPresent(consumer -> consumer.accept(pair.a()));
    }

    Pair<MessageContext, Ability> consumeUpdate(Pair<MessageContext, Ability> pair) {
        pair.b().action().accept(pair.a());
        return pair;
    }

    Pair<MessageContext, Ability> getContext(Trio<Update, Ability, String[]> trio) {
        Update update = trio.a();
        EndUser user = EndUser.fromUser(AbilityUtils.getUser(update));
        return Pair.of(MessageContext.newContext(update, user, AbilityUtils.getChatId(update), trio.c()), trio.b());
    }

    boolean checkBlacklist(Update update) {
        Integer id = AbilityUtils.getUser(update).getId();
        return id.intValue() == this.creatorId() || !this.blacklist().contains(id);
    }

    boolean checkInput(Trio<Update, Ability, String[]> trio) {
        boolean isOk;
        String[] tokens = trio.c();
        int abilityTokens = trio.b().tokens();
        boolean bl = isOk = abilityTokens == 0 || tokens.length > 0 && tokens.length == abilityTokens;
        if (!isOk) {
            this.sender.send(String.format("Sorry, this feature requires %d additional %s.", abilityTokens, abilityTokens == 1 ? "input" : "inputs"), AbilityUtils.getChatId(trio.a()));
        }
        return isOk;
    }

    boolean checkLocality(Trio<Update, Ability, String[]> trio) {
        boolean isOk;
        Update update = trio.a();
        Locality locality = AbilityUtils.isUserMessage(update) ? Locality.USER : Locality.GROUP;
        Locality abilityLocality = trio.b().locality();
        boolean bl = isOk = abilityLocality == Locality.ALL || locality == abilityLocality;
        if (!isOk) {
            this.sender.send(String.format("Sorry, %s-only feature.", abilityLocality.toString().toLowerCase()), AbilityUtils.getChatId(trio.a()));
        }
        return isOk;
    }

    boolean checkPrivacy(Trio<Update, Ability, String[]> trio) {
        boolean isOk;
        Update update = trio.a();
        EndUser user = EndUser.fromUser(AbilityUtils.getUser(update));
        int id = user.id();
        Privacy privacy = this.isCreator(id) ? Privacy.CREATOR : (this.isAdmin(id) ? Privacy.ADMIN : Privacy.PUBLIC);
        boolean bl = isOk = privacy.compareTo(trio.b().privacy()) >= 0;
        if (!isOk) {
            this.sender.send(String.format("Sorry, %s-only feature.", trio.b().privacy().toString().toLowerCase()), AbilityUtils.getChatId(trio.a()));
        }
        return isOk;
    }

    private boolean isCreator(int id) {
        return id == this.creatorId();
    }

    private boolean isAdmin(Integer id) {
        return this.admins().contains(id);
    }

    boolean validateAbility(Trio<Update, Ability, String[]> trio) {
        return trio.b() != null;
    }

    Trio<Update, Ability, String[]> getAbility(Update update) {
        Message msg = update.getMessage();
        if (!update.hasMessage() || !msg.hasText()) {
            return Trio.of(update, this.abilities.get(DEFAULT), new String[0]);
        }
        String[] tokens = msg.getText().split(" ");
        if (tokens[0].startsWith("/")) {
            String abilityToken = this.stripBotUsername(tokens[0].substring(1));
            Ability ability = this.abilities.get(abilityToken);
            tokens = Arrays.copyOfRange(tokens, 1, tokens.length);
            return Trio.of(update, ability, tokens);
        }
        Ability ability = this.abilities.get(DEFAULT);
        return Trio.of(update, ability, tokens);
    }

    private String stripBotUsername(String token) {
        return Pattern.compile(String.format("@%s", this.botUsername), 2).matcher(token).replaceAll("");
    }

    Update addUser(Update update) {
        EndUser endUser = EndUser.fromUser(AbilityUtils.getUser(update));
        this.users().compute(endUser.id(), (id, user) -> {
            if (user == null) {
                this.updateUserId((EndUser)user, endUser);
                return endUser;
            }
            if (!user.equals(endUser)) {
                this.updateUserId((EndUser)user, endUser);
                return endUser;
            }
            return user;
        });
        this.db.commit();
        return update;
    }

    private void updateUserId(EndUser oldUser, EndUser newUser) {
        if (oldUser != null && oldUser.username() != null) {
            this.userIds().remove(oldUser.username());
        }
        if (newUser.username() != null) {
            this.userIds().put(newUser.username().toLowerCase(), newUser.id());
        }
    }

    boolean filterReply(Update update) {
        return this.replies.stream().filter(reply -> reply.isOkFor(update)).map(reply -> {
            reply.actOn(update);
            return false;
        }).reduce(true, Boolean::logicalAnd);
    }

    boolean checkMessageFlags(Trio<Update, Ability, String[]> trio) {
        Ability ability = trio.b();
        Update update = trio.a();
        BiFunction<Boolean, Predicate, Boolean> flagAnd = (flag, nextFlag) -> flag != false && nextFlag.test(update);
        return ability.flags().stream().reduce(true, flagAnd, Boolean::logicalAnd);
    }

    private File downloadFileWithId(String fileId) throws TelegramApiException {
        return this.sender.downloadFile(this.sender.getFile(new GetFile().setFileId(fileId)));
    }
}

