/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.sender;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.telegram.abilitybots.api.sender.MessageSender;
import org.telegram.telegrambots.api.methods.AnswerCallbackQuery;
import org.telegram.telegrambots.api.methods.AnswerInlineQuery;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.methods.ForwardMessage;
import org.telegram.telegrambots.api.methods.GetFile;
import org.telegram.telegrambots.api.methods.GetUserProfilePhotos;
import org.telegram.telegrambots.api.methods.games.GetGameHighScores;
import org.telegram.telegrambots.api.methods.games.SetGameScore;
import org.telegram.telegrambots.api.methods.groupadministration.DeleteChatPhoto;
import org.telegram.telegrambots.api.methods.groupadministration.ExportChatInviteLink;
import org.telegram.telegrambots.api.methods.groupadministration.GetChat;
import org.telegram.telegrambots.api.methods.groupadministration.GetChatAdministrators;
import org.telegram.telegrambots.api.methods.groupadministration.GetChatMember;
import org.telegram.telegrambots.api.methods.groupadministration.GetChatMemberCount;
import org.telegram.telegrambots.api.methods.groupadministration.KickChatMember;
import org.telegram.telegrambots.api.methods.groupadministration.LeaveChat;
import org.telegram.telegrambots.api.methods.groupadministration.PromoteChatMember;
import org.telegram.telegrambots.api.methods.groupadministration.RestrictChatMember;
import org.telegram.telegrambots.api.methods.groupadministration.SetChatDescription;
import org.telegram.telegrambots.api.methods.groupadministration.SetChatPhoto;
import org.telegram.telegrambots.api.methods.groupadministration.SetChatTitle;
import org.telegram.telegrambots.api.methods.groupadministration.UnbanChatMember;
import org.telegram.telegrambots.api.methods.pinnedmessages.PinChatMessage;
import org.telegram.telegrambots.api.methods.pinnedmessages.UnpinChatMessage;
import org.telegram.telegrambots.api.methods.send.SendAudio;
import org.telegram.telegrambots.api.methods.send.SendChatAction;
import org.telegram.telegrambots.api.methods.send.SendContact;
import org.telegram.telegrambots.api.methods.send.SendDocument;
import org.telegram.telegrambots.api.methods.send.SendGame;
import org.telegram.telegrambots.api.methods.send.SendLocation;
import org.telegram.telegrambots.api.methods.send.SendMessage;
import org.telegram.telegrambots.api.methods.send.SendPhoto;
import org.telegram.telegrambots.api.methods.send.SendSticker;
import org.telegram.telegrambots.api.methods.send.SendVenue;
import org.telegram.telegrambots.api.methods.send.SendVideo;
import org.telegram.telegrambots.api.methods.send.SendVoice;
import org.telegram.telegrambots.api.methods.updates.DeleteWebhook;
import org.telegram.telegrambots.api.methods.updatingmessages.DeleteMessage;
import org.telegram.telegrambots.api.methods.updatingmessages.EditMessageCaption;
import org.telegram.telegrambots.api.methods.updatingmessages.EditMessageReplyMarkup;
import org.telegram.telegrambots.api.methods.updatingmessages.EditMessageText;
import org.telegram.telegrambots.api.objects.Chat;
import org.telegram.telegrambots.api.objects.ChatMember;
import org.telegram.telegrambots.api.objects.File;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.User;
import org.telegram.telegrambots.api.objects.UserProfilePhotos;
import org.telegram.telegrambots.api.objects.WebhookInfo;
import org.telegram.telegrambots.api.objects.games.GameHighScore;
import org.telegram.telegrambots.api.objects.replykeyboard.ForceReplyKeyboard;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.bots.DefaultAbsSender;
import org.telegram.telegrambots.exceptions.TelegramApiException;
import org.telegram.telegrambots.logging.BotLogger;
import org.telegram.telegrambots.updateshandlers.DownloadFileCallback;
import org.telegram.telegrambots.updateshandlers.SentCallback;

public class DefaultMessageSender
implements MessageSender {
    private static final String TAG = MessageSender.class.getName();
    private DefaultAbsSender bot;

    public DefaultMessageSender(DefaultAbsSender bot) {
        this.bot = bot;
    }

    @Override
    public Optional<Message> send(String message, long id) {
        return this.doSendMessage(message, id, false);
    }

    @Override
    public Optional<Message> sendMd(String message, long id) {
        return this.doSendMessage(message, id, true);
    }

    @Override
    public Optional<Message> forceReply(String message, long id) {
        SendMessage msg = new SendMessage();
        msg.setText(message);
        msg.setChatId(Long.valueOf(id));
        msg.setReplyMarkup((ReplyKeyboard)new ForceReplyKeyboard());
        return this.optionalSendMessage(msg);
    }

    @Override
    public Boolean answerInlineQuery(AnswerInlineQuery answerInlineQuery) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)answerInlineQuery);
    }

    @Override
    public Boolean sendChatAction(SendChatAction sendChatAction) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)sendChatAction);
    }

    @Override
    public Message forwardMessage(ForwardMessage forwardMessage) throws TelegramApiException {
        return (Message)this.bot.execute((BotApiMethod)forwardMessage);
    }

    @Override
    public Message sendLocation(SendLocation sendLocation) throws TelegramApiException {
        return (Message)this.bot.execute((BotApiMethod)sendLocation);
    }

    @Override
    public Message sendVenue(SendVenue sendVenue) throws TelegramApiException {
        return (Message)this.bot.execute((BotApiMethod)sendVenue);
    }

    @Override
    public Message sendContact(SendContact sendContact) throws TelegramApiException {
        return (Message)this.bot.execute((BotApiMethod)sendContact);
    }

    @Override
    public Boolean kickMember(KickChatMember kickChatMember) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)kickChatMember);
    }

    @Override
    public Boolean unbanMember(UnbanChatMember unbanChatMember) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)unbanChatMember);
    }

    @Override
    public Boolean leaveChat(LeaveChat leaveChat) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)leaveChat);
    }

    @Override
    public Chat getChat(GetChat getChat) throws TelegramApiException {
        return (Chat)this.bot.execute((BotApiMethod)getChat);
    }

    @Override
    public List<ChatMember> getChatAdministrators(GetChatAdministrators getChatAdministrators) throws TelegramApiException {
        return (List)((Object)this.bot.execute((BotApiMethod)getChatAdministrators));
    }

    @Override
    public ChatMember getChatMember(GetChatMember getChatMember) throws TelegramApiException {
        return (ChatMember)this.bot.execute((BotApiMethod)getChatMember);
    }

    @Override
    public Integer getChatMemberCount(GetChatMemberCount getChatMemberCount) throws TelegramApiException {
        return (Integer)this.bot.execute((BotApiMethod)getChatMemberCount);
    }

    @Override
    public Boolean setChatPhoto(SetChatPhoto setChatPhoto) throws TelegramApiException {
        return this.bot.setChatPhoto(setChatPhoto);
    }

    @Override
    public Boolean deleteChatPhoto(DeleteChatPhoto deleteChatPhoto) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)deleteChatPhoto);
    }

    @Override
    public void deleteChatPhoto(DeleteChatPhoto deleteChatPhoto, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)deleteChatPhoto, sentCallback);
    }

    @Override
    public Boolean pinChatMessage(PinChatMessage pinChatMessage) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)pinChatMessage);
    }

    @Override
    public void pinChatMessage(PinChatMessage pinChatMessage, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)pinChatMessage, sentCallback);
    }

    @Override
    public Boolean unpinChatMessage(UnpinChatMessage unpinChatMessage) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)unpinChatMessage);
    }

    @Override
    public void unpinChatMessage(UnpinChatMessage unpinChatMessage, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)unpinChatMessage, sentCallback);
    }

    @Override
    public Boolean promoteChatMember(PromoteChatMember promoteChatMember) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)promoteChatMember);
    }

    @Override
    public void promoteChatMember(PromoteChatMember promoteChatMember, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)promoteChatMember, sentCallback);
    }

    @Override
    public Boolean restrictChatMember(RestrictChatMember restrictChatMember) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)restrictChatMember);
    }

    @Override
    public void restrictChatMember(RestrictChatMember restrictChatMember, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)restrictChatMember, sentCallback);
    }

    @Override
    public Boolean setChatDescription(SetChatDescription setChatDescription) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)setChatDescription);
    }

    @Override
    public void setChatDescription(SetChatDescription setChatDescription, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)setChatDescription, sentCallback);
    }

    @Override
    public Boolean setChatTite(SetChatTitle setChatTitle) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)setChatTitle);
    }

    @Override
    public void setChatTite(SetChatTitle setChatTitle, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)setChatTitle, sentCallback);
    }

    @Override
    public String exportChatInviteLink(ExportChatInviteLink exportChatInviteLink) throws TelegramApiException {
        return (String)((Object)this.bot.execute((BotApiMethod)exportChatInviteLink));
    }

    @Override
    public void exportChatInviteLinkAsync(ExportChatInviteLink exportChatInviteLink, SentCallback<String> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)exportChatInviteLink, sentCallback);
    }

    @Override
    public Boolean deleteMessage(DeleteMessage deleteMessage) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)deleteMessage);
    }

    @Override
    public void deleteMessageAsync(DeleteMessage deleteMessage, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)deleteMessage, sentCallback);
    }

    @Override
    public Serializable editMessageText(EditMessageText editMessageText) throws TelegramApiException {
        return this.bot.execute((BotApiMethod)editMessageText);
    }

    @Override
    public Serializable editMessageCaption(EditMessageCaption editMessageCaption) throws TelegramApiException {
        return this.bot.execute((BotApiMethod)editMessageCaption);
    }

    @Override
    public Serializable editMessageReplyMarkup(EditMessageReplyMarkup editMessageReplyMarkup) throws TelegramApiException {
        return this.bot.execute((BotApiMethod)editMessageReplyMarkup);
    }

    @Override
    public Boolean answerCallbackQuery(AnswerCallbackQuery answerCallbackQuery) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)answerCallbackQuery);
    }

    @Override
    public UserProfilePhotos getUserProfilePhotos(GetUserProfilePhotos getUserProfilePhotos) throws TelegramApiException {
        return (UserProfilePhotos)this.bot.execute((BotApiMethod)getUserProfilePhotos);
    }

    @Override
    public java.io.File downloadFile(String path) throws TelegramApiException {
        return this.bot.downloadFile(path);
    }

    @Override
    public void downloadFileAsync(String path, DownloadFileCallback<String> callback) throws TelegramApiException {
        this.bot.downloadFileAsync(path, callback);
    }

    @Override
    public java.io.File downloadFile(File file) throws TelegramApiException {
        return this.bot.downloadFile(file);
    }

    @Override
    public void downloadFileAsync(File file, DownloadFileCallback<File> callback) throws TelegramApiException {
        this.bot.downloadFileAsync(file, callback);
    }

    @Override
    public File getFile(GetFile getFile) throws TelegramApiException {
        return (File)this.bot.execute((BotApiMethod)getFile);
    }

    @Override
    public User getMe() throws TelegramApiException {
        return this.bot.getMe();
    }

    @Override
    public WebhookInfo getWebhookInfo() throws TelegramApiException {
        return this.bot.getWebhookInfo();
    }

    @Override
    public Serializable setGameScore(SetGameScore setGameScore) throws TelegramApiException {
        return this.bot.execute((BotApiMethod)setGameScore);
    }

    @Override
    public Serializable getGameHighScores(GetGameHighScores getGameHighScores) throws TelegramApiException {
        return this.bot.execute((BotApiMethod)getGameHighScores);
    }

    @Override
    public Message sendGame(SendGame sendGame) throws TelegramApiException {
        return (Message)this.bot.execute((BotApiMethod)sendGame);
    }

    @Override
    public Boolean deleteWebhook(DeleteWebhook deleteWebhook) throws TelegramApiException {
        return (Boolean)this.bot.execute((BotApiMethod)deleteWebhook);
    }

    @Override
    public Message sendMessage(SendMessage sendMessage) throws TelegramApiException {
        return (Message)this.bot.execute((BotApiMethod)sendMessage);
    }

    @Override
    public void sendMessageAsync(SendMessage sendMessage, SentCallback<Message> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)sendMessage, sentCallback);
    }

    @Override
    public void answerInlineQueryAsync(AnswerInlineQuery answerInlineQuery, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)answerInlineQuery, sentCallback);
    }

    @Override
    public void sendChatActionAsync(SendChatAction sendChatAction, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)sendChatAction, sentCallback);
    }

    @Override
    public void forwardMessageAsync(ForwardMessage forwardMessage, SentCallback<Message> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)forwardMessage, sentCallback);
    }

    @Override
    public void sendLocationAsync(SendLocation sendLocation, SentCallback<Message> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)sendLocation, sentCallback);
    }

    @Override
    public void sendVenueAsync(SendVenue sendVenue, SentCallback<Message> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)sendVenue, sentCallback);
    }

    @Override
    public void sendContactAsync(SendContact sendContact, SentCallback<Message> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)sendContact, sentCallback);
    }

    @Override
    public void kickMemberAsync(KickChatMember kickChatMember, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)kickChatMember, sentCallback);
    }

    @Override
    public void unbanMemberAsync(UnbanChatMember unbanChatMember, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)unbanChatMember, sentCallback);
    }

    @Override
    public void leaveChatAsync(LeaveChat leaveChat, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)leaveChat, sentCallback);
    }

    @Override
    public void getChatAsync(GetChat getChat, SentCallback<Chat> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)getChat, sentCallback);
    }

    @Override
    public void getChatAdministratorsAsync(GetChatAdministrators getChatAdministrators, SentCallback<ArrayList<ChatMember>> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)getChatAdministrators, sentCallback);
    }

    @Override
    public void getChatMemberAsync(GetChatMember getChatMember, SentCallback<ChatMember> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)getChatMember, sentCallback);
    }

    @Override
    public void getChatMemberCountAsync(GetChatMemberCount getChatMemberCount, SentCallback<Integer> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)getChatMemberCount, sentCallback);
    }

    @Override
    public void editMessageTextAsync(EditMessageText editMessageText, SentCallback<Serializable> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)editMessageText, sentCallback);
    }

    @Override
    public void editMessageCaptionAsync(EditMessageCaption editMessageCaption, SentCallback<Serializable> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)editMessageCaption, sentCallback);
    }

    @Override
    public void editMessageReplyMarkup(EditMessageReplyMarkup editMessageReplyMarkup, SentCallback<Serializable> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)editMessageReplyMarkup, sentCallback);
    }

    @Override
    public void answerCallbackQueryAsync(AnswerCallbackQuery answerCallbackQuery, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)answerCallbackQuery, sentCallback);
    }

    @Override
    public void getUserProfilePhotosAsync(GetUserProfilePhotos getUserProfilePhotos, SentCallback<UserProfilePhotos> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)getUserProfilePhotos, sentCallback);
    }

    @Override
    public void getFileAsync(GetFile getFile, SentCallback<File> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)getFile, sentCallback);
    }

    @Override
    public void getMeAsync(SentCallback<User> sentCallback) throws TelegramApiException {
        this.bot.getMeAsync(sentCallback);
    }

    @Override
    public void getWebhookInfoAsync(SentCallback<WebhookInfo> sentCallback) throws TelegramApiException {
        this.bot.getWebhookInfoAsync(sentCallback);
    }

    @Override
    public void setGameScoreAsync(SetGameScore setGameScore, SentCallback<Serializable> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)setGameScore, sentCallback);
    }

    @Override
    public void getGameHighScoresAsync(GetGameHighScores getGameHighScores, SentCallback<ArrayList<GameHighScore>> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)getGameHighScores, sentCallback);
    }

    @Override
    public void sendGameAsync(SendGame sendGame, SentCallback<Message> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)sendGame, sentCallback);
    }

    @Override
    public void deleteWebhook(DeleteWebhook deleteWebhook, SentCallback<Boolean> sentCallback) throws TelegramApiException {
        this.bot.executeAsync((BotApiMethod)deleteWebhook, sentCallback);
    }

    @Override
    public Message sendDocument(SendDocument sendDocument) throws TelegramApiException {
        return this.bot.sendDocument(sendDocument);
    }

    @Override
    public Message sendPhoto(SendPhoto sendPhoto) throws TelegramApiException {
        return this.bot.sendPhoto(sendPhoto);
    }

    @Override
    public Message sendVideo(SendVideo sendVideo) throws TelegramApiException {
        return this.bot.sendVideo(sendVideo);
    }

    @Override
    public Message sendSticker(SendSticker sendSticker) throws TelegramApiException {
        return this.bot.sendSticker(sendSticker);
    }

    @Override
    public Message sendAudio(SendAudio sendAudio) throws TelegramApiException {
        return this.bot.sendAudio(sendAudio);
    }

    @Override
    public Message sendVoice(SendVoice sendVoice) throws TelegramApiException {
        return this.bot.sendVoice(sendVoice);
    }

    private Optional<Message> doSendMessage(String txt, long groupId, boolean format) {
        SendMessage smsg = new SendMessage();
        smsg.setChatId(Long.valueOf(groupId));
        smsg.setText(txt);
        smsg.enableMarkdown(format);
        return this.optionalSendMessage(smsg);
    }

    private Optional<Message> optionalSendMessage(SendMessage smsg) {
        try {
            return Optional.ofNullable(this.sendMessage(smsg));
        }
        catch (TelegramApiException e) {
            BotLogger.error((String)"Could not send message", (String)TAG, (Throwable)e);
            return Optional.empty();
        }
    }
}

