/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.telegram.telegrambots.api.objects.User;

public final class EndUser
implements Serializable {
    @JsonProperty(value="id")
    private final Integer id;
    @JsonProperty(value="firstName")
    private final String firstName;
    @JsonProperty(value="lastName")
    private final String lastName;
    @JsonProperty(value="username")
    private final String username;

    private EndUser(Integer id, String firstName, String lastName, String username) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.username = username;
    }

    @JsonCreator
    public static EndUser endUser(@JsonProperty(value="id") Integer id, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="username") String username) {
        return new EndUser(id, firstName, lastName, username);
    }

    public static EndUser fromUser(User user) {
        return new EndUser(user.getId(), user.getFirstName(), user.getLastName(), user.getUserName());
    }

    public int id() {
        return this.id;
    }

    public String firstName() {
        return this.firstName;
    }

    public String lastName() {
        return this.lastName;
    }

    public String username() {
        return this.username;
    }

    public String fullName() {
        StringJoiner name = new StringJoiner(" ");
        if (!StringUtils.isEmpty((CharSequence)this.firstName)) {
            name.add(this.firstName);
        }
        if (!StringUtils.isEmpty((CharSequence)this.lastName)) {
            name.add(this.lastName);
        }
        return name.toString();
    }

    public String shortName() {
        if (!StringUtils.isEmpty((CharSequence)this.firstName)) {
            return this.firstName;
        }
        if (!StringUtils.isEmpty((CharSequence)this.lastName)) {
            return this.lastName;
        }
        return this.username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndUser endUser = (EndUser)o;
        return Objects.equals(this.id, endUser.id) && Objects.equals(this.firstName, endUser.firstName) && Objects.equals(this.lastName, endUser.lastName) && Objects.equals(this.username, endUser.username);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.firstName, this.lastName, this.username);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("firstName", (Object)this.firstName).add("lastName", (Object)this.lastName).add("username", (Object)this.username).toString();
    }
}

