/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.util;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.telegram.abilitybots.api.db.DBContext;
import org.telegram.abilitybots.api.objects.Flag;
import org.telegram.abilitybots.api.objects.MessageContext;
import org.telegram.telegrambots.api.objects.Update;
import org.telegram.telegrambots.api.objects.User;

public final class AbilityUtils {
    private AbilityUtils() {
    }

    public static String stripTag(String username) {
        String lowerCase = username.toLowerCase();
        return lowerCase.startsWith("@") ? lowerCase.substring(1, lowerCase.length()) : lowerCase;
    }

    public static Consumer<MessageContext> commitTo(DBContext db) {
        return ctx -> db.commit();
    }

    public static User getUser(Update update) {
        if (Flag.MESSAGE.test(update)) {
            return update.getMessage().getFrom();
        }
        if (Flag.CALLBACK_QUERY.test(update)) {
            return update.getCallbackQuery().getFrom();
        }
        if (Flag.INLINE_QUERY.test(update)) {
            return update.getInlineQuery().getFrom();
        }
        if (Flag.CHANNEL_POST.test(update)) {
            return update.getChannelPost().getFrom();
        }
        if (Flag.EDITED_CHANNEL_POST.test(update)) {
            return update.getEditedChannelPost().getFrom();
        }
        if (Flag.EDITED_MESSAGE.test(update)) {
            return update.getEditedMessage().getFrom();
        }
        if (Flag.CHOSEN_INLINE_QUERY.test(update)) {
            return update.getChosenInlineQuery().getFrom();
        }
        throw new IllegalStateException("Could not retrieve originating user from update");
    }

    public static boolean isGroupUpdate(Update update) {
        if (Flag.MESSAGE.test(update)) {
            return update.getMessage().isGroupMessage();
        }
        if (Flag.CALLBACK_QUERY.test(update)) {
            return update.getCallbackQuery().getMessage().isGroupMessage();
        }
        if (Flag.CHANNEL_POST.test(update)) {
            return update.getChannelPost().isGroupMessage();
        }
        if (Flag.EDITED_CHANNEL_POST.test(update)) {
            return update.getEditedChannelPost().isGroupMessage();
        }
        if (Flag.EDITED_MESSAGE.test(update)) {
            return update.getEditedMessage().isGroupMessage();
        }
        return false;
    }

    public static Long getChatId(Update update) {
        if (Flag.MESSAGE.test(update)) {
            return update.getMessage().getChatId();
        }
        if (Flag.CALLBACK_QUERY.test(update)) {
            return update.getCallbackQuery().getMessage().getChatId();
        }
        if (Flag.INLINE_QUERY.test(update)) {
            return (long)update.getInlineQuery().getFrom().getId();
        }
        if (Flag.CHANNEL_POST.test(update)) {
            return update.getChannelPost().getChatId();
        }
        if (Flag.EDITED_CHANNEL_POST.test(update)) {
            return update.getEditedChannelPost().getChatId();
        }
        if (Flag.EDITED_MESSAGE.test(update)) {
            return update.getEditedMessage().getChatId();
        }
        if (Flag.CHOSEN_INLINE_QUERY.test(update)) {
            return (long)update.getChosenInlineQuery().getFrom().getId();
        }
        throw new IllegalStateException("Could not retrieve originating chat ID from update");
    }

    public static boolean isUserMessage(Update update) {
        if (Flag.MESSAGE.test(update)) {
            return update.getMessage().isUserMessage();
        }
        if (Flag.CALLBACK_QUERY.test(update)) {
            return update.getCallbackQuery().getMessage().isUserMessage();
        }
        if (Flag.CHANNEL_POST.test(update)) {
            return update.getChannelPost().isUserMessage();
        }
        if (Flag.EDITED_CHANNEL_POST.test(update)) {
            return update.getEditedChannelPost().isUserMessage();
        }
        if (Flag.EDITED_MESSAGE.test(update)) {
            return update.getEditedMessage().isUserMessage();
        }
        if (Flag.CHOSEN_INLINE_QUERY.test(update) || Flag.INLINE_QUERY.test(update)) {
            return true;
        }
        throw new IllegalStateException("Could not retrieve update context origin (user/group)");
    }

    public static String addTag(String username) {
        return "@" + username;
    }

    public static Predicate<Update> isReplyTo(String msg) {
        return update -> update.getMessage().getReplyToMessage().getText().equals(msg);
    }
}

