/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.objects;

import java.util.Objects;
import java.util.function.Predicate;
import org.telegram.telegrambots.meta.api.objects.Update;

public enum Flag implements Predicate<Update>
{
    NONE(update -> true),
    MESSAGE(Update::hasMessage),
    CALLBACK_QUERY(Update::hasCallbackQuery),
    CHANNEL_POST(Update::hasChannelPost),
    EDITED_CHANNEL_POST(Update::hasEditedChannelPost),
    EDITED_MESSAGE(Update::hasEditedMessage),
    INLINE_QUERY(Update::hasInlineQuery),
    CHOSEN_INLINE_QUERY(Update::hasChosenInlineQuery),
    REPLY(update -> update.getMessage().isReply()),
    DOCUMENT(upd -> upd.getMessage().hasDocument()),
    TEXT(upd -> upd.getMessage().hasText()),
    PHOTO(upd -> upd.getMessage().hasPhoto()),
    LOCATION(upd -> upd.getMessage().hasLocation()),
    CAPTION(upd -> Objects.nonNull(upd.getMessage().getCaption()));

    private final Predicate<Update> predicate;

    private Flag(Predicate<Update> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(Update update) {
        return Objects.nonNull(update) && this.predicate.test(update);
    }
}

