/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.bot;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jersey.repackaged.com.google.common.base.Throwables;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.telegram.abilitybots.api.db.DBContext;
import org.telegram.abilitybots.api.objects.Ability;
import org.telegram.abilitybots.api.objects.Flag;
import org.telegram.abilitybots.api.objects.Locality;
import org.telegram.abilitybots.api.objects.MessageContext;
import org.telegram.abilitybots.api.objects.Privacy;
import org.telegram.abilitybots.api.objects.Reply;
import org.telegram.abilitybots.api.sender.DefaultSender;
import org.telegram.abilitybots.api.sender.MessageSender;
import org.telegram.abilitybots.api.sender.SilentSender;
import org.telegram.abilitybots.api.util.AbilityExtension;
import org.telegram.abilitybots.api.util.AbilityMessageCodes;
import org.telegram.abilitybots.api.util.AbilityUtils;
import org.telegram.abilitybots.api.util.Pair;
import org.telegram.abilitybots.api.util.Trio;
import org.telegram.telegrambots.bots.DefaultAbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.meta.api.methods.GetFile;
import org.telegram.telegrambots.meta.api.methods.groupadministration.GetChatAdministrators;
import org.telegram.telegrambots.meta.api.methods.send.SendDocument;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.User;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.logging.BotLogger;

public abstract class BaseAbilityBot
extends DefaultAbsSender
implements AbilityExtension {
    private static final String TAG = BaseAbilityBot.class.getSimpleName();
    public static final String ADMINS = "ADMINS";
    public static final String USERS = "USERS";
    public static final String USER_ID = "USER_ID";
    public static final String BLACKLIST = "BLACKLIST";
    protected static final String DEFAULT = "default";
    protected static final String CLAIM = "claim";
    protected static final String BAN = "ban";
    protected static final String PROMOTE = "promote";
    protected static final String DEMOTE = "demote";
    protected static final String UNBAN = "unban";
    protected static final String BACKUP = "backup";
    protected static final String RECOVER = "recover";
    protected static final String COMMANDS = "commands";
    protected static final String REPORT = "report";
    protected final DBContext db;
    protected MessageSender sender;
    protected SilentSender silent;
    private final String botToken;
    private final String botUsername;
    private Map<String, Ability> abilities;
    private List<Reply> replies;

    public abstract int creatorId();

    protected BaseAbilityBot(String botToken, String botUsername, DBContext db, DefaultBotOptions botOptions) {
        super(botOptions);
        this.botToken = botToken;
        this.botUsername = botUsername;
        this.db = db;
        this.sender = new DefaultSender(this);
        this.silent = new SilentSender(this.sender);
        this.registerAbilities();
    }

    protected Map<Integer, User> users() {
        return this.db.getMap(USERS);
    }

    protected Map<String, Integer> userIds() {
        return this.db.getMap(USER_ID);
    }

    protected Set<Integer> blacklist() {
        return this.db.getSet(BLACKLIST);
    }

    protected Set<Integer> admins() {
        return this.db.getSet(ADMINS);
    }

    public Map<String, Ability> abilities() {
        return this.abilities;
    }

    public List<Reply> replies() {
        return this.replies;
    }

    public void onUpdateReceived(Update update) {
        BotLogger.info((String)String.format("New update [%s] received at %s", update.getUpdateId(), ZonedDateTime.now()), (String)String.format("%s - %s", TAG, this.botUsername));
        BotLogger.info((String)update.toString(), (String)TAG);
        long millisStarted = System.currentTimeMillis();
        Stream.of(update).filter(this::checkGlobalFlags).filter(this::checkBlacklist).map(this::addUser).filter(this::filterReply).map(this::getAbility).filter(this::validateAbility).filter(this::checkPrivacy).filter(this::checkLocality).filter(this::checkInput).filter(this::checkMessageFlags).map(this::getContext).map(this::consumeUpdate).forEach(this::postConsumption);
        long processingTime = System.currentTimeMillis() - millisStarted;
        BotLogger.info((String)String.format("Processing of update [%s] ended at %s%n---> Processing time: [%d ms] <---%n", update.getUpdateId(), ZonedDateTime.now(), processingTime), (String)String.format("%s - %s", TAG, this.botUsername));
    }

    public String getBotToken() {
        return this.botToken;
    }

    public String getBotUsername() {
        return this.botUsername;
    }

    protected boolean checkGlobalFlags(Update update) {
        return true;
    }

    protected User getUser(String username) {
        Integer id = this.userIds().get(username.toLowerCase());
        if (id == null) {
            throw new IllegalStateException(String.format("Could not find ID corresponding to username [%s]", username));
        }
        return this.getUser(id);
    }

    protected User getUser(int id) {
        User user = this.users().get(id);
        if (user == null) {
            throw new IllegalStateException(String.format("Could not find user corresponding to id [%d]", id));
        }
        return user;
    }

    protected int getUserIdSendError(String username, MessageContext ctx) {
        try {
            return this.getUser(username).getId();
        }
        catch (IllegalStateException ex) {
            this.silent.send(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.USER_NOT_FOUND, ctx.user().getLanguageCode(), username), ctx.chatId());
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public Ability reportCommands() {
        return Ability.builder().name(REPORT).locality(Locality.ALL).privacy(Privacy.CREATOR).input(0).action(ctx -> {
            String commands = this.abilities.entrySet().stream().filter(entry -> Objects.nonNull(((Ability)entry.getValue()).info())).map(entry -> {
                String name = ((Ability)entry.getValue()).name();
                String info = ((Ability)entry.getValue()).info();
                return String.format("%s - %s", name, info);
            }).sorted().reduce((a, b) -> String.format("%s%n%s", a, b)).orElse(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.ABILITY_COMMANDS_NOT_FOUND, ctx.user().getLanguageCode(), new Object[0]));
            this.silent.send(commands, ctx.chatId());
        }).build();
    }

    public Ability commands() {
        return Ability.builder().name(COMMANDS).locality(Locality.USER).privacy(Privacy.PUBLIC).input(0).action(ctx -> {
            Privacy privacy = this.getPrivacy(ctx.update(), ctx.user().getId());
            ListMultimap abilitiesPerPrivacy = this.abilities.entrySet().stream().map(entry -> {
                String name = ((Ability)entry.getValue()).name();
                String info = ((Ability)entry.getValue()).info();
                if (!StringUtils.isEmpty((CharSequence)info)) {
                    return Pair.of(((Ability)entry.getValue()).privacy(), String.format("/%s - %s", name, info));
                }
                return Pair.of(((Ability)entry.getValue()).privacy(), String.format("/%s", name));
            }).sorted(Comparator.comparing(Pair::b)).collect(() -> MultimapBuilder.hashKeys().arrayListValues().build(), (map, pair) -> map.put(pair.a(), pair.b()), Multimap::putAll);
            String commands = abilitiesPerPrivacy.asMap().entrySet().stream().filter(entry -> privacy.compareTo((Enum)entry.getKey()) >= 0).sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> ((Collection)entry.getValue()).stream().reduce(((Privacy)((Object)((Object)((Object)entry.getKey())))).toString(), (a, b) -> String.format("%s\n%s", a, b))).collect(Collectors.joining("\n"));
            if (commands.isEmpty()) {
                commands = AbilityUtils.getLocalizedMessage(AbilityMessageCodes.ABILITY_COMMANDS_NOT_FOUND, ctx.user().getLanguageCode(), new Object[0]);
            }
            this.silent.send(commands, ctx.chatId());
        }).build();
    }

    public Ability backupDB() {
        return Ability.builder().name(BACKUP).locality(Locality.USER).privacy(Privacy.CREATOR).input(0).action(ctx -> {
            File backup = new File("backup.json");
            try (PrintStream printStream = new PrintStream(backup);){
                printStream.print(this.db.backup());
                this.sender.sendDocument(new SendDocument().setDocument(backup).setChatId(ctx.chatId()));
            }
            catch (FileNotFoundException e) {
                BotLogger.error((String)"Error while fetching backup", (String)TAG, (Throwable)e);
            }
            catch (TelegramApiException e) {
                BotLogger.error((String)"Error while sending document/backup file", (String)TAG, (Throwable)e);
            }
        }).build();
    }

    public Ability recoverDB() {
        return Ability.builder().name(RECOVER).locality(Locality.USER).privacy(Privacy.CREATOR).input(0).action(ctx -> this.silent.forceReply(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.ABILITY_RECOVER_MESSAGE, ctx.user().getLanguageCode(), new Object[0]), ctx.chatId())).reply(update -> {
            String recoverMessage;
            String replyToMsg = update.getMessage().getReplyToMessage().getText();
            if (!replyToMsg.equals(recoverMessage = AbilityUtils.getLocalizedMessage(AbilityMessageCodes.ABILITY_RECOVER_MESSAGE, AbilityUtils.getUser(update).getLanguageCode(), new Object[0]))) {
                return;
            }
            String fileId = update.getMessage().getDocument().getFileId();
            try (FileReader reader = new FileReader(this.downloadFileWithId(fileId));){
                String backupData = IOUtils.toString((Reader)reader);
                if (this.db.recover(backupData)) {
                    this.send(AbilityMessageCodes.ABILITY_RECOVER_SUCCESS, (Update)update);
                } else {
                    this.send(AbilityMessageCodes.ABILITY_RECOVER_FAIL, (Update)update);
                }
            }
            catch (Exception e) {
                BotLogger.error((String)"Could not recover DB from backup", (String)TAG, (Throwable)e);
                this.send(AbilityMessageCodes.ABILITY_RECOVER_ERROR, (Update)update);
            }
        }, Flag.MESSAGE, Flag.DOCUMENT, Flag.REPLY).build();
    }

    public Ability banUser() {
        return Ability.builder().name(BAN).locality(Locality.ALL).privacy(Privacy.ADMIN).input(1).action(ctx -> {
            String bannedUser;
            String username = AbilityUtils.stripTag(ctx.firstArg());
            int userId = this.getUserIdSendError(username, (MessageContext)ctx);
            if (userId == this.creatorId()) {
                userId = ctx.user().getId();
                bannedUser = Strings.isNullOrEmpty((String)ctx.user().getUserName()) ? AbilityUtils.addTag(ctx.user().getUserName()) : AbilityUtils.shortName(ctx.user());
            } else {
                bannedUser = AbilityUtils.addTag(username);
            }
            Set<Integer> blacklist = this.blacklist();
            if (blacklist.contains(userId)) {
                this.sendMd(AbilityMessageCodes.ABILITY_BAN_FAIL, (MessageContext)ctx, this.escape(bannedUser));
            } else {
                blacklist.add(userId);
                this.sendMd(AbilityMessageCodes.ABILITY_BAN_SUCCESS, (MessageContext)ctx, this.escape(bannedUser));
            }
        }).post(AbilityUtils.commitTo(this.db)).build();
    }

    public Ability unbanUser() {
        return Ability.builder().name(UNBAN).locality(Locality.ALL).privacy(Privacy.ADMIN).input(1).action(ctx -> {
            String username = AbilityUtils.stripTag(ctx.firstArg());
            Integer userId = this.getUserIdSendError(username, (MessageContext)ctx);
            Set<Integer> blacklist = this.blacklist();
            if (!blacklist.remove(userId)) {
                this.silent.sendMd(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.ABILITY_UNBAN_FAIL, ctx.user().getLanguageCode(), this.escape(username)), ctx.chatId());
            } else {
                this.silent.sendMd(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.ABILITY_UNBAN_SUCCESS, ctx.user().getLanguageCode(), this.escape(username)), ctx.chatId());
            }
        }).post(AbilityUtils.commitTo(this.db)).build();
    }

    public Ability promoteAdmin() {
        return Ability.builder().name(PROMOTE).locality(Locality.ALL).privacy(Privacy.ADMIN).input(1).action(ctx -> {
            String username = AbilityUtils.stripTag(ctx.firstArg());
            Integer userId = this.getUserIdSendError(username, (MessageContext)ctx);
            Set<Integer> admins = this.admins();
            if (admins.contains(userId)) {
                this.sendMd(AbilityMessageCodes.ABILITY_PROMOTE_FAIL, (MessageContext)ctx, this.escape(username));
            } else {
                admins.add(userId);
                this.sendMd(AbilityMessageCodes.ABILITY_PROMOTE_SUCCESS, (MessageContext)ctx, this.escape(username));
            }
        }).post(AbilityUtils.commitTo(this.db)).build();
    }

    public Ability demoteAdmin() {
        return Ability.builder().name(DEMOTE).locality(Locality.ALL).privacy(Privacy.ADMIN).input(1).action(ctx -> {
            String username = AbilityUtils.stripTag(ctx.firstArg());
            Integer userId = this.getUserIdSendError(username, (MessageContext)ctx);
            Set<Integer> admins = this.admins();
            if (admins.remove(userId)) {
                this.sendMd(AbilityMessageCodes.ABILITY_DEMOTE_SUCCESS, (MessageContext)ctx, this.escape(username));
            } else {
                this.sendMd(AbilityMessageCodes.ABILITY_DEMOTE_FAIL, (MessageContext)ctx, this.escape(username));
            }
        }).post(AbilityUtils.commitTo(this.db)).build();
    }

    public Ability claimCreator() {
        return Ability.builder().name(CLAIM).locality(Locality.ALL).privacy(Privacy.CREATOR).input(0).action(ctx -> {
            int id;
            Set<Integer> admins = this.admins();
            if (admins.contains(id = this.creatorId())) {
                this.send(AbilityMessageCodes.ABILITY_CLAIM_FAIL, (MessageContext)ctx, new String[0]);
            } else {
                admins.add(id);
                this.send(AbilityMessageCodes.ABILITY_CLAIM_SUCCESS, (MessageContext)ctx, new String[0]);
            }
        }).post(AbilityUtils.commitTo(this.db)).build();
    }

    private Optional<Message> send(String message, MessageContext ctx, String ... args) {
        return this.silent.send(AbilityUtils.getLocalizedMessage(message, ctx.user().getLanguageCode(), (Object[])args), ctx.chatId());
    }

    private Optional<Message> sendMd(String message, MessageContext ctx, String ... args) {
        return this.silent.sendMd(AbilityUtils.getLocalizedMessage(message, ctx.user().getLanguageCode(), (Object[])args), ctx.chatId());
    }

    private Optional<Message> send(String message, Update upd) {
        Long chatId = upd.getMessage().getChatId();
        return this.silent.send(AbilityUtils.getLocalizedMessage(message, AbilityUtils.getUser(upd).getLanguageCode(), new Object[0]), chatId);
    }

    private void registerAbilities() {
        try {
            List extensions = Arrays.stream(this.getClass().getMethods()).filter(this.checkReturnType(AbilityExtension.class)).map(this.returnExtension(this)).collect(Collectors.toList());
            extensions.add(this);
            this.abilities = extensions.stream().flatMap(ext -> Arrays.stream(ext.getClass().getMethods()).filter(this.checkReturnType(Ability.class)).map(this.returnAbility(ext))).collect(ImmutableMap::builder, (b, a) -> b.put((Object)a.name(), a), (b1, b2) -> b1.putAll((Map)b2.build())).build();
            Stream extensionReplies = extensions.stream().flatMap(ext -> Arrays.stream(ext.getClass().getMethods()).filter(this.checkReturnType(Reply.class)).map(this.returnReply(ext)));
            Stream abilityReplies = this.abilities.values().stream().flatMap(ability -> ability.replies().stream());
            this.replies = Stream.concat(abilityReplies, extensionReplies).collect(ImmutableList::builder, ImmutableList.Builder::add, (b1, b2) -> b1.addAll((Iterable)b2.build())).build();
        }
        catch (IllegalStateException e) {
            BotLogger.error((String)TAG, (String)"Duplicate names found while registering abilities. Make sure that the abilities declared don't clash with the reserved ones.", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Predicate<Method> checkReturnType(Class<?> clazz) {
        return method -> clazz.isAssignableFrom(method.getReturnType());
    }

    private Function<? super Method, AbilityExtension> returnExtension(Object obj) {
        return method -> {
            try {
                return (AbilityExtension)method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                BotLogger.error((String)"Could not add ability extension", (String)TAG, (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        };
    }

    private Function<? super Method, Ability> returnAbility(Object obj) {
        return method -> {
            try {
                return (Ability)method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                BotLogger.error((String)"Could not add ability", (String)TAG, (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        };
    }

    private Function<? super Method, Reply> returnReply(Object obj) {
        return method -> {
            try {
                return (Reply)method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                BotLogger.error((String)"Could not add reply", (String)TAG, (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        };
    }

    private void postConsumption(Pair<MessageContext, Ability> pair) {
        Optional.ofNullable(pair.b().postAction()).ifPresent(consumer -> consumer.accept(pair.a()));
    }

    Pair<MessageContext, Ability> consumeUpdate(Pair<MessageContext, Ability> pair) {
        pair.b().action().accept(pair.a());
        return pair;
    }

    Pair<MessageContext, Ability> getContext(Trio<Update, Ability, String[]> trio) {
        Update update = trio.a();
        User user = AbilityUtils.getUser(update);
        return Pair.of(MessageContext.newContext(update, user, AbilityUtils.getChatId(update), trio.c()), trio.b());
    }

    boolean checkBlacklist(Update update) {
        Integer id = AbilityUtils.getUser(update).getId();
        return id.intValue() == this.creatorId() || !this.blacklist().contains(id);
    }

    boolean checkInput(Trio<Update, Ability, String[]> trio) {
        boolean isOk;
        String[] tokens = trio.c();
        int abilityTokens = trio.b().tokens();
        boolean bl = isOk = abilityTokens == 0 || tokens.length > 0 && tokens.length == abilityTokens;
        if (!isOk) {
            this.silent.send(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.CHECK_INPUT_FAIL, AbilityUtils.getUser(trio.a()).getLanguageCode(), abilityTokens, abilityTokens == 1 ? "input" : "inputs"), AbilityUtils.getChatId(trio.a()));
        }
        return isOk;
    }

    boolean checkLocality(Trio<Update, Ability, String[]> trio) {
        boolean isOk;
        Update update = trio.a();
        Locality locality = AbilityUtils.isUserMessage(update) ? Locality.USER : Locality.GROUP;
        Locality abilityLocality = trio.b().locality();
        boolean bl = isOk = abilityLocality == Locality.ALL || locality == abilityLocality;
        if (!isOk) {
            this.silent.send(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.CHECK_LOCALITY_FAIL, AbilityUtils.getUser(trio.a()).getLanguageCode(), abilityLocality.toString().toLowerCase()), AbilityUtils.getChatId(trio.a()));
        }
        return isOk;
    }

    boolean checkPrivacy(Trio<Update, Ability, String[]> trio) {
        boolean isOk;
        User user;
        int id;
        Update update = trio.a();
        Privacy privacy = this.getPrivacy(update, id = (user = AbilityUtils.getUser(update)).getId().intValue());
        boolean bl = isOk = privacy.compareTo(trio.b().privacy()) >= 0;
        if (!isOk) {
            this.silent.send(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.CHECK_PRIVACY_FAIL, AbilityUtils.getUser(trio.a()).getLanguageCode(), new Object[0]), AbilityUtils.getChatId(trio.a()));
        }
        return isOk;
    }

    @NotNull
    private Privacy getPrivacy(Update update, int id) {
        return this.isCreator(id) ? Privacy.CREATOR : (this.isAdmin(id) ? Privacy.ADMIN : ((AbilityUtils.isGroupUpdate(update) || AbilityUtils.isSuperGroupUpdate(update)) && this.isGroupAdmin(update, id) ? Privacy.GROUP_ADMIN : Privacy.PUBLIC));
    }

    private boolean isGroupAdmin(Update update, int id) {
        GetChatAdministrators admins = new GetChatAdministrators().setChatId(AbilityUtils.getChatId(update));
        return this.silent.execute(admins).orElse(new ArrayList()).stream().anyMatch(member -> member.getUser().getId() == id);
    }

    private boolean isCreator(int id) {
        return id == this.creatorId();
    }

    private boolean isAdmin(Integer id) {
        return this.admins().contains(id);
    }

    boolean validateAbility(Trio<Update, Ability, String[]> trio) {
        return trio.b() != null;
    }

    Trio<Update, Ability, String[]> getAbility(Update update) {
        Message msg = update.getMessage();
        if (!update.hasMessage() || !msg.hasText()) {
            return Trio.of(update, this.abilities.get(DEFAULT), new String[0]);
        }
        String[] tokens = msg.getText().split(" ");
        if (tokens[0].startsWith("/")) {
            String abilityToken = this.stripBotUsername(tokens[0].substring(1)).toLowerCase();
            Ability ability = this.abilities.get(abilityToken);
            tokens = Arrays.copyOfRange(tokens, 1, tokens.length);
            return Trio.of(update, ability, tokens);
        }
        Ability ability = this.abilities.get(DEFAULT);
        return Trio.of(update, ability, tokens);
    }

    private String stripBotUsername(String token) {
        return Pattern.compile(String.format("@%s", this.botUsername), 2).matcher(token).replaceAll("");
    }

    Update addUser(Update update) {
        User endUser = AbilityUtils.getUser(update);
        this.users().compute(endUser.getId(), (id, user) -> {
            if (user == null) {
                this.updateUserId((User)user, endUser);
                return endUser;
            }
            if (!user.equals((Object)endUser)) {
                this.updateUserId((User)user, endUser);
                return endUser;
            }
            return user;
        });
        this.db.commit();
        return update;
    }

    private void updateUserId(User oldUser, User newUser) {
        if (oldUser != null && oldUser.getUserName() != null) {
            this.userIds().remove(oldUser.getUserName());
        }
        if (newUser.getUserName() != null) {
            this.userIds().put(newUser.getUserName().toLowerCase(), newUser.getId());
        }
    }

    boolean filterReply(Update update) {
        return this.replies.stream().filter(reply -> reply.isOkFor(update)).map(reply -> {
            reply.actOn(update);
            return false;
        }).reduce(true, Boolean::logicalAnd);
    }

    boolean checkMessageFlags(Trio<Update, Ability, String[]> trio) {
        Ability ability = trio.b();
        Update update = trio.a();
        BiFunction<Boolean, Predicate, Boolean> flagAnd = (flag, nextFlag) -> flag != false && nextFlag.test(update);
        return ability.flags().stream().reduce(true, flagAnd, Boolean::logicalAnd);
    }

    private File downloadFileWithId(String fileId) throws TelegramApiException {
        return this.sender.downloadFile((org.telegram.telegrambots.meta.api.objects.File)this.sender.execute(new GetFile().setFileId(fileId)));
    }

    private String escape(String username) {
        return username.replace("_", "\\_");
    }
}

