/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.objects;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.telegram.abilitybots.api.objects.Locality;
import org.telegram.abilitybots.api.objects.MessageContext;
import org.telegram.abilitybots.api.objects.Privacy;
import org.telegram.abilitybots.api.objects.Reply;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.logging.BotLogger;

public final class Ability {
    private static final String TAG = Ability.class.getSimpleName();
    private final String name;
    private final String info;
    private final Locality locality;
    private final Privacy privacy;
    private final int argNum;
    private final Consumer<MessageContext> action;
    private final Consumer<MessageContext> postAction;
    private final List<Reply> replies;
    private final List<Predicate<Update>> flags;

    @SafeVarargs
    private Ability(String name, String info, Locality locality, Privacy privacy, int argNum, Consumer<MessageContext> action, Consumer<MessageContext> postAction, List<Reply> replies, Predicate<Update> ... flags) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"Method name cannot be empty");
        Preconditions.checkArgument((!StringUtils.containsWhitespace((CharSequence)name) ? 1 : 0) != 0, (Object)"Method name cannot contain spaces");
        Preconditions.checkArgument((boolean)StringUtils.isAlphanumeric((CharSequence)name), (String)"Method name can only be alpha-numeric", (Object)name);
        this.name = name;
        this.info = info;
        this.locality = (Locality)((Object)Preconditions.checkNotNull((Object)((Object)locality), (Object)"Please specify a valid locality setting. Use the Locality enum class"));
        this.privacy = (Privacy)((Object)Preconditions.checkNotNull((Object)((Object)privacy), (Object)"Please specify a valid privacy setting. Use the Privacy enum class"));
        Preconditions.checkArgument((argNum >= 0 ? 1 : 0) != 0, (Object)"The number of arguments the method can handle CANNOT be negative. Use the number 0 if the method ignores the arguments OR uses as many as appended");
        this.argNum = argNum;
        this.action = (Consumer)Preconditions.checkNotNull(action, (Object)"Method action can't be empty. Please assign a function by using .action() method");
        if (postAction == null) {
            BotLogger.info((String)TAG, (String)String.format("No post action was detected for method with name [%s]", name));
        }
        this.flags = Optional.ofNullable(flags).map(Arrays::asList).orElse(Lists.newArrayList());
        this.postAction = postAction;
        this.replies = replies;
    }

    public static AbilityBuilder builder() {
        return new AbilityBuilder();
    }

    public String name() {
        return this.name;
    }

    public String info() {
        return this.info;
    }

    public Locality locality() {
        return this.locality;
    }

    public Privacy privacy() {
        return this.privacy;
    }

    public int tokens() {
        return this.argNum;
    }

    public Consumer<MessageContext> action() {
        return this.action;
    }

    public Consumer<MessageContext> postAction() {
        return this.postAction;
    }

    public List<Reply> replies() {
        return this.replies;
    }

    public List<Predicate<Update>> flags() {
        return this.flags;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("locality", (Object)this.locality).add("privacy", (Object)this.privacy).add("argNum", this.argNum).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ability ability = (Ability)o;
        return this.argNum == ability.argNum && com.google.common.base.Objects.equal((Object)this.name, (Object)ability.name) && this.locality == ability.locality && this.privacy == ability.privacy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.info, this.locality, this.privacy, this.argNum, this.action, this.postAction, this.replies, this.flags});
    }

    public static class AbilityBuilder {
        private String name;
        private String info;
        private Privacy privacy;
        private Locality locality;
        private int argNum;
        private Consumer<MessageContext> consumer;
        private Consumer<MessageContext> postConsumer;
        private List<Reply> replies = Lists.newArrayList();
        private Predicate<Update>[] flags;

        private AbilityBuilder() {
        }

        public AbilityBuilder action(Consumer<MessageContext> consumer) {
            this.consumer = consumer;
            return this;
        }

        public AbilityBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AbilityBuilder info(String info) {
            this.info = info;
            return this;
        }

        public AbilityBuilder flag(Predicate<Update> ... flags) {
            this.flags = flags;
            return this;
        }

        public AbilityBuilder locality(Locality type) {
            this.locality = type;
            return this;
        }

        public AbilityBuilder input(int argNum) {
            this.argNum = argNum;
            return this;
        }

        public AbilityBuilder privacy(Privacy privacy) {
            this.privacy = privacy;
            return this;
        }

        public AbilityBuilder post(Consumer<MessageContext> postConsumer) {
            this.postConsumer = postConsumer;
            return this;
        }

        @SafeVarargs
        public final AbilityBuilder reply(Consumer<Update> action, Predicate<Update> ... conditions) {
            this.replies.add(Reply.of(action, conditions));
            return this;
        }

        public Ability build() {
            return new Ability(this.name, this.info, this.locality, this.privacy, this.argNum, (Consumer)this.consumer, (Consumer)this.postConsumer, (List)this.replies, (Predicate[])this.flags);
        }
    }
}

