/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.db;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.telegram.abilitybots.api.db.BackupMap;
import org.telegram.abilitybots.api.db.DBContext;
import org.telegram.abilitybots.api.db.MapDBVar;
import org.telegram.abilitybots.api.db.Var;
import org.telegram.abilitybots.api.util.Pair;

public class MapDBContext
implements DBContext {
    private static final Logger log = LogManager.getLogger(MapDBContext.class);
    private final DB db;
    private final ObjectMapper objectMapper;

    public MapDBContext(DB db) {
        this.db = db;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.enableDefaultTyping();
    }

    public static DBContext onlineInstance(String name) {
        DB db = DBMaker.fileDB((String)name).fileMmapEnableIfSupported().closeOnJvmShutdown().transactionEnable().make();
        return new MapDBContext(db);
    }

    public static DBContext offlineInstance(String name) {
        DB db = DBMaker.fileDB((String)name).fileMmapEnableIfSupported().closeOnJvmShutdown().transactionEnable().fileDeleteAfterClose().make();
        return new MapDBContext(db);
    }

    @Override
    public <T> List<T> getList(String name) {
        return (List)this.db.indexTreeList(name, (Serializer)Serializer.JAVA).createOrOpen();
    }

    @Override
    public <K, V> Map<K, V> getMap(String name) {
        return this.db.hashMap(name, (Serializer)Serializer.JAVA, (Serializer)Serializer.JAVA).createOrOpen();
    }

    @Override
    public <T> Set<T> getSet(String name) {
        return (Set)this.db.hashSet(name, (Serializer)Serializer.JAVA).createOrOpen();
    }

    @Override
    public <T> Var<T> getVar(String name) {
        return new MapDBVar((Atomic.Var)this.db.atomicVar(name).createOrOpen());
    }

    @Override
    public String summary() {
        return StreamSupport.stream(this.db.getAllNames().spliterator(), false).map(this::info).reduce(new StringJoiner("\n"), StringJoiner::add, StringJoiner::merge).toString();
    }

    @Override
    public Object backup() {
        Map<String, Object> collectedMap = this.localCopy();
        return this.writeAsString(collectedMap);
    }

    @Override
    public boolean recover(Object backup) {
        Map<String, Object> snapshot = this.localCopy();
        try {
            Map backupData = (Map)this.objectMapper.readValue(backup.toString(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            this.doRecover(backupData);
            return true;
        }
        catch (IOException e) {
            log.error(String.format("Could not recover DB data from file with String representation %s", backup), (Throwable)e);
            this.doRecover(snapshot);
            return false;
        }
    }

    @Override
    public String info(String name) {
        Object struct = this.db.get(name);
        if (Objects.isNull(struct)) {
            throw new IllegalStateException(String.format("DB structure with name [%s] does not exist", name));
        }
        if (struct instanceof Set) {
            return String.format("%s - Set - %d", name, ((Set)struct).size());
        }
        if (struct instanceof List) {
            return String.format("%s - List - %d", name, ((List)struct).size());
        }
        if (struct instanceof Map) {
            return String.format("%s - Map - %d", name, ((Map)struct).size());
        }
        return String.format("%s - %s", name, struct.getClass().getSimpleName());
    }

    @Override
    public void commit() {
        this.db.commit();
    }

    @Override
    public void clear() {
        this.db.getAllNames().forEach(name -> {
            Object struct = this.db.get(name);
            if (struct instanceof Collection) {
                ((Collection)struct).clear();
            } else if (struct instanceof Map) {
                ((Map)struct).clear();
            }
        });
        this.commit();
    }

    @Override
    public boolean contains(String name) {
        return this.db.exists(name);
    }

    @Override
    public void close() {
        this.db.close();
    }

    private Map<String, Object> localCopy() {
        return this.db.getAll().entrySet().stream().map(entry -> {
            Object struct = entry.getValue();
            if (struct instanceof Set) {
                return Pair.of((String)entry.getKey(), Sets.newHashSet((Iterable)((Set)struct)));
            }
            if (struct instanceof List) {
                return Pair.of((String)entry.getKey(), Lists.newArrayList((Iterable)((List)struct)));
            }
            if (struct instanceof Map) {
                return Pair.of((String)entry.getKey(), new BackupMap((Map)struct));
            }
            return Pair.of((String)entry.getKey(), struct);
        }).collect(Collectors.toMap(pair -> (String)pair.a(), Pair::b));
    }

    private void doRecover(Map<String, Object> backupData) {
        this.clear();
        backupData.forEach((name, value) -> {
            if (value instanceof Set) {
                Set entrySet = (Set)value;
                this.getSet((String)name).addAll(entrySet);
            } else if (value instanceof BackupMap) {
                Map entryMap = ((BackupMap)value).toMap();
                this.getMap((String)name).putAll(entryMap);
            } else if (value instanceof List) {
                List entryList = (List)value;
                this.getList((String)name).addAll(entryList);
            } else {
                log.error(String.format("Unable to identify object type during DB recovery, entry name: %s", name));
            }
        });
        this.commit();
    }

    private String writeAsString(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.info(String.format("Failed to read the JSON representation of object: %s", obj), (Throwable)e);
            return "Error reading required data...";
        }
    }
}

